/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.awt.Window;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonStrip;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import test.common.LocaleSwitcher;
import test.common.SamplePopupMenu;
import test.svg.transcoded.format_justify_center;
import test.svg.transcoded.format_justify_left;
import test.svg.transcoded.format_justify_right;
import test.svg.transcoded.format_text_bold;
import test.svg.transcoded.format_text_italic;
import test.svg.transcoded.format_text_strikethrough;
import test.svg.transcoded.format_text_underline;

public class TestButtonStripHorizontal
extends JFrame {
    protected Locale currLocale;
    private JPanel buttonPanel = this.getButtonPanel();

    public TestButtonStripHorizontal() {
        super("Tests for horizontal buttons strips");
        this.add((Component)this.buttonPanel, "Center");
        JPanel controlPanel = new JPanel(new FlowLayout(1));
        JComboBox localeSwitcher = LocaleSwitcher.getLocaleSwitcher(new LocaleSwitcher.LocaleCallback(){

            @Override
            public void onLocaleSelected(Locale selected) {
                TestButtonStripHorizontal.this.currLocale = selected;
                TestButtonStripHorizontal.this.remove(TestButtonStripHorizontal.this.buttonPanel);
                TestButtonStripHorizontal.this.buttonPanel = TestButtonStripHorizontal.this.getButtonPanel();
                TestButtonStripHorizontal.this.add((Component)TestButtonStripHorizontal.this.buttonPanel, "Center");
                Window window = SwingUtilities.getWindowAncestor(TestButtonStripHorizontal.this.buttonPanel);
                window.applyComponentOrientation(ComponentOrientation.getOrientation(TestButtonStripHorizontal.this.currLocale));
                SwingUtilities.updateComponentTreeUI(window);
            }
        });
        controlPanel.add(localeSwitcher);
        this.add((Component)controlPanel, "South");
        this.pack();
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
    }

    protected JPanel getButtonPanel() {
        FormLayout lm = new FormLayout("right:pref, 4dlu, left:pref, 4dlu, left:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(lm);
        builder.setDefaultDialogBorder();
        builder.append("hgap 0.5,  vgap 1.0", (Component)this.getStrip1(0.5, 1.0), (Component)this.getStrip2(0.5, 1.0));
        builder.append("hgap 0.75, vgap 1.0", (Component)this.getStrip1(0.75, 1.0), (Component)this.getStrip2(0.75, 1.0));
        builder.append("hgap 1.0,  vgap 1.0", (Component)this.getStrip1(1.0, 1.0), (Component)this.getStrip2(1.0, 1.0));
        builder.append("hgap 0.75, vgap 0.5", (Component)this.getStrip1(0.75, 0.5), (Component)this.getStrip2(0.75, 0.5));
        builder.append("hgap 0.75, vgap 0.75", (Component)this.getStrip1(0.75, 0.75), (Component)this.getStrip2(0.75, 0.75));
        builder.append("hgap 0.75, vgap 1.0", (Component)this.getStrip1(0.75, 1.0), (Component)this.getStrip2(0.75, 1.0));
        return builder.getPanel();
    }

    private JCommandButtonStrip getStrip1(double hgapScaleFactor, double vgapScaleFactor) {
        JCommandButtonStrip buttonStrip = new JCommandButtonStrip();
        buttonStrip.setHGapScaleFactor(hgapScaleFactor);
        buttonStrip.setVGapScaleFactor(vgapScaleFactor);
        buttonStrip.add(new JCommandButton("", new format_justify_left()));
        buttonStrip.add(new JCommandButton("", new format_justify_center()));
        buttonStrip.add(new JCommandButton("", new format_justify_right()));
        return buttonStrip;
    }

    private JCommandButtonStrip getStrip2(double hgapScaleFactor, double vgapScaleFactor) {
        JCommandButtonStrip buttonStrip2 = new JCommandButtonStrip();
        buttonStrip2.setHGapScaleFactor(hgapScaleFactor);
        buttonStrip2.setVGapScaleFactor(vgapScaleFactor);
        buttonStrip2.add(new JCommandButton("", new format_text_bold()));
        buttonStrip2.add(new JCommandButton("", new format_text_italic()));
        buttonStrip2.add(new JCommandButton("", new format_text_underline()));
        JCommandButton strike = new JCommandButton("", new format_text_strikethrough());
        strike.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
        strike.setPopupCallback(new PopupPanelCallback(){

            @Override
            public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                return new SamplePopupMenu(commandButton.getComponentOrientation());
            }
        });
        buttonStrip2.add(strike);
        return buttonStrip2;
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new TestButtonStripHorizontal().setVisible(true);
            }
        });
    }
}

