/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.wc.ISVNPropertyComparator;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNWCProperties {
    public static final String SVN_HASH_TERMINATOR = "END";
    private File myFile;
    private String myPath;

    public SVNWCProperties(File properitesFile, String path) {
        this.myFile = properitesFile;
        this.myPath = path;
    }

    public File getFile() {
        return this.myFile;
    }

    public String getPath() {
        return this.myPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection properties(Collection target) throws SVNException {
        Collection collection = target = target == null ? new TreeSet() : target;
        if (this.isEmpty()) {
            return target;
        }
        ByteArrayOutputStream nameOS = new ByteArrayOutputStream();
        InputStream is = SVNFileUtil.openFileForReading(this.getFile(), SVNLogType.WC);
        try {
            while (SVNWCProperties.readProperty('K', is, nameOS)) {
                target.add(new String(nameOS.toByteArray(), "UTF-8"));
                nameOS.reset();
                SVNWCProperties.readProperty('V', is, null);
            }
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e, SVNLogType.WC);
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNProperties asMap() throws SVNException {
        SVNProperties result = new SVNProperties();
        if (this.isEmpty()) {
            return result;
        }
        ByteArrayOutputStream nameOS = new ByteArrayOutputStream();
        InputStream is = SVNFileUtil.openFileForReading(this.getFile(), SVNLogType.WC);
        try {
            while (SVNWCProperties.readProperty('K', is, nameOS)) {
                String name = new String(nameOS.toByteArray(), "UTF-8");
                nameOS.reset();
                SVNWCProperties.readProperty('V', is, nameOS);
                byte[] value = nameOS.toByteArray();
                result.put(name, value);
                nameOS.reset();
            }
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read properties file ''{0}'': {1}", new Object[]{this.getFile(), e.getLocalizedMessage()});
            SVNErrorManager.error(err, e, SVNLogType.WC);
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compareTo(SVNWCProperties properties, ISVNPropertyComparator comparator) throws SVNException {
        boolean equals = true;
        Collection props1 = this.properties(null);
        Collection props2 = properties.properties(null);
        TreeSet tmp = new TreeSet(props1);
        tmp.removeAll(props2);
        Iterator props = tmp.iterator();
        while (props.hasNext()) {
            String missing = (String)props.next();
            comparator.propertyDeleted(missing);
            equals = false;
        }
        tmp = new TreeSet(props2);
        tmp.removeAll(props1);
        File tmpFile = null;
        File tmpFile1 = null;
        File tmpFile2 = null;
        OutputStream os = null;
        InputStream is = null;
        InputStream is1 = null;
        InputStream is2 = null;
        Iterator props3 = tmp.iterator();
        while (props3.hasNext()) {
            Object var17_16;
            String added = (String)props3.next();
            try {
                tmpFile = SVNFileUtil.createUniqueFile(this.getFile().getParentFile(), this.getFile().getName(), ".tmp", true);
                os = SVNFileUtil.openFileForWriting(tmpFile);
                properties.getPropertyValue(added, os);
                SVNFileUtil.closeFile(os);
                is = SVNFileUtil.openFileForReading(tmpFile, SVNLogType.WC);
                comparator.propertyAdded(added, is, (int)tmpFile.length());
                equals = false;
                SVNFileUtil.closeFile(is);
                var17_16 = null;
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
            catch (Throwable throwable) {
                var17_16 = null;
                if (tmpFile != null) {
                    tmpFile.delete();
                }
                SVNFileUtil.closeFile(os);
                SVNFileUtil.closeFile(is);
                tmpFile = null;
                is = null;
                os = null;
                throw throwable;
            }
            SVNFileUtil.closeFile(os);
            SVNFileUtil.closeFile(is);
            tmpFile = null;
            is = null;
            os = null;
        }
        props2.retainAll(props1);
        Iterator props4 = props2.iterator();
        while (props4.hasNext()) {
            Object var19_22;
            String changed = (String)props4.next();
            try {
                block21: {
                    try {
                        tmpFile1 = SVNFileUtil.createUniqueFile(this.getFile().getParentFile(), this.getFile().getName(), ".tmp1", true);
                        tmpFile2 = SVNFileUtil.createUniqueFile(this.getFile().getParentFile(), this.getFile().getName(), ".tmp2", true);
                        os = SVNFileUtil.openFileForWriting(tmpFile1);
                        this.getPropertyValue(changed, os);
                        os.close();
                        os = SVNFileUtil.openFileForWriting(tmpFile2);
                        properties.getPropertyValue(changed, os);
                        os.close();
                        if (tmpFile2.length() != tmpFile1.length()) {
                            is = SVNFileUtil.openFileForReading(tmpFile2, SVNLogType.WC);
                            comparator.propertyChanged(changed, is, (int)tmpFile2.length());
                            equals = false;
                            SVNFileUtil.closeFile(is);
                            break block21;
                        }
                        is1 = SVNFileUtil.openFileForReading(tmpFile1, SVNLogType.WC);
                        is2 = SVNFileUtil.openFileForReading(tmpFile2, SVNLogType.WC);
                        boolean differs = false;
                        int i = 0;
                        while ((long)i < tmpFile1.length()) {
                            if (is1.read() != is2.read()) {
                                differs = true;
                                break;
                            }
                            ++i;
                        }
                        SVNFileUtil.closeFile(is1);
                        SVNFileUtil.closeFile(is2);
                        if (!differs) break block21;
                        is2 = SVNFileUtil.openFileForReading(tmpFile2, SVNLogType.WC);
                        comparator.propertyChanged(changed, is2, (int)tmpFile2.length());
                        equals = false;
                        SVNFileUtil.closeFile(is2);
                    }
                    catch (IOException e) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                        SVNErrorManager.error(err, e, SVNLogType.WC);
                        var19_22 = null;
                        if (tmpFile2 != null) {
                            tmpFile2.delete();
                        }
                        if (tmpFile1 != null) {
                            tmpFile1.delete();
                        }
                        SVNFileUtil.closeFile(os);
                        SVNFileUtil.closeFile(is);
                        SVNFileUtil.closeFile(is1);
                        SVNFileUtil.closeFile(is2);
                        os = null;
                        tmpFile2 = null;
                        tmpFile1 = null;
                        is2 = null;
                        is1 = null;
                        is = null;
                        continue;
                    }
                }
                var19_22 = null;
                if (tmpFile2 != null) {
                    tmpFile2.delete();
                }
            }
            catch (Throwable throwable) {
                var19_22 = null;
                if (tmpFile2 != null) {
                    tmpFile2.delete();
                }
                if (tmpFile1 != null) {
                    tmpFile1.delete();
                }
                SVNFileUtil.closeFile(os);
                SVNFileUtil.closeFile(is);
                SVNFileUtil.closeFile(is1);
                SVNFileUtil.closeFile(is2);
                os = null;
                tmpFile2 = null;
                tmpFile1 = null;
                is2 = null;
                is1 = null;
                is = null;
                throw throwable;
            }
            if (tmpFile1 != null) {
                tmpFile1.delete();
            }
            SVNFileUtil.closeFile(os);
            SVNFileUtil.closeFile(is);
            SVNFileUtil.closeFile(is1);
            SVNFileUtil.closeFile(is2);
            os = null;
            tmpFile2 = null;
            tmpFile1 = null;
            is2 = null;
            is1 = null;
            is = null;
        }
        return equals;
    }

    public String getPropertyValue(String name) throws SVNException {
        if (this.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if ((os = (ByteArrayOutputStream)this.getPropertyValue(name, os)) != null && os.size() >= 0) {
            byte[] bytes = os.toByteArray();
            try {
                return new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return new String(bytes);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getPropertyValue(String name, OutputStream os) throws SVNException {
        if (this.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream nameOS = new ByteArrayOutputStream();
        InputStream is = SVNFileUtil.openFileForReading(this.getFile(), SVNLogType.WC);
        try {
            while (SVNWCProperties.readProperty('K', is, nameOS)) {
                String currentName = new String(nameOS.toByteArray(), "UTF-8");
                nameOS.reset();
                if (currentName.equals(name)) {
                    SVNWCProperties.readProperty('V', is, os);
                    OutputStream outputStream = os;
                    return outputStream;
                }
                SVNWCProperties.readProperty('V', is, null);
            }
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e, SVNLogType.WC);
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
        return null;
    }

    public void setPropertyValue(String name, String value) throws SVNException {
        byte[] bytes = null;
        try {
            bytes = value == null ? null : value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            bytes = value.getBytes();
        }
        int length = bytes != null && bytes.length >= 0 ? bytes.length : -1;
        this.setPropertyValue(name, bytes != null ? new ByteArrayInputStream(bytes) : null, length);
    }

    public void setPropertyValue(String name, SVNPropertyValue value) throws SVNException {
        byte[] bytes = SVNPropertyValue.getPropertyAsBytes(value);
        int length = bytes != null && bytes.length >= 0 ? bytes.length : -1;
        this.setPropertyValue(name, bytes != null ? new ByteArrayInputStream(bytes) : null, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyValue(String name, InputStream is, int length) throws SVNException {
        InputStream src = null;
        OutputStream dst = null;
        File tmpFile = null;
        boolean empty = false;
        try {
            tmpFile = SVNFileUtil.createUniqueFile(this.getFile().getParentFile(), this.getFile().getName(), ".tmp", true);
            if (!this.isEmpty()) {
                src = SVNFileUtil.openFileForReading(this.getFile(), SVNLogType.WC);
            }
            empty = !SVNWCProperties.copyProperties(src, dst = SVNFileUtil.openFileForWriting(tmpFile), name, is, length);
        }
        catch (Throwable throwable) {
            SVNFileUtil.closeFile(src);
            SVNFileUtil.closeFile(dst);
            throw throwable;
        }
        SVNFileUtil.closeFile(src);
        SVNFileUtil.closeFile(dst);
        if (tmpFile != null) {
            if (!empty) {
                SVNFileUtil.rename(tmpFile, this.getFile());
                SVNFileUtil.setReadonly(this.getFile(), true);
            } else {
                SVNFileUtil.deleteFile(tmpFile);
                SVNFileUtil.deleteFile(this.getFile());
            }
        }
    }

    public void setProperties(SVNProperties properties) throws SVNException {
        if (properties != null) {
            Iterator names = properties.nameSet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                SVNPropertyValue value = properties.getSVNPropertyValue(name);
                this.setPropertyValue(name, value);
            }
        }
    }

    public SVNProperties compareTo(SVNWCProperties properties) throws SVNException {
        final SVNProperties locallyChangedProperties = new SVNProperties();
        this.compareTo(properties, new ISVNPropertyComparator(){

            public void propertyAdded(String name, InputStream value, int length) {
                this.propertyChanged(name, value, length);
            }

            public void propertyChanged(String name, InputStream newValue, int length) {
                ByteArrayOutputStream os = new ByteArrayOutputStream(length);
                for (int i = 0; i < length; ++i) {
                    try {
                        os.write(newValue.read());
                        continue;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                byte[] bytes = os.toByteArray();
                try {
                    locallyChangedProperties.put(name, new String(bytes, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    locallyChangedProperties.put(name, new String(bytes));
                }
            }

            public void propertyDeleted(String name) {
                locallyChangedProperties.put(name, (SVNPropertyValue)null);
            }
        });
        return locallyChangedProperties;
    }

    public void copyTo(SVNWCProperties destination) throws SVNException {
        if (this.isEmpty()) {
            SVNFileUtil.deleteFile(destination.getFile());
        } else {
            SVNFileUtil.copyFile(this.getFile(), destination.getFile(), false);
        }
    }

    public void delete() throws SVNException {
        SVNFileUtil.deleteFile(this.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProperties(SVNProperties namesToValues, File target, File tmpFile, String terminator) throws SVNException {
        OutputStream dst = null;
        try {
            tmpFile.getParentFile().mkdirs();
            dst = SVNFileUtil.openFileForWriting(tmpFile);
            SVNWCProperties.setProperties(namesToValues, dst, terminator);
        }
        catch (Throwable throwable) {
            SVNFileUtil.closeFile(dst);
            throw throwable;
        }
        SVNFileUtil.closeFile(dst);
        if (tmpFile != null && target != null) {
            target.getParentFile().mkdirs();
            SVNFileUtil.rename(tmpFile, target);
            SVNFileUtil.setReadonly(target, true);
        }
    }

    public static void setProperties(SVNProperties namesToValues, OutputStream target, String terminator) throws SVNException {
        try {
            Object[] keys = namesToValues.nameSet().toArray();
            Arrays.sort(keys);
            for (int i = 0; i < keys.length; ++i) {
                String propertyName = (String)keys[i];
                SVNWCProperties.writeProperty(target, 'K', propertyName.getBytes("UTF-8"));
                SVNWCProperties.writeProperty(target, 'V', SVNPropertyValue.getPropertyAsBytes(namesToValues.getSVNPropertyValue(propertyName)));
            }
            if (terminator != null) {
                target.write(terminator.getBytes("UTF-8"));
                target.write(10);
            }
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe, SVNLogType.WC);
        }
    }

    public static void appendProperty(String name, SVNPropertyValue value, OutputStream target) throws SVNException {
        if (name == null || value == null) {
            return;
        }
        byte[] bytes = SVNPropertyValue.getPropertyAsBytes(value);
        try {
            SVNWCProperties.writeProperty(target, 'K', name.getBytes("UTF-8"));
            SVNWCProperties.writeProperty(target, 'V', bytes);
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe, SVNLogType.WC);
        }
    }

    public static void appendPropertyDeleted(String name, OutputStream target) throws SVNException {
        if (name == null) {
            return;
        }
        try {
            SVNWCProperties.writeProperty(target, 'D', name.getBytes("UTF-8"));
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe, SVNLogType.WC);
        }
    }

    private static boolean copyProperties(InputStream is, OutputStream os, String name, InputStream value, int length) throws SVNException {
        int propCount = 0;
        try {
            if (is != null) {
                int l = 0;
                while ((l = SVNWCProperties.readLength(is, 'K')) > 0) {
                    byte[] nameBytes = new byte[l];
                    is.read(nameBytes);
                    is.read();
                    if (name.equals(new String(nameBytes, "UTF-8"))) {
                        SVNWCProperties.readProperty('V', is, null);
                        continue;
                    }
                    SVNWCProperties.writeProperty(os, 'K', nameBytes);
                    l = SVNWCProperties.readLength(is, 'V');
                    SVNWCProperties.writeProperty(os, 'V', is, l);
                    is.read();
                    ++propCount;
                }
            }
            if (value != null && length >= 0) {
                byte[] nameBytes = name.getBytes("UTF-8");
                SVNWCProperties.writeProperty(os, 'K', nameBytes);
                SVNWCProperties.writeProperty(os, 'V', value, length);
                ++propCount;
            }
            if (propCount > 0) {
                os.write(new byte[]{69, 78, 68, 10});
            }
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e, SVNLogType.WC);
        }
        return propCount > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean readProperty(char type, InputStream is, OutputStream os) throws IOException {
        int length = SVNWCProperties.readLength(is, type);
        if (length < 0) {
            return false;
        }
        if (os != null) {
            byte[] value = new byte[length];
            int r = is.read(value);
            if (r < 0) return false;
            os.write(value, 0, r);
        } else {
            while (length > 0) {
                length = (int)((long)length - is.skip(length));
            }
        }
        if (is.read() != 10) return false;
        return true;
    }

    private static void writeProperty(OutputStream os, char type, byte[] value) throws IOException {
        os.write((byte)type);
        os.write(32);
        os.write(Integer.toString(value.length).getBytes("UTF-8"));
        os.write(10);
        os.write(value);
        os.write(10);
    }

    private static void writeProperty(OutputStream os, char type, InputStream value, int length) throws IOException {
        os.write((byte)type);
        os.write(32);
        os.write(Integer.toString(length).getBytes("UTF-8"));
        os.write(10);
        for (int i = 0; i < length; ++i) {
            int r = value.read();
            os.write(r);
        }
        os.write(10);
    }

    private static int readLength(InputStream is, char type) throws IOException {
        byte[] buffer = new byte[255];
        int r = is.read(buffer, 0, 4);
        if (r != 4) {
            throw new IOException("invalid properties file format");
        }
        if (buffer[0] == 69 && buffer[1] == 78 && buffer[2] == 68 && buffer[3] == 10) {
            return -1;
        }
        if (buffer[0] == type && buffer[1] == 32) {
            int i = 4;
            if (buffer[3] != 10) {
                while (true) {
                    int b;
                    if ((b = is.read()) < 0) {
                        throw new IOException("invalid properties file format");
                    }
                    if (b != 10) {
                        buffer[i] = (byte)(0xFF & b);
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                i = 3;
            }
            String length = new String(buffer, 2, i - 2, "UTF-8");
            return Integer.parseInt(length.trim());
        }
        throw new IOException("invalid properties file format");
    }

    public boolean isEmpty() {
        return !this.getFile().exists() || this.getFile().length() <= 4L;
    }
}

