/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.io.IOException;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.mock.web.portlet.MockRenderResponse;
import org.springframework.util.Assert;

public class MockPortletRequestDispatcher
implements PortletRequestDispatcher {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String url;

    public MockPortletRequestDispatcher(String url) {
        Assert.notNull((Object)url, (String)"URL must not be null");
        this.url = url;
    }

    public void include(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        Assert.notNull((Object)request, (String)"Request must not be null");
        Assert.notNull((Object)response, (String)"Response must not be null");
        if (!(response instanceof MockRenderResponse)) {
            throw new IllegalArgumentException("MockPortletRequestDispatcher requires MockRenderResponse");
        }
        ((MockRenderResponse)response).setIncludedUrl(this.url);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MockPortletRequestDispatcher: including URL [" + this.url + "]");
        }
    }
}

