/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequestDispatcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.portlet.MockPortletRequestDispatcher;
import org.springframework.util.Assert;

public class MockPortletContext
implements PortletContext {
    private static final String TEMP_DIR_SYSTEM_PROPERTY = "java.io.tmpdir";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String resourceBasePath;
    private final ResourceLoader resourceLoader;
    private final Hashtable attributes = new Hashtable();
    private final Properties initParameters = new Properties();
    private String portletContextName = "MockPortletContext";

    public MockPortletContext() {
        this("", null);
    }

    public MockPortletContext(String resourceBasePath) {
        this(resourceBasePath, null);
    }

    public MockPortletContext(ResourceLoader resourceLoader) {
        this("", resourceLoader);
    }

    public MockPortletContext(String resourceBasePath, ResourceLoader resourceLoader) {
        this.resourceBasePath = resourceBasePath != null ? resourceBasePath : "";
        this.resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
        String tempDir = System.getProperty(TEMP_DIR_SYSTEM_PROPERTY);
        if (tempDir != null) {
            this.attributes.put("javax.servlet.context.tempdir", new File(tempDir));
        }
    }

    protected String getResourceLocation(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return this.resourceBasePath + path;
    }

    public String getServerInfo() {
        return "MockPortal/1.0";
    }

    public PortletRequestDispatcher getRequestDispatcher(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("PortletRequestDispatcher path at PortletContext level must start with '/'");
        }
        return new MockPortletRequestDispatcher(path);
    }

    public PortletRequestDispatcher getNamedDispatcher(String path) {
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        Resource resource = this.resourceLoader.getResource(this.getResourceLocation(path));
        try {
            return resource.getInputStream();
        }
        catch (IOException ex) {
            this.logger.info("Couldn't open InputStream for " + resource, ex);
            return null;
        }
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public String getMimeType(String filePath) {
        return null;
    }

    public String getRealPath(String path) {
        Resource resource = this.resourceLoader.getResource(this.getResourceLocation(path));
        try {
            return resource.getFile().getAbsolutePath();
        }
        catch (IOException ex) {
            this.logger.info("Couldn't determine real path of resource " + resource, ex);
            return null;
        }
    }

    public Set getResourcePaths(String path) {
        Resource resource = this.resourceLoader.getResource(this.getResourceLocation(path));
        try {
            File file = resource.getFile();
            String[] fileList = file.list();
            String prefix = path.endsWith("/") ? path : path + "/";
            HashSet<String> resourcePaths = new HashSet<String>(fileList.length);
            for (int i = 0; i < fileList.length; ++i) {
                resourcePaths.add(prefix + fileList[i]);
            }
            return resourcePaths;
        }
        catch (IOException ex) {
            this.logger.info("Couldn't get resource paths for " + resource, ex);
            return null;
        }
    }

    public URL getResource(String path) throws MalformedURLException {
        Resource resource = this.resourceLoader.getResource(this.getResourceLocation(path));
        try {
            return resource.getURL();
        }
        catch (IOException ex) {
            this.logger.info("Couldn't get URL for " + resource, ex);
            return null;
        }
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void addInitParameter(String name, String value) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        this.initParameters.setProperty(name, value);
    }

    public String getInitParameter(String name) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        return this.initParameters.getProperty(name);
    }

    public Enumeration getInitParameterNames() {
        return this.initParameters.keys();
    }

    public void log(String message) {
        this.logger.info(message);
    }

    public void log(String message, Throwable t) {
        this.logger.info(message, t);
    }

    public void setPortletContextName(String portletContextName) {
        this.portletContextName = portletContextName;
    }

    public String getPortletContextName() {
        return this.portletContextName;
    }
}

