/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.application.glycanbuilder.util.exchange.importer;

import java.util.HashMap;
import java.util.LinkedList;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.dataset.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.linkage.Linkage;
import org.eurocarbdb.application.glycanbuilder.massutil.MassOptions;
import org.glycoinfo.WURCSFramework.util.WURCSFactory;
import org.glycoinfo.WURCSFramework.wurcs.array.LIN;
import org.glycoinfo.WURCSFramework.wurcs.array.WURCSArray;
import org.glycoinfo.WURCSFramework.wurcs.sequence2.GLIN;
import org.glycoinfo.WURCSFramework.wurcs.sequence2.GRES;
import org.glycoinfo.WURCSFramework.wurcs.sequence2.WURCSSequence2;
import org.glycoinfo.application.glycanbuilder.util.exchange.importer.GLINToLinkage;
import org.glycoinfo.application.glycanbuilder.util.exchange.importer.GRESToFragment;
import org.glycoinfo.application.glycanbuilder.util.exchange.importer.GRESToResidue;
import org.glycoinfo.application.glycanbuilder.util.exchange.importer.LinkageConnector;
import org.glycoinfo.application.glycanbuilder.util.exchange.importer.SUBSTAnalyzer;

public class WURCSSequence2ToGlycan {
    private Glycan glycan = null;
    private final HashMap<GRES, Residue> gres2residue = new HashMap();
    private final GRESToFragment gres2frag = new GRESToFragment();

    public Glycan getGlycan() {
        return this.glycan;
    }

    public void start(WURCSFactory _wf, MassOptions _massOpt) throws Exception {
        Residue fragRoot;
        WURCSSequence2 wSeq2 = _wf.getSequence();
        WURCSArray wArray = _wf.getArray();
        for (GRES gres : wSeq2.getGRESs()) {
            this.analyzeGRES(gres);
            if (wSeq2.getGRESs().size() <= 1) continue;
            this.gres2frag.start(gres);
        }
        if (this.gres2frag.getRootOfCompositions().isEmpty()) {
            for (GRES gres : wSeq2.getGRESs()) {
                this.analyzeGLIN(gres, wArray.getLINs());
            }
        } else {
            for (GRES gres : wSeq2.getGRESs()) {
                this.analyzeCompositionGLIN(gres);
            }
        }
        this.glycan = new Glycan(this.makeRoot(wSeq2.getGRESs()), false, _massOpt);
        for (GRES gres : this.gres2frag.getRootOfFragments()) {
            fragRoot = this.gres2residue.get(gres);
            this.glycan.addAntenna(fragRoot, fragRoot.getParentLinkage().getBonds());
        }
        for (GLIN glin : this.gres2frag.getSubstituentWithFragments()) {
            fragRoot = this.gres2frag.getSubStituentFragment(glin);
            for (GRES gres : this.gres2frag.getChildren()) {
                fragRoot.addParentOfFragment(this.gres2residue.get(gres));
            }
            this.glycan.addAntenna(fragRoot, fragRoot.getParentLinkage().getBonds());
        }
        if (!this.gres2frag.getRootOfCompositions().isEmpty()) {
            this.glycan = Glycan.createComposition(_massOpt);
            for (GRES gres : this.gres2frag.getRootOfCompositions()) {
                Residue compoRoot = this.gres2residue.get(gres);
                compoRoot.isComposition(true);
                this.glycan.addAntenna(compoRoot);
            }
            for (GLIN glin : this.gres2frag.getSubstituentWithFragments()) {
                fragRoot = this.gres2frag.getSubStituentFragment(glin);
                for (GRES gres : this.gres2frag.getChildren()) {
                    fragRoot.addParentOfFragment(this.gres2residue.get(gres));
                }
                this.glycan.addAntenna(fragRoot, fragRoot.getParentLinkage().getBonds());
            }
            if (this.isCompositionWithoutLinkage(this.glycan)) {
                Residue withoutLinkage = new Residue(ResidueType.createAssigned("no glycosidic linkages"));
                this.glycan.addAntenna(withoutLinkage);
            }
        }
    }

    private void analyzeGRES(GRES _gres) throws Exception {
        GRESToResidue gres2residue = new GRESToResidue();
        gres2residue.start(_gres);
        Residue residue = gres2residue.getResidue();
        this.gres2residue.put(_gres, residue);
        SUBSTAnalyzer substAnalyzer = new SUBSTAnalyzer(gres2residue.getModifications());
        substAnalyzer.start(_gres, residue);
    }

    private void analyzeCompositionGLIN(GRES _gres) {
        for (GLIN acceptorGLIN : _gres.getAcceptorGLINs()) {
            for (GRES acceptor : acceptorGLIN.getAcceptor()) {
                this.gres2residue.get(_gres).addParentOfFragment(this.gres2residue.get(acceptor));
            }
        }
    }

    private void analyzeGLIN(GRES _gres, LinkedList<LIN> _lins) throws Exception {
        GLINToLinkage glin2linkage = new GLINToLinkage(this.gres2residue.get(_gres), _lins);
        glin2linkage.start(_gres);
        Residue donor = this.gres2residue.get(_gres);
        Residue acceptor = glin2linkage.getParents().size() > 0 ? this.gres2residue.get(glin2linkage.getParents().get(0)) : null;
        Residue start = this.gres2residue.get(glin2linkage.getStartRepeatingGRES());
        LinkageConnector linkageConnector = new LinkageConnector(donor, acceptor, start);
        linkageConnector.start(glin2linkage);
        if (glin2linkage.getParents().size() > 1) {
            for (GRES gres : glin2linkage.getParents()) {
                this.gres2residue.get(_gres).addParentOfFragment(this.gres2residue.get(gres));
            }
        }
    }

    private Residue makeRoot(LinkedList<GRES> _gress) throws Exception {
        Residue root = this.gres2residue.get(this.getRootResidue(_gress));
        Residue redEnd = null;
        if (root == null) {
            return redEnd;
        }
        Residue residue = redEnd = root.isAlditol() && root.getStartRepetitionResidue() == null ? ResidueDictionary.newResidue("redEnd") : ResidueDictionary.newResidue("freeEnd");
        if (root.getStartCyclicResidue() != null) {
            return root.getStartCyclicResidue();
        }
        if (root.getStartRepetitionResidue() != null && root.getStartCyclicResidue() == null) {
            redEnd.addChild(root.getStartRepetitionResidue(), root.getStartRepetitionResidue().getParentLinkage().getBonds());
            return redEnd;
        }
        Linkage linkage = new Linkage(redEnd, root);
        linkage.setLinkagePositions(new char[]{root.getAnomericCarbon()});
        root.setParentLinkage(linkage);
        redEnd.addChild(root, root.getParentLinkage().getBonds());
        return redEnd;
    }

    private GRES getRootResidue(LinkedList<GRES> _gress) {
        for (GRES gres : _gress) {
            if (this.gres2frag.getRootOfCompositions().contains(gres)) continue;
            if (gres.getDonorGLINs().isEmpty() && gres.getAcceptorGLINs().isEmpty()) {
                return gres;
            }
            if (gres.getDonorGLINs().isEmpty()) {
                return gres;
            }
            if (gres.getAcceptorGLINs().isEmpty()) continue;
            for (GLIN donorGLIN : gres.getDonorGLINs()) {
                GLIN acceptorGLIN;
                if (gres.getDonorGLINs().size() == 1 && donorGLIN.isRepeat()) {
                    return gres;
                }
                if (donorGLIN.isRepeat() || (acceptorGLIN = gres.getAcceptorGLINs().get(0)).getDonor().isEmpty() || new GLINToLinkage().isFacingBetweenAnomer(donorGLIN)) continue;
                if (acceptorGLIN.getAcceptor().get(0).getID() == 1 && donorGLIN.getDonor().get(0).getID() == 1) {
                    return gres;
                }
                if (gres.getID() <= donorGLIN.getAcceptor().get(0).getID()) continue;
                return gres;
            }
        }
        return null;
    }

    private boolean isCompositionWithoutLinkage(Glycan _glycan) {
        if (!_glycan.isComposition()) {
            return false;
        }
        boolean ret = false;
        Residue bracket = _glycan.getBracket();
        for (Linkage fragEdge : bracket.getChildrenLinkages()) {
            Residue fragRoot = fragEdge.getChildResidue();
            if (!fragRoot.getParentsOfFragment().isEmpty()) continue;
            ret = true;
            break;
        }
        return ret;
    }
}

