/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.application.glycanbuilder.util.exchange.importer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glycoinfo.GlycanFormatconverter.Glycan.AnomericStateDescriptor;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.ModificationTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACNotationConverter;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.extended.ExtendedConverter;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.ModifiedMonosaccharideDescriptor;
import org.glycoinfo.GlycanFormatconverter.util.exchange.WURCSGraphToGlyContainer.WURCSGraphToGlyContainer;
import org.glycoinfo.WURCSFramework.util.WURCSException;
import org.glycoinfo.WURCSFramework.util.WURCSFactory;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSGraph;
import org.glycoinfo.WURCSFramework.wurcs.sequence2.GRES;

public class TrivialNameConverter {
    private Node node;
    private String trivialName;
    private String fullName;
    private final ArrayList<String> modifications = new ArrayList();

    public Node getNode() {
        return this.node;
    }

    public String getTrivialName() {
        return this.trivialName;
    }

    public String getIUPACNotation() {
        String ret = this.fullName;
        ret = ret.replaceAll(AnomericStateDescriptor.ALPHA.getIUPACAnomericState(), "\u03b1");
        ret = ret.replaceAll(AnomericStateDescriptor.BETA.getIUPACAnomericState(), "\u03b2");
        return ret;
    }

    public ArrayList<String> getModifications() {
        return this.modifications;
    }

    public void start(GRES _gres) throws GlycanException, WURCSException {
        Node node;
        String wurcs = "WURCS=2.0/1,1,0/[" + _gres.getMS().getString() + "]/1/";
        WURCSFactory wf = new WURCSFactory(wurcs);
        WURCSGraph graph = wf.getGraph();
        WURCSGraphToGlyContainer wg2gc = new WURCSGraphToGlyContainer();
        wg2gc.start(graph);
        GlyContainer gc = wg2gc.getGlycan();
        this.node = node = gc.getAllNodes().get(0);
        this.makeTrivialName(node);
        this.makeIUPACNotation(node);
        this.parseModifications(_gres);
        this.modifyTrivialName();
    }

    private void makeTrivialName(Node _node) {
        IUPACNotationConverter inConv = new IUPACNotationConverter();
        try {
            inConv.makeTrivialName(_node);
        }
        catch (GlycanException e) {
            e.printStackTrace();
        }
        this.trivialName = inConv.getCoreCode();
    }

    public void makeIUPACNotation(Node _node) {
        try {
            ExtendedConverter extConv = new ExtendedConverter();
            this.fullName = extConv.start(_node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseModifications(GRES _gres) {
        Matcher matMono;
        String skeletonCode = _gres.getMS().getCoreStructure().getSkeletonCode();
        String unsaturation = "";
        ArrayList<Integer> a_aPoss = new ArrayList<Integer>();
        Monosaccharide mono = (Monosaccharide)this.node;
        ModifiedMonosaccharideDescriptor monosaccharideDescriptor = ModifiedMonosaccharideDescriptor.forTrivialName(this.trivialName);
        if (monosaccharideDescriptor == null && (matMono = Pattern.compile(".+(HexA)").matcher(this.trivialName)).find()) {
            monosaccharideDescriptor = ModifiedMonosaccharideDescriptor.HEXA;
        }
        for (int i = 0; i < skeletonCode.length(); ++i) {
            ModificationTemplate modTemp = ModificationTemplate.forCarbon(skeletonCode.charAt(i));
            if (modTemp == null || modTemp.equals((Object)ModificationTemplate.HLOSE_5) || modTemp.equals((Object)ModificationTemplate.HLOSE_6) || modTemp.equals((Object)ModificationTemplate.HLOSE_7) || modTemp.equals((Object)ModificationTemplate.HLOSE_8) || modTemp.equals((Object)ModificationTemplate.HLOSE_X)) continue;
            int pos = i + 1;
            if (skeletonCode.charAt(i) == 'e' || skeletonCode.charAt(i) == 'E' || skeletonCode.charAt(i) == 'f' || skeletonCode.charAt(i) == 'F' || skeletonCode.charAt(i) == 'z' || skeletonCode.charAt(i) == 'Z') {
                a_aPoss.add(pos);
                continue;
            }
            if (monosaccharideDescriptor != null && (pos == 2 && skeletonCode.charAt(i) == 'U' || monosaccharideDescriptor.getModifications().contains(pos + "*" + skeletonCode.charAt(i))) || skeletonCode.charAt(i) == 'h' && (pos == mono.getSuperClass().getSize() || i == 0) || skeletonCode.charAt(i) == 'a' && pos == mono.getAnomericPosition() || skeletonCode.charAt(i) == 'o' && pos == 1 && mono.getAnomer().equals((Object)AnomericStateDescriptor.OPEN)) continue;
            this.modifications.add(pos + "*" + skeletonCode.charAt(i));
        }
        Iterator i = a_aPoss.iterator();
        while (i.hasNext()) {
            unsaturation = unsaturation + i.next();
            if (!i.hasNext()) continue;
            unsaturation = unsaturation + ",";
        }
        if (unsaturation.length() != 0) {
            unsaturation = unsaturation + "*en";
            this.modifications.add(unsaturation);
        }
    }

    public void modifyTrivialName() {
        if (this.modifications.contains("6*m") && this.trivialName.equals("Hex")) {
            this.trivialName = "dHex";
            this.modifications.remove("6*m");
        }
    }
}

