/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.application.glycanbuilder.util.exchange.importer;

import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.dataset.ResidueDictionary;
import org.glycoinfo.application.glycanbuilder.util.exchange.importer.GLINToLinkage;

public class LinkageConnector {
    private final Residue donor;
    private final Residue acceptor;
    private final Residue start;

    public LinkageConnector(Residue _donor, Residue _acceptor, Residue _start) {
        this.donor = _donor;
        this.acceptor = _acceptor;
        this.start = _start;
    }

    public void start(GLINToLinkage _glin2linkage) {
        Residue donor = this.donor;
        Residue substituent = null;
        if (!_glin2linkage.getParentLinkage().isEmpty()) {
            if (_glin2linkage.getBridgeLinkage() != null) {
                donor.setParentLinkage(_glin2linkage.getBridgeLinkage());
                substituent = _glin2linkage.getBridgeLinkage().getParentResidue();
                substituent.setParentLinkage(_glin2linkage.getParentLinkage().get(0));
            } else {
                donor.setParentLinkage(_glin2linkage.getParentLinkage().getLast());
            }
        } else if (_glin2linkage.getStartCyclicLinkage() != null) {
            donor.setParentLinkage(_glin2linkage.getStartCyclicLinkage());
        } else if (_glin2linkage.getStartSideRepLinkage() != null) {
            donor.setParentLinkage(_glin2linkage.getStartSideRepLinkage());
        }
        if (_glin2linkage.getDonorGLINs().isEmpty()) {
            this.analyzeBracketNotation(donor, null, _glin2linkage);
            return;
        }
        if (_glin2linkage.getParents().size() > 1) {
            return;
        }
        if (!_glin2linkage.isCyclic() && !_glin2linkage.isRepeating()) {
            if (this.isOutRepeating(this.donor, this.acceptor)) {
                this.acceptor.getEndRepitionResidue().addChild(donor, donor.getParentLinkage().getBonds());
            } else if (substituent != null) {
                this.acceptor.addChild(substituent, substituent.getParentLinkage().getBonds());
                substituent.addChild(donor, donor.getParentLinkage().getBonds());
            } else {
                this.acceptor.addChild(donor, donor.getParentLinkage().getBonds());
            }
        } else {
            this.analyzeBracketNotation(donor, substituent, _glin2linkage);
        }
    }

    private void analyzeBracketNotation(Residue a_oRES, Residue a_oBridge, GLINToLinkage a_oG2L) {
        if (a_oG2L.getEndSideRepLinkage() != null) {
            this.makeEdgeWithEndBracket(a_oG2L, a_oRES);
        }
        if (a_oG2L.getEndCyclicLinkage() != null) {
            this.makeEdgeWithEndCyclic(a_oG2L, a_oRES);
        }
        if (a_oG2L.getStartSideRepLinkage() != null) {
            this.makeEdgeWithStartBracket(a_oG2L, a_oRES);
        }
        if (a_oG2L.getStartCyclicLinkage() != null) {
            this.makeEdgeWithStartCyclic(a_oRES);
        }
        if (this.donor.equals(this.acceptor)) {
            return;
        }
        if (a_oRES.getStartRepetitionResidue() != null && a_oRES.getStartCyclicResidue() == null && this.acceptor != null) {
            Residue a_oStartRep = a_oRES.getStartRepetitionResidue();
            if (this.isOutRepeating(a_oStartRep, this.acceptor)) {
                this.acceptor.getEndRepitionResidue().addChild(a_oStartRep, a_oStartRep.getParentLinkage().getBonds());
            } else {
                this.acceptor.addChild(a_oStartRep, a_oStartRep.getParentLinkage().getBonds());
            }
        } else if (a_oRES.getStartCyclicResidue() == null && !a_oG2L.getParents().isEmpty()) {
            if (this.isOutRepeating(a_oRES, this.acceptor)) {
                this.acceptor.getEndRepitionResidue().addChild(a_oRES, a_oRES.getParentLinkage().getBonds());
            } else if (a_oBridge == null) {
                if (!a_oRES.equals(this.acceptor)) {
                    this.acceptor.addChild(a_oRES, a_oRES.getParentLinkage().getBonds());
                }
            } else {
                this.acceptor.addChild(a_oBridge, a_oBridge.getParentLinkage().getBonds());
                a_oBridge.addChild(a_oRES, a_oRES.getParentLinkage().getBonds());
            }
        }
    }

    private void makeEdgeWithStartBracket(GLINToLinkage a_oG2L, Residue a_oRES) {
        Residue a_oStartRep = ResidueDictionary.createStartRepetition();
        a_oStartRep.setParentLinkage(a_oG2L.getStartSideRepLinkage());
        a_oRES.setStartRepetiionResidue(a_oStartRep);
        a_oStartRep.setAnomericCarbon(a_oRES.getAnomericCarbon());
        a_oStartRep.addChild(a_oRES, a_oRES.getParentLinkage().getBonds());
    }

    private void makeEdgeWithEndBracket(GLINToLinkage a_oG2L, Residue a_oRES) {
        Residue a_oEndRep = ResidueDictionary.createEndRepetition(a_oG2L.getMinRepeatingCount(), a_oG2L.getMaxRepeatingCount());
        a_oEndRep.setParentLinkage(a_oG2L.getEndSideRepLinkage());
        a_oEndRep.setStartResidue(this.start);
        a_oRES.setEndRepitionResidue(a_oEndRep);
        if (a_oG2L.getEndSideRepLinkage().getChildResidue() != null) {
            Residue a_oSUB = a_oG2L.getEndSideRepLinkage().getChildResidue();
            a_oSUB.setParentLinkage(a_oG2L.getParentLinkage().get(0));
            a_oRES.addChild(a_oSUB, a_oSUB.getParentLinkage().getBonds());
            a_oSUB.addChild(a_oEndRep, a_oEndRep.getParentLinkage().getBonds());
        } else {
            a_oRES.addChild(a_oEndRep, a_oEndRep.getParentLinkage().getBonds());
        }
    }

    private void makeEdgeWithStartCyclic(Residue a_oRES) {
        Residue a_oStartCyclic = ResidueDictionary.createStartCyclic();
        a_oRES.setStartCyclicResidue(a_oStartCyclic);
        if (a_oRES.getStartRepetitionResidue() != null) {
            a_oStartCyclic.addChild(a_oRES.getStartRepetitionResidue(), a_oRES.getStartRepetitionResidue().getParentLinkage().getBonds());
        } else {
            a_oStartCyclic.addChild(a_oRES, a_oRES.getParentLinkage().getBonds());
        }
    }

    private void makeEdgeWithEndCyclic(GLINToLinkage a_oG2L, Residue a_oRES) {
        Residue a_oEndCyclic = ResidueDictionary.createEndCyclic();
        a_oEndCyclic.setParentLinkage(a_oG2L.getEndCyclicLinkage());
        a_oRES.setEndCyclicResidue(a_oEndCyclic);
        if (a_oRES.getEndRepitionResidue() != null) {
            a_oRES.getEndRepitionResidue().addChild(a_oEndCyclic, a_oEndCyclic.getParentLinkage().getBonds());
        } else {
            a_oRES.addChild(a_oEndCyclic, a_oEndCyclic.getParentLinkage().getBonds());
        }
    }

    private boolean isOutRepeating(Residue _donor, Residue _acceptor) {
        if (_acceptor.getEndRepitionResidue() == null) {
            return false;
        }
        String donorPos = _donor.getParentLinkage().getParentPositionsString();
        String acceptorPos = _acceptor.getEndRepitionResidue().getParentLinkage().getParentPositionsString();
        if (donorPos.contains("/") && acceptorPos.contains("/")) {
            if (donorPos.equals(acceptorPos)) {
                return true;
            }
            donorPos = donorPos.substring(0, 1);
            acceptorPos = acceptorPos.substring(0, 1);
        }
        if (donorPos.equals("?") || acceptorPos.equals("?")) {
            return false;
        }
        return Integer.parseInt(donorPos) == Integer.parseInt(acceptorPos);
    }
}

