/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.wurcs.graph;

import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.InterfaceRepeat;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.graph.ModificationAlternative;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;

public class Monosaccharide {
    private Backbone m_oCoreBackbone;

    public Monosaccharide(Backbone a_oBackbone) {
        this.m_oCoreBackbone = a_oBackbone;
    }

    public Backbone getBackbone() {
        return this.m_oCoreBackbone;
    }

    public boolean checkAroundAlternative() {
        for (WURCSEdge t_oEdge : this.m_oCoreBackbone.getEdges()) {
            if (!(t_oEdge.getModification() instanceof ModificationAlternative)) continue;
            return true;
        }
        return false;
    }

    public LinkedList<Modification> getRingModifications() {
        LinkedList<Modification> t_aRingMods = new LinkedList<Modification>();
        for (WURCSEdge t_oEdge : this.m_oCoreBackbone.getEdges()) {
            Modification t_oMod = t_oEdge.getModification();
            if (t_oMod.isGlycosidic() || t_oMod.getEdges().size() < 2 || t_oEdge.getModification() instanceof InterfaceRepeat) continue;
            t_aRingMods.add(t_oMod);
        }
        return t_aRingMods;
    }

    public LinkedList<WURCSEdge> getRingEdges() {
        LinkedList<WURCSEdge> t_aModEdges = new LinkedList<WURCSEdge>();
        for (WURCSEdge t_oEdge : this.m_oCoreBackbone.getChildEdges()) {
            if (t_oEdge.getModification().isGlycosidic() || t_oEdge.getModification().getEdges().size() < 2 || t_oEdge.getModification() instanceof InterfaceRepeat) continue;
            t_aModEdges.add(t_oEdge);
        }
        return t_aModEdges;
    }

    public LinkedList<WURCSEdge> getSubstituentEdges() {
        LinkedList<WURCSEdge> t_aModEdges = new LinkedList<WURCSEdge>();
        for (WURCSEdge t_oEdge : this.m_oCoreBackbone.getChildEdges()) {
            if (t_oEdge.getModification().isGlycosidic() || t_oEdge.getModification().getEdges().size() != 1 || t_oEdge.getModification().canOmitMAP()) continue;
            t_aModEdges.add(t_oEdge);
        }
        return t_aModEdges;
    }

    public LinkedList<WURCSEdge> getChildGlycosidicEdges() {
        LinkedList<WURCSEdge> t_aModEdges = new LinkedList<WURCSEdge>();
        for (WURCSEdge t_oEdge : this.m_oCoreBackbone.getChildEdges()) {
            if (!t_oEdge.getModification().isGlycosidic() || t_oEdge.equals(this.m_oCoreBackbone.getAnomericEdge())) continue;
            t_aModEdges.add(t_oEdge);
        }
        return t_aModEdges;
    }
}

