/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.wurcs.graph;

import org.glycoinfo.WURCSFramework.wurcs.graph.ICarbonDescriptor;

public enum CarbonDescriptor implements ICarbonDescriptor
{
    SZ3_METHYL_L('m', "sp3", 1, 0, 1, null, false, H, H, H, 4),
    SZ3_METHYL_U('M', "sp3", 1, 0, 1, null, false, X1, X1, X1, 10),
    SZ3_HYDROXYL('h', "sp3", 1, 0, 2, null, false, H, H, X1, 6),
    SZ3_ACETAL_L('c', "sp3", 1, 0, 2, null, false, X1, X1, H, 8),
    SZ3_ACETAL_U('C', "sp3", 1, 0, 2, null, false, X1, X1, X1, 10),
    SZ3_STEREO_S_L('1', "sp3", 1, 0, 3, "S", false, X1, X1, H, 10),
    SZ3_STEREO_R_L('2', "sp3", 1, 0, 3, "R", false, X1, X1, H, 9),
    SZ3_STEREO_s_L('3', "sp3", 1, 0, 3, "s", false, X1, X1, H, 10),
    SZ3_STEREO_r_L('4', "sp3", 1, 0, 3, "r", false, X1, X1, H, 9),
    SZ3_STEREO_X_L('x', "sp3", 1, 0, 3, "X", false, X1, X1, H, 8),
    SZ3_STEREO_S_U('5', "sp3", 1, 0, 3, "S", false, X1, X1, X1, 12),
    SZ3_STEREO_R_U('6', "sp3", 1, 0, 3, "R", false, X1, X1, X1, 11),
    SZ3_STEREO_s_U('7', "sp3", 1, 0, 3, "s", false, X1, X1, X1, 12),
    SZ3_STEREO_r_U('8', "sp3", 1, 0, 3, "r", false, X1, X1, X1, 11),
    SZ3_STEREO_X_U('X', "sp3", 1, 0, 3, "X", false, X1, X1, X1, 10),
    SZ2_ALDEHYDE('o', "sp2", 1, 0, 2, null, false, X2, H, null, 17),
    SZ2_ACID_U('A', "sp2", 1, 0, 2, null, false, X2, X1, null, 14),
    DZ2_METHYLENE_L('n', "sp2", 2, 0, 1, null, false, H, H, null, 4),
    DZ2_METHYLENE_U('N', "sp2", 2, 0, 1, null, false, X1, X1, null, 8),
    DZ2_CISTRANS_EL('e', "sp2", 2, 0, 2, "E", false, X1, H, null, 8),
    DZ2_CISTRANS_ZL('z', "sp2", 2, 0, 2, "Z", false, X1, H, null, 7),
    DZ2_CISTRANS_XL('f', "sp2", 2, 0, 2, "X", false, X1, H, null, 7),
    DZ2_CISTRANS_EU('E', "sp2", 2, 0, 2, "E", false, X1, X1, null, 10),
    DZ2_CISTRANS_ZU('Z', "sp2", 2, 0, 2, "Z", false, X1, X1, null, 9),
    DZ2_CISTRANS_XU('F', "sp2", 2, 0, 2, "X", false, X1, X1, null, 8),
    SZ1_XETHYNE('T', "sp", 1, 0, 1, null, false, X3, null, null, 10),
    DZ1_KETENE_U('K', "sp", 2, 0, 1, null, false, X2, null, null, 6),
    TZ1_ETHYNE_L('t', "sp", 3, 0, 1, null, false, H, null, null, 4),
    TZ1_ETHYNE_U('T', "sp", 3, 0, 1, null, false, X1, null, null, 6),
    SZX_ANOMER('a', "sp3", 1, 0, 3, null, true, X1, X1, H, 17),
    SZX_UNDEF_L('u', "?", 1, 0, -1, null, null, H, null, null, 17),
    SZX_UNDEF_ALL('Q', "?", -1, 0, -1, null, null, null, null, null, 0),
    SS3_METHYNE('d', "sp3", 1, 1, 1, null, false, H, H, null, 4),
    SS3_ACETAL('C', "sp3", 1, 1, 1, null, false, X1, X1, null, 8),
    SS3_STEREO_S_L('1', "sp3", 1, 1, 2, "S", false, X1, H, null, 8),
    SS3_STEREO_R_L('2', "sp3", 1, 1, 2, "R", false, X1, H, null, 7),
    SS3_STEREO_s_L('3', "sp3", 1, 1, 2, "s", false, X1, H, null, 8),
    SS3_STEREO_r_L('4', "sp3", 1, 1, 2, "r", false, X1, H, null, 7),
    SS3_STEREO_X_L('x', "sp3", 1, 1, 2, "X", false, X1, H, null, 6),
    SS3_CHIRAL_S_U('5', "sp3", 1, 1, 2, "S", false, X1, X1, null, 10),
    SS3_CHIRAL_R_U('6', "sp3", 1, 1, 2, "R", false, X1, X1, null, 9),
    SS3_CHIRAL_s_U('7', "sp3", 1, 1, 2, "s", false, X1, X1, null, 10),
    SS3_CHIRAL_r_U('8', "sp3", 1, 1, 2, "r", false, X1, X1, null, 9),
    SS3_CHIRAL_X_U('X', "sp3", 1, 1, 2, "X", false, X1, X1, null, 8),
    SS2_KETONE_U('O', "sp2", 1, 1, 1, null, false, X2, null, null, 17),
    DS2_CISTRANS_EL('e', "sp2", 2, 1, 1, "E", false, H, null, null, 6),
    DS2_CISTRANS_ZL('z', "sp2", 2, 1, 1, "Z", false, H, null, null, 5),
    DS2_CISTRANS_NL('n', "sp2", 2, 1, 1, "N", false, H, null, null, 4),
    DS2_CISTRANS_XL('f', "sp2", 2, 1, 1, "X", false, H, null, null, 4),
    DS2_CISTRANS_EU('E', "sp2", 2, 1, 1, "E", false, X1, null, null, 8),
    DS2_CISTRANS_ZU('Z', "sp2", 2, 1, 1, "Z", false, X1, null, null, 7),
    DS2_CISTRANS_NU('N', "sp2", 2, 1, 1, "N", false, X1, null, null, 6),
    DS2_CISTRANS_XU('F', "sp2", 2, 1, 1, "X", false, X1, null, null, 6),
    DD1_KETENE('K', "sp", 2, 2, 0, null, false, null, null, null, 4),
    TS1_ETHYNE('T', "sp", 3, 1, 0, null, false, null, null, null, 4),
    SSX_ANOMER('a', "sp3", 1, 1, 2, null, true, X1, X1, null, 17),
    SSX_UNDEF_U('U', "?", 1, 1, -1, null, null, null, null, null, 17),
    SSX_UNDEF_ALL('Q', "?", -1, -1, -1, null, null, null, null, null, 0),
    XXX_UNKNOWN('?', "?", -1, -1, -1, null, null, null, null, null, 0);

    private char m_cChar;
    private String m_strHybridOrbital;
    private int m_iBondTypeCarbon1;
    private int m_iBondTypeCarbon2;
    private int m_nUniqueModification;
    private String m_strStereo;
    private Boolean m_bIsFootOfBridge;
    private ICarbonDescriptor.ModificationType m_typeModification1;
    private ICarbonDescriptor.ModificationType m_typeModification2;
    private ICarbonDescriptor.ModificationType m_typeModification3;
    private int m_iCarbonScore;

    private CarbonDescriptor(char a_strChar, String a_strOrbital, int a_iTypeC1, int a_iTypeC2, int a_nUniqMod, String a_strStereo, Boolean a_bIsFoot, ICarbonDescriptor.ModificationType a_strMod1, ICarbonDescriptor.ModificationType a_strMod2, ICarbonDescriptor.ModificationType a_strMod3, int a_iScore) {
        this.m_cChar = a_strChar;
        this.m_strHybridOrbital = a_strOrbital;
        this.m_iBondTypeCarbon1 = a_iTypeC1;
        this.m_iBondTypeCarbon2 = a_iTypeC2;
        this.m_nUniqueModification = a_nUniqMod;
        this.m_strStereo = a_strStereo;
        this.m_bIsFootOfBridge = a_bIsFoot;
        this.m_typeModification1 = a_strMod1;
        this.m_typeModification2 = a_strMod2;
        this.m_typeModification3 = a_strMod3;
        this.m_iCarbonScore = a_iScore;
    }

    @Override
    public char getChar() {
        return this.m_cChar;
    }

    @Override
    public String getHybridOrbital() {
        return this.m_strHybridOrbital;
    }

    public int getBondTypeCarbon1() {
        return this.m_iBondTypeCarbon1;
    }

    public int getBondTypeCarbon2() {
        return this.m_iBondTypeCarbon2;
    }

    @Override
    public Boolean isTerminal() {
        if (this.m_cChar == '?') {
            return null;
        }
        return this.m_iBondTypeCarbon2 == 0;
    }

    @Override
    public int getNumberOfUniqueModifications() {
        return this.m_nUniqueModification;
    }

    @Override
    public String getStereo() {
        return this.m_strStereo;
    }

    @Override
    public Boolean isAnomeric() {
        return this.m_bIsFootOfBridge;
    }

    public boolean isFootOfBridge() {
        return this.m_bIsFootOfBridge == null ? false : this.m_bIsFootOfBridge;
    }

    @Override
    public boolean isChiral() {
        if (this.m_strHybridOrbital == null) {
            return false;
        }
        if (!this.m_strHybridOrbital.equals("sp3")) {
            return false;
        }
        return this.m_strStereo != null;
    }

    @Override
    public ICarbonDescriptor.ModificationType getModificationType(int num) {
        if (num == 1) {
            return this.m_typeModification1;
        }
        if (num == 2) {
            return this.m_typeModification2;
        }
        if (num == 3) {
            return this.m_typeModification3;
        }
        return null;
    }

    @Override
    public int getNumberOfModifications() {
        int num = 0;
        for (int i = 1; i <= 3; ++i) {
            if (this.getModificationType(i) == null) continue;
            ++num;
        }
        return num;
    }

    @Override
    public int getNumberOfHydrogens() {
        int num = 0;
        for (int i = 1; i <= 3; ++i) {
            if (H != this.getModificationType(i)) continue;
            ++num;
        }
        return num;
    }

    @Override
    public String getModification(int num) {
        ICarbonDescriptor.ModificationType type = this.getModificationType(num);
        if (type == null) {
            return null;
        }
        return type.toString();
    }

    @Override
    public int getCarbonScore() {
        return this.m_iCarbonScore;
    }

    public static CarbonDescriptor forCharacter(char cName, Boolean isTerminal) {
        for (CarbonDescriptor cd : CarbonDescriptor.values()) {
            if (cd.m_cChar != cName || cd.isTerminal() != isTerminal) continue;
            return cd;
        }
        return XXX_UNKNOWN;
    }

    public static CarbonDescriptor forCarbonSituation(String a_strOrbital, int a_iTypeC1, int a_iTypeC2, int a_nUniqMod, String a_strStereo, Boolean a_bIsFoot, ICarbonDescriptor.ModificationType a_modType1, ICarbonDescriptor.ModificationType a_modType2, ICarbonDescriptor.ModificationType a_modType3) {
        for (CarbonDescriptor cd : CarbonDescriptor.values()) {
            if (cd.m_strHybridOrbital != null && !cd.m_strHybridOrbital.equals(a_strOrbital) || cd.m_iBondTypeCarbon1 != a_iTypeC1 || cd.m_iBondTypeCarbon2 != a_iTypeC2 || cd.m_nUniqueModification != -1 && cd.m_nUniqueModification != a_nUniqMod || cd.m_strStereo != null && !cd.m_strStereo.equals(a_strStereo) || cd.m_bIsFootOfBridge != null && !cd.m_bIsFootOfBridge.equals(a_bIsFoot) || !cd.matchModifications(a_modType1, a_modType2, a_modType3)) continue;
            return cd;
        }
        return XXX_UNKNOWN;
    }

    private boolean matchModifications(ICarbonDescriptor.ModificationType mod1, ICarbonDescriptor.ModificationType mod2, ICarbonDescriptor.ModificationType mod3) {
        ICarbonDescriptor.ModificationType[] mMods = new ICarbonDescriptor.ModificationType[]{this.m_typeModification1, this.m_typeModification2, this.m_typeModification3};
        ICarbonDescriptor.ModificationType[] aMods = new ICarbonDescriptor.ModificationType[]{mod1, mod2, mod3};
        for (int i = 0; i < 3; ++i) {
            if (mMods[i] == null) {
                return aMods[i] == null;
            }
            if (aMods[i] == null) {
                return false;
            }
            if (mMods[i] == aMods[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public CarbonDescriptor getInverted() {
        if (!this.isChiral()) {
            return this;
        }
        if (this.m_strStereo.equals("X")) {
            return this;
        }
        String strStereoNew = this.m_strStereo.equals("R") ? "S" : (this.m_strStereo.equals("S") ? "R" : (this.m_strStereo.equals("r") ? "s" : (this.m_strStereo.equals("s") ? "r" : this.m_strStereo)));
        return CarbonDescriptor.forCarbonSituation(this.m_strHybridOrbital, this.m_iBondTypeCarbon1, this.m_iBondTypeCarbon2, this.m_nUniqueModification, strStereoNew, this.m_bIsFootOfBridge, this.m_typeModification1, this.m_typeModification2, this.m_typeModification3);
    }

    public String toString() {
        return "" + this.m_cChar;
    }
}

