/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.map.analysis.cip;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.map.analysis.ValenceBondCalculator;
import org.glycoinfo.WURCSFramework.util.map.analysis.cip.AtomicNumber;
import org.glycoinfo.WURCSFramework.util.map.analysis.cip.MAPConnectionComparatorUsingCIPSystem;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPAtom;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPAtomAbstract;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPBondType;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPConnection;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPGraph;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPStar;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPStereo;

public class MAPStereochemistryCheckerUsingCIPSystem {
    private MAPGraph m_oGraph;
    private boolean m_bHasStereoChange;

    public MAPStereochemistryCheckerUsingCIPSystem(MAPGraph a_oGraph) {
        this.m_oGraph = a_oGraph;
        this.m_bHasStereoChange = false;
    }

    public boolean hasStereoChange() {
        return this.m_bHasStereoChange;
    }

    public void resetStereo() {
        HashSet<MAPConnection> t_aSearchedConns = new HashSet<MAPConnection>();
        for (MAPAtomAbstract t_oAtomAb : this.m_oGraph.getAtoms()) {
            if (!(t_oAtomAb instanceof MAPAtom)) continue;
            MAPAtom t_oAtom = (MAPAtom)t_oAtomAb;
            this.m_bHasStereoChange |= this.resetAtomStereo(t_oAtom);
            for (MAPConnection t_oConn : this.m_oGraph.getAtomToConnections().get(t_oAtom)) {
                if (t_aSearchedConns.contains(t_oConn) || t_aSearchedConns.contains(t_oConn.getReverse())) continue;
                t_aSearchedConns.add(t_oConn);
                MAPAtomAbstract t_oConnAtomAb = t_oConn.getAtom();
                if (!(t_oConnAtomAb instanceof MAPAtom)) continue;
                MAPAtom t_oConnAtom = (MAPAtom)t_oConnAtomAb;
                this.m_bHasStereoChange |= this.resetBondStereo(t_oAtom, t_oConnAtom);
            }
        }
    }

    private boolean resetBondStereo(MAPAtom a_oAtom1, MAPAtom a_oAtom2) {
        MAPConnection t_oBond = null;
        for (MAPConnection t_oConn : a_oAtom1.getConnections()) {
            if (!t_oConn.getAtom().equals(a_oAtom2)) continue;
            t_oBond = t_oConn;
        }
        if (t_oBond == null) {
            return false;
        }
        if (t_oBond.getReverse() == null) {
            return false;
        }
        boolean t_bHasStereo = this.hasBondStereo(a_oAtom1, a_oAtom2);
        if (!t_bHasStereo) {
            if (t_oBond.getStereo() == null) {
                return false;
            }
            t_oBond.setStereo(null);
            t_oBond.getReverse().setStereo(null);
            return true;
        }
        if (t_oBond.getStereo() == null) {
            t_oBond.setStereo(MAPStereo.UNKNOWN);
            t_oBond.getReverse().setStereo(MAPStereo.UNKNOWN);
            return true;
        }
        return false;
    }

    private boolean resetAtomStereo(MAPAtom a_oAtom) {
        boolean t_bHasStereo = this.hasAtomStereo(a_oAtom);
        if (!t_bHasStereo) {
            if (a_oAtom.getStereo() == null) {
                return false;
            }
            a_oAtom.setStereo(null);
            return true;
        }
        if (a_oAtom.getStereo() == null) {
            a_oAtom.setStereo(MAPStereo.UNKNOWN);
            return true;
        }
        MAPStereo t_enumStereo = a_oAtom.getStereo();
        if (t_enumStereo == MAPStereo.UNKNOWN) {
            return false;
        }
        return false;
    }

    private void orderMAPStarsByStereo() {
        LinkedList t_oStereoAtoms = new LinkedList();
        for (MAPAtomAbstract t_oAtomAb : this.m_oGraph.getAtoms()) {
            LinkedList<MAPStar> t_aRelatedStars;
            MAPAtom t_oAtom;
            if (!(t_oAtomAb instanceof MAPAtom) || !this.hasStereo(t_oAtom = (MAPAtom)t_oAtomAb, null) || (t_aRelatedStars = this.getMAPStarsChangingStereo(t_oAtom)).isEmpty()) continue;
            HashSet<Integer> t_aUniqueIndices = new HashSet<Integer>();
            boolean t_bHasUniqueNumbers = true;
            for (MAPStar t_oStar : t_aRelatedStars) {
                if (t_aUniqueIndices.contains(t_oStar.getStarIndex())) {
                    t_bHasUniqueNumbers = false;
                    break;
                }
                t_aUniqueIndices.add(t_oStar.getStarIndex());
            }
            if (!t_bHasUniqueNumbers) continue;
        }
    }

    public LinkedList<MAPStar> getMAPStarsChangingStereo(MAPAtom a_oAtom) {
        LinkedList<MAPStar> t_aRelatedStars = new LinkedList<MAPStar>();
        LinkedList<MAPConnection> t_aConns = this.m_oGraph.getAtomToConnections().get(a_oAtom);
        HashMap<MAPConnection, Integer> t_mapConnToOrderOrig = this.getConnectionsOrder(t_aConns, new AtomicNumber());
        for (MAPStar t_oStar : this.m_oGraph.getStars()) {
            AtomicNumber t_oAN = new AtomicNumber();
            t_oAN.setAdditionalWeight(t_oStar, 0.1);
            HashMap<MAPConnection, Integer> t_mapConnToOrder = this.getConnectionsOrder(t_aConns, t_oAN);
            boolean t_bHasChanged = false;
            for (MAPConnection t_oConn : t_mapConnToOrderOrig.keySet()) {
                int t_iOrder2;
                int t_iOrder1 = t_mapConnToOrderOrig.get(t_oConn);
                if (t_iOrder1 == (t_iOrder2 = t_mapConnToOrder.get(t_oConn).intValue())) continue;
                t_bHasChanged = true;
                break;
            }
            if (!t_bHasChanged) continue;
            t_aRelatedStars.add(t_oStar);
        }
        return t_aRelatedStars;
    }

    private boolean hasBondStereo(MAPAtom a_oAtom1, MAPAtom a_oAtom2) {
        MAPConnection t_oBond = null;
        for (MAPConnection t_oConn : this.m_oGraph.getAtomToConnections().get(a_oAtom1)) {
            if (!t_oConn.getAtom().equals(a_oAtom2)) continue;
            t_oBond = t_oConn;
        }
        if (t_oBond == null) {
            return false;
        }
        if (t_oBond.getReverse() == null) {
            return false;
        }
        if (t_oBond.getBondType() != MAPBondType.DOUBLE && t_oBond.getBondType() != MAPBondType.AROMATIC) {
            return false;
        }
        if (!this.hasThreeConnections(a_oAtom1)) {
            return false;
        }
        if (!this.hasThreeConnections(a_oAtom2)) {
            return false;
        }
        if (!this.hasStereo(a_oAtom1, t_oBond)) {
            return false;
        }
        return this.hasStereo(a_oAtom2, t_oBond.getReverse());
    }

    private boolean hasAtomStereo(MAPAtom a_oAtom) {
        if (!this.hasFourConnections(a_oAtom)) {
            return false;
        }
        return this.hasStereo(a_oAtom, null);
    }

    private boolean hasStereo(MAPAtom a_oAtom, MAPConnection a_oIgnoreConn) {
        ValenceBondCalculator t_oVBCalc = new ValenceBondCalculator(this.m_oGraph);
        int t_iDiff = t_oVBCalc.countRemainingValence(a_oAtom);
        if (t_iDiff == -1) {
            return false;
        }
        if (t_iDiff > 1) {
            return false;
        }
        if (t_oVBCalc.hasTautomaricConnections(a_oAtom)) {
            return false;
        }
        LinkedList<MAPConnection> t_aConns = this.m_oGraph.getAtomToConnections().get(a_oAtom);
        if (a_oIgnoreConn != null && t_aConns.contains(a_oIgnoreConn)) {
            t_aConns.remove(a_oIgnoreConn);
        }
        AtomicNumber t_oAN = new AtomicNumber();
        HashMap<MAPConnection, Integer> t_mapConnToOrder = this.getConnectionsOrder(t_aConns, t_oAN);
        HashSet<Integer> t_aUniqueOrders = new HashSet<Integer>();
        boolean t_bHasUniqueConnections = true;
        for (MAPConnection t_oConn : t_mapConnToOrder.keySet()) {
            if (t_aUniqueOrders.contains(t_mapConnToOrder.get(t_oConn))) {
                t_bHasUniqueConnections = false;
                break;
            }
            t_aUniqueOrders.add(t_mapConnToOrder.get(t_oConn));
        }
        if (t_bHasUniqueConnections) {
            return true;
        }
        if (this.getMAPStarsChangingStereo(a_oAtom).isEmpty()) {
            return false;
        }
        AtomicNumber t_oAN2 = new AtomicNumber();
        int t_iFactor = 1;
        for (MAPStar t_oStar : this.getMAPStarsChangingStereo(a_oAtom)) {
            t_oAN2.setAdditionalWeight(t_oStar, 0.1 * (double)t_iFactor);
            ++t_iFactor;
        }
        t_mapConnToOrder = this.getConnectionsOrder(t_aConns, t_oAN2);
        t_aUniqueOrders = new HashSet();
        t_bHasUniqueConnections = true;
        for (MAPConnection t_oConn : t_mapConnToOrder.keySet()) {
            if (t_aUniqueOrders.contains(t_mapConnToOrder.get(t_oConn))) {
                t_bHasUniqueConnections = false;
                break;
            }
            t_aUniqueOrders.add(t_mapConnToOrder.get(t_oConn));
        }
        return t_bHasUniqueConnections;
    }

    private boolean hasThreeConnections(MAPAtom a_oAtom) {
        ValenceBondCalculator t_oVBCalc = new ValenceBondCalculator(this.m_oGraph);
        int t_iConns = t_oVBCalc.countConnections(a_oAtom);
        if (t_iConns == -1) {
            return false;
        }
        return t_iConns == 3;
    }

    private boolean hasFourConnections(MAPAtom a_oAtom) {
        if (a_oAtom.isAromatic()) {
            return false;
        }
        ValenceBondCalculator t_oVBCalc = new ValenceBondCalculator(this.m_oGraph);
        int t_iConns = t_oVBCalc.countConnections(a_oAtom);
        if (t_iConns == -1) {
            return false;
        }
        return t_iConns == 4;
    }

    private HashMap<MAPConnection, Integer> getConnectionsOrder(LinkedList<MAPConnection> a_aConns, AtomicNumber a_oAN) {
        MAPConnectionComparatorUsingCIPSystem t_oConnComp = new MAPConnectionComparatorUsingCIPSystem(this.m_oGraph, a_oAN);
        Collections.sort(a_aConns, t_oConnComp);
        int t_iOrder = 1;
        HashMap<MAPConnection, Integer> t_mapConnToOrder = new HashMap<MAPConnection, Integer>();
        MAPConnection t_oPrevConn = null;
        for (MAPConnection t_oConn : a_aConns) {
            if (t_oPrevConn == null) {
                t_oPrevConn = t_oConn;
                t_mapConnToOrder.put(t_oConn, t_iOrder);
                continue;
            }
            if (t_oConnComp.compare(t_oPrevConn, t_oConn) != 0) {
                ++t_iOrder;
            }
            t_mapConnToOrder.put(t_oConn, t_iOrder);
            t_oPrevConn = t_oConn;
        }
        return t_mapConnToOrder;
    }
}

