/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.map.analysis.cip;

import java.util.Collections;
import java.util.Comparator;
import org.glycoinfo.WURCSFramework.util.map.analysis.cip.AtomicNumber;
import org.glycoinfo.WURCSFramework.util.map.analysis.cip.HierarchicalDigraphComparator;
import org.glycoinfo.WURCSFramework.util.map.analysis.cip.HierarchicalDigraphComparatorForStereo;
import org.glycoinfo.WURCSFramework.util.map.analysis.cip.HierarchicalDigraphCreator;
import org.glycoinfo.WURCSFramework.util.map.analysis.cip.HierarchicalDigraphNode;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPConnection;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPGraph;

public class MAPConnectionComparatorUsingCIPSystem
implements Comparator<MAPConnection> {
    private MAPGraph m_oMAPGraph;
    private AtomicNumber m_oANum;
    private int m_iMaxDepth;

    public MAPConnectionComparatorUsingCIPSystem(MAPGraph a_oGraph, AtomicNumber a_oANum) {
        this.m_oMAPGraph = a_oGraph;
        this.m_oANum = a_oANum;
        this.m_iMaxDepth = 20;
    }

    public MAPConnectionComparatorUsingCIPSystem(MAPGraph a_oGraph) {
        this(a_oGraph, new AtomicNumber());
    }

    public void setMaximumDepth(int a_iDepth) {
        this.m_iMaxDepth = a_iDepth < 1 ? 0 : a_iDepth;
    }

    @Override
    public int compare(MAPConnection a_oConnection1, MAPConnection a_oConnection2) {
        HierarchicalDigraphNode t_oHD1 = null;
        HierarchicalDigraphNode t_oHD2 = null;
        for (int t_iDepth = 1; this.m_iMaxDepth != 0 && t_iDepth <= this.m_iMaxDepth; ++t_iDepth) {
            HierarchicalDigraphCreator t_oHDCreate1 = this.getHDCreator(a_oConnection1, t_iDepth);
            HierarchicalDigraphCreator t_oHDCreate2 = this.getHDCreator(a_oConnection2, t_iDepth);
            t_oHD1 = t_oHDCreate1.getHierarchicalDigraph();
            t_oHD2 = t_oHDCreate2.getHierarchicalDigraph();
            HierarchicalDigraphComparator t_oHDComp = new HierarchicalDigraphComparator();
            this.sortChildren(t_oHD1, t_oHDComp);
            this.sortChildren(t_oHD2, t_oHDComp);
            int t_iComp = t_oHDComp.compare(t_oHD1, t_oHD2);
            if (t_iComp != 0) {
                return t_iComp;
            }
            if (t_oHDCreate1.isCompletedFullSearch() && t_oHDCreate2.isCompletedFullSearch()) break;
        }
        HierarchicalDigraphComparatorForStereo t_oHDComp = new HierarchicalDigraphComparatorForStereo();
        this.sortChildren(t_oHD1, t_oHDComp);
        this.sortChildren(t_oHD2, t_oHDComp);
        int t_iComp = t_oHDComp.compare(t_oHD1, t_oHD2);
        if (t_iComp != 0) {
            return t_iComp;
        }
        return 0;
    }

    private HierarchicalDigraphCreator getHDCreator(MAPConnection a_oConnection, int t_iDepth) {
        HierarchicalDigraphCreator t_oHDCreator = new HierarchicalDigraphCreator(this.m_oANum, this.m_oMAPGraph);
        t_oHDCreator.start(a_oConnection, t_iDepth);
        return t_oHDCreator;
    }

    private void sortChildren(HierarchicalDigraphNode a_oHD, HierarchicalDigraphComparator a_oHDComp) {
        if (a_oHD.getChildren().isEmpty()) {
            return;
        }
        for (HierarchicalDigraphNode t_oChild : a_oHD.getChildren()) {
            this.sortChildren(t_oChild, a_oHDComp);
        }
        Collections.sort(a_oHD.getChildren(), a_oHDComp);
    }
}

