/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.graph.visitor;

import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.WURCSException;
import org.glycoinfo.WURCSFramework.util.array.WURCSFormatException;
import org.glycoinfo.WURCSFramework.util.graph.ModificationAnalyzer;
import org.glycoinfo.WURCSFramework.util.graph.traverser.WURCSGraphTraverser;
import org.glycoinfo.WURCSFramework.util.graph.traverser.WURCSGraphTraverserTree;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitor;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorException;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSGraph;

public class WURCSVisitorStripTypeIIIModification2
implements WURCSVisitor {
    private LinkedList<WURCSEdge> m_aTargetEdges = new LinkedList();
    private WURCSGraph m_oStrippedGraph;

    public WURCSGraph getStrippedGraph() {
        return this.m_oStrippedGraph;
    }

    @Override
    public void visit(Backbone a_objBackbone) throws WURCSVisitorException {
    }

    @Override
    public void visit(Modification a_objModification) throws WURCSVisitorException {
    }

    @Override
    public void visit(WURCSEdge a_objWURCSEdge) throws WURCSVisitorException {
        if (a_objWURCSEdge.getModification().isGlycosidic()) {
            return;
        }
        try {
            if (!this.isTypeIIIEdge(a_objWURCSEdge)) {
                return;
            }
        }
        catch (WURCSFormatException e) {
            throw new WURCSVisitorException("Error in MAP import", e);
        }
        this.m_aTargetEdges.addLast(a_objWURCSEdge);
    }

    @Override
    public void start(WURCSGraph a_objGraph) throws WURCSVisitorException {
        try {
            this.m_oStrippedGraph = a_objGraph.copy();
            this.getTraverser(this).traverseGraph(this.m_oStrippedGraph);
            LinkedList<Modification> t_aStrippingMods = new LinkedList<Modification>();
            for (WURCSEdge t_oEdge : this.m_aTargetEdges) {
                Modification t_oMod = t_oEdge.getModification();
                if (t_oMod.getEdges().size() > 1) {
                    boolean t_bHasTypeII = false;
                    for (WURCSEdge t_oOtherEdge : t_oMod.getEdges()) {
                        if (t_oEdge.equals(t_oOtherEdge) || this.m_aTargetEdges.contains(t_oOtherEdge)) continue;
                        t_bHasTypeII = true;
                    }
                    if (t_bHasTypeII) continue;
                }
                t_oEdge.getBackbone().removeEdge(t_oEdge);
                t_oMod.removeEdge(t_oEdge);
                if (!t_oMod.getEdges().isEmpty()) continue;
                t_aStrippingMods.addLast(t_oMod);
            }
            for (Modification t_oNakedMod : t_aStrippingMods) {
                this.m_oStrippedGraph.removeModification(t_oNakedMod);
            }
        }
        catch (WURCSException e) {
            throw new WURCSVisitorException(e.getErrorMessage());
        }
    }

    @Override
    public WURCSGraphTraverser getTraverser(WURCSVisitor a_objVisitor) throws WURCSVisitorException {
        return new WURCSGraphTraverserTree(a_objVisitor);
    }

    @Override
    public void clear() {
        this.m_aTargetEdges = new LinkedList();
    }

    private boolean isTypeIIIEdge(WURCSEdge a_oEdge) throws WURCSFormatException {
        if (a_oEdge.getModification() == null) {
            return false;
        }
        int t_iMAPPos = a_oEdge.getLinkages().getFirst().getModificationPosition();
        ModificationAnalyzer t_oModAnal = new ModificationAnalyzer(a_oEdge.getModification());
        return t_oModAnal.isTypeIIICarbon(t_iMAPPos);
    }
}

