/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util;

import org.glycoinfo.WURCSFramework.util.WURCSException;
import org.glycoinfo.WURCSFramework.util.WURCSFactory;
import org.glycoinfo.WURCSFramework.util.array.WURCSImporter;
import org.glycoinfo.WURCSFramework.util.exchange.WURCSArrayToGraph;
import org.glycoinfo.WURCSFramework.util.graph.analysis.WURCSGraphStateDeterminer;
import org.glycoinfo.WURCSFramework.wurcs.array.MS;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSGraph;

public class AnomerCheckUtils {
    public static boolean isValidCompositionForGlycosylation(String a_strWURCSComposition) {
        try {
            WURCSGraph graph = AnomerCheckUtils.toWURCSGraph(a_strWURCSComposition);
            if (WURCSGraphStateDeterminer.hasUncertainAnomericState(graph)) {
                return false;
            }
            if (!WURCSGraphStateDeterminer.hasAnomerOnReducingEnd(graph)) {
                return false;
            }
        }
        catch (WURCSException e) {
            return false;
        }
        return true;
    }

    public static String getAnomericSymbol(String a_strWURCS) {
        try {
            WURCSGraph graph = AnomerCheckUtils.toWURCSGraph(a_strWURCS);
            if (WURCSGraphStateDeterminer.hasMultipleReducingEnd(graph)) {
                return null;
            }
            if (WURCSGraphStateDeterminer.hasUncertainAnomericState(graph)) {
                return null;
            }
            if (!WURCSGraphStateDeterminer.hasAnomerOnReducingEnd(graph)) {
                return null;
            }
            if (WURCSGraphStateDeterminer.getAnomericModificationOnReducingEnd(graph) != null) {
                return null;
            }
            return WURCSGraphStateDeterminer.getAnomericSymbolOnReducingEnd(graph);
        }
        catch (WURCSException wURCSException) {
            return null;
        }
    }

    public static String getAnomericSymbolForResidueCode(String a_strResidueCode) {
        try {
            Backbone bb = AnomerCheckUtils.toBackbone(a_strResidueCode);
            if (WURCSGraphStateDeterminer.hasUncertainAnomericState(bb)) {
                return null;
            }
            if (!WURCSGraphStateDeterminer.hasAnomer(bb)) {
                return null;
            }
            if (WURCSGraphStateDeterminer.isGlycoside(bb)) {
                return null;
            }
            return WURCSGraphStateDeterminer.getAnomericSymbol(bb);
        }
        catch (WURCSException wURCSException) {
            return null;
        }
    }

    private static WURCSGraph toWURCSGraph(String a_strWURCS) throws WURCSException {
        WURCSFactory factory = new WURCSFactory(a_strWURCS);
        WURCSGraph graph = factory.getGraph();
        return graph;
    }

    private static Backbone toBackbone(String a_strResidueCode) throws WURCSException {
        MS ms = new WURCSImporter().extractMS(a_strResidueCode);
        WURCSArrayToGraph a2g = new WURCSArrayToGraph();
        Backbone bb = a2g.convertToBackbone(ms);
        return bb;
    }
}

