/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.KCF;

import java.util.ArrayList;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseSubstituentTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseTypeDictionary;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyCoModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.ModificationTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.Glycan.SubstituentInterface;
import org.glycoinfo.GlycanFormatconverter.io.GlyCoImporterException;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.extended.IUPACNotationParser;
import org.glycoinfo.GlycanFormatconverter.io.KCF.IUPACAglyconDescriptor;
import org.glycoinfo.GlycanFormatconverter.io.KCF.KCFNotationToIUPACNotation;
import org.glycoinfo.GlycanFormatconverter.io.KCF.KCFUtility;
import org.glycoinfo.GlycanFormatconverter.util.SubstituentUtility;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.BaseStereoIndex;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.TrivialNameException;
import org.glycoinfo.GlycanFormatconverter.util.analyzer.MonosaccharideNotationAnalyzer;

public class KCFNodeConverter {
    private final KCFUtility kcfUtil;

    public KCFNodeConverter(KCFUtility _kcfUtil) {
        this.kcfUtil = _kcfUtil;
    }

    public Node start(String _node) throws GlycanException, GlyCoImporterException, TrivialNameException {
        String parentNotation;
        IUPACAglyconDescriptor parentAglycon;
        ArrayList<String> units = this.kcfUtil.splitNotation(_node);
        String notation = units.get(1);
        IUPACAglyconDescriptor currentAglycon = IUPACAglyconDescriptor.forNotation(notation);
        if (units.get(0).equals("1") && currentAglycon != null) {
            return null;
        }
        if (units.get(0).equals("2") && currentAglycon != null && (parentAglycon = IUPACAglyconDescriptor.forNotation(parentNotation = this.kcfUtil.splitNotation(this.kcfUtil.getNodeByID("1")).get(1))) != null) {
            return null;
        }
        if (units.get(1).equals("*")) {
            return null;
        }
        if (this.isLinkageSubstituents(_node)) {
            return null;
        }
        Node node = this.makeSubstituent(_node);
        if (node == null) {
            KCFNotationToIUPACNotation kcf2iupac = new KCFNotationToIUPACNotation();
            IUPACNotationParser inp = new IUPACNotationParser();
            node = inp.parseMonosaccharide(kcf2iupac.start(notation));
            this.modifyMonosaccharide(node);
            this.modifyHeadAtom(node);
            this.modifyCrosslinkedSubstituent(node);
        }
        return node;
    }

    private Node makeSubstituent(String _notation) throws GlycanException {
        String unit = this.modifyNotation(this.kcfUtil.splitNotation(_notation).get(1));
        if (!this.isSubstituent(unit)) {
            return null;
        }
        if (this.isDuplicatedSubstituent(_notation)) {
            return this.makeLinkedSubstituent(_notation);
        }
        if (this.isBridge(_notation)) {
            return this.makeLinkedSubstituent(_notation);
        }
        if (this.isBranches(_notation)) {
            return this.makeLinkedSubstituent(_notation);
        }
        return this.makeSubstituentNotation(BaseSubstituentTemplate.forIUPACNotationWithIgnore(unit));
    }

    private Node makeLinkedSubstituent(String _notation) throws GlycanException {
        String unit = this.modifyNotation(this.kcfUtil.splitNotation(_notation).get(1));
        if (this.isPyrophosphate(_notation)) {
            if (this.isCrossLinkedSubstituent(_notation)) {
                return this.makeSubstituentNotation(BaseCrossLinkedTemplate.PYROPHOSPHATE);
            }
            return this.makeSubstituentNotation(BaseSubstituentTemplate.PYROPHOSPHATE);
        }
        if (this.isPhosphoEthanolamine(_notation)) {
            if (this.isCrossLinkedSubstituent(_notation)) {
                return this.makeSubstituentNotation(BaseCrossLinkedTemplate.PHOSPHOETHANOLAMINE);
            }
            return this.makeSubstituentNotation(BaseSubstituentTemplate.PHOSPHOETHANOLAMINE);
        }
        if (unit.equals("P")) {
            if (this.isCrossLinkedSubstituent(_notation)) {
                return this.makeSubstituentNotation(BaseCrossLinkedTemplate.PHOSPHATE);
            }
            return this.makeSubstituentNotation(BaseSubstituentTemplate.OPHOSPHATE);
        }
        if (unit.equalsIgnoreCase("etn")) {
            if (this.isCrossLinkedSubstituent(_notation)) {
                return this.makeSubstituentNotation(BaseCrossLinkedTemplate.ETHANOLAMINE);
            }
            return this.makeSubstituentNotation(BaseSubstituentTemplate.ETHANOLAMINE);
        }
        return null;
    }

    private boolean isAglycon(String _notation) {
        IUPACAglyconDescriptor iupacAglyconDescriptor = IUPACAglyconDescriptor.forNotation(_notation);
        return iupacAglyconDescriptor != null;
    }

    private boolean isSubstituent(String _notation) {
        BaseCrossLinkedTemplate crossT = BaseCrossLinkedTemplate.forIUPACNotationWithIgnore(_notation);
        BaseSubstituentTemplate subT = BaseSubstituentTemplate.forIUPACNotationWithIgnore(_notation);
        return crossT != null || subT != null;
    }

    private Node modifyMonosaccharide(Node _node) throws GlycanException {
        Monosaccharide mono = (Monosaccharide)_node;
        if (mono.getStereos().size() > 1 || mono.getStereos().isEmpty()) {
            return _node;
        }
        BaseTypeDictionary baseDict = BaseTypeDictionary.forName(mono.getStereos().getFirst());
        String tempStereo = mono.getStereos().getFirst();
        StringBuilder skeletonCode = new StringBuilder(baseDict.getStereoCode());
        BaseStereoIndex bsi = BaseStereoIndex.forCode(baseDict.getCoreName());
        if (bsi.getSize() != mono.getSuperClass().getSize()) {
            return _node;
        }
        for (GlyCoModification gMod : mono.getModifications()) {
            if (gMod.getPositionOne().intValue() == mono.getAnomericPosition() || gMod.getPositionOne().intValue() == mono.getSuperClass().getSize() || this.isHLOSETypeModification(gMod)) continue;
            skeletonCode.replace(gMod.getPositionOne() - 2, gMod.getPositionOne() - 1, "");
        }
        baseDict = BaseTypeDictionary.forStereoCode(skeletonCode.toString());
        String modifiedStereo = baseDict.getName();
        mono.removeStereo(tempStereo);
        mono.addStereo(modifiedStereo);
        return _node;
    }

    private boolean isDuplicatedSubstituent(String _notation) {
        String currentID = this.kcfUtil.splitNotation(_notation).get(0);
        ArrayList<String> acceptorEdges = this.kcfUtil.extractAcceptorEdgeByID(currentID);
        if (acceptorEdges.size() != 1) {
            return false;
        }
        String acceptorEdge = acceptorEdges.get(0);
        ArrayList<String> units = this.kcfUtil.splitNotation(acceptorEdge);
        String donorLinkage = this.kcfUtil.extractLinkagePosition(units.get(1));
        String acceptorLinkage = this.kcfUtil.extractLinkagePosition(units.get(2));
        return donorLinkage == null && acceptorLinkage == null;
    }

    private boolean isBridge(String _notation) {
        String currentID = this.kcfUtil.splitNotation(_notation).get(0);
        String donorEdge = this.kcfUtil.extractDonorEdgeByID(currentID);
        String acceptorEdge = this.kcfUtil.extractEdgeByID(currentID, true);
        if (donorEdge.equals("") || acceptorEdge.equals("")) {
            return false;
        }
        ArrayList<String> donorSide = this.kcfUtil.splitNotation(donorEdge);
        ArrayList<String> acceptorSide = this.kcfUtil.splitNotation(acceptorEdge);
        String donorNotation = this.kcfUtil.getNodeByID(this.kcfUtil.extractID(donorSide.get(2)));
        String acceptorNotation = this.kcfUtil.getNodeByID(this.kcfUtil.extractID(acceptorSide.get(1)));
        String donorNode = this.kcfUtil.splitNotation(donorNotation).get(1);
        String acceptorNode = this.kcfUtil.splitNotation(acceptorNotation).get(1);
        if (this.isAglycon(donorNode)) {
            return false;
        }
        return !this.isSubstituent(donorNode) && !this.isSubstituent(acceptorNode);
    }

    private boolean isBranches(String _notation) {
        String currentID = this.kcfUtil.splitNotation(_notation).get(0);
        ArrayList<String> acceptorEdge = this.kcfUtil.extractAcceptorEdgeByID(currentID);
        return acceptorEdge.size() > 1;
    }

    private boolean isCrossLinkedSubstituent(String _notation) {
        String linkage = this.kcfUtil.getEdgeByID(this.kcfUtil.splitNotation(_notation).get(0), true);
        String id = this.kcfUtil.extractID(this.kcfUtil.splitNotation(linkage).get(1));
        String donorNode = this.kcfUtil.getNodeByID(id);
        String acceptorEdge = this.kcfUtil.getEdgeByID(this.kcfUtil.splitNotation(linkage).get(2), false);
        if (acceptorEdge.equals("")) {
            return false;
        }
        String acceptorNode = this.kcfUtil.getNodeByID(this.kcfUtil.splitNotation(acceptorEdge).get(2));
        if (donorNode.equals("")) {
            return false;
        }
        if (!acceptorNode.equals("") && !MonosaccharideNotationAnalyzer.start(acceptorNode)) {
            return false;
        }
        return MonosaccharideNotationAnalyzer.start(this.kcfUtil.splitNotation(donorNode).get(1));
    }

    private boolean isPyrophosphate(String _notation) {
        if (this.kcfUtil.splitNotation(_notation).get(1).equals("PP")) {
            return true;
        }
        String currentID = this.kcfUtil.splitNotation(_notation).get(0);
        String childSideNotation = this.kcfUtil.extractEdgeByID(currentID, true);
        if (!childSideNotation.equals("")) {
            String childNode = this.kcfUtil.getNodeByID(this.kcfUtil.splitNotation(childSideNotation).get(1));
            String parentNode = this.kcfUtil.getNodeByID(this.kcfUtil.splitNotation(childSideNotation).get(2));
            if (childNode.equals("") || parentNode.equals("")) {
                return false;
            }
            BaseSubstituentTemplate parentT = BaseSubstituentTemplate.forIUPACNotationWithIgnore(this.kcfUtil.splitNotation(parentNode).get(1));
            BaseSubstituentTemplate childT = BaseSubstituentTemplate.forIUPACNotationWithIgnore(this.kcfUtil.splitNotation(childNode).get(1));
            if (parentT == null || childT == null) {
                return false;
            }
            return parentT.equals(BaseSubstituentTemplate.OPHOSPHATE) && childT.equals(BaseSubstituentTemplate.OPHOSPHATE);
        }
        return false;
    }

    private boolean isPhosphoEthanolamine(String _notation) {
        String currentID = this.kcfUtil.splitNotation(_notation).get(0);
        if (this.isPhosphoEthanolamineForDonorSide(currentID)) {
            return true;
        }
        return this.isPhosphoEthanolamineForAcceptorSide(currentID);
    }

    private boolean isPhosphoEthanolamineForDonorSide(String _currentID) {
        ArrayList<String> donorEdges = this.kcfUtil.extractAcceptorEdgeByID(_currentID);
        boolean ret = false;
        for (String edge : donorEdges) {
            String donorNode = this.kcfUtil.getNodeByID(this.kcfUtil.splitNotation(edge).get(1));
            String acceptorNode = this.kcfUtil.getNodeByID(this.kcfUtil.splitNotation(edge).get(2));
            if (donorNode.equals("") || acceptorNode.equals("")) continue;
            if (this.kcfUtil.splitNotation(donorNode).get(1).equalsIgnoreCase("etn") && this.kcfUtil.splitNotation(acceptorNode).get(1).equalsIgnoreCase("p")) {
                ret = true;
                break;
            }
            if (!this.kcfUtil.splitNotation(donorNode).get(1).equalsIgnoreCase("p") || !this.kcfUtil.splitNotation(acceptorNode).get(1).equalsIgnoreCase("etn")) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private boolean isPhosphoEthanolamineForAcceptorSide(String _currentID) {
        String acceptorEdge = this.kcfUtil.getEdgeByID(_currentID, false);
        if (acceptorEdge.equals("")) {
            return false;
        }
        String donorNode = this.kcfUtil.getNodeByID(this.kcfUtil.splitNotation(acceptorEdge).get(1));
        String acceptorNode = this.kcfUtil.getNodeByID(this.kcfUtil.splitNotation(acceptorEdge).get(2));
        if (donorNode.equals("") || acceptorNode.equals("")) {
            return false;
        }
        donorNode = this.kcfUtil.splitNotation(donorNode).get(1);
        acceptorNode = this.kcfUtil.splitNotation(acceptorNode).get(1);
        return donorNode.equals("P") && acceptorNode.equals("EtN") || donorNode.equals("EtN") && acceptorNode.equals("P");
    }

    private boolean isLinkageSubstituents(String _notation) {
        String currentID = this.kcfUtil.splitNotation(_notation).get(0);
        String parentSideNotation = this.kcfUtil.extractDonorEdgeByID(currentID);
        if (parentSideNotation.equals("")) {
            return false;
        }
        String childID = this.kcfUtil.splitNotation(parentSideNotation).get(1);
        String parentID = this.kcfUtil.splitNotation(parentSideNotation).get(2);
        if (childID.contains(":") || parentID.contains(":")) {
            return false;
        }
        if (this.kcfUtil.splitNotation(this.kcfUtil.getNodeByID(childID)).get(1).equals("EtN") && this.kcfUtil.splitNotation(this.kcfUtil.getNodeByID(parentID)).get(1).equals("P")) {
            return true;
        }
        return this.kcfUtil.splitNotation(this.kcfUtil.getNodeByID(childID)).get(1).equals("P") && this.kcfUtil.splitNotation(this.kcfUtil.getNodeByID(parentID)).get(1).equals("P");
    }

    private Node makeSubstituentNotation(SubstituentInterface _subInf) throws GlycanException {
        Substituent ret = new Substituent(_subInf);
        ret.setFirstPosition(new Linkage());
        if (ret.getSubstituent() instanceof BaseCrossLinkedTemplate) {
            ret.setSecondPosition(new Linkage());
        }
        if (!SubstituentUtility.isNLinkedSubstituent(ret)) {
            ret.setHeadAtom("O");
        }
        return ret;
    }

    private String modifyNotation(String _notation) {
        if (_notation.equals("PP")) {
            _notation = "PyrP";
        }
        if (_notation.equals("EtN")) {
            _notation = BaseSubstituentTemplate.ETHANOLAMINE.getIUPACnotation();
        }
        if (_notation.equals("EtnP")) {
            _notation = BaseSubstituentTemplate.PHOSPHOETHANOLAMINE.getIUPACnotation();
        }
        return _notation;
    }

    private void modifyHeadAtom(Node _node) {
        for (Edge donorEdge : _node.getChildEdges()) {
            Substituent sub;
            if (donorEdge.getSubstituent() != null && !((sub = (Substituent)donorEdge.getSubstituent()) instanceof GlycanRepeatModification)) continue;
        }
    }

    private void modifyCrosslinkedSubstituent(Node _node) throws GlycanException {
        Monosaccharide mono = (Monosaccharide)_node;
        if (mono.getRingStart() == -1 || mono.getRingEnd() == -1) {
            return;
        }
        for (Edge donorEdge : mono.getChildEdges()) {
            BaseCrossLinkedTemplate baseCross;
            if (donorEdge.getSubstituent() == null) continue;
            Substituent sub = (Substituent)donorEdge.getSubstituent();
            Linkage lin = donorEdge.getGlycosidicLinkages().get(0);
            if (sub.getSubstituent() instanceof BaseCrossLinkedTemplate || (baseCross = BaseCrossLinkedTemplate.forIUPACNotation(sub.getNameWithIUPAC())) == null || !lin.getChildLinkages().contains(mono.getRingStart()) || !lin.getParentLinkages().contains(mono.getRingEnd())) continue;
            Substituent newSub = new Substituent(baseCross);
            Linkage first = new Linkage();
            first.setParentLinkages(sub.getFirstPosition().getChildLinkages());
            first.setChildLinkages(sub.getFirstPosition().getChildLinkages());
            newSub.setFirstPosition(first);
            Linkage second = new Linkage();
            second.setParentLinkages(sub.getFirstPosition().getParentLinkages());
            second.setChildLinkages(sub.getFirstPosition().getChildLinkages());
            newSub.setSecondPosition(second);
            donorEdge.setGlycosidicLinkages(new ArrayList<Linkage>());
            donorEdge.addGlycosidicLinkage(first);
            donorEdge.addGlycosidicLinkage(second);
            newSub.addParentEdge(donorEdge);
            donorEdge.setSubstituent(newSub);
        }
    }

    private boolean isHLOSETypeModification(GlyCoModification _gMod) {
        return _gMod.getModificationTemplate().equals((Object)ModificationTemplate.HLOSE_5) || _gMod.getModificationTemplate().equals((Object)ModificationTemplate.HLOSE_6) || _gMod.getModificationTemplate().equals((Object)ModificationTemplate.HLOSE_7) || _gMod.getModificationTemplate().equals((Object)ModificationTemplate.HLOSE_8) || _gMod.getModificationTemplate().equals((Object)ModificationTemplate.HLOSE_X);
    }
}

