/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.JSON;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.glycoinfo.GlycanFormatconverter.Glycan.Aglycone;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseTypeDictionary;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyCoModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanUndefinedUnit;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.ModificationTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.condensed.CondensedConverter;
import org.glycoinfo.GlycanFormatconverter.util.MonosaccharideUtility;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.TrivialNameException;
import org.glycoinfo.GlycanFormatconverter.util.exchange.WURCSGraphToGlyContainer.WURCSGraphToGlyContainer;
import org.glycoinfo.GlycanFormatconverter.util.similarity.NodeSimilarity;
import org.glycoinfo.WURCSFramework.util.oldUtil.ConverterExchangeException;
import org.json.JSONArray;
import org.json.JSONObject;

public class GCJSONExporter {
    private TreeMap<Integer, Node> nodeIndex;
    private HashMap<Edge, String> edgeIndex = new HashMap();

    public String start(WURCSGraphToGlyContainer _wg2gc) throws GlycanException, ConverterExchangeException, TrivialNameException {
        boolean _isVisualize = true;
        GlyContainer glyco = _wg2gc.getGlycan();
        this.nodeIndex = this.makeTreeMap(glyco, _wg2gc.getSortedList());
        MonosaccharideUtility monoUtil = new MonosaccharideUtility();
        JSONObject monosaccharides = new JSONObject();
        JSONObject bridges = new JSONObject();
        JSONObject repeat = new JSONObject();
        JSONObject edge = new JSONObject();
        for (Integer key : this.nodeIndex.keySet()) {
            Monosaccharide mono = (Monosaccharide)this.nodeIndex.get(key);
            JSONObject monosaccharide = new JSONObject();
            monosaccharide.accumulate("AnomState", Character.valueOf(mono.getAnomer().getAnomericState()));
            monosaccharide.accumulate("AnomPosition", mono.getAnomericPosition());
            monosaccharide.accumulate("TrivialName", this.extractTrivialName(mono.getStereos()));
            monosaccharide.accumulate("Configuration", this.extractConfiguration(mono.getStereos()));
            monosaccharide.accumulate("SuperClass", (Object)mono.getSuperClass());
            monosaccharide.accumulate("RingSize", this.makeRingSymbol(mono));
            if (_isVisualize) {
                Iterator<Object> copyMono = mono.copy();
                String trivialName = this.makeTrivialNotation((Node)((Object)copyMono));
                monosaccharide.accumulate("Notation", trivialName);
                monoUtil.modifiedSubstituents(trivialName, (Node)((Object)copyMono));
            }
            monosaccharide.put("Modifications", this.extractModifications(mono));
            monosaccharide.put("Substituents", this.extractSubstituents(mono));
            if (!this.isFragmentRoot(glyco, mono)) {
                for (Object obj : this.extractEdge(mono)) {
                    edge.accumulate("e" + edge.length(), obj);
                }
            }
            for (Object obj : this.extractRepeat(mono)) {
                repeat.accumulate("r" + repeat.length(), obj);
            }
            JSONObject bridge = this.extractBridge(mono);
            if (bridge.length() != 0) {
                bridges.accumulate("b" + bridges.keySet().size(), bridge);
            }
            monosaccharides.accumulate("m" + key, monosaccharide);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Monosaccharides", monosaccharides);
        jsonObject.put("Edges", edge);
        jsonObject.put("Bridge", bridges);
        jsonObject.put("Composition", this.extractComposition(glyco, monosaccharides));
        jsonObject.put("Repeat", repeat);
        jsonObject.accumulate("Fragments", this.extractFragment(glyco));
        jsonObject.put("Aglycone", this.extractAglycone(glyco.getAglycone()));
        jsonObject.put("WURCS", "");
        jsonObject.put("AN", "");
        return jsonObject.toString();
    }

    private JSONArray extractRepeat(Monosaccharide _mono) {
        JSONArray ret = new JSONArray();
        BidiMap flip = this.makeFlipMap();
        for (Edge parent : _mono.getParentEdges()) {
            Substituent sub = (Substituent)parent.getSubstituent();
            if (sub == null || !(sub instanceof GlycanRepeatModification)) continue;
            GlycanRepeatModification repMod = (GlycanRepeatModification)sub;
            JSONObject repUnit = new JSONObject();
            for (Linkage lin : parent.getGlycosidicLinkages()) {
                repUnit = this.extractLinkage(lin);
            }
            repUnit.getJSONObject("Donor").accumulate("Node", "m" + flip.get(parent.getChild()));
            repUnit.getJSONObject("Acceptor").accumulate("Node", "m" + flip.get(parent.getParent()));
            repUnit.accumulate("Min", repMod.getMinRepeatCount());
            repUnit.accumulate("Max", repMod.getMaxRepeatCount());
            ret.put(repUnit);
        }
        return ret;
    }

    private JSONObject extractFragment(GlyContainer _glyCo) throws GlycanException {
        JSONObject ret = new JSONObject();
        BidiMap flip = this.makeFlipMap();
        for (GlycanUndefinedUnit und : _glyCo.getUndefinedUnit()) {
            if (und.isComposition()) continue;
            Node root = und.getRootNodes().get(0);
            ArrayList<String> acceptors = new ArrayList<String>();
            for (Node acceptor : und.getParents()) {
                if (flip.get(acceptor) == null) continue;
                acceptors.add("m" + flip.get(acceptor));
            }
            JSONObject pos = new JSONObject();
            if (!und.isComposition()) {
                for (Linkage linkage : und.getConnection().getGlycosidicLinkages()) {
                    pos = this.extractLinkage(linkage);
                }
            }
            pos.getJSONObject("Acceptor").accumulate("Node", acceptors);
            if (root instanceof Substituent) {
                pos.getJSONObject("Donor").accumulate("Notation", ((Substituent)root).getNameWithIUPAC());
            } else {
                pos.getJSONObject("Donor").accumulate("Node", "m" + flip.get(root));
            }
            ret.accumulate("f" + _glyCo.getUndefinedUnit().indexOf(und), pos);
        }
        return ret;
    }

    private JSONArray extractSubstituents(Monosaccharide _mono) {
        JSONArray ret = new JSONArray();
        for (Edge childEdge : _mono.getChildEdges()) {
            Substituent sub = (Substituent)childEdge.getSubstituent();
            if (sub == null || sub instanceof GlycanRepeatModification || sub.getSubstituent() instanceof BaseCrossLinkedTemplate && childEdge.getChild() != null) continue;
            JSONObject unit = this.extractLinkage(sub.getFirstPosition());
            unit.accumulate("Notation", sub.getSubstituent().getIUPACnotation());
            if (sub.getSecondPosition() != null && !sub.getSecondPosition().getParentLinkages().isEmpty()) {
                unit.accumulate("Status", "simple");
            }
            if (sub.getSecondPosition() == null) {
                if (sub.getFirstPosition().getParentLinkages().size() > 1) {
                    unit.accumulate("Status", "fuzzy");
                } else {
                    unit.accumulate("Status", "simple");
                }
            }
            ret.put(unit);
        }
        return ret;
    }

    private JSONObject extractProbability(Linkage _lin) {
        JSONObject prob = new JSONObject();
        prob.accumulate("Low", _lin.getParentProbabilityLower());
        prob.accumulate("High", _lin.getParentProbabilityUpper());
        return prob;
    }

    private JSONObject extractLinkage(Linkage _lin) {
        JSONObject ret = new JSONObject();
        if (_lin == null) {
            return ret;
        }
        JSONObject acceptor = new JSONObject();
        acceptor.accumulate("Position", _lin.getParentLinkages());
        acceptor.accumulate("LinkageType", (Object)_lin.getParentLinkageType());
        JSONObject donor = new JSONObject();
        donor.accumulate("Position", _lin.getChildLinkages());
        donor.accumulate("LinkageType", (Object)_lin.getChildLinkageType());
        ret.accumulate("Probability", this.extractProbability(_lin));
        ret.accumulate("Donor", donor);
        ret.accumulate("Acceptor", acceptor);
        return ret;
    }

    private JSONArray extractEdge(Monosaccharide _mono) {
        JSONArray ret = new JSONArray();
        BidiMap flip = this.makeFlipMap();
        for (Edge acceptor : _mono.getParentEdges()) {
            Substituent sub = (Substituent)acceptor.getSubstituent();
            if (sub != null && sub instanceof GlycanRepeatModification || acceptor.getParent() == null) continue;
            JSONObject edge = new JSONObject();
            for (Linkage lin : acceptor.getGlycosidicLinkages()) {
                edge = this.extractLinkage(lin);
            }
            edge.getJSONObject("Donor").accumulate("Node", "m" + flip.get(acceptor.getChild()));
            edge.getJSONObject("Acceptor").accumulate("Node", "m" + flip.get(acceptor.getParent()));
            this.edgeIndex.put(acceptor, "e" + this.edgeIndex.size());
            ret.put(edge);
        }
        return ret;
    }

    private JSONObject extractBridge(Node _node) {
        JSONObject unit = new JSONObject();
        BidiMap flip = this.makeFlipMap();
        for (Edge parentEdge : _node.getParentEdges()) {
            Substituent sub = (Substituent)parentEdge.getSubstituent();
            if (sub == null || !(sub.getSubstituent() instanceof BaseCrossLinkedTemplate)) continue;
            unit.accumulate("Notation", sub.getNameWithIUPAC());
            JSONObject acceptor = new JSONObject();
            JSONObject donor = new JSONObject();
            acceptor.accumulate("Node", "m" + flip.get(_node.getParentNode()));
            donor.accumulate("Node", "m" + flip.get(_node));
            if (this.haveSubstituentDirection(sub)) {
                donor.accumulate("Position", sub.getFirstPosition().getChildLinkages().get(0));
                acceptor.accumulate("Position", sub.getSecondPosition().getChildLinkages().get(0));
            }
            if (sub.getFirstPosition() != null && sub.getSecondPosition() != null) {
                acceptor.accumulate("LinkageType", (Object)sub.getFirstPosition().getChildLinkageType());
                donor.accumulate("LinkageType", (Object)sub.getSecondPosition().getParentLinkageType());
            }
            unit.accumulate("Donor", donor);
            unit.accumulate("Acceptor", acceptor);
            unit.accumulate("Target", this.edgeIndex.get(parentEdge));
        }
        return unit;
    }

    private TreeMap<Integer, Node> makeTreeMap(GlyContainer _glyco, ArrayList<Node> _sortedNodes) throws GlycanException {
        TreeMap<Integer, Node> ret = new TreeMap<Integer, Node>();
        NodeSimilarity nodeSim = new NodeSimilarity();
        ArrayList<Node> sorted = new ArrayList<Node>();
        if (_glyco.getAllNodes().size() == _glyco.getUndefinedUnit().size()) {
            for (GlycanUndefinedUnit und : _glyco.getUndefinedUnit()) {
                sorted.addAll(und.getNodes());
            }
        } else {
            sorted.addAll(_sortedNodes);
        }
        for (Node node : sorted) {
            ret.put(sorted.indexOf(node), node);
        }
        return ret;
    }

    private ArrayList<String> extractTrivialName(LinkedList<String> _stereo) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String unit : _stereo) {
            unit = unit.contains("-") ? unit.substring(unit.indexOf("-") + 1) : unit;
            BaseTypeDictionary baseType = BaseTypeDictionary.forName(unit);
            String name = baseType.getCoreName();
            ret.add(name);
        }
        return ret;
    }

    private String makeTrivialNotation(Node _node) throws GlycanException, TrivialNameException {
        CondensedConverter extConv = new CondensedConverter();
        return extConv.start(_node);
    }

    private ArrayList<String> extractConfiguration(LinkedList<String> _stereo) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String unit : _stereo) {
            unit = unit.contains("-") ? unit.substring(unit.indexOf("-") + 1) : unit;
            BaseTypeDictionary baseType = BaseTypeDictionary.forName(unit);
            String name = baseType.getConfiguration();
            ret.add(name);
        }
        return ret;
    }

    private String makeRingSymbol(Node _node) {
        Monosaccharide mono = (Monosaccharide)_node;
        int ringStart = mono.getRingStart();
        int ringEnd = mono.getRingEnd();
        if (ringStart == 0 && ringEnd == 0) {
            return "o";
        }
        if (ringStart == 1) {
            if (ringEnd == 4) {
                return "f";
            }
            if (ringEnd == 5) {
                return "p";
            }
            if (ringEnd == -1) {
                return "?";
            }
        }
        if (ringStart == 2) {
            if (ringEnd == 5) {
                return "f";
            }
            if (ringEnd == 6) {
                return "p";
            }
            if (ringEnd == -1) {
                return "?";
            }
        }
        return "";
    }

    private boolean haveSubstituentDirection(Node _node) {
        if (!(_node instanceof Substituent)) {
            return false;
        }
        Substituent sub = (Substituent)_node;
        if (sub.getFirstPosition() == null || sub.getSecondPosition() == null) {
            return false;
        }
        return !sub.getFirstPosition().getChildLinkages().isEmpty() && !sub.getSecondPosition().getChildLinkages().isEmpty();
    }

    private BidiMap makeFlipMap() {
        DualHashBidiMap bidi = new DualHashBidiMap(this.nodeIndex);
        BidiMap flip = bidi.inverseBidiMap();
        return flip;
    }

    private JSONArray extractModifications(Node _node) {
        Monosaccharide mono = (Monosaccharide)_node;
        JSONArray ret = new JSONArray();
        for (GlyCoModification gMod : mono.getModifications()) {
            if (mono.getSuperClass().getSize() == gMod.getPositionOne().intValue() && gMod.getModificationTemplate().equals((Object)ModificationTemplate.HYDROXYL)) continue;
            JSONObject modUnit = new JSONObject();
            modUnit.accumulate("Position", gMod.getPositionOne());
            modUnit.accumulate("Notation", gMod.getModificationTemplate().getIUPACnotation());
            if (this.isDeoxyUnsaturation(gMod.getModificationTemplate())) {
                JSONObject deoxy = new JSONObject();
                deoxy.accumulate("Position", gMod.getPositionOne());
                deoxy.accumulate("Notation", "deoxy");
                ret.put(deoxy);
            }
            ret.put(modUnit);
        }
        return ret;
    }

    private JSONObject extractComposition(GlyContainer _glyCo, JSONObject _monoObj) {
        JSONObject ret = new JSONObject();
        if (!_glyCo.isComposition()) {
            return ret;
        }
        LinkedHashMap count = new LinkedHashMap();
        for (Integer n : this.nodeIndex.keySet()) {
            String jsonKey = "m" + n;
            String json = _monoObj.get(jsonKey).toString();
            if (!count.containsKey(json)) {
                ArrayList<String> tmp = new ArrayList<String>();
                tmp.add(jsonKey);
                count.put(json, tmp);
                continue;
            }
            ((ArrayList)count.get(json)).add(jsonKey);
        }
        for (String string : count.keySet()) {
            JSONObject unit = new JSONObject();
            unit.put("Monosaccharide", ((ArrayList)count.get(string)).get(0));
            unit.put("Count", ((ArrayList)count.get(string)).size());
            ret.accumulate("c" + ret.length(), unit);
        }
        return ret;
    }

    private String extractAglycone(Node _node) {
        if (_node == null) {
            return "";
        }
        if (_node instanceof Aglycone) {
            return "";
        }
        Aglycone agly = (Aglycone)_node;
        return agly.getName();
    }

    private boolean isDeoxyUnsaturation(ModificationTemplate _modTemp) {
        return _modTemp.equals((Object)ModificationTemplate.UNSATURATION_EL) || _modTemp.equals((Object)ModificationTemplate.UNSATURATION_ZL) || _modTemp.equals((Object)ModificationTemplate.UNSATURATION_FL);
    }

    private boolean isFragmentRoot(GlyContainer _glyco, Node _root) {
        boolean ret = false;
        for (GlycanUndefinedUnit und : _glyco.getUndefinedUnit()) {
            Edge connection = und.getConnection();
            if (connection.getChild() != null && connection.getChild().equals(_root)) {
                ret = true;
                break;
            }
            if (connection.getSubstituent() == null || !connection.getSubstituent().equals(_root)) continue;
            ret = true;
            break;
        }
        return ret;
    }
}

