/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.IUPAC.condensed;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glycoinfo.GlycanFormatconverter.Glycan.AnomericStateDescriptor;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.SuperClass;
import org.glycoinfo.GlycanFormatconverter.io.GlyCoImporterException;
import org.glycoinfo.GlycanFormatconverter.util.MonosaccharideUtility;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.BaseStereoIndex;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.MonosaccharideIndex;
import org.glycoinfo.GlycanFormatconverter.util.analyzer.IUPACSubstituentNotationAnalyzer;
import org.glycoinfo.GlycanFormatconverter.util.analyzer.ThreeLetterCodeAnalyzer;

public class IUPACCondensedNotationParser {
    public Node parseMonosaccharide(String _notation) throws GlycanException, GlyCoImporterException {
        Matcher matMono1;
        Matcher matUlo;
        Matcher matAldi;
        Matcher matModiSuf;
        Matcher matDeoxy;
        Matcher matSubUnhydro;
        if (_notation.matches("\\[[\\d?]\\).+") || _notation.matches(".*\\([ab?]\\d-][\\dn-]+.*")) {
            throw new GlyCoImporterException("Repeating structure is not support !");
        }
        if (_notation.matches("[\\d?]\\).+")) {
            throw new GlyCoImporterException("Cyclic structure is not support !");
        }
        if (_notation.contains("$")) {
            throw new GlyCoImporterException("Glycan fragments is not support !");
        }
        String temp = this.trimSymbols(_notation);
        String ringSize = "";
        Monosaccharide mono = new Monosaccharide();
        ArrayList<String> subNotations = new ArrayList<String>();
        ArrayList<String> modifications = new ArrayList<String>();
        LinkedList<String> configurations = new LinkedList<String>();
        if (this.isSubstituent(temp)) {
            IUPACSubstituentNotationAnalyzer subAna = new IUPACSubstituentNotationAnalyzer();
            subAna.start(temp);
            return subAna.getSubstituents().get(0);
        }
        String linkage = this.extractLinkage(temp);
        temp = temp.replace(linkage, "");
        Matcher matModiAlde = Pattern.compile("(aldehyde|keto)-").matcher(temp);
        if (matModiAlde.find()) {
            String modification = matModiAlde.group(1);
            modifications.add(modification);
            temp = temp.replace(matModiAlde.group(0), "");
        }
        if ((matSubUnhydro = Pattern.compile("([\\d,?]+)-(Anhydro)-").matcher(temp)).find()) {
            String position = matSubUnhydro.group(1);
            String notation = matSubUnhydro.group(2);
            subNotations.add(position + notation);
            temp = temp.replace(matSubUnhydro.group(0), "");
        }
        if ((matDeoxy = Pattern.compile("([\\d,?]+)-(.*)?(deoxy)-").matcher(temp)).find()) {
            String position = matDeoxy.group(1);
            String notation = matDeoxy.group(3);
            for (String pos : position.split(",")) {
                modifications.add(pos + notation.substring(0, 1));
            }
            temp = temp.replace(matDeoxy.group(0), "");
        }
        if ((matModiSuf = Pattern.compile("(-(onic|aric|uronic))").matcher(temp)).find() && matModiSuf.group(2) != null) {
            String acidic = matModiSuf.group(2);
            if (acidic.equals("aric")) {
                modifications.add("aric");
            }
            if (acidic.equals("onic")) {
                modifications.add("onic");
            }
            if (acidic.equals("uronic")) {
                modifications.add("uronic");
            }
            temp = temp.replace(matModiSuf.group(1), "");
        }
        if ((matAldi = Pattern.compile("-ol").matcher(temp)).find()) {
            modifications.add("ol");
            temp = temp.replace(matAldi.group(0), "");
        }
        if ((matUlo = Pattern.compile("(([\\d,?]+)+(.*)?(ulo))").matcher(temp)).find()) {
            IUPACSubstituentNotationAnalyzer subAnalyze = new IUPACSubstituentNotationAnalyzer();
            modifications.addAll(subAnalyze.resolveSubstituents(matUlo.group(0), true));
            temp = temp.replace(matUlo.group(1), "");
        }
        if ((matMono1 = Pattern.compile("([DL?]+)([a-z]{3})+([pf?])?([A-Z][a-z]{2})+").matcher(temp)).find()) {
            String notation;
            String isomer = "";
            int partSize = -1;
            int coreSize = -1;
            if (matMono1.group(1) != null) {
                isomer = String.valueOf(matMono1.group(1).charAt(0));
                temp = temp.replace(isomer, "");
                configurations.add(isomer);
            }
            if (matMono1.group(2) != null) {
                notation = matMono1.group(2);
                BaseStereoIndex baseInd = BaseStereoIndex.forCode(notation.toLowerCase());
                partSize = baseInd.getSize();
                temp = temp.replace(notation, String.valueOf(notation.charAt(0)).toUpperCase() + notation.charAt(1) + notation.charAt(2));
            }
            if (matMono1.group(3) != null) {
                ringSize = matMono1.group(3);
            }
            if (matMono1.group(4) != null) {
                SuperClass superclass = SuperClass.forSuperClassWithIgnore(matMono1.group(4));
                coreSize = superclass.getSize();
                mono.setSuperClass(superclass);
                temp = temp.replace(matMono1.group(4), "");
            }
            if (coreSize - partSize == 1) {
                notation = BaseStereoIndex.GRO.getNotation();
                mono.addStereo(isomer.equals("?") ? "" : isomer.toLowerCase() + notation);
                configurations.add(isomer.toLowerCase());
            } else {
                throw new GlyCoImporterException("Multiple name of monosaccharide can be assign to this monosaccharide : " + _notation);
            }
        }
        Matcher matSubMono = Pattern.compile("(([DL?])-([a-z]{3})-)").matcher(temp);
        Matcher matMono = Pattern.compile("([LD?]-?)?([468]?[dei])?([A-Z][a-z]{1,2}C?|KDN|[a-zA-Z]{6})([pf?])?(5[GA]c|N[AG]c|NA|A|N)?([A-Za-z]+)?").matcher(temp);
        String threeLetterCode = "";
        if (matMono.find()) {
            String isomer = "";
            String prefix = "";
            String coreName = "";
            if (matSubMono.find() && !matSubMono.group(3).equals(matMono.group(3))) {
                String subIsomer = matSubMono.group(2);
                String subNotation = matSubMono.group(3);
                mono.addStereo(subIsomer.equals("?") ? "" : subIsomer.toLowerCase() + subNotation);
                temp = temp.replaceFirst(matSubMono.group(1), "");
                configurations.add(subIsomer);
            }
            if (matMono.group(1) != null) {
                isomer = matMono.group(1);
                temp = temp.replace(isomer, "");
                configurations.add(isomer.replaceFirst("-", ""));
            }
            if (matMono.group(2) != null) {
                prefix = matMono.group(2);
                temp = temp.replaceFirst(prefix, "");
            }
            if (matMono.group(3) != null) {
                coreName = matMono.group(3);
                ThreeLetterCodeAnalyzer threeCode = new ThreeLetterCodeAnalyzer();
                threeCode.analyzeTrivialName(prefix + coreName, new LinkedList<String>());
                threeLetterCode = threeCode.getCoreNotation() != null ? threeCode.getCoreNotation() : coreName;
                for (String stereo : threeCode.getStereos()) {
                    mono.addStereo((isomer = isomer.replace("-", "")).equals("?") ? stereo : isomer.toLowerCase() + stereo);
                }
                if (mono.getSuperClass() == null) {
                    mono.setSuperClass(threeCode.getSuperClass());
                }
                subNotations.addAll(threeCode.getSubstituents());
                modifications.addAll(threeCode.getModificaitons());
                temp = temp.replace(coreName, "");
            }
            if (matMono.group(4) != null) {
                if (matMono.group(4).equals("?") && matMono.group(6) == null) {
                    ringSize = matMono.group(4);
                    temp = temp.replaceFirst("\\?", "");
                }
                if (!matMono.group(4).equals("?")) {
                    ringSize = matMono.group(4);
                    temp = temp.replaceFirst(ringSize, "");
                }
            }
            if (matMono.group(5) != null) {
                String sub = matMono.group(5);
                if (sub.matches("NA\\d?")) {
                    subNotations.add("N");
                    modifications.add("6A");
                }
                if (sub.equals("A")) {
                    modifications.add("6A");
                }
                if (sub.matches("5[AG]c")) {
                    subNotations.add(sub);
                } else if (ringSize.equals("?")) {
                    ringSize = "";
                    subNotations.add("?" + sub);
                } else {
                    subNotations.add(sub);
                }
                temp = this.replaceTemplate(temp, sub);
            }
        }
        String anomericState = "";
        int anomericPosition = -1;
        if (!linkage.equals("")) {
            for (int i = 0; i < linkage.length(); ++i) {
                char item = linkage.charAt(i);
                if (i == 1 && (item == 'a' || item == 'b' || item == '?')) {
                    anomericState = String.valueOf(item);
                }
                if (i == 2 && String.valueOf(item).matches("[\\d]")) {
                    anomericPosition = Integer.parseInt(String.valueOf(item));
                }
                if (i != 1 || item != '-') continue;
                anomericState = AnomericStateDescriptor.UNKNOWN.getIUPACAnomericState();
                anomericPosition = 1;
            }
        }
        if (this.isSubstituent(temp)) {
            if (ringSize.equals("?") && temp.startsWith(",")) {
                temp = ringSize + temp;
                ringSize = "";
            }
            IUPACSubstituentNotationAnalyzer subAnalyze = new IUPACSubstituentNotationAnalyzer();
            subNotations.addAll(subAnalyze.resolveSubstituents(temp, true));
            modifications.addAll(subAnalyze.resolveSubstituents(temp, false));
            temp = temp.replace(temp, "");
        }
        if (!temp.equals("")) {
            throw new GlyCoImporterException(_notation + " could not completely parsed : " + temp);
        }
        MonosaccharideIndex mi = MonosaccharideIndex.forTrivialNameWithIgnore(threeLetterCode);
        MonosaccharideUtility monoUtil = new MonosaccharideUtility();
        mono.setAnomericPosition(anomericPosition);
        mono.setAnomer(this.convertAnomericState(mono, anomericState));
        if (mi != null) {
            mono = this.assignAnomericPosition(mono, mi);
            mono = (Monosaccharide)this.modifyRingSize(mono, mi, ringSize);
            configurations.addLast(mi.getFirstConfiguration());
            mono = monoUtil.modifyStereos(mono, configurations);
        }
        mono = monoUtil.appendSubstituents(mono, subNotations);
        mono = monoUtil.appendModifications(mono, modifications);
        return mono;
    }

    private Monosaccharide assignAnomericPosition(Node _mono, MonosaccharideIndex _mi) {
        if (_mi == null) {
            return (Monosaccharide)_mono;
        }
        if (((Monosaccharide)_mono).getAnomer().equals((Object)AnomericStateDescriptor.OPEN)) {
            ((Monosaccharide)_mono).setAnomericPosition(0);
        } else {
            ((Monosaccharide)_mono).setAnomericPosition(_mi.getAnomerciPosition());
        }
        return (Monosaccharide)_mono;
    }

    private Node modifyRingSize(Node _mono, MonosaccharideIndex _mi, String _ringSize) throws GlycanException {
        Monosaccharide mono = (Monosaccharide)_mono;
        int anomericPosition = ((Monosaccharide)_mono).getAnomericPosition();
        if (mono.getAnomericPosition() == 1) {
            if (_ringSize.equals("p") && mono.getSuperClass().getSize() < SuperClass.PEN.getSize()) {
                throw new GlycanException("Ring position exceeds the number of carbon backbone : 5 -> " + mono.getSuperClass().getSize());
            }
            if (_ringSize.equals("f") && mono.getSuperClass().getSize() < SuperClass.TET.getSize()) {
                throw new GlycanException("Ring position exceeds the number of carbon backbone : 4 -> " + mono.getSuperClass().getSize());
            }
        }
        if (mono.getAnomericPosition() == 2) {
            if (_ringSize.equals("p") && mono.getSuperClass().getSize() < SuperClass.HEX.getSize()) {
                throw new GlycanException("Ring position exceeds the number of carbon backbone : 6 -> " + mono.getSuperClass().getSize());
            }
            if (_ringSize.equals("f") && mono.getSuperClass().getSize() < SuperClass.PEN.getSize()) {
                throw new GlycanException("Ring position exceeds the number of carbon backbone : 5 -> " + mono.getSuperClass().getSize());
            }
        }
        if (anomericPosition == 0 && _ringSize.equals("")) {
            return this.assignRingSize("o", mono);
        }
        if (_ringSize.equals("")) {
            return this.assignRingSize(_mi.getRingSize(), mono);
        }
        return this.assignRingSize(_ringSize, mono);
    }

    private Node assignRingSize(String _ringSize, Node _node) throws GlycanException {
        Monosaccharide mono = (Monosaccharide)_node;
        int anomericPosition = ((Monosaccharide)_node).getAnomericPosition();
        switch (_ringSize) {
            case "p": {
                if (anomericPosition == 1) {
                    mono.setRing(anomericPosition, 5);
                }
                if (anomericPosition != 2) break;
                mono.setRing(anomericPosition, 6);
                break;
            }
            case "f": {
                if (anomericPosition == 1) {
                    mono.setRing(anomericPosition, 4);
                }
                if (anomericPosition != 2) break;
                mono.setRing(anomericPosition, 5);
                break;
            }
            case "o": {
                mono.setRing(anomericPosition, 0);
                break;
            }
            default: {
                mono.setRing(anomericPosition, -1);
            }
        }
        return mono;
    }

    private int extractAnomericPosition(Monosaccharide _mono, String _linkage) {
        if (_linkage.equals("")) {
            if (_mono.getAnomericPosition() != 0) {
                return _mono.getAnomericPosition();
            }
            return 0;
        }
        int childPos = -1;
        AnomericStateDescriptor anomer = _mono.getAnomer();
        for (String unit : _linkage.split(":")) {
            if (unit.matches("\\(.+")) {
                unit = this.trimHead(unit);
            }
            if (!unit.contains("a") && !unit.contains("b")) continue;
            childPos = this.charToInt(unit.charAt(1));
        }
        if (anomer.equals((Object)AnomericStateDescriptor.OPEN)) {
            return 0;
        }
        if (_mono.getAnomericPosition() != 0 && childPos == -1) {
            childPos = _mono.getAnomericPosition();
        }
        return childPos;
    }

    private AnomericStateDescriptor convertAnomericState(Monosaccharide _mono, String _anomeric) {
        if (_anomeric.equals("?")) {
            if (_mono.getAnomericPosition() == -1) {
                return AnomericStateDescriptor.UNKNOWN;
            }
            return AnomericStateDescriptor.UNKNOWN_STATE;
        }
        if (_anomeric.equals("")) {
            return AnomericStateDescriptor.OPEN;
        }
        if (_anomeric.equals("a")) {
            return AnomericStateDescriptor.ALPHA;
        }
        if (_anomeric.equals("b")) {
            return AnomericStateDescriptor.BETA;
        }
        return null;
    }

    private int charToInt(char _char) {
        if (_char == '?') {
            return -1;
        }
        return Integer.parseInt(String.valueOf(_char));
    }

    private String trimSymbols(String _notation) {
        if (_notation.matches("\\[[\\d?]\\).+")) {
            _notation = _notation.replaceAll("\\[[\\d?]\\)", "");
        }
        if (_notation.matches("[\\d?]\\)].+")) {
            _notation = _notation.replaceFirst("[\\d?]\\)", "");
        }
        if ((_notation = _notation.replaceFirst("\\[", "")).matches(".+][n\\d-]+$")) {
            _notation = _notation.replaceAll("][n\\d-]+", "");
        }
        if (_notation.matches(".+\\([ab?][\\d?]-][n\\d-]+:.+")) {
            _notation = _notation.replaceAll("[ab?][\\d?]-][n\\d-]+:", "");
        }
        if (_notation.matches(".+\\([ab?]?[\\d?]-")) {
            _notation.replaceFirst("\\([ab?][\\d?]-", "");
        }
        if ((_notation = _notation.replaceFirst("]", "")).startsWith("[") && _notation.matches("\\[[A-Za-z\\[]+.+")) {
            _notation = _notation.replaceFirst("\\[", "");
        }
        if (_notation.matches("^\\[(-[(A-Za-z)]+-)?[\\d?/]+\\).+$")) {
            _notation = _notation.replaceFirst("^\\[(-[(A-Za-z)]+-)?[\\d?/]+\\)", "");
        }
        if (_notation.startsWith("]")) {
            _notation = _notation.replaceFirst("]", "");
        }
        if (_notation.matches("\\[(([\\d,]+-.?deoxy-)|\\de)?([?DL]-)?[A-Z].+")) {
            _notation = _notation.replaceFirst("\\[", "");
        }
        if (_notation.endsWith(")]")) {
            _notation = _notation.replace("]", "");
        }
        _notation = _notation.replaceAll("=?[?\\d]\\$,?", "");
        return _notation;
    }

    private String extractLinkage(String _notation) {
        String donor = "[ab?]?[\\d?]";
        String bridge = "\\d?(Tri-)?[(A-Za-z)]+\\d?";
        String acceptor = "[\\d?/]+[ab?]?";
        String edge = donor + "-" + acceptor;
        String root = donor + "-";
        String bridgeEdge = donor + "-" + bridge + "-" + acceptor;
        Matcher matPos = Pattern.compile("\\((" + root + "[:)]*|" + bridgeEdge + "[:)]*|" + edge + "[:)]*)+$").matcher(_notation);
        if (matPos.find()) {
            return matPos.group(0);
        }
        return "";
    }

    private boolean isSubstituent(String _notation) {
        if (this.isModification(_notation)) {
            return false;
        }
        String simple = "[\\d?]";
        String bridge = "[\\d?](-[\\d?])?,[\\d?](-[\\d?])?";
        String multiple = "([\\d?,]+[\\d?])";
        String fuzzy = "([\\d?/]+[\\d?])";
        String regex = "(" + simple + ":?|" + bridge + ":?|" + multiple + ":?|" + fuzzy + ":?)+";
        String notation = "(Tri-)?([(A-Za-z)]+)\\d?";
        return _notation.matches("^(?![468][de])(" + regex + notation + ")+");
    }

    private boolean isModification(String _notation) {
        return _notation.matches("^(\\d,?)+-(.*)?(deoxy|Anhydro|aldehyde)-.*");
    }

    private String trimHead(String _temp) {
        return _temp.substring(1);
    }

    private String replaceTemplate(String _temp, String _regex) {
        return _temp.replaceFirst(_regex, "");
    }
}

