/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.template;

import java.util.ArrayList;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbObject;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModification;
import org.eurocarbdb.resourcesdb.monosaccharide.Modification;
import org.eurocarbdb.resourcesdb.monosaccharide.Monosaccharide;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideValidation;
import org.eurocarbdb.resourcesdb.monosaccharide.Stereocode;
import org.eurocarbdb.resourcesdb.monosaccharide.Substitution;
import org.eurocarbdb.resourcesdb.template.TemplateContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonosaccharideDictionaryEntry
extends ResourcesDbObject {
    private String foreignName = null;
    private GlycanNamescheme scheme = null;
    private String basetypeStr = null;
    private ArrayList<Modification> substList = new ArrayList();
    private Monosaccharide ms;

    public MonosaccharideDictionaryEntry() {
        this(null, null);
    }

    public MonosaccharideDictionaryEntry(Config conf, TemplateContainer container) {
        this.setConfig(conf);
        this.setTemplateContainer(container);
        this.init();
    }

    public String getForeignName() {
        return this.foreignName;
    }

    public void setForeignName(String foreignNameStr) {
        this.foreignName = foreignNameStr;
    }

    public GlycanNamescheme getScheme() {
        return this.scheme;
    }

    public void setScheme(GlycanNamescheme theScheme) {
        this.scheme = theScheme;
    }

    public String getBasetypeStr() {
        return this.basetypeStr;
    }

    public void setBasetypeStr(String basetypeName) {
        this.basetypeStr = basetypeName;
    }

    public ArrayList<Modification> getSubstList() {
        return this.substList;
    }

    public void setSubstList(ArrayList<Modification> substlist) {
        this.substList = substlist;
    }

    public void addSubstitution(Modification subst) {
        this.getSubstList().add(subst);
    }

    public Monosaccharide getMs() {
        if (this.ms == null) {
            this.ms = this.buildMs();
        }
        return this.ms;
    }

    public void setMs(Monosaccharide mono) {
        this.ms = mono;
    }

    public Monosaccharide buildMs() {
        Monosaccharide ms = null;
        try {
            ms = new Monosaccharide(GlycanNamescheme.GLYCOCT, this.getBasetypeStr(), this.getTemplateContainer(), this.getConfig());
            for (Modification mod : this.getSubstList()) {
                if (mod.getClass().equals(Substitution.class)) {
                    ms.addSubstitution((Substitution)mod);
                    continue;
                }
                ms.addCoreModification((CoreModification)mod);
            }
            ms.sortModifications();
            String stereo = ms.getStereoStrWithoutAnomeric();
            ms.setConfiguration(Stereocode.getConfigurationFromStereoString(stereo));
            ms.buildName();
            MonosaccharideValidation.checkMonosaccharideConsistency(ms, new TemplateContainer());
        }
        catch (Exception ex) {
            System.err.println("Exception in building monosaccharide from dictionary entry " + this);
            System.err.println(ex);
        }
        return ms;
    }

    public void init() {
        this.setForeignName(null);
        this.setBasetypeStr(null);
        this.setScheme(null);
        this.setMs(null);
        if (this.getSubstList() == null) {
            this.setSubstList(new ArrayList<Modification>());
        } else {
            this.getSubstList().clear();
        }
    }

    public String toString() {
        String outStr = "";
        outStr = String.valueOf(outStr) + "[";
        outStr = String.valueOf(outStr) + this.getForeignName() + " (";
        outStr = this.getScheme() != null ? String.valueOf(outStr) + this.getScheme().getNameStr() : String.valueOf(outStr) + "unknown scheme";
        outStr = String.valueOf(outStr) + "): ";
        outStr = String.valueOf(outStr) + this.getBasetypeStr();
        outStr = String.valueOf(outStr) + " - " + this.getSubstList().toString();
        outStr = String.valueOf(outStr) + "]";
        return outStr;
    }
}

