/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.template;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.monosaccharide.Monosaccharide;
import org.eurocarbdb.resourcesdb.monosaccharide.StereoConfiguration;
import org.eurocarbdb.resourcesdb.monosaccharide.Stereocode;
import org.eurocarbdb.resourcesdb.template.BasetypeTemplate;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasetypeTemplateContainer {
    private Config config = null;
    private HashMap<String, BasetypeTemplate> basetypeTemplateByBasetypeNameMap;
    private ArrayList<String> basetypeListSpecific;
    private ArrayList<String> basetypeListSuperclass;
    private HashMap<String, BasetypeTemplate> basetypeTemplateByStereocodeMap;

    public BasetypeTemplateContainer() {
        this.setConfig(new Config());
    }

    public BasetypeTemplateContainer(Config conf) {
        this.setConfig(conf);
    }

    private void setConfig(Config theConf) {
        this.config = theConf;
    }

    public Config getConfig() {
        return this.config;
    }

    public HashMap<String, BasetypeTemplate> getBasetypeTemplateByBasetypeNameMap() throws ResourcesDbException {
        if (this.basetypeTemplateByBasetypeNameMap == null) {
            this.setData(this.getConfig());
        }
        return this.basetypeTemplateByBasetypeNameMap;
    }

    public void setBasetypeTemplateByBasetypeNameMap(HashMap<String, BasetypeTemplate> msTemplateByBasetypeMap) {
        this.basetypeTemplateByBasetypeNameMap = msTemplateByBasetypeMap;
    }

    public BasetypeTemplate getBasetypeTemplateByName(String basetypeName) throws ResourcesDbException {
        return this.getBasetypeTemplateByBasetypeNameMap().get(basetypeName.toLowerCase());
    }

    public ArrayList<String> getBasetypeList() throws ResourcesDbException {
        ArrayList<String> basetypeList = new ArrayList<String>();
        basetypeList.addAll(this.getBasetypeListSuperclass());
        basetypeList.addAll(this.getBasetypeListSpecific());
        return basetypeList;
    }

    public ArrayList<String> getBasetypeListSuperclass() throws ResourcesDbException {
        if (this.basetypeListSuperclass == null) {
            this.setData(this.getConfig());
        }
        return this.basetypeListSuperclass;
    }

    public void setBasetypeListSuperclass(ArrayList<String> basetypeListSuperclass) {
        this.basetypeListSuperclass = basetypeListSuperclass;
    }

    public ArrayList<String> getBasetypeListSpecific() throws ResourcesDbException {
        if (this.basetypeListSpecific == null) {
            this.setData(this.getConfig());
        }
        return this.basetypeListSpecific;
    }

    public void setBasetypeListSpecific(ArrayList<String> basetypeListSpecific) {
        this.basetypeListSpecific = basetypeListSpecific;
    }

    private HashMap<String, BasetypeTemplate> getBasetypeTemplateByStereocodeMap() throws ResourcesDbException {
        if (this.basetypeTemplateByStereocodeMap == null) {
            this.setData(this.getConfig());
        }
        return this.basetypeTemplateByStereocodeMap;
    }

    private void setBasetypeTemplateByStereocodeMap(HashMap<String, BasetypeTemplate> templateByStereocodeMap) {
        this.basetypeTemplateByStereocodeMap = templateByStereocodeMap;
    }

    public BasetypeTemplate getBasetypeTemplateByStereoString(String stereo) throws ResourcesDbException {
        BasetypeTemplate tmpl;
        if (Stereocode.stereoStringHasRelativePosition(stereo)) {
            if (Stereocode.stereoStringContainsAbsoluteAndRelative(stereo)) {
                throw new ResourcesDbException("Cannot get basetype template by a stereocode string that contains both absolute and relative configurations: " + stereo);
            }
            stereo = Stereocode.relativeToAbsolute(stereo);
        }
        if (Stereocode.getConfigurationFromStereoString(stereo).equals((Object)StereoConfiguration.Laevus)) {
            stereo = Stereocode.changeDLinStereoString(stereo);
        }
        if ((tmpl = this.getBasetypeTemplateByStereocodeMap().get(stereo)) == null) {
            throw new ResourcesDbException("Cannot get basetype template by stereocode string " + stereo);
        }
        return tmpl;
    }

    public BasetypeTemplate getSuperclassTemplateBySize(int size) throws ResourcesDbException {
        ArrayList<String> superclassTemplateNames = this.getBasetypeListSuperclass();
        int i = 0;
        while (i < superclassTemplateNames.size()) {
            BasetypeTemplate template = this.getBasetypeTemplateByName(superclassTemplateNames.get(i));
            if (template.getSize() == size) {
                return template;
            }
            ++i;
        }
        return null;
    }

    public ArrayList<BasetypeTemplate> assignRootTemplates(Monosaccharide ms) throws ResourcesDbException {
        ArrayList<BasetypeTemplate> rootTemplates;
        if (ms.getSize() < 7) {
            String stereo = ms.getStereoStr();
            if (ms.getRingStart() > 1) {
                stereo = String.valueOf(stereo.substring(0, ms.getRingStart() - 1)) + StereoConfiguration.Nonchiral.getStereosymbol() + stereo.substring(ms.getRingStart());
            }
            stereo = stereo.substring(1, stereo.length() - 1);
            rootTemplates = Stereocode.getRootTemplatesByStereoString(stereo, this);
            if (ms.isAlditol()) {
                ArrayList<BasetypeTemplate> rotatedTemplates = Stereocode.getRootTemplatesByStereoString(Stereocode.rotateStereoString(stereo), this);
                rootTemplates.addAll(rotatedTemplates);
            }
        } else {
            rootTemplates = new ArrayList<BasetypeTemplate>();
        }
        return rootTemplates;
    }

    public void setData(Config conf) throws ResourcesDbException {
        URL xmlUrl = conf.getMonosaccharideTemplatesXmlUrl();
        this.setDataFromXmlFile(xmlUrl);
    }

    private void setDataFromXmlFile(URL fileUrl) throws ResourcesDbException {
        HashMap<String, BasetypeTemplate> templateByBasetypeMap = new HashMap<String, BasetypeTemplate>();
        HashMap<String, BasetypeTemplate> templateByStereostrMap = new HashMap<String, BasetypeTemplate>();
        ArrayList<String> superclassList = new ArrayList<String>();
        ArrayList<String> specificList = new ArrayList<String>();
        SAXBuilder parser = new SAXBuilder();
        try {
            Document doc = parser.build(fileUrl);
            Element root = doc.getRootElement();
            List templateList = root.getChildren();
            for (Element xmlTemplate : templateList) {
                BasetypeTemplate template = BasetypeTemplateContainer.getTemplateFromXmlTree(xmlTemplate);
                if (template == null) continue;
                if (template.isSuperclass().booleanValue()) {
                    superclassList.add(template.getBaseName().toLowerCase());
                } else {
                    specificList.add(template.getBaseName().toLowerCase());
                }
                templateByBasetypeMap.put(template.getBaseName().toLowerCase(), template);
                templateByStereostrMap.put(template.getStereocode(), template);
            }
        }
        catch (JDOMException je) {
            throw new ResourcesDbException("Exception in parsing basetype templates from xml file.", je);
        }
        catch (IOException ie) {
            throw new ResourcesDbException("Exception in parsing basetype templates from xml file.", ie);
        }
        this.setBasetypeTemplateByBasetypeNameMap(templateByBasetypeMap);
        this.setBasetypeTemplateByStereocodeMap(templateByStereostrMap);
        this.setBasetypeListSpecific(specificList);
        this.setBasetypeListSuperclass(superclassList);
    }

    private static BasetypeTemplate getTemplateFromXmlTree(Element xmlTemplate) {
        BasetypeTemplate mt = null;
        if (xmlTemplate.getName().equals("template")) {
            mt = new BasetypeTemplate();
            List propList = xmlTemplate.getChildren();
            for (Element property : propList) {
                if (property.getName().equals("name")) {
                    mt.setBaseName(property.getValue());
                    continue;
                }
                if (property.getName().equals("longname")) {
                    mt.setLongName(property.getValue());
                    continue;
                }
                if (property.getName().equals("size")) {
                    mt.setSize(Integer.parseInt(property.getValue()));
                    continue;
                }
                if (property.getName().equals("carbonyl_position")) {
                    mt.setCarbonylPosition(Integer.parseInt(property.getValue()));
                    continue;
                }
                if (property.getName().equals("stereocode")) {
                    mt.setStereocode(property.getValue());
                    continue;
                }
                if (property.getName().equals("is_superclass")) {
                    mt.setIsSuperclass(property.getValue().toLowerCase().equals("true"));
                    continue;
                }
                if (property.getName().equals("default_configuration")) {
                    if (property.getValue().length() <= 0) continue;
                    try {
                        mt.setDefaultConfiguration(StereoConfiguration.forNameOrSymbol(property.getValue()));
                    }
                    catch (ResourcesDbException rex) {
                        System.err.println("illegal stereoconfiguration symbol: '" + property.getValue() + "'");
                    }
                    continue;
                }
                if (property.getName().equals("default_ringtype")) {
                    if (property.getValue().equals("p")) {
                        mt.setDefaultRingend(mt.getCarbonylPosition() + 4);
                        continue;
                    }
                    if (!property.getValue().equals("f")) continue;
                    mt.setDefaultRingend(mt.getCarbonylPosition() + 3);
                    continue;
                }
                System.err.println("warning: unknown tag in monosaccharide templates xml file: " + property.getName());
            }
        }
        return mt;
    }
}

