/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.monosaccharide;

import java.util.ArrayList;
import java.util.HashMap;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.monosaccharide.Basetype;
import org.eurocarbdb.resourcesdb.monosaccharide.Monosaccharide;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;
import org.eurocarbdb.resourcesdb.monosaccharide.StereoConfiguration;
import org.eurocarbdb.resourcesdb.template.BasetypeTemplate;
import org.eurocarbdb.resourcesdb.template.BasetypeTemplateContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stereocode
implements Cloneable {
    public static final char StereoD = '2';
    public static final char StereoL = '1';
    public static final char StereoXD = '4';
    public static final char StereoXL = '3';
    public static final char StereoX = 'x';
    public static final char StereoN = '0';
    public static final char ExtStereoDeoxy = 'd';
    public static final char ExtStereoEnOH = 'n';
    public static final char ExtStereoEnDeoxy = 'e';
    public static final char ExtStereoEnX = 'E';
    public static final char ExtStereoCH2OH = 'h';
    public static final char ExtStereoCH3 = 'm';
    public static final char ExtStereoAcid = 'a';
    public static final char ExtStereoCarbonyl = 'o';
    public static final char ExtStereoSp2 = 's';
    public static final char ExtStereoYn = 'y';
    public static final char ExtStereoKeto = 'k';
    public static final char ExtStereoUnknown = 'x';
    private String stereoStr;
    public static final String SUBTYPESTR = "subtype";
    public static final String BASETYPESTR = "basetype";

    public Stereocode(String code) {
        this.setStereoStr(code);
    }

    public Stereocode() {
        this.setStereoStr("");
    }

    public String getStereoStr() {
        return this.stereoStr;
    }

    public void setStereoStr(String stereocode) {
        this.stereoStr = stereocode;
    }

    public static String rotateStereoString(String stereo) {
        String rotStereo = "";
        int i = stereo.length() - 1;
        while (i >= 0) {
            rotStereo = String.valueOf(rotStereo) + stereo.substring(i, i + 1);
            --i;
        }
        return Stereocode.changeDLinStereoString(rotStereo);
    }

    public void rotate() {
        this.setStereoStr(Stereocode.rotateStereoString(this.getStereoStr()));
    }

    public static String changeDLinStereoString(String stereoIn) {
        String stereoOut = "";
        int i = 0;
        while (i < stereoIn.length()) {
            stereoOut = stereoIn.charAt(i) == '2' ? String.valueOf(stereoOut) + '1' : (stereoIn.charAt(i) == '1' ? String.valueOf(stereoOut) + '2' : (stereoIn.charAt(i) == '4' ? String.valueOf(stereoOut) + '3' : (stereoIn.charAt(i) == '3' ? String.valueOf(stereoOut) + '4' : String.valueOf(stereoOut) + stereoIn.charAt(i))));
            ++i;
        }
        return stereoOut;
    }

    public void changeDL() {
        this.setStereoStr(Stereocode.changeDLinStereoString(this.getStereoStr()));
    }

    public static String changeRelativeDLinStereoString(String stereoIn) {
        String stereoOut = "";
        int i = 0;
        while (i < stereoIn.length()) {
            stereoOut = stereoIn.charAt(i) == '4' ? String.valueOf(stereoOut) + '3' : (stereoIn.charAt(i) == '3' ? String.valueOf(stereoOut) + '4' : String.valueOf(stereoOut) + stereoIn.charAt(i));
            ++i;
        }
        return stereoOut;
    }

    public void changeRelativeDL() {
        this.setStereoStr(Stereocode.changeRelativeDLinStereoString(this.getStereoStr()));
    }

    public static String absoluteToRelative(String stereoIn) throws ResourcesDbException {
        String stereoOut = "";
        int i = 0;
        while (i < stereoIn.length()) {
            stereoOut = String.valueOf(stereoOut) + StereoConfiguration.stereosymbolAbsoluteToRelative(stereoIn.charAt(i));
            ++i;
        }
        return stereoOut;
    }

    public static String relativeToAbsolute(String stereoIn) throws ResourcesDbException {
        String stereoOut = "";
        int i = 0;
        while (i < stereoIn.length()) {
            stereoOut = String.valueOf(stereoOut) + StereoConfiguration.stereosymbolRelativeToAbsolute(stereoIn.charAt(i));
            ++i;
        }
        return stereoOut;
    }

    public static boolean stereoStringContainsAbsoluteAndRelative(String stereo) throws ResourcesDbException {
        boolean containsAbsolute = false;
        boolean containsRelative = false;
        int i = 0;
        while (i < stereo.length()) {
            StereoConfiguration c = StereoConfiguration.forStereosymbol(stereo.charAt(i));
            if (c.equals((Object)StereoConfiguration.Dexter) || c.equals((Object)StereoConfiguration.Laevus)) {
                containsAbsolute = true;
            }
            if (c.equals((Object)StereoConfiguration.XDexter) || c.equals((Object)StereoConfiguration.XLaevus)) {
                containsRelative = true;
            }
            ++i;
        }
        return containsAbsolute && containsRelative;
    }

    public static boolean stereoStringHasRelativePosition(String stereo) {
        int i = 0;
        while (i < stereo.length()) {
            block4: {
                StereoConfiguration c;
                try {
                    c = StereoConfiguration.forStereosymbol(stereo.charAt(i));
                }
                catch (ResourcesDbException e) {
                    break block4;
                }
                if (c.equals((Object)StereoConfiguration.XDexter) || c.equals((Object)StereoConfiguration.XLaevus)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public boolean hasRelativePosition() {
        return Stereocode.stereoStringHasRelativePosition(this.getStereoStr());
    }

    public static StereoConfiguration getConfigurationFromStereoString(String stereo) {
        stereo = stereo.replaceAll("0", "");
        int configCode = 32;
        if (stereo.length() == 0) {
            return StereoConfiguration.Nonchiral;
        }
        configCode = stereo.length() < 4 ? (int)stereo.charAt(stereo.length() - 1) : (int)stereo.charAt(3);
        if (configCode == 50) {
            return StereoConfiguration.Dexter;
        }
        if (configCode == 49) {
            return StereoConfiguration.Laevus;
        }
        return StereoConfiguration.Unknown;
    }

    public static StereoConfiguration getTrivialnameConfigurationFromStereoString(String stereo) {
        stereo = stereo.replaceAll("0", "");
        int configCode = 32;
        if (stereo.length() == 0) {
            return StereoConfiguration.Nonchiral;
        }
        configCode = stereo.charAt(stereo.length() - 1);
        if (configCode == 50) {
            return StereoConfiguration.Dexter;
        }
        if (configCode == 49) {
            return StereoConfiguration.Laevus;
        }
        return StereoConfiguration.Unknown;
    }

    public static String getChiralOnlyStereoString(String stereo) {
        String stereoOut = "";
        int i = 0;
        while (i < stereo.length()) {
            char symbol = stereo.charAt(i);
            if (symbol == '2' || symbol == '1' || symbol == '4' || symbol == '3') {
                stereoOut = String.valueOf(stereoOut) + symbol;
            }
            ++i;
        }
        return stereoOut;
    }

    public static String maskAnomerInStereoString(String stereo, Basetype bt) throws ResourcesDbException {
        if (stereo.length() != bt.getSize()) {
            throw new ResourcesDbException("stereostring length (" + stereo.length() + ") does not match basetype size (" + bt.getSize() + ")");
        }
        if (bt.getRingStart() > 0 && bt.getRingStart() <= bt.getSize()) {
            stereo = Stereocode.setPositionInStereoString(stereo, '0', bt.getRingStart());
        }
        return stereo;
    }

    public static HashMap<String, BasetypeTemplate> getBasetypeFromStereoString(String stereo, Monosaccharide ms, BasetypeTemplateContainer container) throws ResourcesDbException {
        if (stereo.length() == ms.getSize()) {
            stereo = ms.getStereoStrWithoutAnomeric();
        }
        if ((stereo = Stereocode.getChiralOnlyStereoString(stereo)).length() > 4) {
            stereo = stereo.substring(0, 4);
        }
        HashMap<String, BasetypeTemplate> resultMap = new HashMap<String, BasetypeTemplate>();
        BasetypeTemplate msTmpl = container.getBasetypeTemplateByStereoString(stereo);
        if (msTmpl == null) {
            throw new MonosaccharideException("Cannot get basetype from stereocode " + stereo);
        }
        if (msTmpl.getSize() == ms.getSize()) {
            resultMap.put(BASETYPESTR, msTmpl);
            resultMap.put(SUBTYPESTR, null);
        } else {
            resultMap.put(BASETYPESTR, container.getSuperclassTemplateBySize(ms.getSize()));
            resultMap.put(SUBTYPESTR, msTmpl);
        }
        return resultMap;
    }

    public static BasetypeTemplate getBasetypeFromStereoStringNoSizecheck(String stereo, BasetypeTemplateContainer container) throws ResourcesDbException {
        if ((stereo = Stereocode.getChiralOnlyStereoString(stereo)).length() > 4) {
            stereo = stereo.substring(0, 4);
        }
        BasetypeTemplate msTmpl = container.getBasetypeTemplateByStereoString(stereo);
        return msTmpl;
    }

    public static ArrayList<BasetypeTemplate> getRootTemplatesByStereoString(String stereo, BasetypeTemplateContainer container) throws ResourcesDbException {
        ArrayList<BasetypeTemplate> rootList = new ArrayList<BasetypeTemplate>();
        stereo.replaceAll("[x0]", ".");
        String stereoDL = Stereocode.changeDLinStereoString(stereo);
        ArrayList<String> basetypeList = container.getBasetypeListSpecific();
        int i = 0;
        while (i < basetypeList.size()) {
            BasetypeTemplate tmpl = container.getBasetypeTemplateByName(basetypeList.get(i));
            if (tmpl.getStereocode().matches(stereo) || tmpl.getStereocode().matches(stereoDL)) {
                rootList.add(tmpl);
            }
            ++i;
        }
        return rootList;
    }

    public static String expandChiralonlyStereoString(String stereo, Monosaccharide ms) throws MonosaccharideException {
        String stereoOut = "";
        stereoOut = String.valueOf(stereoOut) + StereoConfiguration.Nonchiral.getStereosymbol();
        if (ms.getRingStart() == 2) {
            stereoOut = String.valueOf(stereoOut) + StereoConfiguration.Nonchiral.getStereosymbol();
        }
        stereoOut = String.valueOf(stereoOut) + stereo;
        stereoOut = String.valueOf(stereoOut) + StereoConfiguration.Nonchiral.getStereosymbol();
        ArrayList<Integer> stereoLossPos = ms.getStereolossPositions();
        if (stereoLossPos.contains(new Integer(0))) {
            throw new MonosaccharideException("Cannot assign stereochemistry due to unknown position of a modification that causes loss of stereochemistry");
        }
        int i = 0;
        while (i < stereoLossPos.size()) {
            int position = stereoLossPos.get(i);
            if (position <= 0) {
                throw new MonosaccharideException("Error in setting stereocode: position out of range (" + position + ").");
            }
            if ((position != ms.getRingStart() || position != 2) && position != 1 && position != ms.getSize()) {
                if (position > stereoOut.length()) {
                    throw new MonosaccharideException("Error in setting stereocode: position out of range (" + position + ").");
                }
                stereoOut = String.valueOf(stereoOut.substring(0, position - 1)) + StereoConfiguration.Nonchiral.getStereosymbol() + stereoOut.substring(position - 1);
            }
            ++i;
        }
        return stereoOut;
    }

    public static String markNonchiralPositionsInStereoString(String stereo, Monosaccharide ms) throws MonosaccharideException {
        if (stereo.length() != ms.getSize()) {
            throw new MonosaccharideException("Size mismatch error in markNonchiralPositions: " + stereo + "/" + ms.getSize());
        }
        ArrayList<Integer> stereoLossPos = ms.getStereolossPositions();
        char[] stereoChars = stereo.toCharArray();
        int i = 0;
        while (i < stereoLossPos.size()) {
            int position = stereoLossPos.get(i);
            if (position == 0) {
                System.out.println("Warning: skipped unknown stereoloss position (markNonchiralPositions).");
            } else {
                if (position < 0 || position > ms.getSize()) {
                    throw new MonosaccharideException("Error in markNonchiralPositions: position out of range: " + position);
                }
                stereoChars[position - 1] = StereoConfiguration.Nonchiral.getStereosymbol();
            }
            ++i;
        }
        stereo = String.valueOf(stereoChars);
        return stereo;
    }

    public static String getSuperclassStereostring(int size) {
        String outStr = "";
        if (size > 0) {
            outStr = String.valueOf(outStr) + '0';
        }
        int i = 0;
        while (i < size - 2) {
            outStr = String.valueOf(outStr) + 'x';
            ++i;
        }
        if (size > 1) {
            outStr = String.valueOf(outStr) + '0';
        }
        return outStr;
    }

    public ArrayList<StereoConfiguration> toConfigurationList() throws ResourcesDbException {
        ArrayList<StereoConfiguration> configList = new ArrayList<StereoConfiguration>();
        int i = 0;
        while (i < this.getStereoStr().length()) {
            configList.add(StereoConfiguration.forStereosymbol(this.getStereoStr().charAt(i)));
            ++i;
        }
        return configList;
    }

    public static String setPositionInStereoString(String stereo, char posChar, int pos) throws ResourcesDbException {
        if (pos <= 0 || pos > stereo.length()) {
            throw new MonosaccharideException("Stereocode.setPosition: position out of range (" + (pos + 1) + ")");
        }
        if (StereoConfiguration.forStereosymbol(posChar) == null) {
            throw new MonosaccharideException("Stereocode.setPosition: Symbol to be set is not a valid configuration symbol: " + posChar);
        }
        stereo = pos < stereo.length() ? String.valueOf(stereo.substring(0, pos - 1)) + posChar + stereo.substring(pos) : String.valueOf(stereo.substring(0, pos - 1)) + posChar;
        return stereo;
    }

    public static String setPositionInStereoString(String stereo, StereoConfiguration posConf, int pos) throws ResourcesDbException {
        return Stereocode.setPositionInStereoString(stereo, posConf.getStereosymbol(), pos);
    }

    public static StereoConfiguration getPositionFromStereoString(String stereo, int pos) throws ResourcesDbException {
        if (pos < 1 || pos > stereo.length()) {
            throw new MonosaccharideException("position out of range: " + pos);
        }
        return StereoConfiguration.forStereosymbol(stereo.charAt(pos - 1));
    }

    public StereoConfiguration getPositionConfiguration(int pos) throws ResourcesDbException {
        return Stereocode.getPositionFromStereoString(this.getStereoStr(), pos);
    }

    public static ArrayList<String> getBasetypelistFromStereocode(Monosaccharide ms, BasetypeTemplateContainer container) throws ResourcesDbException {
        return Stereocode.getBasetypelistFromStereoString(ms.getStereoStr(), ms, container);
    }

    /*
     * Unable to fully structure code
     */
    public static ArrayList<String> getBasetypelistFromStereoString(String stereo, Monosaccharide ms, BasetypeTemplateContainer container) throws ResourcesDbException {
        block4: {
            if (ms.getRingStart() > 1) {
                stereo = Stereocode.setPositionInStereoString(stereo, StereoConfiguration.Nonchiral.getStereosymbol(), ms.getRingStart());
            }
            stereo = stereo.substring(1);
            stereo = stereo.replaceAll("" + StereoConfiguration.Nonchiral.getStereosymbol(), "");
            basetypeList = new ArrayList<String>();
            if (stereo.replaceAll("" + StereoConfiguration.Unknown.getStereosymbol(), "").equals("")) break block4;
            if (stereo.indexOf(StereoConfiguration.Unknown.getStereosymbol()) == -1) ** GOTO lbl18
            throw new MonosaccharideException("Stereocode string contains unknown positions.");
lbl-1000:
            // 1 sources

            {
                if (stereo.length() > 4) {
                    basetypeStr = container.getBasetypeTemplateByStereoString(stereo.substring(0, 4)).getBaseName();
                    basetypeStr = String.valueOf(Stereocode.getConfigurationFromStereoString(stereo.substring(0, 4)).getSymbol()) + "-" + basetypeStr;
                    stereo = stereo.substring(4);
                } else {
                    basetypeStr = container.getBasetypeTemplateByStereoString(stereo).getBaseName();
                    basetypeStr = String.valueOf(Stereocode.getConfigurationFromStereoString(stereo).getSymbol()) + "-" + basetypeStr;
                    stereo = "";
                }
                basetypeList.add(0, basetypeStr);
lbl18:
                // 2 sources

                ** while (stereo.length() > 0)
            }
        }
        return basetypeList;
    }

    public static ArrayList<String> prepareStereocodeForBasetypeDetermination(Monosaccharide ms) throws ResourcesDbException {
        ArrayList<String> stereoList = new ArrayList<String>();
        String stereo = ms.getStereoStr();
        if (ms.getRingStart() > 1) {
            stereo = Stereocode.setPositionInStereoString(stereo, StereoConfiguration.Nonchiral.getStereosymbol(), ms.getRingStart());
        }
        stereo = stereo.substring(1);
        if (!(stereo = stereo.replaceAll("" + StereoConfiguration.Nonchiral.getStereosymbol(), "")).replaceAll("" + StereoConfiguration.Unknown.getStereosymbol(), "").equals("")) {
            while (stereo.length() > 0) {
                if (stereo.length() > 4) {
                    stereoList.add(0, stereo.substring(0, 4));
                    stereo = stereo.substring(4);
                    continue;
                }
                stereoList.add(0, stereo);
                stereo = "";
            }
        }
        return stereoList;
    }

    public boolean hasUncertainPosition() {
        return Stereocode.stereoStringHasUncertainPosition(this.getStereoStr());
    }

    public static boolean stereoStringHasUncertainPosition(String stereo) {
        return !stereo.matches("^[210]*$");
    }

    public String toString() {
        return this.stereoStr;
    }

    public Stereocode clone() {
        return new Stereocode(this.getStereoStr());
    }
}

