/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.monosaccharide;

import java.util.ArrayList;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.atom.Composition;
import org.eurocarbdb.resourcesdb.atom.Periodic;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModification;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CoreModificationTemplate {
    DEOXY("deoxy", "deoxygenation", "deoxy", "d", 1, true, false, "-1O"),
    EN("en", "double bond", "en", "en", 2, true, true, "-2H"),
    ENX("enx", "double bond with unknown deoxygenation pattern", "", "", 2, true, true, ""),
    YN("yn", "triple bond", "yn", "yn", 2, true, false, "-4H"),
    ANHYDRO("anhydro", "anhydro", "anhydro", "anh", 2, false, false, "-2H-1O"),
    LACTONE("lactone", "lactone", "lactone", "", 2, false, false, "-2H-1O"),
    KETO("keto", "carbonyl group", "ulo", "ulo", 1, true, false, "-2H"),
    ACID("acid", "carboxyl group", "", "", 1, true, true, "+1O"),
    SP2("sp2", "sp2-hybride", "", "", 1, true, true, "-1H"),
    SP("sp", "sp-hybride", "", "", 1, true, true, "-1H"),
    ALDITOL("aldi", "alditol", "ol", "ol", 1, false, true, "+2H"),
    EPOXY("epoxy", "epoxy", "epoxy", "", 2, false, false, "-2H-1O");

    private String modName;
    private String description;
    private String carbbankName;
    private String bcsdbName;
    private int valence;
    private boolean stereoLoss;
    private boolean substitutable;
    private Composition compositionChanges;
    private String compositionChangesStr;
    private static ArrayList<String> coreModNamesList;
    private static ArrayList<String> carbbankNamesList;

    static {
        coreModNamesList = null;
        carbbankNamesList = null;
    }

    private CoreModificationTemplate(String nameStr, String descriptionStr, String carbbankStr, String bcsdbString, int valence, boolean stereoLoss, boolean substitutable, String compoChange) {
        this.setName(nameStr);
        this.setDescription(descriptionStr);
        this.setCarbbankName(carbbankStr);
        this.setBcsdbName(bcsdbString);
        this.setValence(valence);
        this.setStereoLoss(stereoLoss);
        this.setSubstitutable(substitutable);
        this.setCompositionChanges(CoreModificationTemplate.parseCompositionChangesString(compoChange));
        this.compositionChangesStr = compoChange;
    }

    public String getDescription() {
        return this.description;
    }

    private void setDescription(String descStr) {
        this.description = descStr;
    }

    public String getName() {
        return this.modName;
    }

    private void setName(String nameStr) {
        this.modName = nameStr;
    }

    public String getCarbbankName() {
        return this.carbbankName;
    }

    private void setCarbbankName(String carbbankNameStr) {
        this.carbbankName = carbbankNameStr;
    }

    public String getBcsdbName() {
        return this.bcsdbName;
    }

    public void setBcsdbName(String bcsdbName) {
        this.bcsdbName = bcsdbName;
    }

    public boolean isStereoLoss() {
        return this.stereoLoss;
    }

    private void setStereoLoss(boolean stereoLossFlag) {
        this.stereoLoss = stereoLossFlag;
    }

    public boolean isSubstitutable() {
        return this.substitutable;
    }

    private void setSubstitutable(boolean substable) {
        this.substitutable = substable;
    }

    public int getValence() {
        return this.valence;
    }

    private void setValence(int theValence) {
        this.valence = theValence;
    }

    public Composition getCompositionChanges() {
        if (this.compositionChanges == null && this.compositionChangesStr != null) {
            this.setCompositionChanges(CoreModificationTemplate.parseCompositionChangesString(this.compositionChangesStr));
        }
        return this.compositionChanges;
    }

    private void setCompositionChanges(Composition compChanges) {
        this.compositionChanges = compChanges;
    }

    private static Composition parseCompositionChangesString(String changeStr) {
        Composition compo = new Composition();
        while (changeStr.length() > 0) {
            try {
                int factor = 1;
                if (changeStr.startsWith("-")) {
                    factor = -1;
                    changeStr = changeStr.substring(1);
                } else if (changeStr.startsWith("+")) {
                    changeStr = changeStr.substring(1);
                }
                int count = Integer.parseInt(changeStr.substring(0, 1));
                changeStr = changeStr.substring(1);
                String elemSymbol = "";
                while (changeStr.matches("^[A-Za-z].*")) {
                    elemSymbol = String.valueOf(elemSymbol) + changeStr.substring(0, 1);
                    changeStr = changeStr.substring(1);
                }
                Periodic el = Periodic.getElementBySymbol(elemSymbol);
                compo.increaseCount(el, factor * count);
            }
            catch (ResourcesDbException re) {
                return null;
            }
        }
        return compo;
    }

    public static CoreModificationTemplate forName(String name) throws MonosaccharideException {
        if (name.equalsIgnoreCase("ulo")) {
            return KETO;
        }
        CoreModificationTemplate[] coreModificationTemplateArray = CoreModificationTemplate.values();
        int n = coreModificationTemplateArray.length;
        int n2 = 0;
        while (n2 < n) {
            CoreModificationTemplate c = coreModificationTemplateArray[n2];
            if (name.equalsIgnoreCase(c.modName)) {
                return c;
            }
            if (name.equalsIgnoreCase(c.name())) {
                return c;
            }
            ++n2;
        }
        throw new MonosaccharideException("Invalid core modification: " + name);
    }

    public static CoreModificationTemplate forCarbbankName(String name) {
        if (name != null) {
            CoreModificationTemplate[] coreModificationTemplateArray = CoreModificationTemplate.values();
            int n = coreModificationTemplateArray.length;
            int n2 = 0;
            while (n2 < n) {
                CoreModificationTemplate c = coreModificationTemplateArray[n2];
                if (name.equalsIgnoreCase(c.getCarbbankName())) {
                    return c;
                }
                ++n2;
            }
        }
        return null;
    }

    public static ArrayList<String> getCoreModificationNamesList() {
        if (coreModNamesList == null) {
            CoreModificationTemplate.setCoreModificationNamesList();
        }
        return coreModNamesList;
    }

    private static void setCoreModificationNamesList() {
        coreModNamesList = new ArrayList();
        CoreModificationTemplate[] coreModificationTemplateArray = CoreModificationTemplate.values();
        int n = coreModificationTemplateArray.length;
        int n2 = 0;
        while (n2 < n) {
            CoreModificationTemplate c = coreModificationTemplateArray[n2];
            coreModNamesList.add(c.getName());
            ++n2;
        }
    }

    public static ArrayList<String> getCarbbankNamesList() {
        if (carbbankNamesList == null) {
            CoreModificationTemplate.setCarbbankNamesList();
        }
        return carbbankNamesList;
    }

    private static void setCarbbankNamesList() {
        carbbankNamesList = new ArrayList();
        CoreModificationTemplate[] coreModificationTemplateArray = CoreModificationTemplate.values();
        int n = coreModificationTemplateArray.length;
        int n2 = 0;
        while (n2 < n) {
            CoreModificationTemplate c = coreModificationTemplateArray[n2];
            if (c.getCarbbankName().length() > 0) {
                carbbankNamesList.add(c.getCarbbankName());
            }
            ++n2;
        }
    }

    public static ArrayList<String> getBcsdbNamesList() {
        ArrayList<String> bcsdbNamesList = new ArrayList<String>();
        CoreModificationTemplate[] coreModificationTemplateArray = CoreModificationTemplate.values();
        int n = coreModificationTemplateArray.length;
        int n2 = 0;
        while (n2 < n) {
            CoreModificationTemplate c = coreModificationTemplateArray[n2];
            if (c.getBcsdbName().length() > 0) {
                bcsdbNamesList.add(c.getBcsdbName());
            }
            ++n2;
        }
        return bcsdbNamesList;
    }

    public String toString() {
        String outStr = String.valueOf(this.name()) + " " + this.modName + " " + this.description + " " + this.compositionChanges.toString();
        return outStr;
    }

    public static boolean modListContainsModType(ArrayList<CoreModification> modList, CoreModificationTemplate modTmpl) {
        for (CoreModification mod : modList) {
            if (!mod.getTemplate().equals((Object)modTmpl)) continue;
            return true;
        }
        return false;
    }
}

