/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.io;

import java.util.ArrayList;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.ResourcesDbObject;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.GlycoconjugateException;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;
import org.eurocarbdb.resourcesdb.io.BcsdbExporter;
import org.eurocarbdb.resourcesdb.io.BcsdbImporter;
import org.eurocarbdb.resourcesdb.io.CarbbankExporter;
import org.eurocarbdb.resourcesdb.io.CarbbankImporter;
import org.eurocarbdb.resourcesdb.io.CfgExporter;
import org.eurocarbdb.resourcesdb.io.CfgImporter;
import org.eurocarbdb.resourcesdb.io.GlycoCTExporter;
import org.eurocarbdb.resourcesdb.io.GlycoCTImporter;
import org.eurocarbdb.resourcesdb.io.MonosaccharideConversion;
import org.eurocarbdb.resourcesdb.io.MonosaccharideExchangeObject;
import org.eurocarbdb.resourcesdb.io.StandardExporter;
import org.eurocarbdb.resourcesdb.io.SubstituentExchangeObject;
import org.eurocarbdb.resourcesdb.monosaccharide.BasetypeConversion;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModification;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModificationTemplate;
import org.eurocarbdb.resourcesdb.monosaccharide.Monosaccharide;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideValidation;
import org.eurocarbdb.resourcesdb.monosaccharide.Substitution;
import org.eurocarbdb.resourcesdb.nonmonosaccharide.AglyconTemplate;
import org.eurocarbdb.resourcesdb.nonmonosaccharide.NonmonosaccharideException;
import org.eurocarbdb.resourcesdb.template.SubstituentTemplate;
import org.eurocarbdb.resourcesdb.template.TemplateContainer;

public class MonosaccharideConverter
extends ResourcesDbObject
implements MonosaccharideConversion {
    public MonosaccharideConverter() {
        this(null, null);
    }

    public MonosaccharideConverter(Config conf) {
        this(conf, null);
    }

    public MonosaccharideConverter(TemplateContainer container) {
        this(null, container);
    }

    public MonosaccharideConverter(Config conf, TemplateContainer container) {
        this.setConfig(conf);
        this.setTemplateContainer(container);
    }

    public Monosaccharide parseMsNamestr(String msNamestr, GlycanNamescheme sourceScheme) throws ResourcesDbException {
        Monosaccharide ms = null;
        if (GlycanNamescheme.CARBBANK.equals((Object)sourceScheme.getBaseScheme())) {
            CarbbankImporter importer = new CarbbankImporter(sourceScheme, this.getConfig(), this.getTemplateContainer());
            ms = importer.parseMsString(msNamestr);
        } else if (GlycanNamescheme.GLYCOCT.equals((Object)sourceScheme.getBaseScheme())) {
            GlycoCTImporter importer = new GlycoCTImporter(sourceScheme, this.getConfig(), this.getTemplateContainer());
            ms = importer.parseMsString(msNamestr);
        } else if (GlycanNamescheme.CFG.equals((Object)sourceScheme.getBaseScheme())) {
            CfgImporter importer = new CfgImporter(this.getConfig(), this.getTemplateContainer());
            ms = importer.parseMsString(msNamestr);
        } else if (GlycanNamescheme.BCSDB.equals((Object)sourceScheme.getBaseScheme())) {
            BcsdbImporter importer = new BcsdbImporter(this.getConfig(), this.getTemplateContainer());
            ms = importer.parseMsString(msNamestr);
        } else {
            if (GlycanNamescheme.AUTO.equals((Object)sourceScheme)) {
                ArrayList<Monosaccharide> msList = new ArrayList<Monosaccharide>();
                GlycanNamescheme[] glycanNameschemeArray = GlycanNamescheme.values();
                int n = glycanNameschemeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GlycanNamescheme testScheme = glycanNameschemeArray[n2];
                    if (!testScheme.equals((Object)GlycanNamescheme.AUTO)) {
                        try {
                            ms = this.parseMsNamestr(msNamestr, testScheme);
                            if (ms != null) {
                                boolean addToList = true;
                                for (Monosaccharide listMs : msList) {
                                    if (!listMs.getName().equals(ms.getName())) continue;
                                    addToList = false;
                                }
                                if (addToList) {
                                    msList.add(ms);
                                }
                            }
                        }
                        catch (ResourcesDbException resourcesDbException) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
                if (msList.size() == 1) {
                    return (Monosaccharide)msList.get(0);
                }
                if (msList.size() == 0) {
                    throw new ResourcesDbException("Cannot auto-detect namescheme for monosaccharide " + msNamestr + ": the name cannot be parsed correctly in any namescheme.");
                }
                throw new ResourcesDbException("Cannot auto-detect namescheme for monosaccharide " + msNamestr + ": " + msList.size() + " schemes reveal different results.");
            }
            throw new ResourcesDbException("unsupported source namescheme: " + sourceScheme.getNameStr());
        }
        return ms;
    }

    public MonosaccharideExchangeObject convertMonosaccharide(String msNamestr, GlycanNamescheme sourceScheme, GlycanNamescheme targetScheme) throws ResourcesDbException {
        MonosaccharideExchangeObject msObjOutput = new MonosaccharideExchangeObject(this.getConfig(), this.getTemplateContainer());
        Monosaccharide ms = null;
        ms = this.parseMsNamestr(msNamestr, sourceScheme);
        msObjOutput = this.convertMonosaccharide(ms, targetScheme);
        return msObjOutput;
    }

    public MonosaccharideExchangeObject convertMonosaccharide(MonosaccharideExchangeObject msObjInput, GlycanNamescheme sourceScheme, GlycanNamescheme targetScheme) throws ResourcesDbException {
        MonosaccharideExchangeObject msObjOutput = new MonosaccharideExchangeObject(this.getConfig(), this.getTemplateContainer());
        Monosaccharide ms = null;
        if (GlycanNamescheme.GLYCOCT.equals((Object)sourceScheme.getBaseScheme())) {
            if (msObjInput.getBasetype() != null) {
                ms = BasetypeConversion.eurcarbdbToMsdb(msObjInput.getBasetype(), msObjInput.getConfig(), msObjInput.getTemplateContainer());
                if (ms == null) {
                    throw new MonosaccharideException("cannot get monosaccharide object from eurocarbdb basetype.");
                }
            } else {
                ms = this.parseMsNamestr(msObjInput.getMonosaccharideName(), sourceScheme);
            }
            for (SubstituentExchangeObject substExch : msObjInput.getSubstituents()) {
                CoreModification mod;
                if (substExch.getName().equals(CoreModificationTemplate.ANHYDRO.getName())) {
                    mod = new CoreModification();
                    mod.setName(CoreModificationTemplate.ANHYDRO.getName());
                    mod.setPosition1(substExch.getPosition1());
                    mod.setPosition2(substExch.getSubstituentPosition1());
                    mod.setValence(2);
                    ms.addCoreModification(mod);
                    continue;
                }
                if (substExch.getName().equals((Object)CoreModificationTemplate.LACTONE)) {
                    mod = new CoreModification();
                    mod.setName(CoreModificationTemplate.LACTONE.getName());
                    mod.setPosition1(substExch.getPosition1());
                    mod.setPosition2(substExch.getSubstituentPosition1());
                    mod.setValence(2);
                    mod.sortPositions();
                    ms.addCoreModification(mod);
                    continue;
                }
                Substitution subst = new Substitution(substExch, sourceScheme, this.getConfig(), this.getTemplateContainer());
                ms.addSeparateDisplaySubstitution(subst, sourceScheme, this.getTemplateContainer().getSubstituentTemplateContainer(), false);
            }
        } else if (GlycanNamescheme.CARBBANK.equals((Object)sourceScheme.getBaseScheme())) {
            ms = this.parseMsNamestr(msObjInput.getMonosaccharideName(), sourceScheme);
            if (msObjInput.hasSubstituentsInList()) {
                for (SubstituentExchangeObject substExchObj : msObjInput.getSubstituents()) {
                    Substitution subst = new Substitution(substExchObj, this.getConfig(), this.getTemplateContainer());
                    ms.addSeparateDisplaySubstitution(subst, sourceScheme, this.getTemplateContainer().getSubstituentTemplateContainer(), true);
                }
            }
        } else if (GlycanNamescheme.CFG.equals((Object)sourceScheme.getBaseScheme())) {
            ms = this.parseMsNamestr(msObjInput.getMonosaccharideName(), sourceScheme);
            if (msObjInput.hasSubstituentsInList()) {
                for (SubstituentExchangeObject substExchObj : msObjInput.getSubstituents()) {
                    Substitution subst = new Substitution(substExchObj, this.getConfig(), this.getTemplateContainer());
                    ms.addSeparateDisplaySubstitution(subst, sourceScheme, this.getTemplateContainer().getSubstituentTemplateContainer(), true);
                }
            }
        } else if (GlycanNamescheme.BCSDB.equals((Object)sourceScheme.getBaseScheme())) {
            ms = this.parseMsNamestr(msObjInput.getMonosaccharideName(), sourceScheme);
            if (msObjInput.hasSubstituentsInList()) {
                for (SubstituentExchangeObject substExchObj : msObjInput.getSubstituents()) {
                    Substitution subst = new Substitution(substExchObj, this.getConfig(), this.getTemplateContainer());
                    ms.addSeparateDisplaySubstitution(subst, sourceScheme, this.getTemplateContainer().getSubstituentTemplateContainer(), true);
                }
            }
        } else {
            throw new ResourcesDbException("unsupported source namescheme: " + sourceScheme.getNameStr());
        }
        msObjOutput = this.convertMonosaccharide(ms, targetScheme);
        return msObjOutput;
    }

    public MonosaccharideExchangeObject convertMonosaccharide(Monosaccharide ms, GlycanNamescheme targetScheme) throws ResourcesDbException {
        MonosaccharideExchangeObject msObjOutput = new MonosaccharideExchangeObject(this.getConfig(), this.getTemplateContainer());
        StandardExporter exporter = null;
        String nameStr = null;
        if (GlycanNamescheme.CARBBANK.equals((Object)targetScheme.getBaseScheme())) {
            exporter = new CarbbankExporter(targetScheme, this.getConfig(), this.getTemplateContainer());
            nameStr = exporter.export(ms);
        } else if (GlycanNamescheme.GLYCOCT.equals((Object)targetScheme.getBaseScheme())) {
            exporter = new GlycoCTExporter(targetScheme, this.getConfig(), this.getTemplateContainer());
            nameStr = exporter.export(ms);
        } else if (GlycanNamescheme.CFG.equals((Object)targetScheme.getBaseScheme())) {
            exporter = new CfgExporter(this.getConfig(), this.getTemplateContainer());
            nameStr = exporter.export(ms);
        } else if (GlycanNamescheme.BCSDB.equals((Object)targetScheme.getBaseScheme())) {
            exporter = new BcsdbExporter(this.getConfig(), this.getTemplateContainer());
            nameStr = exporter.export(ms);
        } else {
            throw new ResourcesDbException("Unsupported target namescheme: " + targetScheme.getNameStr());
        }
        msObjOutput.setMonosaccharideName(nameStr);
        msObjOutput.setMonosaccharideNamescheme(targetScheme);
        try {
            msObjOutput.setBasetype(BasetypeConversion.msdbToEurocarbdb(ms));
        }
        catch (GlycoconjugateException ge) {
            throw new MonosaccharideException("Error in basetype conversion: " + ge.getMessage(), ge);
        }
        ArrayList<SubstituentExchangeObject> extSubstList = exporter.getSeparateDisplaySubstituents(ms);
        for (SubstituentExchangeObject substObj : extSubstList) {
            msObjOutput.addSubstituent(substObj);
        }
        MonosaccharideValidation.checkMonosaccharideConsistency(ms, this.getTemplateContainer(), this.getConfig());
        msObjOutput.setOrientationChanged(ms.isOrientationChanged());
        msObjOutput.addResidueType(MonosaccharideExchangeObject.ResidueTypes.monosaccharide);
        msObjOutput.setAvgMass(ms.getAvgMass());
        msObjOutput.setMonoMass(ms.getMonoMass());
        return msObjOutput;
    }

    public String convertSubstituent(String sourceSubstituentName, GlycanNamescheme sourceScheme, GlycanNamescheme targetScheme) throws ResourcesDbException {
        SubstituentTemplate subst = this.getTemplateContainer().getSubstituentTemplateContainer().forName(sourceScheme, sourceSubstituentName);
        if (subst == null) {
            throw new NonmonosaccharideException(String.valueOf(sourceSubstituentName) + " is not a valid substituent name in " + sourceScheme.getNameStr() + " namescheme.");
        }
        return subst.getPrimaryAlias(targetScheme, subst.getDefaultLinkagetype1()).getSeparateDisplayName();
    }

    public SubstituentExchangeObject convertSubstituent(SubstituentExchangeObject sourceSubst, GlycanNamescheme sourceScheme, GlycanNamescheme targetScheme) throws ResourcesDbException {
        SubstituentTemplate subst = this.getTemplateContainer().getSubstituentTemplateContainer().forName(sourceScheme, sourceSubst.getName());
        if (subst == null) {
            throw new NonmonosaccharideException(String.valueOf(sourceSubst.getName()) + " is not a valid substituent name in " + sourceScheme.getNameStr() + " namescheme.");
        }
        LinkageType linktype = sourceSubst.getLinkagetype1();
        if (linktype == null) {
            linktype = subst.getLinkageTypeBySubstituentName(sourceScheme, sourceSubst.getName());
        }
        SubstituentExchangeObject substOut = new SubstituentExchangeObject(targetScheme, this.getConfig(), this.getTemplateContainer());
        substOut.setName(subst.getPrimaryAlias(targetScheme, linktype).getSeparateDisplayName());
        substOut.setPosition1(sourceSubst.getPosition1());
        substOut.setPosition2(sourceSubst.getPosition2());
        substOut.setSubstituentPosition1(sourceSubst.getSubstituentPosition1());
        substOut.setSubstituentPosition2(sourceSubst.getSubstituentPosition2());
        substOut.setLinkagetype1(linktype);
        substOut.setOriginalName(sourceSubst.getName());
        substOut.setOriginalLinkagetype1(sourceSubst.getLinkagetype1());
        substOut.setOriginalLinkagetype2(sourceSubst.getLinkagetype2());
        return substOut;
    }

    public String convertAglycon(String sourceAglyconName, GlycanNamescheme sourceScheme, GlycanNamescheme targetScheme) throws ResourcesDbException {
        AglyconTemplate aglycTemplate = this.getTemplateContainer().getAglyconTemplateContainer().getAglyconTemplateByName(sourceScheme, sourceAglyconName);
        if (aglycTemplate == null) {
            throw new NonmonosaccharideException(String.valueOf(sourceAglyconName) + " is not a valid aglycon name in notation " + sourceScheme.getNameStr());
        }
        String targetName = aglycTemplate.getPrimaryAlias(targetScheme);
        if (targetName == null) {
            throw new NonmonosaccharideException("No primary alias available for aglycon " + aglycTemplate.getName() + " in notation " + sourceScheme.getNameStr());
        }
        return targetName;
    }

    public String checkSubstituent(String substName, GlycanNamescheme sourceScheme) throws ResourcesDbException {
        return this.convertSubstituent(substName, sourceScheme, sourceScheme);
    }

    public String checkAglycon(String aglyconName, GlycanNamescheme sourceScheme) throws ResourcesDbException {
        return this.convertAglycon(aglyconName, sourceScheme, sourceScheme);
    }

    public MonosaccharideExchangeObject convertResidue(String resNamestr, GlycanNamescheme sourceScheme, GlycanNamescheme targetScheme) throws ResourcesDbException {
        String resOutnameStr2;
        MonosaccharideExchangeObject retObj = null;
        try {
            retObj = this.convertMonosaccharide(resNamestr, sourceScheme, targetScheme);
        }
        catch (ResourcesDbException resourcesDbException) {
            // empty catch block
        }
        try {
            resOutnameStr2 = this.convertSubstituent(resNamestr, sourceScheme, targetScheme);
            if (retObj == null) {
                retObj = new MonosaccharideExchangeObject(resOutnameStr2, targetScheme, this.getConfig(), this.getTemplateContainer());
            }
            retObj.addResidueType(MonosaccharideExchangeObject.ResidueTypes.substituent);
        }
        catch (ResourcesDbException resOutnameStr2) {
            // empty catch block
        }
        try {
            resOutnameStr2 = this.convertAglycon(resNamestr, sourceScheme, targetScheme);
            if (retObj == null) {
                retObj = new MonosaccharideExchangeObject(resOutnameStr2, targetScheme, this.getConfig(), this.getTemplateContainer());
            }
            retObj.addResidueType(MonosaccharideExchangeObject.ResidueTypes.aglycon);
        }
        catch (ResourcesDbException resourcesDbException) {
            // empty catch block
        }
        if (retObj == null) {
            throw new ResourcesDbException("Cannot convert residue '" + resNamestr + "' from " + sourceScheme.getNameStr() + " to " + targetScheme.getNameStr());
        }
        return retObj;
    }

    public MonosaccharideExchangeObject validateGlycoCT(MonosaccharideExchangeObject msObj) throws ResourcesDbException {
        return this.convertMonosaccharide(msObj, GlycanNamescheme.GLYCOCT, GlycanNamescheme.GLYCOCT);
    }
}

