/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.io;

import java.util.ArrayList;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;
import org.eurocarbdb.resourcesdb.io.MonosaccharideImporter;
import org.eurocarbdb.resourcesdb.io.NameParsingException;
import org.eurocarbdb.resourcesdb.io.StandardImporter;
import org.eurocarbdb.resourcesdb.monosaccharide.Anomer;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModification;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModificationTemplate;
import org.eurocarbdb.resourcesdb.monosaccharide.Monosaccharide;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideValidation;
import org.eurocarbdb.resourcesdb.monosaccharide.Ringtype;
import org.eurocarbdb.resourcesdb.monosaccharide.StereoConfiguration;
import org.eurocarbdb.resourcesdb.monosaccharide.Stereocode;
import org.eurocarbdb.resourcesdb.monosaccharide.Substitution;
import org.eurocarbdb.resourcesdb.template.BasetypeTemplate;
import org.eurocarbdb.resourcesdb.template.SubstituentTemplate;
import org.eurocarbdb.resourcesdb.template.TemplateContainer;
import org.eurocarbdb.resourcesdb.template.TrivialnameTemplate;
import org.eurocarbdb.resourcesdb.util.NumberPrefix;
import org.eurocarbdb.resourcesdb.util.StringUtils;

public class CarbbankImporter
extends StandardImporter
implements MonosaccharideImporter {
    private String prePosStr;
    private String postPosStr;
    private BasetypeTemplate detectedBasetype;
    private BasetypeTemplate detectedSubtype;
    private Ringtype detectedRingtype;
    private int fuzzy;
    private int preposWildcards;
    private boolean useDefaultValues = false;

    public CarbbankImporter() {
        this(GlycanNamescheme.CARBBANK, null, null);
    }

    public CarbbankImporter(GlycanNamescheme scheme, Config confObj) {
        this(scheme, confObj, null);
    }

    public CarbbankImporter(GlycanNamescheme scheme, Config confObj, TemplateContainer container) {
        super(scheme, confObj, container);
        this.init();
    }

    private String getPostPosStr() {
        return this.postPosStr;
    }

    private void setPostPosStr(String postPosStr) {
        this.postPosStr = postPosStr;
    }

    private String getPrePosStr() {
        return this.prePosStr;
    }

    private void setPrePosStr(String prePosStr) {
        this.prePosStr = prePosStr;
    }

    public BasetypeTemplate getDetectedBasetype() {
        return this.detectedBasetype;
    }

    public void setDetectedBasetype(BasetypeTemplate detectedBasetype) {
        this.detectedBasetype = detectedBasetype;
    }

    public BasetypeTemplate getDetectedSubtype() {
        return this.detectedSubtype;
    }

    public void setDetectedSubtype(BasetypeTemplate detectedSubtype) {
        this.detectedSubtype = detectedSubtype;
    }

    public boolean isUseDefaultValues() {
        return this.useDefaultValues;
    }

    public void setUseDefaultValues(boolean useDefaultValues) {
        this.useDefaultValues = useDefaultValues;
    }

    private int getPreposWildcards() {
        return this.preposWildcards;
    }

    private void setPreposWildcards(int preposWildcards) {
        this.preposWildcards = preposWildcards;
    }

    private void increasePreposWildcards() {
        this.setPreposWildcards(this.getPreposWildcards() + 1);
    }

    private void decreasePreposWildcards() {
        this.setPreposWildcards(this.getPreposWildcards() - 1);
    }

    private int getFuzzy() {
        return this.fuzzy;
    }

    private void setFuzzy(int fuzzy) {
        this.fuzzy = fuzzy;
    }

    private void addFuzzy() {
        this.setFuzzy(this.getFuzzy() + 1);
    }

    public boolean isFuzzy() {
        return this.getFuzzy() > 0;
    }

    public Monosaccharide parseMsString(String name) throws ResourcesDbException {
        Monosaccharide ms = new Monosaccharide(this.getConfig(), this.getTemplateContainer());
        this.parseMsString(name, ms);
        return ms;
    }

    public void parseMsString(String name, Monosaccharide ms) throws ResourcesDbException {
        TrivialnameTemplate trivTmpl;
        BasetypeTemplate basetype;
        int basepos;
        if (ms == null) {
            throw new NameParsingException("CarbbankImporter.parseMsString(String, Monosaccharide): Monosaccharide must not be null.");
        }
        ms.init();
        ms.setCheckPositionsOnTheFly(false);
        this.setInputName(name);
        this.setFoundMs(false);
        ArrayList<String> basetypesSuperclassList = this.getTemplateContainer().getBasetypeTemplateContainer().getBasetypeListSuperclass();
        ArrayList<String> basetypesSpecificList = this.getTemplateContainer().getBasetypeTemplateContainer().getBasetypeListSpecific();
        String nameLowercase = name.toLowerCase();
        int i = 0;
        while (i < basetypesSuperclassList.size()) {
            basepos = nameLowercase.indexOf(basetypesSuperclassList.get(i));
            if (basepos != -1) {
                this.setPrePosStr(name.substring(0, basepos));
                this.setPostPosStr(name.substring(basepos + basetypesSuperclassList.get(i).length()));
                basetype = this.getTemplateContainer().getBasetypeTemplateContainer().getBasetypeTemplateByName(basetypesSuperclassList.get(i));
                this.setDetectedBasetype(basetype);
                ms.setSize(basetype.getSize());
                ms.setDefaultCarbonylPosition(basetype.getCarbonylPosition());
                if (this.getPrePosStr().length() >= 3) {
                    BasetypeTemplate subtype;
                    String subtypeStr = this.getPrePosStr().substring(this.getPrePosStr().length() - 3, this.getPrePosStr().length()).toLowerCase();
                    if (subtypeStr.equals("thr")) {
                        subtypeStr = "tro";
                    }
                    if ((subtype = this.getTemplateContainer().getBasetypeTemplateContainer().getBasetypeTemplateByName(subtypeStr)) == null) {
                        TrivialnameTemplate trivialnameTemplate = this.getTemplateContainer().getTrivialnameTemplateContainer().forBasetypeName(this.getNamescheme(), subtypeStr);
                    }
                    if (subtype != null) {
                        this.setDetectedSubtype(subtype);
                        this.setTmpStereocode(subtype.getStereocode());
                        ms.setDefaultCarbonylPosition(subtype.getCarbonylPosition());
                        this.setPrePosStr(this.getPrePosStr().substring(0, this.getPrePosStr().length() - 3));
                    }
                }
                this.setFoundMs(true);
                break;
            }
            ++i;
        }
        if (!this.isFoundMs()) {
            i = 0;
            while (i < basetypesSpecificList.size()) {
                basepos = nameLowercase.indexOf(basetypesSpecificList.get(i));
                if (basepos != -1) {
                    this.setPrePosStr(name.substring(0, basepos));
                    this.setPostPosStr(name.substring(basepos + basetypesSpecificList.get(i).length()));
                    basetype = this.getTemplateContainer().getBasetypeTemplateContainer().getBasetypeTemplateByName(basetypesSpecificList.get(i));
                    this.setDetectedBasetype(basetype);
                    ms.setSize(basetype.getSize());
                    ms.setDefaultCarbonylPosition(basetype.getCarbonylPosition());
                    this.setTmpStereocode(basetype.getStereocode());
                    this.setFoundMs(true);
                    break;
                }
                ++i;
            }
        }
        if (!this.isFoundMs()) {
            ArrayList<String> trivialNamesList = this.getTemplateContainer().getTrivialnameTemplateContainer().getTrivialnameBasetypeList(GlycanNamescheme.CARBBANK);
            for (String basename : trivialNamesList) {
                int basepos2 = nameLowercase.indexOf(basename);
                if (basepos2 == -1) continue;
                this.setPrePosStr(name.substring(0, basepos2));
                this.setPostPosStr(name.substring(basepos2 + basename.length()));
                TrivialnameTemplate template = this.getTemplateContainer().getTrivialnameTemplateContainer().forBasetypeName(this.getNamescheme(), basename);
                this.setDetectedBasetype(template);
                this.setDetectedTrivialname(template);
                this.setTmpStereocode(template.getStereocode());
                this.setFoundMs(true);
                ms.init(template);
                break;
            }
        }
        if (!this.isFoundMs()) {
            throw new NameParsingException("Could not find ms basetype in " + name);
        }
        this.parsePreposStr(this.getPrePosStr(), ms);
        this.parsePostposStr(this.getPostPosStr(), ms);
        this.processParsedData(ms);
        if (this.getDetectedTrivialname() != null && (trivTmpl = this.getDetectedTrivialname()).isDefaultConfigIsCompulsory()) {
            if (ms.getConfiguration() == null) {
                ms.setConfiguration(trivTmpl.getDefaultConfiguration());
            }
            if (!trivTmpl.getDefaultConfiguration().equals((Object)ms.getConfiguration())) {
                throw new NameParsingException("Trivialname '" + trivTmpl.getPrimaryName(this.getNamescheme()) + "' is not defined for configuration " + ms.getConfiguration().getSymbol() + ".");
            }
        }
        MonosaccharideValidation.checkMonosaccharideConsistency(ms, this.getTemplateContainer(), this.getConfig());
    }

    private void parsePreposStr(String preposStr, Monosaccharide ms) throws ResourcesDbException {
        while (preposStr.length() > 0) {
            String subStereo;
            BasetypeTemplate subtype2;
            if (preposStr.startsWith("-")) {
                preposStr = preposStr.substring(1);
                this.increaseParsingPosition();
                continue;
            }
            if (preposStr.startsWith("aldehydo-")) {
                ms.setRingEnd(-1);
                ms.setRingStart(-1);
                preposStr = preposStr.substring(9);
                this.increaseParsingPosition(9);
                this.detectedRingtype = Ringtype.OPEN;
                continue;
            }
            if (preposStr.startsWith("keto-")) {
                ms.setRingEnd(-1);
                ms.setRingStart(-1);
                preposStr = preposStr.substring(5);
                this.increaseParsingPosition(5);
                this.detectedRingtype = Ringtype.OPEN;
                continue;
            }
            if (preposStr.startsWith("?-")) {
                BasetypeTemplate subtype22;
                this.increasePreposWildcards();
                preposStr = preposStr.substring(2);
                this.increaseParsingPosition(2);
                if (preposStr.length() <= 2 || (subtype22 = this.getTemplateContainer().getBasetypeTemplateContainer().getBasetypeTemplateByName(preposStr.substring(0, 3))) == null) continue;
                preposStr = preposStr.substring(3);
                this.increaseParsingPosition(3);
                String subStereoStr = Stereocode.absoluteToRelative(subtype22.getStereocode());
                ms.setStereoStr(String.valueOf(subStereoStr) + ms.getStereoStr());
                this.addFuzzy();
                this.decreasePreposWildcards();
                continue;
            }
            if (preposStr.toLowerCase().startsWith("a-") || preposStr.toLowerCase().startsWith("b-")) {
                if (ms.getAnomer() != null) {
                    throw new NameParsingException("multiple definition of anomer.", this.getInputName(), this.getParsingPosition());
                }
                ms.setAnomer(preposStr.substring(0, 1));
                preposStr = preposStr.substring(2);
                this.increaseParsingPosition(2);
                continue;
            }
            if (preposStr.toLowerCase().startsWith("alpha")) {
                if (ms.getAnomer() != null) {
                    throw new NameParsingException("multiple definition of anomer.", this.getInputName(), this.getParsingPosition());
                }
                ms.setAnomer("a");
                preposStr = preposStr.substring(5);
                this.increaseParsingPosition(5);
                continue;
            }
            if (preposStr.toLowerCase().startsWith("beta")) {
                if (ms.getAnomer() != null) {
                    throw new NameParsingException("multiple definition of anomer.", this.getInputName(), this.getParsingPosition());
                }
                ms.setAnomer("b");
                preposStr = preposStr.substring(4);
                this.increaseParsingPosition(4);
                continue;
            }
            int tmpParsingPosition = this.getParsingPosition();
            if (preposStr.toLowerCase().startsWith("d-") || preposStr.toLowerCase().startsWith("l-")) {
                String configStr = preposStr.substring(0, 1).toLowerCase();
                preposStr = preposStr.substring(2);
                this.increaseParsingPosition(2);
                subtype2 = null;
                if (preposStr.length() > 2) {
                    String subtypeStr = preposStr.substring(0, 3);
                    subtype2 = this.getTemplateContainer().getBasetypeTemplateContainer().getBasetypeTemplateByName(subtypeStr);
                }
                if (subtype2 != null) {
                    subStereo = subtype2.getStereocode();
                    if (configStr.equals("l")) {
                        subStereo = Stereocode.changeDLinStereoString(subStereo);
                    }
                    ms.setStereoStr(String.valueOf(subStereo) + ms.getStereoStr());
                    preposStr = preposStr.substring(3);
                    this.increaseParsingPosition(3);
                    continue;
                }
                if (ms.getConfiguration() != null) {
                    throw new NameParsingException("Found multiple configuration definitions.", this.getInputName(), tmpParsingPosition);
                }
                ms.setConfiguration(configStr);
                continue;
            }
            String tmpStr = preposStr;
            if (!tmpStr.equals(preposStr = this.parseModifications(preposStr, ms))) continue;
            if (preposStr.length() > 2) {
                subtype2 = null;
                subtype2 = this.getTemplateContainer().getBasetypeTemplateContainer().getBasetypeTemplateByName(preposStr.substring(0, 3));
                if (subtype2 != null) {
                    subStereo = Stereocode.absoluteToRelative(subtype2.getStereocode());
                    ms.setStereoStr(String.valueOf(subStereo) + ms.getStereoStr());
                    preposStr = preposStr.substring(3);
                    this.increaseParsingPosition(3);
                    continue;
                }
            }
            throw new NameParsingException("Cannot parse " + preposStr, this.getInputName(), this.getParsingPosition());
        }
    }

    private void parsePostposStr(String postposStr, Monosaccharide ms) throws ResourcesDbException {
        if (postposStr.startsWith("-")) {
            postposStr = postposStr.substring(1);
            this.increaseParsingPosition(1);
        }
        if (postposStr.toLowerCase().matches("^[0-9]+(,[0-9])*(-)?(di|tri|tetra){0,1}(-)?ulo(.*)")) {
            postposStr = this.parseModifications(postposStr, ms);
        }
        if (postposStr.toLowerCase().startsWith("p")) {
            this.detectedRingtype = Ringtype.PYRANOSE;
            postposStr = postposStr.substring(1);
            this.increaseParsingPosition(1);
        } else if (postposStr.toLowerCase().startsWith("f")) {
            this.detectedRingtype = Ringtype.FURANOSE;
            postposStr = postposStr.substring(1);
            this.increaseParsingPosition(1);
        }
        while (postposStr.length() > 0) {
            String tmpStr;
            if (postposStr.startsWith("-")) {
                postposStr = postposStr.substring(1);
                this.increaseParsingPosition(1);
                continue;
            }
            if (postposStr.toLowerCase().startsWith("ol")) {
                ms.setAlditol(true);
                this.detectedRingtype = Ringtype.OPEN;
                postposStr = postposStr.substring(2);
                this.increaseParsingPosition(2);
                continue;
            }
            if (postposStr.toLowerCase().startsWith("onic")) {
                ms.setAldonic();
                postposStr = postposStr.substring(4);
                this.increaseParsingPosition(4);
                continue;
            }
            if (postposStr.toLowerCase().startsWith("aric")) {
                ms.setAldaric();
                postposStr = postposStr.substring(4);
                this.increaseParsingPosition(4);
                continue;
            }
            if (postposStr.toLowerCase().startsWith("a")) {
                boolean matchesSubstitution = false;
                ArrayList<String> substNameList = this.getTemplateContainer().getSubstituentTemplateContainer().getResidueIncludedNameList(this.getNamescheme());
                int i = 0;
                while (i < substNameList.size()) {
                    if (postposStr.toLowerCase().startsWith(substNameList.get(i).toLowerCase())) {
                        matchesSubstitution = true;
                        break;
                    }
                    ++i;
                }
                if (!matchesSubstitution) {
                    ms.setUronic();
                    postposStr = postposStr.substring(1);
                    this.increaseParsingPosition(1);
                    continue;
                }
            }
            if (!(tmpStr = postposStr).equals(postposStr = this.parseModifications(postposStr, ms))) continue;
            throw new NameParsingException("Cannot parse " + postposStr, this.getInputName(), this.getParsingPosition());
        }
    }

    private void processParsedData(Monosaccharide ms) throws ResourcesDbException {
        if (ms.getRingStart() == 0) {
            ms.setRingStart(ms.getDefaultCarbonylPosition());
        }
        if (this.detectedRingtype == null) {
            if (this.useDefaultValues) {
                if (this.getDetectedTrivialname() != null) {
                    ms.setRingEnd(this.getDetectedTrivialname().getDefaultRingend());
                } else if (this.getDetectedBasetype() != null) {
                    ms.setRingEnd(this.getDetectedBasetype().getDefaultRingend());
                }
            }
        } else {
            ms.setRingtype(this.detectedRingtype);
        }
        if (ms.getConfiguration() == null) {
            if (this.isUseDefaultValues() && this.getDetectedBasetype().getDefaultConfiguration() != null) {
                ms.setConfiguration(this.getDetectedBasetype().getDefaultConfiguration());
            } else if (this.isUseDefaultValues() && this.getDetectedSubtype() != null && this.getDetectedSubtype().getDefaultConfiguration() != null) {
                ms.setConfiguration(this.getDetectedSubtype().getDefaultConfiguration());
            } else {
                ms.setConfiguration(StereoConfiguration.Unknown);
            }
        }
        if ((this.getTmpStereocode() == null || this.getTmpStereocode().length() == 0) && this.getDetectedBasetype().isSuperclass().booleanValue()) {
            this.setTmpStereocode(StringUtils.multiplyChar(StereoConfiguration.Unknown.getStereosymbol(), this.getDetectedBasetype().getSize() - 2 - ms.getStereoStr().length()));
        }
        String stereo = ms.getConfiguration().equals((Object)StereoConfiguration.Laevus) ? String.valueOf(Stereocode.changeDLinStereoString(this.getTmpStereocode())) + ms.getStereoStr() : (ms.getConfiguration() == null || ms.getConfiguration().equals((Object)StereoConfiguration.Unknown) ? String.valueOf(Stereocode.absoluteToRelative(this.getTmpStereocode())) + ms.getStereoStr() : String.valueOf(this.getTmpStereocode()) + ms.getStereoStr());
        if (ms.hasCoreModification(CoreModificationTemplate.ACID, 1) && ms.getRingStart() == 1) {
            if (ms.getRingEnd() > 0) {
                throw new MonosaccharideException("Aldonic residue with open chain cannot have ring oxygen " + ms.getRingEnd());
            }
            ms.setRingEnd(-1);
        }
        if (ms.getAnomer() == null) {
            if (ms.isAlditol() || ms.getRingEnd() == -1) {
                ms.setAnomer(Anomer.OPEN_CHAIN);
            } else {
                ms.setAnomer(Anomer.UNKNOWN);
            }
        }
        stereo = String.valueOf(StereoConfiguration.Nonchiral.getStereosymbol()) + stereo + StereoConfiguration.Nonchiral.getStereosymbol();
        if (this.getDetectedBasetype().isSuperclass().booleanValue()) {
            if (this.getDetectedSubtype() != null) {
                stereo = Stereocode.getChiralOnlyStereoString(stereo);
                if ((stereo = Stereocode.expandChiralonlyStereoString(stereo, ms)).length() != ms.getSize()) {
                    throw new MonosaccharideException("Error in stereocode: size is " + stereo.length() + ", ms size is " + ms.getSize());
                }
            }
        } else {
            stereo = Stereocode.markNonchiralPositionsInStereoString(stereo, ms);
        }
        ms.setStereoStr(stereo);
        ms.setAnomerInStereocode();
        ms.setFuzzy(this.isFuzzy());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String parseModifications(String parseStr, Monosaccharide ms) throws ResourcesDbException {
        if (parseStr.startsWith(";")) {
            parseStr = parseStr.substring(1);
            this.increaseParsingPosition(1);
        }
        if (parseStr.startsWith("-")) {
            parseStr = parseStr.substring(1);
            this.increaseParsingPosition(1);
        }
        if (parseStr.length() <= 0) return parseStr;
        int defaultPos = 0;
        ArrayList<Integer> positions = new ArrayList<Integer>();
        ArrayList<Integer> autoPosList = new ArrayList<Integer>();
        String posStr = "";
        boolean foundSubstitution = false;
        boolean foundCoreModification = false;
        while (parseStr.matches("^[0-9].*")) {
            posStr = String.valueOf(posStr) + parseStr.substring(0, 1);
            parseStr = parseStr.substring(1);
            this.increaseParsingPosition(1);
        }
        if (posStr.equals("")) {
            if (parseStr.startsWith("?")) {
                posStr = "0";
                parseStr = parseStr.substring(1);
                this.increaseParsingPosition(1);
            } else if (this.getDetectedTrivialname() != null && this.getDetectedTrivialname().getPrimaryName(this.getNamescheme()).equalsIgnoreCase("neu")) {
                if (ms.countSubstitutions() == 1 && ms.getSubstitution(SubstituentTemplate.AMINOTEMPLATENAME, 5, LinkageType.DEOXY) != null && (parseStr.toLowerCase().matches("^n{0,1}([ag]c)$") || parseStr.toLowerCase().matches("^n{0,1}([ag]c)[0-9](.*)"))) {
                    if (this.isUseDefaultValues()) {
                        defaultPos = 5;
                        posStr = "5";
                    } else {
                        defaultPos = -1;
                        posStr = "0";
                    }
                }
            } else if (ms.countSubstitutions() == 0) {
                defaultPos = 2;
                posStr = "2";
            } else {
                defaultPos = -1;
                posStr = "0";
            }
        }
        if (posStr.equals("")) {
            defaultPos = -1;
            posStr = "0";
        }
        if (defaultPos > 0) {
            autoPosList.add(new Integer(posStr));
        } else {
            positions.add(new Integer(posStr));
        }
        while (parseStr.matches("^,[0-9?].*")) {
            posStr = parseStr.substring(1, 2);
            parseStr = parseStr.substring(2);
            this.increaseParsingPosition(2);
            while (parseStr.matches("^[0-9].*")) {
                posStr = String.valueOf(posStr) + parseStr.substring(0, 1);
                parseStr = parseStr.substring(1);
                this.increaseParsingPosition(1);
            }
            positions.add(new Integer(posStr));
        }
        if (parseStr.startsWith("-")) {
            parseStr = parseStr.substring(1);
            this.increaseParsingPosition(1);
        }
        String modStr = "";
        ArrayList<String> coreModList = CoreModificationTemplate.getCarbbankNamesList();
        int i = 0;
        while (i < coreModList.size()) {
            String coremodName = coreModList.get(i);
            if (coremodName.length() > modStr.length() && parseStr.toLowerCase().startsWith(coremodName)) {
                modStr = coremodName;
                foundCoreModification = true;
            }
            ++i;
        }
        ArrayList<String> substTemplateList = this.getTemplateContainer().getSubstituentTemplateContainer().getResidueIncludedNameList(this.getNamescheme());
        int i2 = 0;
        while (i2 < substTemplateList.size()) {
            String substName = substTemplateList.get(i2).toLowerCase();
            if (substName.length() > modStr.length() && parseStr.toLowerCase().startsWith(substName)) {
                modStr = substName;
                foundSubstitution = true;
            }
            ++i2;
        }
        ArrayList<Object> numberPrefixList = new ArrayList();
        int numberPrefixStrLength = 0;
        if (modStr.length() == 0 && positions.size() + autoPosList.size() > 1) {
            numberPrefixList = NumberPrefix.getPrefixListBySize(positions.size() + autoPosList.size());
            for (NumberPrefix numberPrefix : numberPrefixList) {
                String numberPrefixStr = numberPrefix.getPrefixStr();
                int i3 = 0;
                while (i3 < coreModList.size()) {
                    String coremodName = coreModList.get(i3);
                    if (coremodName.length() > modStr.length() && parseStr.toLowerCase().startsWith(String.valueOf(numberPrefixStr) + coremodName)) {
                        modStr = coremodName;
                        foundCoreModification = true;
                        numberPrefixStrLength = numberPrefixStr.length();
                    }
                    ++i3;
                }
                i3 = 0;
                while (i3 < substTemplateList.size()) {
                    String substName = substTemplateList.get(i3);
                    if (substName.length() > modStr.length() && parseStr.toLowerCase().startsWith(String.valueOf(numberPrefixStr) + substName)) {
                        modStr = substName;
                        foundSubstitution = true;
                        numberPrefixStrLength = numberPrefixStr.length();
                    }
                    ++i3;
                }
                if (modStr.length() > 0) break;
            }
        }
        if (modStr.length() > 0) {
            if (foundCoreModification) {
                int position;
                void var14_21;
                boolean bl = false;
                while (var14_21 < autoPosList.size()) {
                    positions.add(new Integer(0));
                    ++var14_21;
                }
                CoreModificationTemplate modTemplate = CoreModificationTemplate.forCarbbankName(modStr);
                if (modTemplate == null) {
                    throw new ResourcesDbException("Cannot get template for core modification " + modStr + " (carbbank style)");
                }
                if (modTemplate.equals((Object)CoreModificationTemplate.EN)) {
                    modTemplate = CoreModificationTemplate.ENX;
                }
                if (modTemplate.equals((Object)CoreModificationTemplate.EN) || modTemplate.equals((Object)CoreModificationTemplate.ENX) || modTemplate.equals((Object)CoreModificationTemplate.YN)) {
                    int i4 = 0;
                    while (i4 < positions.size()) {
                        position = (Integer)positions.get(i4);
                        CoreModification coreModification = new CoreModification();
                        coreModification.setDivalentModification(modTemplate, position, position + 1);
                        coreModification.setSourceName(modStr);
                        ms.addCoreModification(coreModification);
                        ++i4;
                    }
                } else if (modTemplate.getValence() == 1) {
                    int i5 = 0;
                    while (i5 < positions.size()) {
                        position = (Integer)positions.get(i5);
                        if (this.getNamescheme().equals((Object)GlycanNamescheme.IUPAC) && modTemplate.equals((Object)CoreModificationTemplate.DEOXY)) {
                            ArrayList<Substitution> substList = ms.getSubstitutionsByPosition(position);
                            for (Substitution subst : substList) {
                                if (!subst.getLinkagetype1().equals((Object)LinkageType.DEOXY)) continue;
                            }
                        }
                        if (position > 1 && modTemplate.equals((Object)CoreModificationTemplate.KETO) && ms.getDefaultCarbonylPosition() == 1 && !ms.hasCoreModification(CoreModificationTemplate.KETO, 1)) {
                            ms.setDefaultCarbonylPosition(position);
                        }
                        CoreModification coreModification = new CoreModification();
                        coreModification.setModification(modTemplate, position);
                        coreModification.setSourceName(modStr);
                        ms.addCoreModification(coreModification);
                        ++i5;
                    }
                } else if (modTemplate.getValence() == 2) {
                    if (positions.size() != 2) throw new NameParsingException("Divalent core modification " + modStr + " requires two positions.");
                    CoreModification coreModification = new CoreModification();
                    coreModification.setDivalentModification(modTemplate, (Integer)positions.get(0), (Integer)positions.get(1));
                    coreModification.setSourceName(modStr);
                    ms.addCoreModification(coreModification);
                }
            } else if (foundSubstitution) {
                positions.addAll(autoPosList);
                SubstituentTemplate substituentTemplate = this.getTemplateContainer().getSubstituentTemplateContainer().forResidueIncludedName(this.getNamescheme(), modStr);
                if (substituentTemplate == null) {
                    throw new ResourcesDbException("Cannot get substituent template for substituent name " + modStr + " and namescheme " + this.getNamescheme().getNameStr());
                }
                if (substituentTemplate.getMaxValence() == 1) {
                    LinkageType linktype = substituentTemplate.getLinkageTypeBySubstituentName(this.getNamescheme(), modStr);
                    int i6 = 0;
                    while (i6 < positions.size()) {
                        CoreModification mod;
                        Substitution subst = new Substitution(this.getTemplateContainer());
                        subst.setSourceName(modStr);
                        if (this.getNamescheme().equals((Object)GlycanNamescheme.IUPAC) && LinkageType.DEOXY.equals((Object)linktype) && (mod = ms.getCoreModification(CoreModificationTemplate.DEOXY.getName(), (int)((Integer)positions.get(i6)))) != null) {
                            ms.deleteCoreModification(mod);
                        } else {
                            void var14_26;
                            if (positions.size() == 1 && this.getDetectedBasetype().isTrivialname()) {
                                TrivialnameTemplate trivTemplate = (TrivialnameTemplate)this.getDetectedBasetype();
                                for (Substitution trivSubst : trivTemplate.getSubstitutions()) {
                                    Substitution nSubst;
                                    if (trivSubst.getValence() != 1 || !trivSubst.getPosition1().get(0).equals(positions.get(i6)) || !trivSubst.getName().equals(this.getTemplateContainer().getSubstituentTemplateContainer().forResidueIncludedName(GlycanNamescheme.CARBBANK, "n").getName()) || (nSubst = ms.getSubstitution(trivSubst.getName(), trivSubst.getPosition1().get(0), LinkageType.DEOXY)) == null) continue;
                                    if (var14_26.getDefaultLinkingAtom1().getElement().getPeriodicNumber() == 7) {
                                        nSubst.alterSubstituentTemplate((SubstituentTemplate)var14_26);
                                        Object var14_27 = null;
                                        continue;
                                    }
                                    SubstituentTemplate tmpSubstTmpl = this.getTemplateContainer().getSubstituentTemplateContainer().forName(GlycanNamescheme.CARBBANK, "n" + modStr);
                                    if (tmpSubstTmpl == null || tmpSubstTmpl.getDefaultLinkingAtom1().getElement().getPeriodicNumber() != 7) continue;
                                    nSubst.alterSubstituentTemplate(tmpSubstTmpl);
                                    Object var14_28 = null;
                                }
                            }
                            if (var14_26 != null) {
                                subst.setSubstitution((SubstituentTemplate)var14_26, (Integer)positions.get(i6), linktype);
                                ms.addSubstitution(subst);
                                if (subst.getBondOrder1() == 2.0) {
                                    if (subst.getPosition1().size() == 1 && subst.getPosition1().get(0) != 0) {
                                        ms.addCoreModification(new CoreModification(CoreModificationTemplate.SP2, subst.getPosition1().get(0)));
                                    } else {
                                        System.out.println("Warning: substitution with sp2 hybrid at unknown position.");
                                    }
                                }
                            }
                        }
                        ++i6;
                    }
                } else if (substituentTemplate.getMaxValence() == 2) {
                    Substitution subst = new Substitution();
                    subst.setSourceName(modStr);
                    if (positions.size() == 2) {
                        subst.setDivalentSubstitution(substituentTemplate, (Integer)positions.get(0), (Integer)positions.get(1));
                        ms.addSubstitution(subst);
                    } else {
                        if (substituentTemplate.getMinValence() == 2) {
                            throw new NameParsingException("Only one position given for divalent substituent " + modStr);
                        }
                        for (Integer pos : positions) {
                            subst = new Substitution();
                            subst.setSourceName(modStr);
                            subst.setSubstitution(substituentTemplate, pos);
                            ms.addSubstitution(subst);
                        }
                    }
                }
            }
            parseStr = parseStr.substring(modStr.length() + numberPrefixStrLength);
            this.increaseParsingPosition(modStr.length() + numberPrefixStrLength);
            return parseStr;
        }
        if (defaultPos != 0) return parseStr;
        throw new NameParsingException("Cannot assign modification in " + parseStr, this.getInputName(), this.getParsingPosition());
    }

    public void init() {
        super.init();
        this.setPrePosStr("");
        this.setPostPosStr("");
        this.setDetectedBasetype(null);
        this.setDetectedSubtype(null);
        this.setFuzzy(0);
        this.setUseDefaultValues(false);
        this.detectedRingtype = null;
    }
}

