/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.renderutil;

import java.util.HashMap;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.svggen.DOMGroupManager;
import org.apache.batik.svggen.DOMTreeManager;
import org.apache.batik.svggen.DefaultExtensionHandler;
import org.apache.batik.svggen.DefaultImageHandler;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.Document;

class GroupingSVGGraphics2D
extends SVGGraphics2D {
    private MyDOMTreeManager tm;
    private MyDOMGroupManager gm;
    private HashMap<String, Integer> last_ids = new HashMap();
    private HashMap<Object, Integer> ids = new HashMap();

    public GroupingSVGGraphics2D(Document d, boolean text_as_shapes) {
        super(d, new DefaultImageHandler(), new DefaultExtensionHandler(), text_as_shapes);
        this.tm = new MyDOMTreeManager(this.gc, this.generatorCtx, 3);
        this.setDOMTreeManager(this.tm);
        this.gm = new MyDOMGroupManager(this.gc, this.tm);
        this.setDOMGroupManager(this.gm);
    }

    public void addGroup(String id_class, Object parent, Object rep) {
        int id_p = this.getID(parent);
        int id_r = this.getID(rep);
        this.gm.addGroup(id_class + "-" + id_p + ":" + id_r);
    }

    public void addGroup(String id_class, Object parent, Object rep1, Object rep2) {
        int id_p = this.getID(parent);
        int id_r1 = this.getID(rep1);
        int id_r2 = this.getID(rep2);
        this.gm.addGroup(id_class + "-" + id_p + ":" + id_r1 + "," + id_r2);
    }

    private int getID(Object o) {
        if (o == null) {
            return 0;
        }
        if (this.ids.containsKey(o)) {
            return this.ids.get(o);
        }
        int new_id = this.generateID(o.getClass().getName());
        this.ids.put(o, new_id);
        return new_id;
    }

    private int generateID(String class_name) {
        if (this.last_ids.containsKey(class_name)) {
            int last_id = this.last_ids.get(class_name);
            this.last_ids.put(class_name, last_id + 1);
            return last_id + 1;
        }
        this.last_ids.put(class_name, 1);
        return 1;
    }

    private static class MyDOMTreeManager
    extends DOMTreeManager {
        public MyDOMTreeManager(GraphicContext gc, SVGGeneratorContext generatorContext, int maxGCOverrides) {
            super(gc, generatorContext, maxGCOverrides);
        }

        public Document getDOMFactory() {
            return this.generatorContext.getDOMFactory();
        }
    }

    private static class MyDOMGroupManager
    extends DOMGroupManager {
        private MyDOMTreeManager tm;

        public MyDOMGroupManager(GraphicContext gc, MyDOMTreeManager domTreeManager) {
            super(gc, domTreeManager);
            this.tm = domTreeManager;
        }

        public void addGroup(String id) {
            this.currentGroup = this.tm.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "g");
            this.currentGroup.setAttribute("ID", id);
        }
    }
}

