/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.renderutil;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.LinkedList;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueStyle;
import org.eurocarbdb.application.glycanbuilder.ResidueStyleDictionary;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.linkage.Linkage;
import org.eurocarbdb.application.glycanbuilder.renderutil.Geometry;
import org.eurocarbdb.application.glycanbuilder.renderutil.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.renderutil.Paintable;
import org.eurocarbdb.application.glycanbuilder.renderutil.ResAngle;
import org.eurocarbdb.application.glycanbuilder.renderutil.ResidueRenderer;
import org.eurocarbdb.application.glycanbuilder.util.GraphicOptions;
import org.eurocarbdb.application.glycanbuilder.util.TextUtils;

public abstract class AbstractResidueRenderer
implements ResidueRenderer {
    protected ResidueStyleDictionary theResidueStyleDictionary;
    protected GraphicOptions theGraphicOptions;

    public AbstractResidueRenderer() {
        this.theResidueStyleDictionary = new ResidueStyleDictionary();
        this.theGraphicOptions = new GraphicOptions();
    }

    public AbstractResidueRenderer(GlycanRenderer src) {
        this.theResidueStyleDictionary = src.getResidueStyleDictionary();
        this.theGraphicOptions = src.getGraphicOptions();
    }

    @Override
    public GraphicOptions getGraphicOptions() {
        return this.theGraphicOptions;
    }

    @Override
    public void setGraphicOptions(GraphicOptions opt) {
        this.theGraphicOptions = opt;
    }

    @Override
    public ResidueStyleDictionary getResidueStyleDictionary() {
        return this.theResidueStyleDictionary;
    }

    @Override
    public void setResidueStyleDictionary(ResidueStyleDictionary residueStyleDictionary) {
        this.theResidueStyleDictionary = residueStyleDictionary;
    }

    @Override
    public String getText(Residue node) {
        if (node == null) {
            return "";
        }
        ResidueType type = node.getType();
        ResidueStyle style = this.theResidueStyleDictionary.getStyle(node);
        String text = style.getText();
        if (type.getSuperclass().equals("Bridge") && text != null && text.equals("SH")) {
            text = "S";
        }
        return text != null ? text : type.getResidueName();
    }

    @Override
    public String getText(Residue node, boolean on_border) {
        if (node == null) {
            return "";
        }
        if (on_border && node.isSpecial() && !node.isLCleavage()) {
            return "*";
        }
        String text = null;
        text = on_border && node.isLCleavage() ? this.getText(node.getCleavedResidue()) : this.getText(node);
        if (on_border && this.theGraphicOptions.SHOW_INFO) {
            text = node.getParentLinkage().getParentPositionsString() + text;
        }
        if (node.hasParent()) {
            text = this.createProbability(node.getParentLinkage()) + text;
        }
        if (on_border && node.isLCleavage()) {
            text = "(" + text + ")";
        }
        return text;
    }

    @Override
    public Rectangle computeBoundingBox(Residue node, boolean on_border, int x, int y, ResAngle orientation, int node_size, int max_y_size) {
        Dimension dim;
        ResidueStyle style = this.theResidueStyleDictionary.getStyle(node);
        if (this.theGraphicOptions.NOTATION.equals("snfg") && style.getShape() == null && node.isSaccharide() && !node.getType().getSuperclass().equals("Bridge")) {
            style = ResidueStyle.assignedSNFG(node);
        }
        String shape = style.getShape();
        if (max_y_size < node_size) {
            node_size = max_y_size;
        }
        if (shape == null || on_border) {
            String text = this.getText(node, on_border);
            int font_size = this.theGraphicOptions.NODE_FONT_SIZE;
            int x_size = Geometry.textBounds((String)text, (String)this.theGraphicOptions.NODE_FONT_FACE, (int)font_size).width;
            dim = x_size > node_size ? new Dimension(x_size, node_size) : new Dimension(node_size, node_size);
            orientation = this.theGraphicOptions.getOrientationAngle();
        } else if (shape.equals("startrep") || shape.equals("endrep")) {
            int size = Math.min(node_size * 2, max_y_size);
            int font_size = this.theGraphicOptions.LINKAGE_INFO_SIZE;
            dim = new Dimension(size / 2, size + 2 * font_size);
        } else {
            dim = shape.equals("point") ? new Dimension(1, 1) : new Dimension(node_size, node_size);
        }
        if (orientation.equals(0) || orientation.equals(180)) {
            return new Rectangle(x, y, dim.width, dim.height);
        }
        return new Rectangle(x, y, dim.height, dim.width);
    }

    protected static int sat(int v, int t) {
        if (v > t) {
            return t;
        }
        return v;
    }

    protected static int sig(int v) {
        return 128 + v / 2;
    }

    @Override
    public void paint(Paintable paintable, Residue node, boolean selected, boolean on_border, Rectangle par_bbox, Rectangle cur_bbox, Rectangle sup_bbox, ResAngle orientation) {
        this.paint(paintable, node, selected, true, on_border, par_bbox, cur_bbox, sup_bbox, orientation);
    }

    @Override
    public abstract void paint(Paintable var1, Residue var2, boolean var3, boolean var4, boolean var5, Rectangle var6, Rectangle var7, Rectangle var8, ResAngle var9);

    private static Polygon createDiamond(double x, double y, double w, double h) {
        if (w % 2.0 == 1.0) {
            w += 1.0;
        }
        if (h % 2.0 == 1.0) {
            h += 1.0;
        }
        Polygon p = new Polygon();
        p.addPoint((int)(x + w / 2.0), (int)y);
        p.addPoint((int)(x + w), (int)(y + h / 2.0));
        p.addPoint((int)(x + w / 2.0), (int)(y + h));
        p.addPoint((int)x, (int)(y + h / 2.0));
        return p;
    }

    private static Shape createHatDiamond(double angle, double x, double y, double w, double h) {
        GeneralPath f = new GeneralPath();
        f.append(AbstractResidueRenderer.createDiamond(x, y, w, h), false);
        Polygon p = new Polygon();
        p.addPoint((int)(x - 2.0), (int)(y + h / 2.0 - 2.0));
        p.addPoint((int)(x + w / 2.0 - 2.0), (int)(y - 2.0));
        f.append(p, false);
        return f;
    }

    private static Shape createRHatDiamond(double angle, double x, double y, double w, double h) {
        GeneralPath f = new GeneralPath();
        f.append(AbstractResidueRenderer.createDiamond(x, y, w, h), false);
        Polygon p = new Polygon();
        p.addPoint((int)(x + w + 2.0), (int)(y + h / 2.0 - 2.0));
        p.addPoint((int)(x + w / 2.0 + 2.0), (int)(y - 2.0));
        f.append(p, false);
        return f;
    }

    private static Polygon createRhombus(double x, double y, double w, double h) {
        Polygon p = new Polygon();
        p.addPoint((int)(x + 0.5 * w), (int)y);
        p.addPoint((int)(x + 0.85 * w), (int)(y + 0.5 * h));
        p.addPoint((int)(x + 0.5 * w), (int)(y + h));
        p.addPoint((int)(x + 0.15 * w), (int)(y + 0.5 * h));
        return p;
    }

    private static Polygon createTriangle(double angle, double x, double y, double w, double h) {
        Polygon p = new Polygon();
        if (angle >= -0.7853981633974483 && angle <= 0.7853981633974483) {
            p.addPoint((int)(x + w), (int)(y + h / 2.0));
            p.addPoint((int)x, (int)(y + h));
            p.addPoint((int)x, (int)y);
        } else if (angle >= 0.7853981633974483 && angle <= 2.356194490192345) {
            p.addPoint((int)(x + w / 2.0), (int)(y + h));
            p.addPoint((int)x, (int)y);
            p.addPoint((int)(x + w), (int)y);
        } else if (angle >= -2.356194490192345 && angle <= -0.7853981633974483) {
            p.addPoint((int)(x + w / 2.0), (int)y);
            p.addPoint((int)(x + w), (int)(y + h));
            p.addPoint((int)x, (int)(y + h));
        } else {
            p.addPoint((int)x, (int)(y + h / 2.0));
            p.addPoint((int)(x + w), (int)(y + h));
            p.addPoint((int)(x + w), (int)y);
        }
        return p;
    }

    private static Polygon createTopTriangle(int angle, double x, double y, double w, double h) {
        Polygon p = new Polygon();
        if (angle == 0) {
            p.addPoint((int)(x + w / 2.0), (int)y);
            p.addPoint((int)(x + w), (int)(y + h));
            p.addPoint((int)x, (int)(y + h));
        }
        if (angle == 1) {
            p.addPoint((int)(x + w), (int)(y + h / 2.0));
            p.addPoint((int)x, (int)(y + h));
            p.addPoint((int)x, (int)y);
        }
        if (angle == 2) {
            p.addPoint((int)(x + w / 2.0), (int)(y + h));
            p.addPoint((int)x, (int)y);
            p.addPoint((int)(x + w), (int)y);
        }
        if (angle == 3) {
            p.addPoint((int)x, (int)(y + h / 2.0));
            p.addPoint((int)(x + w), (int)(y + h));
            p.addPoint((int)(x + w), (int)y);
        }
        return p;
    }

    private static Polygon createStar(double x, double y, double w, double h, int points) {
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double step = Math.PI / (double)points;
        double nstep = 1.5707963267948966 - 2.0 * step;
        double mrx = rx / (Math.cos(step) + Math.sin(step) / Math.tan(nstep));
        double mry = ry / (Math.cos(step) + Math.sin(step) / Math.tan(nstep));
        Polygon p = new Polygon();
        for (int i = 0; i <= 2 * points; ++i) {
            if (i % 2 == 0) {
                p.addPoint((int)(cx + rx * Math.cos((double)i * step - 1.5707963267948966)), (int)(cy + ry * Math.sin((double)i * step - 1.5707963267948966)));
                continue;
            }
            p.addPoint((int)(cx + mrx * Math.cos((double)i * step - 1.5707963267948966)), (int)(cy + mry * Math.sin((double)i * step - 1.5707963267948966)));
        }
        return p;
    }

    private static Polygon createPentagon(double x, double y, double w, double h) {
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double step = 1.2566370614359172;
        Polygon p = new Polygon();
        for (int i = 0; i <= 5; ++i) {
            p.addPoint((int)(cx + rx * Math.cos((double)i * step - 1.5707963267948966)), (int)(cy + ry * Math.sin((double)i * step - 1.5707963267948966)));
        }
        return p;
    }

    private static Polygon createHexagon(double x, double y, double w, double h) {
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double step = 1.0471975511965976;
        Polygon p = new Polygon();
        for (int i = 0; i <= 6; ++i) {
            p.addPoint((int)(cx + rx * Math.cos((double)i * step)), (int)(cy + ry * Math.sin((double)i * step)));
        }
        return p;
    }

    private static Polygon createFlatHexagon(double x, double y, double w, double h) {
        double rx = w / 2.0;
        double ry = h / 2.5;
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double step = 1.0471975511965976;
        Polygon p = new Polygon();
        for (int i = 0; i <= 6; ++i) {
            p.addPoint((int)(cx + rx * Math.cos((double)i * step)), (int)(cy + ry * Math.sin((double)i * step)));
        }
        return p;
    }

    private static Polygon createHeptagon(double x, double y, double w, double h) {
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double step = 0.8975979010256552;
        Polygon p = new Polygon();
        for (int i = 0; i <= 7; ++i) {
            p.addPoint((int)(cx + rx * Math.cos((double)i * step - 1.5707963267948966)), (int)(cy + ry * Math.sin((double)i * step - 1.5707963267948966)));
        }
        return p;
    }

    private static Shape createLine(double angle, double x, double y, double w, double h) {
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        Polygon p = new Polygon();
        double x1 = cx + rx * Math.cos(angle - 1.5707963267948966);
        double y1 = cy + ry * Math.sin(angle - 1.5707963267948966);
        p.addPoint((int)x1, (int)y1);
        double x2 = cx + rx * Math.cos(angle + 1.5707963267948966);
        double y2 = cy + ry * Math.sin(angle + 1.5707963267948966);
        p.addPoint((int)x2, (int)y2);
        return p;
    }

    private static Shape createCleavage(double angle, double x, double y, double w, double h, boolean has_oxygen) {
        GeneralPath f = new GeneralPath();
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double x1 = cx + rx * Math.cos(angle + 1.5707963267948966);
        double y1 = cy + ry * Math.sin(angle + 1.5707963267948966);
        double x2 = cx + rx * Math.cos(angle - 1.5707963267948966);
        double y2 = cy + ry * Math.sin(angle - 1.5707963267948966);
        double x3 = x2 + rx * Math.cos(angle);
        double y3 = y2 + ry * Math.sin(angle);
        Polygon p = new Polygon();
        p.addPoint((int)x1, (int)y1);
        p.addPoint((int)x2, (int)y2);
        p.addPoint((int)x3, (int)y3);
        p.addPoint((int)x2, (int)y2);
        f.append(p, false);
        if (has_oxygen) {
            double ox = cx + rx * Math.cos(angle);
            double oy = cy + ry * Math.sin(angle);
            Ellipse2D.Double o = new Ellipse2D.Double(ox - rx / 3.0, oy - ry / 3.0, rx / 1.5, ry / 1.5);
            f.append(o, false);
        }
        return f;
    }

    private static Shape createCrossRingCleavage(double angle, double x, double y, double w, double h, int first_pos, int last_pos) {
        GeneralPath c = new GeneralPath();
        c.append(AbstractResidueRenderer.createHexagon(x + 1.0, y + 1.0, w - 2.0, h - 2.0), false);
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        Polygon p1 = new Polygon();
        p1.addPoint((int)cx, (int)cy);
        p1.addPoint((int)(cx + 1.2 * rx * Math.cos(angle + (double)first_pos * Math.PI / 3.0 - 0.5235987755982988)), (int)(cy + 1.2 * ry * Math.sin(angle + (double)first_pos * Math.PI / 3.0 - 0.5235987755982988)));
        c.append(p1, false);
        Polygon p2 = new Polygon();
        p2.addPoint((int)cx, (int)cy);
        p2.addPoint((int)(cx + 1.2 * rx * Math.cos(angle + (double)last_pos * Math.PI / 3.0 - 0.5235987755982988)), (int)(cy + 1.2 * ry * Math.sin(angle + (double)last_pos * Math.PI / 3.0 - 0.5235987755982988)));
        c.append(p2, false);
        return c;
    }

    private static Shape createEnd(double angle, double x, double y, double w, double h) {
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double x1 = cx + rx * Math.cos(angle - 1.5707963267948966);
        double y1 = cy + ry * Math.sin(angle - 1.5707963267948966);
        double x2 = cx + rx * Math.cos(angle + 1.5707963267948966);
        double y2 = cy + ry * Math.sin(angle + 1.5707963267948966);
        double cx1 = cx + 0.5 * rx * Math.cos(angle - 1.5707963267948966);
        double cy1 = cy + 0.5 * ry * Math.sin(angle - 1.5707963267948966);
        double tx1 = cx1 + 0.5 * rx * Math.cos(angle - Math.PI);
        double ty1 = cy1 + 0.5 * ry * Math.sin(angle - Math.PI);
        double cx2 = cx + 0.5 * rx * Math.cos(angle + 1.5707963267948966);
        double cy2 = cy + 0.5 * ry * Math.sin(angle + 1.5707963267948966);
        double tx2 = cx2 + 0.5 * rx * Math.cos(angle);
        double ty2 = cy2 + 0.5 * ry * Math.sin(angle);
        return new CubicCurve2D.Double(x1, y1, tx1, ty1, tx2, ty2, x2, y2);
    }

    private static Polygon createBracket(double angle, double x, double y, double w, double h) {
        double y4;
        double x4;
        double y1;
        double x1;
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        Polygon p = new Polygon();
        double xygap = 10.0;
        if (angle == Math.PI) {
            x1 = cx + rx * Math.cos(angle - 1.5707963267948966) - rx * Math.cos(angle) - xygap;
            y1 = cy + ry * Math.sin(angle - 1.5707963267948966) + ry * Math.sin(angle);
        } else if (angle == 0.0) {
            x1 = cx + rx * Math.cos(angle - 1.5707963267948966) - rx * Math.cos(angle) + xygap;
            y1 = cy + ry * Math.sin(angle - 1.5707963267948966) + ry * Math.sin(angle);
        } else if (angle == 1.5707963267948966) {
            x1 = cx + rx * Math.cos(angle - 1.5707963267948966) + rx * Math.cos(angle);
            y1 = cy + ry * Math.sin(angle - 1.5707963267948966) - ry * Math.sin(angle) + xygap;
        } else {
            x1 = cx + rx * Math.cos(angle - 1.5707963267948966) + rx * Math.cos(angle);
            y1 = cy + ry * Math.sin(angle - 1.5707963267948966) - ry * Math.sin(angle) - xygap;
        }
        p.addPoint((int)x1, (int)y1);
        double x2 = cx + rx * Math.cos(angle - 1.5707963267948966);
        double y2 = cy + ry * Math.sin(angle - 1.5707963267948966);
        x2 = angle == Math.PI ? x2 - xygap : x2;
        double d = x2 = angle == 0.0 ? x2 + xygap : x2;
        if (angle != Math.PI && angle != 0.0) {
            y2 = angle == 1.5707963267948966 ? (y2 += xygap) : (y2 -= xygap);
        }
        p.addPoint((int)x2, (int)y2);
        double x3 = cx + rx * Math.cos(angle + 1.5707963267948966);
        double y3 = cy + ry * Math.sin(angle + 1.5707963267948966);
        x3 = angle == Math.PI ? x3 - xygap : x3;
        double d2 = x3 = angle == 0.0 ? x3 + xygap : x3;
        if (angle != Math.PI && angle != 0.0) {
            y3 = angle == 1.5707963267948966 ? (y3 += xygap) : (y3 -= xygap);
        }
        p.addPoint((int)x3, (int)y3);
        if (angle == Math.PI) {
            x4 = cx + rx * Math.cos(angle + 1.5707963267948966) - rx * Math.cos(angle) - xygap;
            y4 = cy + ry * Math.sin(angle + 1.5707963267948966) + ry * Math.sin(angle);
        } else if (angle == 0.0) {
            x4 = cx + rx * Math.cos(angle + 1.5707963267948966) - rx * Math.cos(angle) + xygap;
            y4 = cy + ry * Math.sin(angle + 1.5707963267948966) + ry * Math.sin(angle);
        } else if (angle == 1.5707963267948966) {
            x4 = cx + rx * Math.cos(angle + 1.5707963267948966) - rx * Math.cos(angle);
            y4 = cy + ry * Math.sin(angle + 1.5707963267948966) - ry * Math.sin(angle) + xygap;
        } else {
            x4 = cx + rx * Math.cos(angle + 1.5707963267948966) + rx * Math.cos(angle);
            y4 = cy + ry * Math.sin(angle + 1.5707963267948966) - ry * Math.sin(angle) - xygap;
        }
        p.addPoint((int)x4, (int)y4);
        p.addPoint((int)x3, (int)y3);
        p.addPoint((int)x2, (int)y2);
        return p;
    }

    private Shape createRepetition(double angle, double x, double y, double w, double h) {
        double r = Math.min(w, h);
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        Polygon p = new Polygon();
        double x1 = cx + r * Math.cos(angle - 1.5707963267948966) + r / 4.0 * Math.cos(angle + Math.PI);
        double y1 = cy + r * Math.sin(angle - 1.5707963267948966) + r / 4.0 * Math.sin(angle + Math.PI);
        p.addPoint((int)x1, (int)y1);
        double x2 = cx + r * Math.cos(angle - 1.5707963267948966);
        double y2 = cy + r * Math.sin(angle - 1.5707963267948966);
        p.addPoint((int)x2, (int)y2);
        double x3 = cx + r * Math.cos(angle + 1.5707963267948966);
        double y3 = cy + r * Math.sin(angle + 1.5707963267948966);
        p.addPoint((int)x3, (int)y3);
        double x4 = cx + r * Math.cos(angle + 1.5707963267948966) + r / 4.0 * Math.cos(angle + Math.PI);
        double y4 = cy + r * Math.sin(angle + 1.5707963267948966) + r / 4.0 * Math.sin(angle + Math.PI);
        p.addPoint((int)x4, (int)y4);
        p.addPoint((int)x3, (int)y3);
        p.addPoint((int)x2, (int)y2);
        return p;
    }

    protected Shape createCyclic(ResAngle a_oAngle, double x, double y, double w, double h) {
        double a_dXpoint = x;
        double a_dCtrlX = 0.0;
        double a_dCtrlY = 0.0;
        QuadCurve2D.Double s1 = null;
        if (a_oAngle.getIntAngle() == 0) {
            a_dCtrlX = a_dXpoint + w;
            a_dCtrlY = (y - h * 0.5 + y + h * 1.5) * 0.5;
            s1 = new QuadCurve2D.Double(a_dXpoint, y - h * 0.5, a_dCtrlX, a_dCtrlY, a_dXpoint, y + h * 1.5);
        }
        if (a_oAngle.getIntAngle() == 180) {
            a_dCtrlX = a_dXpoint;
            a_dCtrlY = (y - h * 0.5 + y + h * 1.5) * 0.5;
            s1 = new QuadCurve2D.Double(a_dXpoint += w, y - h * 0.5, a_dCtrlX, a_dCtrlY, a_dXpoint, y + h * 1.5);
        }
        if (a_oAngle.getIntAngle() == 90) {
            a_dCtrlX = (a_dXpoint * 2.0 + 23.0) * 0.5;
            a_dCtrlY = y + h;
            s1 = new QuadCurve2D.Double(a_dXpoint + 34.0, y, a_dCtrlX, a_dCtrlY, a_dXpoint - 11.0, y);
        }
        if (a_oAngle.getIntAngle() == -90) {
            a_dCtrlX = (a_dXpoint * 2.0 + 23.0) * 0.5;
            a_dCtrlY = y;
            s1 = new QuadCurve2D.Double(a_dXpoint + 34.0, y + h, a_dCtrlX, a_dCtrlY, a_dXpoint - 11.0, y + h);
        }
        return s1;
    }

    private static Polygon createFlatDiamond(double x, double y, double w, double h) {
        if (w % 2.0 == 1.0) {
            w += 1.0;
        }
        if (h % 2.0 == 1.0) {
            h += 1.0;
        }
        Polygon p = new Polygon();
        p.addPoint((int)(x + w / 2.0), (int)y);
        p.addPoint((int)(x + w), (int)(y + h / 2.0));
        p.addPoint((int)(x + w / 2.0), (int)(y + h));
        p.addPoint((int)x, (int)(y + h / 2.0));
        return p;
    }

    protected Shape createShape(Residue node, Rectangle par_bbox, Rectangle cur_bbox, Rectangle sup_bbox, ResAngle orientation, ResidueStyle style) {
        Point ps;
        String shape = style.getShape();
        if (shape == null || shape.equals("none") || shape.equals("-")) {
            return null;
        }
        double x = cur_bbox.getX();
        double y = cur_bbox.getY();
        double w = cur_bbox.getWidth();
        double h = cur_bbox.getHeight();
        if (shape.equals("point")) {
            return new Rectangle2D.Double(x + w / 2.0, y + h / 2.0, 0.0, 0.0);
        }
        if (shape.equals("square")) {
            return new Rectangle2D.Double(x, y, w, h);
        }
        if (shape.equals("circle")) {
            return new Ellipse2D.Double(x, y, w, h);
        }
        if (shape.equals("diamond")) {
            return AbstractResidueRenderer.createDiamond(x, y, w, h);
        }
        if (shape.equals("rhombus")) {
            return AbstractResidueRenderer.createRhombus(x, y, w, h);
        }
        if (shape.equals("star")) {
            return AbstractResidueRenderer.createStar(x, y, w, h, 5);
        }
        if (shape.equals("sixstar")) {
            return AbstractResidueRenderer.createStar(x, y, w, h, 6);
        }
        if (shape.equals("sevenstar")) {
            return AbstractResidueRenderer.createStar(x, y, w, h, 7);
        }
        if (shape.equals("pentagon")) {
            return AbstractResidueRenderer.createPentagon(x, y, w, h);
        }
        if (shape.equals("hexagon")) {
            return AbstractResidueRenderer.createHexagon(x, y, w, h);
        }
        if (shape.equals("flathexagon")) {
            return AbstractResidueRenderer.createFlatHexagon(x, y, w, h);
        }
        if (shape.equals("heptagon")) {
            return AbstractResidueRenderer.createHeptagon(x, y, w, h);
        }
        if (shape.equals("flatsquare")) {
            return new Rectangle2D.Double(x, y + h * 0.25, w, h * 0.5);
        }
        if (shape.equals("flatdiamond")) {
            return AbstractResidueRenderer.createFlatDiamond(x, y + h * 0.25, w, h * 0.5);
        }
        Point pp = par_bbox != null ? Geometry.center(par_bbox) : Geometry.center(cur_bbox);
        Point pc = Geometry.center(cur_bbox);
        Point point = ps = sup_bbox != null ? Geometry.center(sup_bbox) : Geometry.center(cur_bbox);
        if (shape.equals("triangle")) {
            if (this.theGraphicOptions.NOTATION.equals("snfg")) {
                if (node.getWasSticky()) {
                    if (orientation.getIntAngle() == 180) {
                        return AbstractResidueRenderer.createTopTriangle(this.theGraphicOptions.ORIENTATION, x, y, w, h);
                    }
                    return AbstractResidueRenderer.createTriangle(Geometry.angle(pp, ps), x, y, w, h);
                }
                return AbstractResidueRenderer.createTopTriangle(this.theGraphicOptions.ORIENTATION, x, y, w, h);
            }
            return AbstractResidueRenderer.createTriangle(Geometry.angle(pp, ps), x, y, w, h);
        }
        if (shape.equals("hatdiamond")) {
            return AbstractResidueRenderer.createHatDiamond(Geometry.angle(pp, ps), x, y, w, h);
        }
        if (shape.equals("rhatdiamond")) {
            return AbstractResidueRenderer.createRHatDiamond(Geometry.angle(pp, ps), x, y, w, h);
        }
        if (shape.equals("bracket")) {
            return AbstractResidueRenderer.createBracket(orientation.getAngle(), x, y, w, h);
        }
        if (shape.equals("startrep")) {
            return this.createRepetition(orientation.opposite().getAngle(), x, y, w, h);
        }
        if (shape.equals("endrep")) {
            return this.createRepetition(orientation.getAngle(), x, y, w, h);
        }
        if (shape.equals("startcyclic")) {
            return this.createCyclic(orientation, x, y, w, h);
        }
        if (shape.equals("endcyclic")) {
            return this.createCyclic(orientation.opposite(), x, y, w, h);
        }
        if (shape.equals("startalt")) {
            return AbstractResidueRenderer.createBracket(orientation.getAngle(), x, y, w, h);
        }
        if (shape.equals("endalt")) {
            return AbstractResidueRenderer.createBracket(orientation.opposite().getAngle(), x, y, w, h);
        }
        if (shape.startsWith("acleavage")) {
            LinkedList<String> tokens = TextUtils.tokenize(shape, "_");
            int first_pos = Integer.parseInt(tokens.get(1));
            int last_pos = Integer.parseInt(tokens.get(2));
            return AbstractResidueRenderer.createCrossRingCleavage(Geometry.angle(pc, ps), x, y, w, h, first_pos, last_pos);
        }
        if (shape.equals("bcleavage")) {
            return AbstractResidueRenderer.createCleavage(Geometry.angle(ps, pc), x, y, w, h, false);
        }
        if (shape.equals("ccleavage")) {
            return AbstractResidueRenderer.createCleavage(Geometry.angle(ps, pc), x, y, w, h, true);
        }
        if (shape.startsWith("xcleavage")) {
            LinkedList<String> tokens = TextUtils.tokenize(shape, "_");
            int first_pos = Integer.parseInt(tokens.get(1));
            int last_pos = Integer.parseInt(tokens.get(2));
            return AbstractResidueRenderer.createCrossRingCleavage(Geometry.angle(pp, pc), x, y, w, h, first_pos, last_pos);
        }
        if (shape.equals("ycleavage")) {
            return AbstractResidueRenderer.createCleavage(Geometry.angle(pp, pc), x, y, w, h, true);
        }
        if (shape.equals("zcleavage")) {
            return AbstractResidueRenderer.createCleavage(Geometry.angle(pp, pc), x, y, w, h, false);
        }
        if (shape.equals("end")) {
            return AbstractResidueRenderer.createEnd(Geometry.angle(pp, ps), x, y, w, h);
        }
        return cur_bbox;
    }

    private Shape createRepetitionText(double angle, double x, double y, double w, double h, int min, int max) {
        double dist;
        Dimension tb;
        String text;
        double r = Math.min(w, h);
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double x2 = cx + r * Math.cos(angle - 1.5707963267948966);
        double y2 = cy + r * Math.sin(angle - 1.5707963267948966);
        double x3 = cx + r * Math.cos(angle + 1.5707963267948966);
        double y3 = cy + r * Math.sin(angle + 1.5707963267948966);
        GeneralPath ret = new GeneralPath();
        if (min == max && min != -1 && max != -1) {
            min = -1;
        }
        if (min >= 0 || max >= 0 || min == -1 && max == -1) {
            double ymin;
            double xmin;
            text = min >= 0 ? "" + min : "n";
            tb = Geometry.textBounds(text, this.theGraphicOptions.LINKAGE_INFO_FONT_FACE, this.theGraphicOptions.LINKAGE_INFO_SIZE);
            double d = dist = Geometry.isUp(angle) || Geometry.isDown(angle) ? (double)(tb.width / 2 + 4) : (double)(tb.height / 2 + 4);
            if (Geometry.isLeft(angle) || Geometry.isUp(angle)) {
                xmin = x2 + dist * Math.cos(angle - 1.5707963267948966) - (double)tb.width / 2.0;
                ymin = y2 + dist * Math.sin(angle - 1.5707963267948966) + (double)tb.height / 2.0;
            } else {
                xmin = x3 + dist * Math.cos(angle + 1.5707963267948966) - (double)tb.width / 2.0;
                ymin = y3 + dist * Math.sin(angle + 1.5707963267948966) + (double)tb.height / 2.0;
            }
            ret.append(Geometry.getTextShape(xmin, ymin, text, this.theGraphicOptions.LINKAGE_INFO_FONT_FACE, this.theGraphicOptions.LINKAGE_INFO_SIZE), false);
        }
        if (min >= 0 || max >= 0) {
            double ymax;
            double xmax;
            text = max >= 0 ? "" + max : "n";
            tb = Geometry.textBounds(text, this.theGraphicOptions.LINKAGE_INFO_FONT_FACE, this.theGraphicOptions.LINKAGE_INFO_SIZE);
            double d = dist = Geometry.isUp(angle) || Geometry.isDown(angle) ? (double)(tb.width / 2 + 4) : (double)(tb.height / 2 + 4);
            if (Geometry.isLeft(angle) || Geometry.isUp(angle)) {
                xmax = x3 + dist * Math.cos(angle + 1.5707963267948966) - (double)tb.width / 2.0;
                ymax = y3 + dist * Math.sin(angle + 1.5707963267948966) + (double)tb.height / 2.0;
            } else {
                xmax = x2 + dist * Math.cos(angle - 1.5707963267948966) - (double)tb.width / 2.0;
                ymax = y2 + dist * Math.sin(angle - 1.5707963267948966) + (double)tb.height / 2.0;
            }
            ret.append(Geometry.getTextShape(xmax, ymax, text, this.theGraphicOptions.LINKAGE_INFO_FONT_FACE, this.theGraphicOptions.LINKAGE_INFO_SIZE), false);
        }
        return ret;
    }

    protected Shape createTextShape(Residue node, Rectangle par_bbox, Rectangle cur_bbox, Rectangle sup_bbox, ResAngle orientation, ResidueStyle style) {
        String shape = style.getShape();
        if (shape == null || shape.equals("none") || shape.equals("-")) {
            return null;
        }
        double x = cur_bbox.getX();
        double y = cur_bbox.getY();
        double w = cur_bbox.getWidth();
        double h = cur_bbox.getHeight();
        if (shape.equals("endrep")) {
            return this.createRepetitionText(orientation.getAngle(), x, y, w, h, node.getMinRepetitions(), node.getMaxRepetitions());
        }
        return null;
    }

    private static Shape createTriangle(double x1, double y1, double x2, double y2, double x3, double y3) {
        Polygon p = new Polygon();
        p.addPoint((int)x1, (int)y1);
        p.addPoint((int)x2, (int)y2);
        p.addPoint((int)x3, (int)y3);
        return p;
    }

    private static Shape createHalf(double rx, double ry, double cx, double cy) {
        double step = 1.2566370614359172;
        Polygon p = new Polygon();
        p.addPoint((int)(cx - 0.5 + rx * Math.cos(5.0 * step - 1.5707963267948966)), (int)(cy + ry * Math.sin(5.0 * step - 1.5707963267948966)));
        p.addPoint((int)(cx - 0.5 + rx * Math.cos(4.0 * step - 1.5707963267948966)), (int)(cy + ry * Math.sin(4.0 * step - 1.5707963267948966)));
        p.addPoint((int)(cx - 0.5 + rx * Math.cos(3.0 * step - 1.5707963267948966)), (int)(cy + ry * Math.sin(3.0 * step - 1.5707963267948966)));
        p.addPoint((int)(cx - 0.5 + rx * Math.cos(2.5 * step - 1.5707963267948966)), (int)(cy + ry * Math.sin(3.0 * step - 1.5707963267948966)));
        return p;
    }

    private static Shape createCheckered(double x, double y, double w, double h) {
        GeneralPath c = new GeneralPath();
        c.append(new Rectangle2D.Double(x + w / 2.0, y, w / 2.0, h / 2.0), false);
        c.append(new Rectangle2D.Double(x, y + h / 2.0, w / 2.0, h / 2.0), false);
        return c;
    }

    private static Shape createArc(double x, double y, double w, double h, int start_pos, int end_pos) {
        return new Arc2D.Double(x - 0.5 * w, y - 0.5 * h, 2.0 * w, 2.0 * h, (double)(-end_pos) * 60.0 + 30.0, (double)(-((start_pos - end_pos + 6) % 6)) * 60.0, 2);
    }

    protected Shape createFillShape(Residue node, Rectangle cur_bbox, ResidueStyle style, ResAngle orientation, double a_dAngle) {
        String fillstyle = style.getFillStyle();
        double x = cur_bbox.x;
        double y = cur_bbox.y;
        double w = cur_bbox.width;
        double h = cur_bbox.height;
        if (node.isStartCyclic() || node.isEndCyclic()) {
            return new Rectangle2D.Double(x, y, 0.0, 0.0);
        }
        if (style.getShape() != null && style.getShape().equals("triangle") && node.getTypeName().contains("NAc")) {
            if (this.theGraphicOptions.ORIENTATION == 0) {
                return new Rectangle2D.Double(x + w / 2.0, y, w / 2.0, h);
            }
            if (this.theGraphicOptions.ORIENTATION == 1) {
                return new Rectangle2D.Double(y, x, w, h / 2.0);
            }
            if (this.theGraphicOptions.ORIENTATION == 2) {
                return new Rectangle2D.Double(x, y, w / 2.0, h);
            }
            if (this.theGraphicOptions.ORIENTATION == 3) {
                return new Rectangle2D.Double(x, y, w, h / 2.0);
            }
        }
        if (fillstyle.equals("empty")) {
            return null;
        }
        if (fillstyle.equals("full")) {
            return cur_bbox;
        }
        if (fillstyle.equals("half")) {
            return AbstractResidueRenderer.createHalf(w / 2.0, h / 2.0, x + w / 2.0, y + h / 2.0);
        }
        if (fillstyle.equals("left")) {
            return new Rectangle2D.Double(x, y, w / 2.0, h);
        }
        if (fillstyle.equals("top")) {
            return new Rectangle2D.Double(x, y, w, h / 2.0);
        }
        if (fillstyle.equals("right")) {
            return new Rectangle2D.Double(x + w / 2.0, y, w / 2.0, h);
        }
        if (fillstyle.equals("bottom")) {
            return new Rectangle2D.Double(x, y + h / 2.0, w, h / 2.0);
        }
        if (fillstyle.equals("topleft")) {
            return AbstractResidueRenderer.createTriangle(x, y, x + w, y, x, y + h);
        }
        if (fillstyle.equals("topright")) {
            return AbstractResidueRenderer.createTriangle(x, y, x + w, y, x + w, y + h);
        }
        if (fillstyle.equals("bottomright")) {
            return AbstractResidueRenderer.createTriangle(x + w, y, x + w, y + h, x, y + h);
        }
        if (fillstyle.equals("bottomleft")) {
            return AbstractResidueRenderer.createTriangle(x, y, x + w, y + h, x, y + h);
        }
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double rx = w / 6.0;
        double ry = h / 6.0;
        if (fillstyle.equals("circle")) {
            return new Ellipse2D.Double(cx - rx, cy - ry, 2.0 * rx, 2.0 * ry);
        }
        if (fillstyle.equals("checkered")) {
            return AbstractResidueRenderer.createCheckered(x, y, w, h);
        }
        if (fillstyle.startsWith("arc")) {
            LinkedList<String> tokens = TextUtils.tokenize(fillstyle, "_");
            int first_pos = Integer.parseInt(tokens.get(1));
            int last_pos = Integer.parseInt(tokens.get(2));
            return AbstractResidueRenderer.createArc(x, y, w, h, first_pos, last_pos);
        }
        return null;
    }

    private String createProbability(Linkage _linkage) {
        StringBuilder probability = new StringBuilder("");
        int high = _linkage.getBonds().get(0).getProbabilityHigh();
        int low = _linkage.getBonds().get(0).getProbabilityLow();
        if (high != 100 && low != 100 && high == low) {
            probability.append("(" + (high == -100 ? "?" : Integer.valueOf(high)) + "%)");
            return probability.toString();
        }
        if (low != 100) {
            probability.append("(");
            probability.append(low == -100 ? "?" : Integer.valueOf(low));
        }
        if (high != 100 || low < 100) {
            if (probability.length() != 0) {
                probability.append(",");
                probability.append(high == -100 ? "?" : Integer.valueOf(high));
            } else {
                probability.append("(");
                probability.append(high == -100 ? "?" : Integer.valueOf(high));
            }
        }
        if (probability.length() > 0) {
            probability.append("%)");
        }
        return probability.toString();
    }

    public ArrayList<String> checkComposiiton(Residue residue) {
        ArrayList<String> confs = new ArrayList<String>();
        if (!this.theGraphicOptions.NOTATION.equals("snfg")) {
            return confs;
        }
        if (!residue.isSaccharide()) {
            return confs;
        }
        ResidueType residueType = residue.getType();
        if (residueType.getName().equals(residue.getTypeName())) {
            if (residue.getRingSize() != '?' && residueType.getRingSize() != '?' && residueType.getRingSize() != residue.getRingSize()) {
                confs.add(String.valueOf(residue.getRingSize()));
            }
            if (residue.getChirality() != '?' && residueType.getChirality() != '?' && residueType.getChirality() != residue.getChirality()) {
                confs.add(String.valueOf(residue.getChirality()));
            }
            if (residueType.getRingSize() == '?' && residue.isAlditol()) {
                confs.add(String.valueOf(residue.getRingSize()));
            }
        }
        return confs;
    }
}

