/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.massutil;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eurocarbdb.application.glycanbuilder.massutil.Atom;
import org.eurocarbdb.application.glycanbuilder.massutil.MassUtils;

public class Molecule {
    private static Pattern mol_pattern = Pattern.compile("([A-Z][a-z]?)([0-9]*)(\\^[0-9]+)?");
    private TreeMap<Atom, Integer> atoms = new TreeMap();
    private double main_mass = 0.0;
    private double avg_mass = 0.0;
    private int charges = 0;

    public Molecule() {
    }

    public Molecule(String init) throws Exception {
        int i;
        if (init.equals("0")) {
            init = "";
        }
        int mul = 1;
        if (init.startsWith("-")) {
            mul = -1;
            init = init.substring(1);
        }
        int cur = 0;
        Matcher m = mol_pattern.matcher(init);
        while (m.find()) {
            String atom_name = m.group(1);
            String atom_number_str = m.group(2);
            String isotope_number_str = m.group(3);
            if (isotope_number_str != null) {
                isotope_number_str = isotope_number_str.substring(1, isotope_number_str.length());
            }
            if (atom_number_str != null && atom_number_str.length() > 0) {
                if (isotope_number_str == null) {
                    this.add(atom_name, mul * Integer.valueOf(atom_number_str));
                } else {
                    this.addIsotope(atom_name, mul * Integer.valueOf(atom_number_str), Integer.valueOf(isotope_number_str));
                }
            } else if (isotope_number_str == null) {
                this.add(atom_name, mul);
            } else {
                this.addIsotope(atom_name, mul, Integer.valueOf(isotope_number_str));
            }
            cur = m.end();
        }
        for (i = cur; i < init.length(); ++i) {
            if (init.charAt(i) == '-') {
                --this.charges;
                continue;
            }
            if (init.charAt(i) != '+') break;
            ++this.charges;
        }
        if (i != init.length()) {
            throw new Exception("Invalid format: " + init);
        }
        if (this.charges != 0) {
            this.main_mass -= (double)this.charges * MassUtils.electron.getMainMass();
            this.avg_mass -= (double)this.charges * MassUtils.electron.getAverageMass();
        }
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Molecule)) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Molecule clone() {
        Molecule ret = new Molecule();
        ret.atoms = (TreeMap)this.atoms.clone();
        ret.main_mass = this.main_mass;
        ret.avg_mass = this.avg_mass;
        ret.charges = this.charges;
        return ret;
    }

    public Collection<Map.Entry<Atom, Integer>> getAtoms() {
        return this.atoms.entrySet();
    }

    public double getMass() {
        return this.main_mass;
    }

    public double getMainMass() {
        return this.main_mass;
    }

    public double getAverageMass() {
        return this.avg_mass;
    }

    public double getMZ() {
        if (this.charges == 0) {
            return this.getMass();
        }
        return this.getMass() / (double)Math.abs(this.charges);
    }

    public int getNoCharges() {
        return this.charges;
    }

    public void addPositiveCharges(int num) {
        this.charges += num;
        this.main_mass -= (double)num * MassUtils.electron.getMainMass();
        this.avg_mass -= (double)num * MassUtils.electron.getAverageMass();
    }

    public void removePositiveCharges(int num) {
        this.addNegativeCharges(num);
    }

    public void addNegativeCharges(int num) {
        this.charges -= num;
        this.main_mass += (double)num * MassUtils.electron.getMainMass();
        this.avg_mass += (double)num * MassUtils.electron.getAverageMass();
    }

    public void removeNegativeCharges(int num) {
        this.addPositiveCharges(num);
    }

    public Molecule and(String atom, int num) throws Exception {
        Molecule ret = this.clone();
        ret.add(atom, num);
        return ret;
    }

    public Molecule and(Atom a) {
        return this.and(a, 1);
    }

    public Molecule and(Atom a, int num) {
        Molecule ret = this.clone();
        ret.add(a, num);
        return ret;
    }

    public Molecule and(Molecule m) {
        return this.and(m, 1);
    }

    public Molecule and(Molecule m, int num) {
        Molecule ret = this.clone();
        ret.add(m, num);
        return ret;
    }

    public void add(String atom) throws Exception {
        this.add(MassUtils.getAtom(atom), 1);
    }

    public void addIsotope(String atom, int isotope) throws Exception {
        this.add(MassUtils.getAtom(atom + "^" + isotope), 1);
    }

    public void add(String atom, int num) throws Exception {
        this.add(MassUtils.getAtom(atom), num);
    }

    public void addIsotope(String atom, int num, int isotope) throws Exception {
        this.add(MassUtils.getAtom(atom + "^" + isotope), num);
    }

    public void add(Atom a) {
        this.add(a, 1);
    }

    public void add(Atom a, int num) {
        Integer cur_num = this.atoms.get(a);
        if (cur_num == null) {
            this.atoms.put(a, num);
        } else {
            this.atoms.put(a, cur_num + num);
        }
        this.main_mass += (double)num * a.getMainMass();
        this.avg_mass += (double)num * a.getAverageMass();
    }

    public void add(Molecule m) {
        this.add(m, 1);
    }

    public void add(Molecule m, int num) {
        if (m != null) {
            for (Map.Entry<Atom, Integer> a : m.atoms.entrySet()) {
                this.add(a.getKey(), num * a.getValue());
            }
            this.addPositiveCharges(num * m.charges);
        }
    }

    public void remove(String atom, int num) throws Exception {
        this.add(atom, -num);
    }

    public void remove(Atom a) {
        this.add(a, -1);
    }

    public void remove(Atom a, int num) {
        this.add(a, -num);
    }

    public void remove(Molecule m) {
        this.add(m, -1);
    }

    public void remove(Molecule m, int num) {
        this.add(m, -num);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Atom, Integer> a : this.atoms.entrySet()) {
            sb.append(a.getKey().toString());
            sb.append(a.getValue().toString());
        }
        for (int i = 0; i < Math.abs(this.charges); ++i) {
            if (this.charges > 0) {
                sb.append('+');
                continue;
            }
            sb.append('-');
        }
        return sb.toString();
    }

    public TreeMap<Atom, Integer> getRawAtomTree() {
        return this.atoms;
    }
}

