/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.massutil;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eurocarbdb.application.glycanbuilder.logutility.LogUtils;
import org.eurocarbdb.application.glycanbuilder.massutil.Atom;
import org.eurocarbdb.application.glycanbuilder.massutil.Isotope;
import org.eurocarbdb.application.glycanbuilder.massutil.Molecule;
import org.eurocarbdb.application.glycanbuilder.util.TextUtils;

public class MassUtils {
    private static HashMap<String, Atom> atoms = new HashMap();
    private static HashMap<Atom, Isotope> atom_main_isotope = new HashMap();
    private static HashMap<Atom, ArrayList<Isotope>> atom_other_isotopes = new HashMap();
    private static HashMap<Atom, ArrayList<Isotope>> atom_all_isotopes = new HashMap();
    public static Atom hydrogen;
    public static Atom electron;
    public static Molecule water;
    public static Molecule methyl;
    public static Molecule heavyMethyl;
    public static Molecule dmethyl;
    public static Molecule acetyl;
    public static Molecule dacetyl;
    public static Molecule h_ion;
    public static Molecule li_ion;
    public static Molecule na_ion;
    public static Molecule k_ion;
    public static Molecule cl_ion;
    public static Molecule h2po4_ion;

    private MassUtils() {
    }

    private static void loadAtoms(String filename) {
        try {
            String line;
            URL file_url = MassUtils.class.getResource(filename);
            if (file_url == null) {
                throw new FileNotFoundException(filename);
            }
            BufferedReader is = new BufferedReader(new InputStreamReader(file_url.openStream()));
            while ((line = is.readLine()) != null) {
                if ((line = TextUtils.trim(line)).length() <= 0 || line.startsWith("%")) continue;
                Atom atom = new Atom(line);
                atoms.put(atom.getSymbol(), atom);
            }
            is.close();
        }
        catch (Exception e) {
            LogUtils.report(e);
            atoms.clear();
        }
    }

    private static void loadIsotopes(String filename) {
        try {
            String line;
            URL file_url = MassUtils.class.getResource(filename);
            if (file_url == null) {
                throw new FileNotFoundException(filename);
            }
            BufferedReader is = new BufferedReader(new InputStreamReader(file_url.openStream()));
            while ((line = is.readLine()) != null) {
                if ((line = TextUtils.trim(line)).length() <= 0 || line.startsWith("%")) continue;
                Isotope isotope = new Isotope(line);
                if (atoms.get(isotope.getAtomSymbol()) == null) {
                    throw new Exception("Invalid atom name: " + isotope.getAtomSymbol());
                }
                if (!isotope.isStable()) continue;
                Atom atom = atoms.get(isotope.getAtomSymbol());
                if (atom_all_isotopes.get(atom) == null) {
                    atom_all_isotopes.put(atom, new ArrayList());
                }
                atom_all_isotopes.get(atom).add(isotope);
                Atom isotopeAtomObj = new Atom(atom.getSymbol() + "^" + isotope.getAtomicNumber() + "\t" + atom.getName() + "(" + isotope.getAtomicNumber() + ")\t" + isotope.getMass() + "\t" + isotope.getMass());
                atoms.put(isotopeAtomObj.getSymbol(), isotopeAtomObj);
            }
            for (Map.Entry<Atom, ArrayList<Isotope>> e : atom_all_isotopes.entrySet()) {
                Atom atom = e.getKey();
                ArrayList<Isotope> isotopes = e.getValue();
                Isotope main_isotope = isotopes.get(0);
                for (Isotope isotope : isotopes) {
                    if (!(isotope.getAbundance() > main_isotope.getAbundance())) continue;
                    main_isotope = isotope;
                }
                atom_main_isotope.put(atom, main_isotope);
                ArrayList<Isotope> other_isotopes = new ArrayList<Isotope>();
                for (Isotope isotope3 : isotopes) {
                    if (isotope3 == main_isotope) continue;
                    other_isotopes.add(isotope3);
                }
                atom_other_isotopes.put(atom, other_isotopes);
                ArrayList<Isotope> arrayList = atom_all_isotopes.get(atom);
                arrayList.remove(main_isotope);
                arrayList.add(0, main_isotope);
            }
            is.close();
        }
        catch (Exception e) {
            LogUtils.report(e);
            atoms.clear();
        }
    }

    public static Atom getAtom(String atom_name) throws Exception {
        Atom ret = atoms.get(atom_name);
        if (ret == null) {
            throw new Exception("Invalid atom " + atom_name);
        }
        return ret;
    }

    public static Isotope getMainIsotope(Atom atom) {
        if (atom == null) {
            return null;
        }
        return atom_main_isotope.get(atom);
    }

    public static ArrayList<Isotope> getAllIsotopes(Atom atom) {
        if (atom == null) {
            return null;
        }
        return atom_all_isotopes.get(atom);
    }

    static {
        MassUtils.loadAtoms("/conf/atoms");
        MassUtils.loadIsotopes("/conf/isotopes");
        try {
            water = new Molecule("H2O");
            hydrogen = MassUtils.getAtom("H");
            electron = MassUtils.getAtom("e");
            methyl = new Molecule("CH3");
            dmethyl = new Molecule("CD3");
            acetyl = new Molecule("C2H3O");
            dacetyl = new Molecule("C2D3O");
            heavyMethyl = new Molecule("C^13H3");
            h_ion = new Molecule("H+");
            li_ion = new Molecule("Li+");
            na_ion = new Molecule("Na+");
            k_ion = new Molecule("K+");
            cl_ion = new Molecule("Cl-");
            h2po4_ion = new Molecule("H2PO4-");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

