/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.logutility;

import java.awt.Frame;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JOptionPane;
import org.eurocarbdb.application.glycanbuilder.logutility.LoggerStorageIndex;
import org.eurocarbdb.application.glycanbuilder.logutility.LoggerStorageIndexImpl;
import org.eurocarbdb.application.glycanbuilder.util.ReportDialog;

public class LogUtils {
    private static LoggerStorageIndex loggerStorageIndex = new LoggerStorageIndexImpl();

    private LogUtils() {
    }

    public static void setLookupLogger(LoggerStorageIndex loggerStorageIndex) {
        LogUtils.loggerStorageIndex = loggerStorageIndex;
    }

    public static void setGraphicalReport(boolean flag) {
        loggerStorageIndex.getLogger().setGraphicalReport(flag);
    }

    public static boolean getGraphicReport() {
        return loggerStorageIndex.getLogger().getGraphicalReport();
    }

    public static void setReportOwner(Frame owner) {
        loggerStorageIndex.getLogger().setFrameOwner(owner);
    }

    public static Frame getReportOwner() {
        return loggerStorageIndex.getLogger().getFrameOwner();
    }

    public static void clearLastError() {
        loggerStorageIndex.getLogger().setHasLastError(false);
        loggerStorageIndex.getLogger().setLastError("");
        loggerStorageIndex.getLogger().setLastStackError("");
    }

    public static boolean hasLastError() {
        return loggerStorageIndex.getLogger().getHasLastError();
    }

    public static String getLastError() {
        return loggerStorageIndex.getLogger().getLastError();
    }

    public static String getLastErrorStack() {
        return loggerStorageIndex.getLogger().getLastStackError();
    }

    public static String getError(Exception e) {
        return e.getMessage();
    }

    public static String getErrorStack(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.getBuffer().toString();
    }

    public static void report(Exception e) {
        if (e == null) {
            LogUtils.clearLastError();
            return;
        }
        loggerStorageIndex.getLogger().setHasLastError(true);
        loggerStorageIndex.getLogger().setLastError(LogUtils.getError(e));
        if (loggerStorageIndex.getLogger().getLastError() == null) {
            loggerStorageIndex.getLogger().setLastError("");
        }
        loggerStorageIndex.getLogger().setLastStackError(LogUtils.getErrorStack(e));
        if (loggerStorageIndex.getLogger().getLastStackError() == null) {
            loggerStorageIndex.getLogger().setLastStackError("");
        }
        if (loggerStorageIndex.getLogger().getGraphicalReport()) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error in GlycanBuilder2", 0);
            new ReportDialog(loggerStorageIndex.getLogger().getFrameOwner(), loggerStorageIndex.getLogger().getLastStackError()).setVisible(true);
        } else {
            e.printStackTrace();
        }
    }
}

