/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.linkage;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.dataset.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.linkage.Linkage;
import org.eurocarbdb.application.glycanbuilder.linkage.LinkageStyle;
import org.eurocarbdb.application.glycanbuilder.logutility.LogUtils;
import org.eurocarbdb.application.glycanbuilder.util.TextUtils;

public class LinkageStyleDictionary {
    private LinkedList<LinkageStyle> styles = new LinkedList();

    public void loadStyles(String filename) {
        this.styles.clear();
        try {
            String line;
            BufferedReader is;
            if (filename.startsWith("http")) {
                URLConnection conn = new URL(filename).openConnection();
                is = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            } else {
                URL file_url = ResidueDictionary.class.getResource(filename);
                if (file_url == null) {
                    File file = new File(filename);
                    if (!file.exists()) {
                        throw new FileNotFoundException(filename);
                    }
                    is = new BufferedReader(new FileReader(file));
                } else {
                    is = new BufferedReader(new InputStreamReader(file_url.openStream()));
                }
            }
            while ((line = is.readLine()) != null) {
                if ((line = TextUtils.trim(line)).length() <= 0 || line.startsWith("%")) continue;
                LinkageStyle toadd = new LinkageStyle(line);
                this.styles.addLast(toadd);
            }
            is.close();
        }
        catch (Exception e) {
            LogUtils.report(e);
            this.styles.clear();
        }
    }

    public LinkageStyle getStyle(Linkage link) {
        return this.getStyle(link.getParentResidue(), link, link.getChildResidue());
    }

    public LinkageStyle getStyle(Residue parent, Linkage link, Residue child) {
        for (LinkageStyle a_objLinkage : this.styles) {
            if (null == a_objLinkage || !a_objLinkage.matches(parent, link, child)) continue;
            return a_objLinkage;
        }
        return new LinkageStyle();
    }
}

