/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.linkage;

import java.util.Arrays;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.linkage.Union;

public class Bond {
    private char[] parent_positions;
    private char child_position;
    int a_iProbabilityLow = 100;
    int a_iProbabilityHigh = 100;

    public Bond() {
        this.parent_positions = new char[]{'?'};
        this.child_position = (char)63;
    }

    public Bond(char p_pos, char c_pos) {
        this.parent_positions = new char[]{p_pos};
        this.child_position = c_pos;
    }

    public Bond(char[] p_poss, char c_pos) {
        this.parent_positions = (char[])p_poss.clone();
        this.child_position = c_pos;
        Arrays.sort(this.parent_positions);
    }

    public Bond clone() {
        return new Bond(this.parent_positions, this.child_position);
    }

    public static Vector<Bond> single() {
        return new Union<Bond>(new Bond('?', '?'));
    }

    public static Vector<Bond> single(char p_pos) {
        return new Union<Bond>(new Bond(p_pos, '?'));
    }

    public char[] getParentPositions() {
        return this.parent_positions;
    }

    public void setParentPosition(char pos) {
        this.parent_positions = new char[]{pos};
    }

    public void setParentPositions(char[] poss) {
        this.parent_positions = (char[])poss.clone();
        Arrays.sort(this.parent_positions);
    }

    public char getChildPosition() {
        return this.child_position;
    }

    public void setChildPosition(char pos) {
        this.child_position = pos;
    }

    public void setProbabilityLow(double a_dLow) {
        this.a_iProbabilityLow = (int)(a_dLow * 100.0);
    }

    public void setProbabilityHigh(double a_dHigh) {
        this.a_iProbabilityHigh = (int)(a_dHigh * 100.0);
    }

    public void setProbabilityLow(int a_iLow) {
        this.a_iProbabilityLow = a_iLow;
    }

    public void setProbabilityHigh(int a_iHigh) {
        this.a_iProbabilityHigh = a_iHigh;
    }

    public int getProbabilityLow() {
        return this.a_iProbabilityLow;
    }

    public int getProbabilityHigh() {
        return this.a_iProbabilityHigh;
    }

    private boolean fuzzyMatch(char c1, char c2) {
        return this.match(c1, c2, true);
    }

    private boolean match(char c1, char c2, boolean fuzzy) {
        return c1 == c2 || fuzzy && (c1 == '?' || c2 == '?');
    }

    public boolean fuzzyMatch(Bond other) {
        return this.match(other, true);
    }

    public boolean match(Bond other, boolean fuzzy) {
        if (other == null) {
            return false;
        }
        if (!this.match(this.child_position, other.child_position, true)) {
            return false;
        }
        if (this.parent_positions.length < other.parent_positions.length) {
            return false;
        }
        int matched = 0;
        int i = 0;
        block0: for (int l = 0; l < other.parent_positions.length; ++l) {
            while (i < this.parent_positions.length) {
                if (this.match(this.parent_positions[i], other.parent_positions[l], fuzzy)) {
                    ++matched;
                    ++i;
                    continue block0;
                }
                ++i;
            }
        }
        return matched == other.parent_positions.length;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Bond)) {
            return false;
        }
        Bond bother = (Bond)other;
        if (this.child_position != bother.child_position) {
            return false;
        }
        if (this.parent_positions.length != bother.parent_positions.length) {
            return false;
        }
        for (int i = 0; i < this.parent_positions.length; ++i) {
            if (this.parent_positions[i] == bother.parent_positions[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int ret = 1;
        ret *= this.child_position;
        for (char c : this.parent_positions) {
            ret *= c;
        }
        return ret;
    }

    protected static class Comparator
    implements java.util.Comparator<Bond> {
        protected Comparator() {
        }

        @Override
        public int compare(Bond o1, Bond o2) {
            return o1.child_position - o2.child_position;
        }
    }
}

