/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.converterKCF;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.converter.GlycanParser;
import org.eurocarbdb.application.glycanbuilder.converterGWS.GWSParser;
import org.eurocarbdb.application.glycanbuilder.dataset.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.linkage.Bond;
import org.eurocarbdb.application.glycanbuilder.linkage.Linkage;
import org.eurocarbdb.application.glycanbuilder.massutil.MassOptions;
import org.eurocarbdb.application.glycanbuilder.renderutil.BBoxManager;
import org.eurocarbdb.application.glycanbuilder.util.TextUtils;

public class KCFParser
implements GlycanParser {
    private static Pattern gmind_pattern = Pattern.compile("([A-Z]+)([\\'\\^\\~]?)((?:\\[[\\?1-9a-zA-Z\\,]+\\])?)([abo\\?]?)([1-9\\?]?(?:/[1-9\\?])*)\\z");
    private static Pattern gmind_sub_pattern = Pattern.compile("([\\?1-9]{0,1})([a-zA-Z]*)(?:\\,([\\?1-9]{0,1})([a-zA-Z]+))*");
    private static HashMap<String, String> gmind_types = new HashMap();
    private static HashMap<String, SU> gmind_codes;

    @Override
    public void setTolerateUnknown(boolean f) {
    }

    @Override
    public String writeGlycan(Glycan structure) {
        if (structure.isFragment()) {
            return "";
        }
        int bracket = 0;
        Residue root = structure.getRoot();
        if (root != null && !root.isSaccharide()) {
            root = root.firstChild();
        }
        if (structure.getBracket() == null) {
            return this.writeSubtree(root, bracket, false);
        }
        ArrayList myList = new ArrayList();
        HashMap map = new HashMap();
        StringBuilder sb = new StringBuilder();
        for (Linkage l : structure.getBracket().getChildrenLinkages()) {
            ++bracket;
        }
        System.out.println(bracket);
        sb.append(this.writeSubtree(root, bracket, false));
        int antena = 1;
        bracket = 0;
        for (Linkage l : structure.getBracket().getChildrenLinkages()) {
            sb.insert(0, "=" + antena + "%|");
            sb.insert(0, this.writeSubtree(l.getChildResidue(), bracket, false));
            ++antena;
        }
        return sb.toString();
    }

    @Override
    public Glycan readGlycan(String str, MassOptions default_mass_options) throws Exception {
        if ((str = TextUtils.trim(str)).indexOf("//") != -1) {
            throw new Exception("Unsupported structures with uncertain residues");
        }
        int index = str.indexOf(";");
        if (index == -1 && (index = str.indexOf(":")) == -1) {
            index = str.indexOf("#");
        }
        if (index != -1) {
            str = str.substring(0, index);
        }
        str = str.replaceAll("(\\([1-9]+\\%\\))|([1-9]+\\%)", "");
        str = str.replaceAll("-", "");
        String[] tokens1 = str.split("\\|");
        String str_core = tokens1[tokens1.length - 1];
        Glycan structure = new Glycan(KCFParser.readSubtree(str_core), true, default_mass_options);
        ArrayList<String> myList = new ArrayList<String>();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = tokens1.length - 2; i >= 0; --i) {
            String str_antenna = tokens1[i].substring(0, tokens1[i].length() - 1);
            Matcher m = gmind_pattern.matcher(str_antenna);
            if (!m.find()) {
                throw new Exception("Unrecognized format: " + str_antenna);
            }
            map.put(m.group(1), str_antenna);
            myList.add(m.group(1));
        }
        Collections.sort(myList);
        Iterator it = myList.iterator();
        for (int i = 0; i < myList.size(); ++i) {
            String an = (String)myList.get(i);
            String ans = (String)map.get(an);
            Residue antenna = KCFParser.readSubtree(ans);
            structure.addAntenna(antenna, antenna.getParentLinkage().getBonds());
        }
        return structure;
    }

    private static Residue readSubtree(String str) throws Exception {
        Bond bond;
        Linkage par_link;
        Residue startRep = null;
        Residue endRep = null;
        if (str.charAt(str.length() - 1) == '}') {
            startRep = ResidueDictionary.createStartRepetition();
            str = str.substring(0, str.length() - 1);
        } else if (str.charAt(str.length() - 1) == '{') {
            endRep = ResidueDictionary.createEndRepetition();
            int repetation = TextUtils.findEnclosedInvert(str, str.length() - 1, '{', '}');
            str = str.substring(0, str.length() - 1);
        }
        Residue ret = null;
        if (endRep != null) {
            ret = endRep;
            par_link = new Linkage(null, ret);
            bond = new Bond();
            bond.setChildPosition('?');
            ret.setAnomericCarbon(bond.getChildPosition());
            par_link.setLinkagePositions(KCFParser.parsePositions("?"));
            ret.setParentLinkage(par_link);
        } else if (startRep != null) {
            ret = startRep;
            par_link = new Linkage(null, ret);
            bond = new Bond();
            bond.setChildPosition('?');
            ret.setAnomericCarbon(bond.getChildPosition());
            par_link.setLinkagePositions(KCFParser.parsePositions("?"));
            ret.setParentLinkage(par_link);
        } else if (str.length() > 0) {
            Matcher m = gmind_pattern.matcher(str);
            if (!m.find()) {
                throw new Exception("Unrecognized format: " + str);
            }
            ret = KCFParser.createFromRINGS(m.group(1), m.group(2), m.group(3), m.group(4), m.group(5));
            str = str.substring(0, str.length() - m.group(0).length());
        }
        Vector<Linkage> children = new Vector<Linkage>();
        while (str.length() > 0) {
            Residue child = null;
            int par_ind = TextUtils.findEnclosedInvert(str, str.length() - 1, '(', ')');
            if (par_ind != -1) {
                child = KCFParser.readSubtree(str.substring(par_ind + 1, str.length() - 1));
                str = str.substring(0, par_ind);
            } else {
                child = KCFParser.readSubtree(str);
                str = "";
            }
            children.add(child.getParentLinkage());
        }
        if (children.size() > 0) {
            children.insertElementAt((Linkage)children.lastElement(), 0);
            children.remove(children.size() - 1);
        }
        KCFParser.fixBisectingGlcNAc(ret, children);
        Collections.sort(children, new Linkage.LinkageComparator());
        for (Linkage l : children) {
            ret.addChild(l.getChildResidue(), l.getBonds());
        }
        return ret;
    }

    private static void fixBisectingGlcNAc(Residue parent, Vector<Linkage> children) {
        if (!parent.getTypeName().equals("Man") || children.size() != 3) {
            return;
        }
        int glcnac_pos = -1;
        int no_glcnac = 0;
        int no_man = 0;
        for (int i = 0; i < children.size(); ++i) {
            Linkage l = children.get(i);
            if (l.getChildResidue().getTypeName().equals("Man")) {
                ++no_man;
                continue;
            }
            if (l.getChildResidue().getTypeName().equals("GlcNAc")) {
                ++no_glcnac;
                glcnac_pos = i;
                continue;
            }
            return;
        }
        if (no_glcnac != 1 || no_man != 2) {
            return;
        }
        if (glcnac_pos != 1) {
            Linkage help = children.get(1);
            children.set(1, children.get(glcnac_pos));
            children.set(glcnac_pos, help);
        }
    }

    private static Residue createFromRINGS(String type, String mod_stereo, String subs, String anom, String link) throws Exception {
        String res_type = gmind_types.get(type);
        if (res_type == null) {
            throw new Exception("Unrecognized gmind type: " + type);
        }
        Residue ret = GWSParser.readSubtree(res_type, false);
        if (mod_stereo != null && mod_stereo.length() > 0) {
            if (mod_stereo.equals("'")) {
                ret.setChirality(ret.getChirality() == 'D' ? (char)'L' : 'D');
            } else if (mod_stereo.equals("^")) {
                ret.setRingSize(ret.getRingSize() == 'p' ? (char)'f' : 'p');
            } else if (mod_stereo.equals("~")) {
                ret.setChirality(ret.getChirality() == 'D' ? (char)'L' : 'D');
                ret.setRingSize(ret.getRingSize() == 'p' ? (char)'f' : 'p');
            }
        }
        if (anom != null && anom.length() > 0) {
            ret.setAnomericState(anom.charAt(0));
        }
        if (subs != null && subs.length() > 1) {
            Matcher m = gmind_sub_pattern.matcher(subs = subs.substring(1, subs.length() - 1));
            if (!m.lookingAt()) {
                throw new Exception("Unrecognized format for substitution: " + subs);
            }
            for (int i = 0; i < m.groupCount(); i += 2) {
                String sub = m.group(i + 2);
                if (sub == null || sub.length() <= 0) continue;
                String sub_type = gmind_types.get(sub);
                if (sub_type == null) {
                    throw new Exception("Unrecognized gmind type: " + sub);
                }
                Residue ret_sub = ResidueDictionary.newResidue(sub_type);
                StringBuilder sb = new StringBuilder();
                sb.append("1");
                sb.append(m.group(i + 1));
                ret.addChild(ret_sub, sb.charAt(sb.length() - 1));
            }
        }
        Linkage par_link = new Linkage(null, ret);
        if (link != null && link.length() > 0) {
            par_link.setLinkagePositions(KCFParser.parsePositions(link));
        }
        ret.setParentLinkage(par_link);
        return ret;
    }

    private static char[] parsePositions(String str) {
        String[] fields = str.split("/");
        char[] ret = new char[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            ret[i] = fields[i].charAt(0);
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private String writeSubtree(Residue r, int bracket, boolean repetition) {
        StringBuilder sb = new StringBuilder();
        if (r == null) {
            return "";
        }
        if (!(r.isStartRepetition() || r.isEndRepetition() || r.isSaccharide())) {
            return "?";
        }
        if (r.getType().isStartRepetition()) {
            repetition = true;
            sb.insert(0, '}');
            sb.insert(0, this.writeSubtree(r.getChildrenLinkages().getFirst().getChildResidue(), bracket, repetition));
        } else if (r.getType().isEndRepetition()) {
            sb.insert(0, '{');
            repetition = false;
        } else if (gmind_codes.get(r.getTypeName()) == null) {
            sb.insert(0, '*');
        } else {
            if (r.getParentLinkage() != null) {
                char ppos = r.getParentLinkage().getParentPositionsSingle();
                sb.insert(0, ppos);
            }
            sb.insert(0, r.getAnomericState());
            Vector<Linkage> modifications = new Vector<Linkage>();
            Vector<Linkage> children = new Vector<Linkage>();
            for (Linkage linkage : r.getChildrenLinkages()) {
                if (linkage.getChildResidue().isStartRepetition()) {
                    children.add(linkage);
                    continue;
                }
                if (linkage.getChildResidue().isEndRepetition()) {
                    children.add(linkage);
                    continue;
                }
                if (linkage.getChildResidue().isSaccharide()) {
                    children.add(linkage);
                    continue;
                }
                modifications.add(linkage);
            }
            Collections.sort(modifications, new Linkage.LinkageComparator());
            if (modifications.size() > 0) {
                StringBuilder msb = new StringBuilder();
                msb.append('[');
                for (Linkage l : modifications) {
                    if (gmind_codes.get(l.getChildResidue().getTypeName()) == null) {
                        sb.append('*');
                        continue;
                    }
                    if (l.getParentPositionsSingle() != '1') {
                        msb.append(l.getParentPositionsSingle());
                    }
                    msb.append(KCFParser.gmind_codes.get((Object)l.getChildResidue().getTypeName()).code);
                }
                msb.append(']');
                sb.insert(0, msb.toString());
            }
            SU su = gmind_codes.get(r.getTypeName());
            if (su.chirality != r.getChirality() && su.ring_size != r.getRingSize()) {
                sb.insert(0, '~');
            } else if (su.chirality != r.getChirality()) {
                sb.insert(0, '\'');
            } else if (su.ring_size != r.getRingSize()) {
                sb.insert(0, '^');
            }
            sb.insert(0, su.code);
            if (children.size() > 0) {
                void var8_13;
                boolean bl = true;
                while (var8_13 < children.size()) {
                    sb.insert(0, ')');
                    if (repetition) {
                        sb.insert(0, '-');
                    }
                    sb.insert(0, this.writeSubtree(((Linkage)children.get((int)var8_13)).getChildResidue(), bracket, repetition));
                    if (repetition) {
                        sb.insert(0, '-');
                    }
                    sb.insert(0, '(');
                    ++var8_13;
                }
                sb.insert(0, this.writeSubtree(((Linkage)children.firstElement()).getChildResidue(), bracket, repetition));
            } else if (bracket > 0) {
                boolean bl = true;
                while (bracket > 0) {
                    void var8_15;
                    sb.insert(0, (int)var8_15 + "%");
                    ++var8_15;
                    --bracket;
                }
            }
        }
        return sb.toString();
    }

    @Override
    public String writeGlycan(Glycan structure, BBoxManager bboxManager) {
        throw new UnsupportedOperationException();
    }

    static {
        gmind_types.put("G", "?1D-Glc,p");
        gmind_types.put("A", "?1D-Gal,p");
        gmind_types.put("GN", "?1D-GlcNAc,p");
        gmind_types.put("AN", "?1D-GalNAc,p");
        gmind_types.put("M", "?1D-Man,p");
        gmind_types.put("N", "?2D-Neu,p");
        gmind_types.put("NN", "?2D-NeuAc,p");
        gmind_types.put("NJ", "?2D-NeuGc,p");
        gmind_types.put("K", "?2D-KDN,p");
        gmind_types.put("W", "?2D-KDO,p");
        gmind_types.put("L", "?1D-GalA,p");
        gmind_types.put("I", "?1D-IdoA,p");
        gmind_types.put("H", "?1L-Rha,p");
        gmind_types.put("F", "?1L-Fuc,p");
        gmind_types.put("X", "?1D-Xyl,p");
        gmind_types.put("B", "?1D-Rib,p");
        gmind_types.put("R", "?1L-Ara,f");
        gmind_types.put("U", "?1D-GlcA,p");
        gmind_types.put("O", "?1D-All,p");
        gmind_types.put("P", "?1D-Api,p");
        gmind_types.put("E", "?2D-Fru,f");
        gmind_types.put("LYX", "?1L-Lyx,p");
        gmind_types.put("QUI", "?1D-Qui,p");
        gmind_types.put("DTAL", "?1D-dTal,p");
        gmind_types.put("BAC", "?1D-Bac,p");
        gmind_types.put("TAL", "?1D-Tal,p");
        gmind_types.put("J", "?1L-Alt,p");
        gmind_types.put("GL", "?1D-Gul,f");
        gmind_types.put("SOR", "?2L-Sor,p");
        gmind_types.put("TAG", "?2L-Tag,p");
        gmind_types.put("MA", "?1D-ManA,p");
        gmind_types.put("JA", "?1L-AltA,p");
        gmind_types.put("GLA", "?1D-GulA,f");
        gmind_types.put("MAC", "?1D-ManNAc,p");
        gmind_types.put("BNAC", "?1D-BacNAc,p");
        gmind_types.put("MUR", "?1D-MurNAc,p");
        gmind_types.put("KO", "?2D-Ko,p");
        gmind_types.put("C", "Cer");
        gmind_types.put("DAG", "DAG");
        gmind_types.put("IPC", "IPC");
        gmind_types.put("LIA", "LipdA");
        gmind_types.put("D", "Sph");
        gmind_types.put("P", "P");
        gmind_types.put("ME", "Me");
        gmind_types.put("T", "Ac");
        gmind_types.put("NAC", "NAc");
        gmind_types.put("S", "S");
        gmind_types.put("PYR", "Pyr");
        gmind_types.put("PC", "PC");
        gmind_types.put("PPETN", "PPEtn");
        gmind_types.put("PETN", "PEtn");
        gmind_types.put("N", "N");
        gmind_types.put("DO", "deoxy");
        gmind_codes = new HashMap();
        gmind_codes.put("Glc", new SU("G", 'D', 'p'));
        gmind_codes.put("Gal", new SU("A", 'D', 'p'));
        gmind_codes.put("GlcNAc", new SU("GN", 'D', 'p'));
        gmind_codes.put("GalNAc", new SU("AN", 'D', 'p'));
        gmind_codes.put("Man", new SU("M", 'D', 'p'));
        gmind_codes.put("Neu", new SU("N", 'D', 'p'));
        gmind_codes.put("NeuAc", new SU("NN", 'D', 'p'));
        gmind_codes.put("NeuGc", new SU("NJ", 'D', 'p'));
        gmind_codes.put("KDN", new SU("K", 'D', 'p'));
        gmind_codes.put("KDO", new SU("W", 'D', 'p'));
        gmind_codes.put("GalA", new SU("L", 'D', 'p'));
        gmind_codes.put("IdoA", new SU("I", 'D', 'p'));
        gmind_codes.put("Rha", new SU("H", 'L', 'p'));
        gmind_codes.put("Fuc", new SU("F", 'L', 'p'));
        gmind_codes.put("Xyl", new SU("X", 'D', 'p'));
        gmind_codes.put("Rib", new SU("B", 'D', 'p'));
        gmind_codes.put("Ara", new SU("R", 'L', 'f'));
        gmind_codes.put("GlcA", new SU("U", 'D', 'p'));
        gmind_codes.put("All", new SU("O", 'D', 'p'));
        gmind_codes.put("Api", new SU("P", 'D', 'p'));
        gmind_codes.put("Fru", new SU("E", 'D', 'f'));
        gmind_codes.put("Lyx", new SU("LYX", 'L', 'p'));
        gmind_codes.put("Qui", new SU("QUI", 'D', 'p'));
        gmind_codes.put("dTal", new SU("DTAL", 'D', 'p'));
        gmind_codes.put("Bac", new SU("BAC", 'D', 'p'));
        gmind_codes.put("Tal", new SU("TAL", 'D', 'p'));
        gmind_codes.put("Alt", new SU("J", 'L', 'p'));
        gmind_codes.put("Gul", new SU("GL", 'D', 'f'));
        gmind_codes.put("Sor", new SU("SOR", 'L', 'p'));
        gmind_codes.put("Tag", new SU("TAG", 'L', 'p'));
        gmind_codes.put("ManA", new SU("MA", 'D', 'p'));
        gmind_codes.put("AltA", new SU("JA", 'L', 'p'));
        gmind_codes.put("GulA", new SU("GLA", 'D', 'f'));
        gmind_codes.put("ManNAc", new SU("MAC", 'D', 'p'));
        gmind_codes.put("BacNAc", new SU("BNAC", 'D', 'p'));
        gmind_codes.put("MurNAc", new SU("MUR", 'D', 'p'));
        gmind_codes.put("Ko", new SU("KO", 'D', 'p'));
        gmind_codes.put("Cer", new SU("C"));
        gmind_codes.put("DAG", new SU("DAG"));
        gmind_codes.put("IPC", new SU("IPC"));
        gmind_codes.put("LipdA", new SU("LIA"));
        gmind_codes.put("Sph", new SU("D"));
        gmind_codes.put("P", new SU("P"));
        gmind_codes.put("Me", new SU("ME"));
        gmind_codes.put("Ac", new SU("T"));
        gmind_codes.put("NAc", new SU("NAC"));
        gmind_codes.put("S", new SU("S"));
        gmind_codes.put("Pyr", new SU("PYR"));
        gmind_codes.put("PC", new SU("PC"));
        gmind_codes.put("PPEtn", new SU("PPETN"));
        gmind_codes.put("PEtn", new SU("PETN"));
        gmind_codes.put("N", new SU("N"));
        gmind_codes.put("deoxy", new SU("DO"));
        gmind_types.put("DO", "deoxy");
    }

    private static final class SU {
        public String code;
        public char chirality;
        public char ring_size;

        public SU(String _code) {
            this.code = _code;
            this.chirality = (char)63;
            this.ring_size = (char)63;
        }

        public SU(String _code, char _chirality, char _ring_size) {
            this.code = _code;
            this.chirality = _chirality;
            this.ring_size = _ring_size;
        }
    }
}

