/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.converterGlycoCT;

import org.eurocarbdb.MolecularFramework.io.GlycoCT.SugarExporterGlycoCTCondensed;
import org.eurocarbdb.MolecularFramework.io.GlycoCT.SugarImporterGlycoCTCondensed;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.converterGlycoCT.GlycoCTParser;
import org.eurocarbdb.application.glycanbuilder.logutility.LogUtils;
import org.eurocarbdb.application.glycanbuilder.massutil.MassOptions;

public class GlycoCTCondensedParser
extends GlycoCTParser {
    private SugarImporterGlycoCTCondensed cond_importer = null;
    private SugarExporterGlycoCTCondensed cond_exporter = null;

    public GlycoCTCondensedParser(boolean tolerate) {
        super(tolerate);
        try {
            this.cond_importer = new SugarImporterGlycoCTCondensed();
            this.cond_exporter = new SugarExporterGlycoCTCondensed();
        }
        catch (Exception e) {
            LogUtils.report(e);
        }
    }

    @Override
    public String writeGlycan(Glycan structure) {
        return this.toGlycoCTCondensed(structure);
    }

    @Override
    public Glycan readGlycan(String buffer, MassOptions default_mass_options) throws Exception {
        return this.fromGlycoCTCondensed(buffer, default_mass_options);
    }

    public SugarImporterGlycoCTCondensed getImporterCondensed() {
        return this.cond_importer;
    }

    public SugarExporterGlycoCTCondensed getExporterCondensed() {
        return this.cond_exporter;
    }

    public String toGlycoCTCondensed(Glycan structure) {
        try {
            this.cond_exporter.start(this.toSugar(structure));
            return this.cond_exporter.getHashCode();
        }
        catch (Exception e) {
            LogUtils.report(e);
            return "";
        }
    }

    @Override
    public Sugar toSugar(Glycan structure) throws Exception {
        return this.toSugar(structure, null);
    }

    public Glycan fromGlycoCTCondensed(String str, MassOptions default_mass_opt) throws Exception {
        return this.fromSugar(this.cond_importer.parse(str), default_mass_opt);
    }
}

