/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.converterGWS;

import org.eurocarbdb.application.glycanbuilder.BuilderWorkspace;
import org.eurocarbdb.application.glycanbuilder.GlycanDocument;
import org.eurocarbdb.application.glycanbuilder.logutility.LogUtils;
import org.eurocarbdb.application.glycanbuilder.renderutil.GlycanRendererAWT;

public class ConvertGWS {
    public static final String toFormat(String format_name, String gws_sequence) throws Exception {
        BuilderWorkspace theWorkspace = new BuilderWorkspace(null, false, new GlycanRendererAWT());
        GlycanDocument theDoc = theWorkspace.getStructures();
        theDoc.fromString(gws_sequence, false);
        return theDoc.toString(format_name);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage: ConvertGWS <GWS string> [<output format>]");
            return;
        }
        String sequence = args[0];
        String outputType = args.length > 1 ? args[1] : "glycoct_xml";
        try {
            System.out.println(ConvertGWS.toFormat(outputType, sequence));
        }
        catch (Exception e) {
            System.err.println("Error: " + LogUtils.getError(e));
            System.err.println("Stack: " + LogUtils.getErrorStack(e));
        }
    }
}

