/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.TreeMap;
import org.eurocarbdb.application.glycanbuilder.CrossRingFragmentType;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueStyle;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.dataset.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.logutility.LogUtils;
import org.eurocarbdb.application.glycanbuilder.util.TextUtils;

public class ResidueStyleDictionary {
    private TreeMap<String, String> styles = new TreeMap();

    public void loadStyles(String filename) {
        this.styles.clear();
        try {
            String line;
            BufferedReader is;
            if (filename.startsWith("http")) {
                URLConnection conn = new URL(filename).openConnection();
                is = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            } else {
                URL file_url = ResidueDictionary.class.getResource(filename);
                if (file_url == null) {
                    File file = new File(filename);
                    if (!file.exists()) {
                        throw new FileNotFoundException(filename);
                    }
                    is = new BufferedReader(new FileReader(file));
                } else {
                    is = new BufferedReader(new InputStreamReader(file_url.openStream()));
                }
            }
            while ((line = is.readLine()) != null) {
                if ((line = TextUtils.trim(line)).length() <= 0 || line.startsWith("%")) continue;
                String[] str_tokens = line.split("\t");
                this.styles.put(str_tokens[0], line);
            }
            is.close();
        }
        catch (Exception e) {
            LogUtils.report(e);
            this.styles.clear();
        }
    }

    public ResidueStyle getStyle(Residue node) {
        if (node == null) {
            return new ResidueStyle();
        }
        ResidueStyle a_oRS = null;
        ResidueType type = node.getType();
        String type_name = type.getName();
        if (this.styles.containsKey(type_name)) {
            try {
                return new ResidueStyle(this.styles.get(type_name));
            }
            catch (Exception e) {
                LogUtils.report(e);
            }
        }
        if (type_name.startsWith("#startrep")) {
            return ResidueStyle.createStartRepetition();
        }
        if (type_name.startsWith("#endrep")) {
            return ResidueStyle.createEndRepetition();
        }
        if (type_name.startsWith("#startcyclic")) {
            return ResidueStyle.createStartCyclic();
        }
        if (type_name.startsWith("#endcyclic")) {
            return ResidueStyle.createEndCyclic();
        }
        if (type_name.equals("#attach")) {
            return ResidueStyle.createAttachPoint();
        }
        if (type_name.equals("#redend")) {
            return ResidueStyle.createReducingEnd();
        }
        if (type_name.equals("#altstart")) {
            return ResidueStyle.createStartAlternative();
        }
        if (type_name.equals("#altend")) {
            return ResidueStyle.createEndAlternative();
        }
        if (type_name.equals("#bracket")) {
            return ResidueStyle.createBracket();
        }
        if (type_name.startsWith("#acleavage")) {
            CrossRingFragmentType crt = (CrossRingFragmentType)type;
            return ResidueStyle.createACleavage(crt.getStartPos(), crt.getEndPos());
        }
        if (type_name.equals("#bcleavage")) {
            return ResidueStyle.createBCleavage();
        }
        if (type_name.equals("#ccleavage")) {
            return ResidueStyle.createCCleavage();
        }
        if (type_name.startsWith("#xcleavage")) {
            CrossRingFragmentType crt = (CrossRingFragmentType)type;
            return ResidueStyle.createXCleavage(crt.getStartPos(), crt.getEndPos());
        }
        if (type_name.equals("#ycleavage")) {
            return ResidueStyle.createYCleavage();
        }
        if (type_name.equals("#zcleavage")) {
            return ResidueStyle.createZCleavage();
        }
        if (type.isCustomType()) {
            return ResidueStyle.createText(type.getResidueName());
        }
        String a_sStyle = "";
        if (a_oRS == null) {
            a_sStyle = this.styles.get(type.getSuperclass());
        }
        if (a_sStyle == null || a_sStyle.equals("")) {
            a_sStyle = type_name + "\t-\t0,0,0\tempty\tno\t255,255,255\t" + node.getTypeName() + "\t0,0,0";
        }
        try {
            a_oRS = new ResidueStyle(a_sStyle);
        }
        catch (Exception e) {
            LogUtils.report(e);
        }
        if (node.getID() != 0) {
            a_oRS.setText(String.valueOf(node.getID()));
        }
        return a_oRS;
    }

    public boolean containsResidue(Residue node) {
        return this.styles.containsKey(node.getTypeName());
    }

    public Iterator<String> iterator() {
        return this.styles.values().iterator();
    }
}

