/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.tools.ant.launch.Locator;
import org.eurocarbdb.application.glycanbuilder.EurocarbResizableIcon;
import org.eurocarbdb.application.glycanbuilder.ICON_SIZE;
import org.eurocarbdb.application.glycanbuilder.ImageResizableIconReducedMem;
import org.eurocarbdb.application.glycanbuilder.STOCK_ICON;
import org.eurocarbdb.application.glycanbuilder.ThemeManager;
import org.eurocarbdb.application.glycanbuilder.util.IconProperties;

public class ICON_PATH {
    static final ICON_SIZE[] iconSizes = ICON_SIZE.values();
    protected URL iconPath;
    protected Class clazz;
    protected ThemeManager themeManager;
    protected HashMap<STOCK_ICON, String> stockIconToLocalName = new HashMap();
    protected HashMap<String, HashMap<Integer, HashSet<EXTENSION>>> nameToSizeToExtension = new HashMap();
    protected EXTENSION defaultExtension = EXTENSION.PNG;
    protected boolean searchAllExtensions = true;
    protected boolean searchAllSizes = true;
    protected HashMap<ICON_SIZE, Integer> iconSizeToInteger = new HashMap();

    public ICON_PATH(String _iconPath, Class _clazz, ThemeManager _themeManager) throws IOException {
        this.clazz = _clazz;
        this.themeManager = _themeManager;
        this.init(_iconPath);
    }

    public ICON_PATH(String _iconPath, Class _clazz) throws IOException {
        this.clazz = _clazz;
        this.init(_iconPath);
    }

    private void init(String _iconPath) throws IOException {
        this.setIconPath(_iconPath);
        this.parseThemeFile();
        this.parseCacheFile();
    }

    public void setIconPath(String iconPath) throws MalformedURLException {
        URL url;
        if (this.clazz.getResource(iconPath) == null) {
            String urlString = Locator.getClassSource(this.clazz).getParent() + iconPath;
            urlString = urlString.contains("!") ? "jar:" + urlString.replaceAll("\\\\", "/") : "file:" + urlString;
            url = new URL(urlString);
        } else {
            url = this.clazz.getResource(iconPath);
        }
        this.iconPath = url;
    }

    public void parseCacheFile(String file) throws IOException {
        try {
            URL url = new URL(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = null;
            HashSet<Integer> iconSizeSet = new HashSet<Integer>();
            while ((line = reader.readLine()) != null) {
                String[] cols = line.split("~");
                String name = cols[2];
                EXTENSION extension = EXTENSION.getExtension(cols[1]);
                int size = cols[0].equals("DEFAULT") ? 0 : Integer.parseInt(cols[0]);
                if (!this.nameToSizeToExtension.containsKey(name)) {
                    this.nameToSizeToExtension.put(name, new HashMap());
                }
                if (!this.nameToSizeToExtension.get(name).containsKey(size)) {
                    this.nameToSizeToExtension.get(name).put(size, new HashSet());
                }
                this.nameToSizeToExtension.get(name).get(size).add(extension);
                if (size == 0) continue;
                iconSizeSet.add(size);
            }
            Object[] uniqueIconSizes = iconSizeSet.toArray(new Integer[1]);
            Arrays.sort(uniqueIconSizes);
            for (int i = 0; i < uniqueIconSizes.length; ++i) {
                if (i >= iconSizes.length) continue;
                this.iconSizeToInteger.put(iconSizes[i], (Integer)uniqueIconSizes[i]);
            }
            this.iconSizeToInteger.put(ICON_SIZE.L0, 0);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void parseCacheFile() throws IOException {
        this.parseCacheFile(this.iconPath.getProtocol() + ":" + this.iconPath.getPath() + "/theme.cache");
    }

    public void parseThemeFile(String file) throws IOException {
        Properties properties = new Properties();
        try {
            URL url = new URL(file);
            properties.load(url.openStream());
            for (STOCK_ICON icon : STOCK_ICON.values()) {
                if (properties.get(icon.getIdentifier()) == null) continue;
                this.stockIconToLocalName.put(icon, (String)properties.get(icon.getIdentifier()));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void parseThemeFile() throws IOException {
        this.parseThemeFile(this.iconPath.getProtocol() + ":" + this.iconPath.getPath() + "/theme.properties");
    }

    public EurocarbResizableIcon getResizableIcon(STOCK_ICON icon, ICON_SIZE iconSize, EXTENSION extension) {
        if (this.stockIconToLocalName.containsKey((Object)icon)) {
            return this.getResizableIcon(this.stockIconToLocalName.get((Object)icon), iconSize, extension);
        }
        return this.getResizableIcon(icon.getIdentifier(), iconSize, extension);
    }

    public EurocarbResizableIcon getResizableIcon(STOCK_ICON icon, ICON_SIZE iconSize) {
        return this.getResizableIcon(icon, iconSize, this.defaultExtension);
    }

    public EurocarbResizableIcon getResizableIcon(String id, ICON_SIZE iconSize) {
        return this.getResizableIcon(id, iconSize, this.defaultExtension);
    }

    /*
     * WARNING - void declaration
     */
    public EurocarbResizableIcon getResizableIcon(String id, ICON_SIZE iconSize, EXTENSION extension) {
        void var6_10;
        ArrayList<EXTENSION> extensions = new ArrayList<EXTENSION>();
        extensions.add(extension);
        if (this.searchAllExtensions) {
            for (EXTENSION eXTENSION : extensions) {
                if (eXTENSION == extension) continue;
                extensions.add(extension);
            }
        }
        ArrayList<ICON_SIZE> sizes = new ArrayList<ICON_SIZE>();
        sizes.add(iconSize);
        sizes.add(ICON_SIZE.L0);
        if (this.searchAllSizes) {
            for (ICON_SIZE size : iconSizes) {
                if (size == iconSize) continue;
                if (size == ICON_SIZE.L0) continue;
                sizes.add(size);
            }
        }
        Object var6_9 = null;
        ICON_SIZE finalIconSize = null;
        for (EXTENSION ext : extensions) {
            for (ICON_SIZE size : sizes) {
                if (!this.isIcon(id, size, ext)) continue;
                EXTENSION eXTENSION = ext;
                finalIconSize = size;
                break;
            }
            if (var6_10 == null) continue;
            break;
        }
        if (var6_10 != null) {
            try {
                ImageIcon imageIcon;
                URL iconUrl = this.getIconUrl(id, finalIconSize, (EXTENSION)var6_10);
                IconProperties iconProperties = new IconProperties(iconUrl, true);
                iconProperties.id = id;
                EurocarbResizableIcon eurocarbIcon = new EurocarbResizableIcon();
                eurocarbIcon.setResizableIcon(ImageResizableIconReducedMem.getIcon(iconProperties.imgURL, new Dimension(iconSize.getSize(), iconSize.getSize())));
                eurocarbIcon.setIconProperties(iconProperties);
                eurocarbIcon.setThemeManager(this.themeManager);
                try {
                    BufferedImage src = ImageIO.read(iconProperties.imgURL);
                    imageIcon = new ImageIcon(src);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    imageIcon = ThemeManager.getEmptyIcon(iconSize);
                }
                eurocarbIcon.imageIcon = imageIcon;
                return eurocarbIcon;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public ImageIcon getImageIcon(STOCK_ICON icon, ICON_SIZE iconSize, EXTENSION extension) {
        if (this.stockIconToLocalName.containsKey((Object)icon)) {
            return this.getImageIcon(this.stockIconToLocalName.get((Object)icon), iconSize, extension);
        }
        return this.getImageIcon(icon.getIdentifier(), iconSize, extension);
    }

    public ImageIcon getImageIcon(STOCK_ICON icon, ICON_SIZE iconSize) {
        return this.getImageIcon(icon, iconSize, this.defaultExtension);
    }

    public ImageIcon getImageIcon(String id, ICON_SIZE iconSize) {
        return this.getImageIcon(id, iconSize, this.defaultExtension);
    }

    public ImageIcon getImageIcon(String id, ICON_SIZE iconSize, EXTENSION extension) {
        return this.getResizableIcon((String)id, (ICON_SIZE)iconSize, (EXTENSION)extension).imageIcon;
    }

    public URL getIconUrl(String id, ICON_SIZE iconSize, EXTENSION extension) throws MalformedURLException {
        String url = this.iconPath.getProtocol() + ":" + this.iconPath.getPath();
        if (iconSize != ICON_SIZE.L0) {
            url = url.concat("/" + iconSize.getSize() + "x" + iconSize.getSize());
        }
        url = url.concat("/" + id + "." + (Object)((Object)extension));
        return new URL(url);
    }

    public boolean isIcon(String id, ICON_SIZE iconSize, EXTENSION extension) {
        if (!this.iconSizeToInteger.containsKey((Object)iconSize)) {
            return false;
        }
        Integer size = this.iconSizeToInteger.get((Object)iconSize);
        return this.nameToSizeToExtension.containsKey(id) && this.nameToSizeToExtension.get(id).containsKey(size) && this.nameToSizeToExtension.get(id).get(size).contains((Object)extension);
    }

    public ThemeManager getThemeManager() {
        return this.themeManager;
    }

    public void setThemeManager(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    public static BufferedImage scaleImage(BufferedImage src, int toX, int toY) {
        AffineTransform trans = AffineTransform.getScaleInstance((double)toX / (double)src.getWidth(), (double)toY / (double)src.getHeight());
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        int transparency = src.getColorModel().getTransparency();
        BufferedImage dest = gc.createCompatibleImage(toX, toY, transparency);
        Graphics2D g = dest.createGraphics();
        g.drawRenderedImage(src, trans);
        g.dispose();
        return dest;
    }

    public static enum EXTENSION {
        PNG("png"),
        GIF("gif"),
        SVG("svg"),
        JPG("jpg");

        public String toString;

        private EXTENSION(String _toString) {
            this.toString = _toString;
        }

        public String toString() {
            return this.toString;
        }

        public static EXTENSION getExtension(String extension) {
            if (extension.equals("jpg")) {
                return JPG;
            }
            if (extension.equals("gif")) {
                return GIF;
            }
            if (extension.equals("svg")) {
                return SVG;
            }
            if (extension.equals("png")) {
                return PNG;
            }
            return null;
        }
    }
}

