/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import com.opencsv.exceptions.CsvException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.GlycanStructureAndChangeUser;
import org.json.JSONArray;
import org.json.JSONObject;

public class GlytoucanIDList {
    private static File file;
    private static final String accessionIdByHashKeyBetaApi = "https://sparqlist.beta.glycosmos.org/sparqlist/trace/gtc_select_acc_by_hashkey?hash=";
    private static final String accessionIdByHashKeyRealApi = "https://sparqlist.glycosmos.org/sparqlist/trace/hash2gtcids?hash=";
    private static final int itemsPerPage = 10;
    private static int maxPageIndex;
    private static int currentPageIndex;
    private static DefaultTableModel model;
    private static TableRowSorter<TableModel> sorter;
    private static JTable table;
    private static final JLabel label;
    private static final JButton firstbtn;
    private static final JButton prevbtn;
    private static final JButton nextbtn;
    private static final JButton lastbtn;

    public static void showGlycanIdList(Frame pFrame) {
        final JDialog frame = new JDialog(pFrame, "GlyTouCanID List", true);
        JButton idButton = new JButton("GetID");
        JButton downloadButton = new JButton("Download");
        frame.getContentPane().removeAll();
        idButton.setBounds(60, 120, 120, 50);
        downloadButton.setBounds(60, 120, 120, 50);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.setOpaque(true);
        buttonPanel.add(idButton);
        buttonPanel.add(downloadButton);
        buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        DefaultTableModel model = GlytoucanIDList.readCSV();
        if (model.getRowCount() == 0) {
            idButton.setEnabled(false);
            downloadButton.setEnabled(false);
        }
        JPanel container = new JPanel();
        container.repaint();
        container.setLayout(new BoxLayout(container, 1));
        container.add(GlytoucanIDList.glycanlistTable());
        container.add(Box.createRigidArea(new Dimension(20, 20)));
        container.add(buttonPanel);
        downloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setDialogTitle("Choose save file path");
                fileChooser.setFileFilter(new FileNameExtensionFilter("CSV file", ".csv"));
                String description = fileChooser.getFileFilter().getDescription();
                int option = fileChooser.showSaveDialog(frame);
                file = fileChooser.getSelectedFile();
                if (option == 0) {
                    GlytoucanIDList.exportCSV(description);
                    fileChooser.setVisible(false);
                }
            }
        });
        idButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GlytoucanIDList.getGlytoucanID();
                }
                catch (CsvException | IOException e1) {
                    e1.printStackTrace();
                }
                catch (Throwable e1) {
                    e1.printStackTrace();
                }
            }
        });
        frame.getContentPane().add(container);
        frame.setPreferredSize(new Dimension(800, 390));
        frame.pack();
        frame.setLocationByPlatform(true);
        frame.setResizable(true);
        frame.setLocationRelativeTo(pFrame);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(2);
    }

    public static DefaultTableModel readCSV() {
        ArrayList<String> idlist = new ArrayList<String>();
        ArrayList<String> sequencelist = new ArrayList<String>();
        ArrayList<String> betaOrReal = new ArrayList<String>();
        Object[] column = new String[]{"#", "ID (or) HashKey", "Sequence", "Environment"};
        try {
            int i;
            CSVReader reader = GlycanStructureAndChangeUser.readCSVFile();
            try {
                List<String[]> csvBody = reader.readAll();
                for (i = csvBody.size() - 1; i >= 0; --i) {
                    String[] strArray = csvBody.get(i);
                    idlist.add(strArray[0]);
                    sequencelist.add(strArray[1]);
                    betaOrReal.add(strArray[2]);
                }
                reader.close();
            }
            catch (CsvException e) {
                e.printStackTrace();
            }
            Object[][] obj = new Object[idlist.size()][4];
            for (i = 0; i < idlist.size(); ++i) {
                obj[i][0] = i + 1;
                obj[i][1] = idlist.get(i);
                obj[i][2] = ((String)sequencelist.get(i)).replaceAll("\\:", "\\,");
                obj[i][3] = ((String)betaOrReal.get(i)).toString();
            }
            model = new DefaultTableModel(obj, column){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return model;
    }

    public static long countLineCSV(String fileName) {
        Path path = Paths.get(fileName, new String[0]);
        long lines = 0L;
        try {
            lines = Files.lines(path).count();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lines;
    }

    public static void exportCSV(String description) {
        String filepath = description.equals("CSV file") ? file.toString() + ".csv" : file.toString();
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        String[] glycanList = new String[4];
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (int i = 0; model.getRowCount() > i; ++i) {
            for (int j = 0; j < model.getColumnCount(); ++j) {
                glycanList[j] = model.getValueAt(i, j).toString();
            }
            list.add(glycanList);
            glycanList = new String[4];
        }
        try (CSVWriter writer = new CSVWriter(new FileWriter(filepath));){
            String[] header = new String[]{"NO", "GlyToucanID", "Sequence", "Environment"};
            writer.writeNext(header);
            writer.writeAll((List<String[]>)list);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static JComponent glycanlistTable() {
        firstbtn.setPreferredSize(new Dimension(50, 20));
        prevbtn.setPreferredSize(new Dimension(50, 20));
        nextbtn.setPreferredSize(new Dimension(50, 20));
        lastbtn.setPreferredSize(new Dimension(50, 20));
        table.repaint();
        table.setFillsViewportHeight(true);
        model.fireTableDataChanged();
        model = GlytoucanIDList.readCSV();
        JPanel labelPanel = new JPanel();
        labelPanel.add(label);
        labelPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        JPanel paginationPanel = new JPanel(new GridLayout(1, 4, 3, 2));
        for (JComponent r : Arrays.asList(firstbtn, prevbtn, labelPanel, nextbtn, lastbtn)) {
            paginationPanel.add(r);
        }
        paginationPanel.setLayout(new BoxLayout(paginationPanel, 0));
        JPanel btnpanel = new JPanel(new BorderLayout());
        btnpanel.add((Component)paginationPanel, "East");
        int rowCount = model.getRowCount();
        if (rowCount == 0) {
            firstbtn.disable();
            prevbtn.disable();
            nextbtn.disable();
            lastbtn.disable();
            label.disable();
        }
        int v = rowCount % 10 == 0 ? 0 : 1;
        maxPageIndex = rowCount / 10 + v;
        model.fireTableDataChanged();
        model.fireTableRowsUpdated(0, table.getRowCount());
        table = new JTable(model);
        JTableHeader tableHeader = table.getTableHeader();
        Font headerFont = new Font("Verdana", 1, 12);
        tableHeader.setFont(headerFont);
        tableHeader.setReorderingAllowed(false);
        table.updateUI();
        sorter = new TableRowSorter<DefaultTableModel>(model);
        table.setRowSorter(sorter);
        sorter.setSortable(0, false);
        sorter.setSortable(1, false);
        sorter.setSortable(2, false);
        GlytoucanIDList.paginateFilterAndButton();
        table.getColumnModel().getColumn(0).setMaxWidth(35);
        table.getColumnModel().getColumn(1).setPreferredWidth(200);
        table.getColumnModel().getColumn(2).setPreferredWidth(250);
        table.getColumnModel().getColumn(3).setPreferredWidth(20);
        table.setRowHeight(25);
        table.setSelectionMode(0);
        table.setCellSelectionEnabled(false);
        JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
        mainPanel.add(new JScrollPane(table));
        mainPanel.add((Component)btnpanel, "South");
        return mainPanel;
    }

    private static void paginateFilterAndButton() {
        sorter.setRowFilter(new RowFilter<TableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
                int ei;
                int ti = currentPageIndex - 1;
                return ti * 10 <= (ei = entry.getIdentifier().intValue()) && ei < ti * 10 + 10;
            }
        });
        firstbtn.setEnabled(currentPageIndex > 1);
        prevbtn.setEnabled(currentPageIndex > 1);
        nextbtn.setEnabled(currentPageIndex < maxPageIndex);
        lastbtn.setEnabled(currentPageIndex < maxPageIndex);
        label.setText(Integer.toString(currentPageIndex));
    }

    public static void getGlytoucanID() throws Exception {
        String[] strArray;
        int k;
        File glycanIDDirectory = GlycanStructureAndChangeUser.getConfigurationDirectory();
        File glytoucanIDFilepath = new File(glycanIDDirectory.getPath() + File.separator + "glytoucanIdList.csv");
        CSVReader reader = GlycanStructureAndChangeUser.readCSVFile();
        List<String[]> csvBody = reader.readAll();
        File idlistBackupFile = null;
        String glytoucanId = null;
        ArrayList<String> testOrRealArr = new ArrayList<String>();
        ArrayList<String> hashKeyArr = new ArrayList<String>();
        ArrayList<String> glycanArr = new ArrayList<String>();
        ArrayList<String> csvIdArr = new ArrayList<String>();
        ArrayList<String> csvTestRealArr = new ArrayList<String>();
        ArrayList<String> csvHashKeyArr = new ArrayList<String>();
        csvIdArr.clear();
        csvHashKeyArr.clear();
        csvTestRealArr.clear();
        String glycan = "";
        for (k = 0; k < csvBody.size(); ++k) {
            strArray = csvBody.get(k);
            if (strArray[0].length() <= 10 || testOrRealArr.contains(strArray[2].toString() + "," + strArray[0].toString())) continue;
            hashKeyArr.add(strArray[0].toString());
            testOrRealArr.add(strArray[2].toString() + "," + strArray[0].toString());
        }
        for (int i = 0; i < hashKeyArr.size(); ++i) {
            csvHashKeyArr.add((String)hashKeyArr.get(i));
            String strTestOrReal = ((String)testOrRealArr.get(i)).split(",")[0];
            csvTestRealArr.add(strTestOrReal);
            StringBuilder outputString = new StringBuilder();
            String apiUrl = strTestOrReal.equalsIgnoreCase("beta") ? accessionIdByHashKeyBetaApi : accessionIdByHashKeyRealApi;
            if (!GlytoucanIDList.getAccessionIdByHashKey(apiUrl, (String)hashKeyArr.get(i), outputString)) {
                return;
            }
            glytoucanId = outputString.toString();
            csvIdArr.add(glytoucanId);
            glycanArr.add(glytoucanId);
        }
        idlistBackupFile = new File(glycanIDDirectory.getPath() + File.separator + "glytoucanIdListOldDataBackup.csv");
        if (!idlistBackupFile.exists()) {
            FileUtils.copy(glytoucanIDFilepath, idlistBackupFile);
        }
        for (k = 0; k < csvBody.size(); ++k) {
            strArray = csvBody.get(k);
            for (int j = 0; j < strArray.length; ++j) {
                for (int l = 0; l < csvHashKeyArr.size(); ++l) {
                    if (!strArray[0].equals(csvHashKeyArr.get(l)) || !strArray[2].equalsIgnoreCase((String)csvTestRealArr.get(l))) continue;
                    strArray[0] = (String)csvIdArr.get(l);
                }
            }
        }
        csvHashKeyArr.clear();
        csvIdArr.clear();
        csvTestRealArr.clear();
        reader.close();
        CSVWriter writer = new CSVWriter(new FileWriter(glytoucanIDFilepath));
        writer.writeAll(csvBody);
        writer.flush();
        writer.close();
        Long beforecount = GlytoucanIDList.countLineCSV(idlistBackupFile + "");
        Long aftercount = GlytoucanIDList.countLineCSV(glytoucanIDFilepath + "");
        if (beforecount != aftercount) {
            glytoucanIDFilepath.delete();
            idlistBackupFile.renameTo(new File(glycanIDDirectory.getPath() + File.separator + "glytoucanIdList.csv"));
        } else {
            idlistBackupFile.delete();
        }
        for (int g = glycanArr.size() - 1; g > -1; --g) {
            glycan = ((String)glycanArr.get(g)).length() < 10 ? glycan + "Accession ID of \"" + (String)hashKeyArr.get(g) + " \" is \"" + (String)glycanArr.get(g) + "\"\n" : glycan + "Accession ID of \"" + (String)hashKeyArr.get(g) + "\" is not avaliable now.\n";
        }
        if (!glycan.equals("") && glycanArr.size() > 0) {
            JOptionPane.showMessageDialog(null, glycan, "Accession ID", 1, null);
            glycan = "";
            glycanArr.clear();
            model.setRowCount(0);
            model = GlytoucanIDList.readCSV();
            model.fireTableDataChanged();
            table.repaint();
            table.setModel(model);
            table.setVisible(true);
            table.updateUI();
            sorter = new TableRowSorter<DefaultTableModel>(model);
            table.setRowSorter(sorter);
            GlytoucanIDList.paginateFilterAndButton();
            table.getColumnModel().getColumn(0).setMaxWidth(35);
            table.getColumnModel().getColumn(1).setPreferredWidth(200);
            table.getColumnModel().getColumn(2).setPreferredWidth(250);
            table.getColumnModel().getColumn(3).setPreferredWidth(20);
            table.setRowHeight(25);
        }
    }

    private static boolean getAccessionIdByHashKey(String apiUrl, String hashKey, StringBuilder outputString) {
        try {
            String glytoucanId = hashKey;
            HttpResponse<JsonNode> jsonResponse = Unirest.get(apiUrl + hashKey).header("accept", "application/json").header("Content-Type", "application/json").asJson();
            JSONArray jsonarr = jsonResponse.getBody().getObject().getJSONArray("results");
            if (jsonarr.length() > 0) {
                for (Object o : jsonarr) {
                    JSONObject jsonLineItem = (JSONObject)o;
                    String accession = jsonLineItem.getString("accession");
                    if (accession.isEmpty() || accession.length() >= 10) continue;
                    glytoucanId = accession;
                }
            }
            outputString.append(glytoucanId);
            return true;
        }
        catch (UnirestException e) {
            if (e.getMessage().contains("org.apache.http.conn.HttpHostConnectException")) {
                JOptionPane.showMessageDialog(null, "Server service is unavailable now", "Server Error!", 2);
            } else {
                JOptionPane.showMessageDialog(null, "Please, check your internet connection again!", "Connection Error", 0);
            }
            return false;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "UnExecpted error occur.\nPlease Try again your process!", "UnExecpted Error", 0);
            return false;
        }
    }

    static {
        currentPageIndex = 1;
        model = GlytoucanIDList.readCSV();
        sorter = new TableRowSorter<DefaultTableModel>(GlytoucanIDList.readCSV());
        table = new JTable();
        label = new JLabel();
        firstbtn = new JButton(new AbstractAction("|<"){

            @Override
            public void actionPerformed(ActionEvent e) {
                currentPageIndex = 1;
                GlytoucanIDList.paginateFilterAndButton();
            }
        });
        prevbtn = new JButton(new AbstractAction("<"){

            @Override
            public void actionPerformed(ActionEvent e) {
                currentPageIndex -= 1;
                GlytoucanIDList.paginateFilterAndButton();
            }
        });
        nextbtn = new JButton(new AbstractAction(">"){

            @Override
            public void actionPerformed(ActionEvent e) {
                currentPageIndex += 1;
                GlytoucanIDList.paginateFilterAndButton();
            }
        });
        lastbtn = new JButton(new AbstractAction(">|"){

            @Override
            public void actionPerformed(ActionEvent e) {
                currentPageIndex = maxPageIndex;
                GlytoucanIDList.paginateFilterAndButton();
            }
        });
    }
}

