/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.util.Iterator;
import java.util.LinkedList;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.util.GlycanUndoRedoEvent;
import org.eurocarbdb.application.glycanbuilder.util.GlycanUndoRedoListener;

public class GlycanUndoManager
implements BaseDocument.DocumentChangeListener {
    private static final int MAXIMUM_NUMBER_OF_STATES = 50;
    protected BaseDocument theDoc = null;
    protected boolean doing = false;
    protected int cur_state = -1;
    protected int no_actions = 0;
    protected boolean was_changed = false;
    protected LinkedList<String> states = new LinkedList();
    protected LinkedList<GlycanUndoRedoListener> listeners = new LinkedList();

    public GlycanUndoManager(BaseDocument _theDoc) {
        this.theDoc = _theDoc;
        this.theDoc.addDocumentChangeListener(this);
        this.reset();
    }

    public void addUndoRedoListener(GlycanUndoRedoListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public void removeUndoRedoListener(GlycanUndoRedoListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    public void reset() {
        this.states.clear();
        this.states.add(this.theDoc.toString());
        this.cur_state = 0;
        this.no_actions = 0;
        this.was_changed = this.theDoc.hasChanged();
    }

    public boolean canUndo() {
        return this.cur_state > 0;
    }

    public void undo() throws Exception {
        if (this.cur_state <= 0) {
            return;
        }
        this.doing = true;
        --this.cur_state;
        --this.no_actions;
        this.theDoc.fill(this.states.get(this.cur_state), this.no_actions == 0 && !this.was_changed);
        this.doing = false;
        this.fireUndoRedoAction(true);
    }

    public boolean canRedo() {
        return this.cur_state < this.states.size() - 1;
    }

    public void redo() throws Exception {
        if (this.cur_state >= this.states.size() - 1) {
            return;
        }
        this.doing = true;
        ++this.cur_state;
        ++this.no_actions;
        this.theDoc.fill(this.states.get(this.cur_state), false);
        this.doing = false;
        this.fireUndoRedoAction(false);
    }

    public boolean isChanged() {
        if (this.cur_state >= 0) {
            String cur_state_str;
            String last_state_str = this.states.get(this.cur_state);
            return !last_state_str.equals(cur_state_str = this.theDoc.toString());
        }
        return true;
    }

    public void fireUndoRedoAction(boolean is_undo) {
        GlycanUndoRedoEvent e = new GlycanUndoRedoEvent(this, is_undo);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((GlycanUndoRedoListener)i.next()).undoRedoHappened(e);
        }
    }

    @Override
    public void documentInit(BaseDocument.DocumentChangeEvent e) {
        if (e.getSource() == this.theDoc) {
            this.reset();
        }
    }

    @Override
    public void documentChanged(BaseDocument.DocumentChangeEvent e) {
        if (e.getSource() == this.theDoc && !this.doing && this.isChanged()) {
            while (this.cur_state < this.states.size() - 1) {
                this.states.removeLast();
            }
            this.states.addLast(this.theDoc.toString());
            while (this.states.size() > 50) {
                this.states.removeFirst();
            }
            this.cur_state = this.states.size() - 1;
            ++this.no_actions;
        }
    }
}

