/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.eurocarbdb.application.glycanbuilder.BuilderWorkspace;
import org.eurocarbdb.application.glycanbuilder.CoreType;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.GlycanAction;
import org.eurocarbdb.application.glycanbuilder.GlycanCanvas;
import org.eurocarbdb.application.glycanbuilder.GlycanDocument;
import org.eurocarbdb.application.glycanbuilder.ICON_SIZE;
import org.eurocarbdb.application.glycanbuilder.ThemeManager;
import org.eurocarbdb.application.glycanbuilder.converter.GlycanParserFactory;
import org.eurocarbdb.application.glycanbuilder.dataset.CoreDictionary;
import org.eurocarbdb.application.glycanbuilder.logutility.LogUtils;
import org.eurocarbdb.application.glycanbuilder.renderutil.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.renderutil.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.util.ActionManager;
import org.eurocarbdb.application.glycanbuilder.util.MouseUtils;

public class GlycanBuilderApplet
extends JApplet
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 0L;
    protected BuilderWorkspace theWorkspace;
    protected GlycanDocument theDoc;
    protected ActionManager theActionManager;
    protected JMenuBar theMenuBar;
    protected JToolBar theToolBarFile;
    protected JPanel theToolBarPanel;
    protected GlycanCanvas theCanvas;
    private ThemeManager theThemeManager;
    private static final int MOD_MASK = 47;

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.black);
        int width = this.getSize().width;
        int height = this.getSize().height;
        g.drawRect(0, 0, width - 1, height - 1);
        g.drawRect(1, 1, width - 3, height - 3);
    }

    @Override
    public Insets getInsets() {
        return new Insets(2, 2, 2, 2);
    }

    @Override
    public void init() {
        super.init();
        try {
            this.theThemeManager = new ThemeManager(null, this.getClass());
            try {
                this.theThemeManager.addIconPath("/icons/glycan_builder", this.getClass());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.theThemeManager.addIconPath("/icons/crystal_project", this.getClass());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            FileUtils.themeManager = this.theThemeManager;
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        ThemeManager.lookupNoneCached = false;
        LogUtils.setGraphicalReport(true);
        String residueTypesFile = this.getParameter("residueTypesFile");
        String terminalTypesFile = this.getParameter("terminalTypesFile");
        String coreTypesFile = this.getParameter("coreTypesFile");
        String crossRingFragmentTypesFile = this.getParameter("crossRingFragmentTypesFile");
        String SkeletonCodeDictionaryFile = this.getParameter("SkeletonCodeDictionaryFile");
        this.theWorkspace = new BuilderWorkspace(null, false, new GlycanRendererAWT(), residueTypesFile, terminalTypesFile, coreTypesFile, crossRingFragmentTypesFile);
        this.theDoc = this.theWorkspace.getStructures();
        this.theActionManager = new ActionManager();
        this.createActions();
        if (this.getParameter("NOTATION") != null) {
            this.theWorkspace.setNotation(this.getParameter("NOTATION"));
        }
        if (this.getParameter("DISPLAY") != null) {
            this.theWorkspace.setDisplay(this.getParameter("DISPLAY"));
        }
        try {
            this.createUI();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        if (this.getParameter("DOCUMENT") != null) {
            this.setDocument(this.getParameter("DOCUMENT"));
        }
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    protected void createUI() throws MalformedURLException {
        String allowMultipleStructuresString;
        String allowRepeatingUnitsString;
        this.theCanvas = new GlycanCanvas(null, this.theWorkspace, this.theThemeManager, false);
        String allowUncertainTerminalsString = this.getParameter("allowUncertainTerminals");
        if (allowUncertainTerminalsString != null) {
            this.theCanvas.setAllowUncertainTerminals(Boolean.parseBoolean(allowUncertainTerminalsString));
        }
        if ((allowRepeatingUnitsString = this.getParameter("allowRepeatingUnits")) != null) {
            this.theCanvas.setAllowRepeatingUnits(Boolean.parseBoolean(allowRepeatingUnitsString));
        }
        if ((allowMultipleStructuresString = this.getParameter("allowMultipleStructures")) != null) {
            this.theCanvas.setAllowMultipleStructures(Boolean.parseBoolean(allowMultipleStructuresString));
        }
        this.getContentPane().setLayout(new BorderLayout());
        UIManager.getDefaults().put("ToolTip.hideAccelerator", Boolean.TRUE);
        this.theToolBarPanel = new JPanel(new BorderLayout());
        this.theToolBarFile = this.createToolBarFile();
        JPanel northTbPanel = new JPanel();
        northTbPanel.setLayout(new BoxLayout(northTbPanel, 0));
        northTbPanel.add(this.theToolBarFile);
        northTbPanel.add(this.theCanvas.getToolBarDocument());
        this.theToolBarPanel.add((Component)northTbPanel, "North");
        this.theToolBarPanel.add((Component)this.theCanvas.getToolBarStructure(), "Center");
        this.theToolBarPanel.add((Component)this.theCanvas.getToolBarProperties(), "South");
        this.getContentPane().add((Component)this.theToolBarPanel, "North");
        this.theMenuBar = this.createMenuBar();
        this.setJMenuBar(this.theMenuBar);
        JScrollPane sp = new JScrollPane(this.theCanvas);
        this.theCanvas.setScrollPane(sp);
        this.getContentPane().add((Component)sp, "Center");
        this.onNew();
    }

    public BuilderWorkspace getWorkspace() {
        return this.theWorkspace;
    }

    public GlycanRenderer getGlycanRenderer() {
        return this.theWorkspace.getGlycanRenderer();
    }

    public GlycanCanvas getCanvas() {
        return this.theCanvas;
    }

    private void createActions() {
        this.theActionManager.add("empty", ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), "Empty", -1, "", (ActionListener)this);
        for (CoreType t : CoreDictionary.getCores()) {
            this.theActionManager.add("new=" + t.getName(), ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), t.getDescription(), -1, "", (ActionListener)this);
        }
        this.theActionManager.add("new", FileUtils.themeManager.getImageIcon("new"), "New", 78, "ctrl N", (ActionListener)this);
        this.theActionManager.add("print", FileUtils.themeManager.getImageIcon("print"), "Print...", 80, "ctrl P", (ActionListener)this);
        this.theActionManager.add("about", FileUtils.themeManager.getImageIcon("about"), "About", 66, "", (ActionListener)this);
    }

    private JMenu createNewDocumentMenu() {
        JMenu new_menu = new JMenu("New");
        new_menu.setIcon(FileUtils.themeManager.getImageIcon("new"));
        new_menu.add(this.theActionManager.get("empty"));
        for (String superclass : CoreDictionary.getSuperclasses()) {
            JMenu class_menu = new JMenu(superclass);
            for (CoreType t : CoreDictionary.getCores(superclass)) {
                class_menu.add(this.theActionManager.get("new=" + t.getName()));
            }
            if (class_menu.getItemCount() <= 0) continue;
            new_menu.add(class_menu);
        }
        return new_menu;
    }

    private JMenuBar createMenuBar() {
        JMenuBar menubar = new JMenuBar();
        JMenu file_menu = new JMenu("File");
        file_menu.setMnemonic(70);
        file_menu.add(this.createNewDocumentMenu());
        file_menu.addSeparator();
        file_menu.add(this.theActionManager.get("print"));
        menubar.add(file_menu);
        menubar.add(this.theCanvas.getEditMenu());
        menubar.add(this.theCanvas.getStructureMenu());
        menubar.add(this.theCanvas.getViewMenu());
        JMenu help_menu = new JMenu("Help");
        help_menu.setMnemonic(72);
        help_menu.add(this.theActionManager.get("about"));
        menubar.add(help_menu);
        return menubar;
    }

    protected JPopupMenu createPopupMenu() {
        return this.theCanvas.createPopupMenu();
    }

    private JToolBar createToolBarFile() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add(this.theActionManager.get("new"));
        toolbar.addSeparator();
        toolbar.add(this.theActionManager.get("print"));
        return toolbar;
    }

    private String askName(String what) {
        return JOptionPane.showInputDialog(this, "Insert " + what + " name:", "", 3);
    }

    public void onNew() {
        this.theDoc.init();
    }

    public void onNew(String name) {
        try {
            this.theDoc.init();
            if (name != null && name.length() > 0) {
                this.theDoc.addStructure(CoreDictionary.newCore(name));
                this.theDoc.setChanged(false);
            }
        }
        catch (Exception e) {
            LogUtils.report(e);
        }
    }

    public void onPrint() {
        try {
            PrinterJob pj = this.theWorkspace.getPrinterJob();
            if (pj != null) {
                pj.setPrintable(this.theCanvas);
                if (pj.printDialog()) {
                    this.theCanvas.print(pj);
                }
            }
        }
        catch (Exception e) {
            LogUtils.report(e);
        }
    }

    public void onAbout() {
        try {
            JDialog dlg = new JDialog((Frame)null, "About GlycanBuilder2", true);
            JEditorPane html = new JEditorPane(GlycanBuilderApplet.class.getResource("/html/about_builder.html"));
            html.setEditable(false);
            html.setBorder(new EmptyBorder(20, 20, 20, 20));
            dlg.add(html);
            dlg.setSize(320, 340);
            dlg.setResizable(false);
            dlg.setLocationRelativeTo(this);
            dlg.setVisible(true);
        }
        catch (Exception e) {
            LogUtils.report(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (MouseUtils.isPopupTrigger(e)) {
            this.theCanvas.enforceSelection(e.getPoint());
            this.createPopupMenu().show(this.theCanvas, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (MouseUtils.isPopupTrigger(e)) {
            this.theCanvas.enforceSelection(e.getPoint());
            this.createPopupMenu().show(this.theCanvas, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public boolean isActive() {
        return super.isActive();
    }

    public String getDocument() {
        if (this.theDoc.getNoStructures() == 0) {
            return "";
        }
        return this.theDoc.toString();
    }

    public String getDocument(String format) {
        if (this.theDoc.getNoStructures() == 0) {
            return "";
        }
        return this.theDoc.toString(format);
    }

    public String getCurrentCoordinates(String format) {
        return this.theDoc.toStringWithCoordinates(format, this.theCanvas.theBBoxManager);
    }

    public void setDocument(String src, String format) {
        try {
            this.theDoc.init();
            this.theDoc.fromString(src, format);
            this.theDoc.setChanged(false);
        }
        catch (Exception e) {
            LogUtils.report(e);
        }
    }

    public void setDocument(String src) {
        this.setDocument(src, "gws");
    }

    public void setDocumentFromUrl(String url, String format) {
        try {
            this.theDoc.init();
            this.theDoc.fromURL(url, format);
            this.theDoc.setChanged(false);
        }
        catch (Exception e) {
            LogUtils.report(e);
        }
    }

    public boolean getShowInfo() {
        return this.theWorkspace.getGraphicOptions().SHOW_INFO;
    }

    public boolean getShowMassesCanvas() {
        return this.theWorkspace.getGraphicOptions().SHOW_MASSES_CANVAS;
    }

    public boolean getShowMasses() {
        return this.theWorkspace.getGraphicOptions().SHOW_MASSES;
    }

    public void setShowRedendCanvas(boolean f) {
        this.theCanvas.setShowRedendCanvas(f);
    }

    public boolean getShowRedendCanvas() {
        return this.theWorkspace.getGraphicOptions().SHOW_REDEND_CANVAS;
    }

    public boolean getShowRedend() {
        return this.theWorkspace.getGraphicOptions().SHOW_REDEND;
    }

    public int getOrientation() {
        return this.theWorkspace.getGraphicOptions().ORIENTATION;
    }

    public String getNotation() {
        return this.theWorkspace.getGraphicOptions().NOTATION;
    }

    public void setNotation(String notation) {
        this.theCanvas.setNotation(notation);
    }

    public String getDisplay() {
        return this.theWorkspace.getGraphicOptions().DISPLAY;
    }

    public void setDisplay(String display) {
        this.theCanvas.setDisplay(display);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = GlycanAction.getAction(e);
        String param = GlycanAction.getParam(e);
        if (action.equals("empty")) {
            this.onNew();
        } else if (action.equals("new")) {
            this.onNew(param);
        } else if (action.equals("print")) {
            this.onPrint();
        } else if (action.equals("about")) {
            this.onAbout();
        }
    }

    public Set<String> getImportFormats() {
        return GlycanParserFactory.getImportFormats().keySet();
    }

    public Set<String> getExportFormats() {
        return GlycanDocument.getExportFormats().keySet();
    }
}

