/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import chrriis.dj.nativeswing.swtimpl.NativeInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.BuilderWorkspace;
import org.eurocarbdb.application.glycanbuilder.ContextAwareContainer;
import org.eurocarbdb.application.glycanbuilder.CoreType;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.GlycanAction;
import org.eurocarbdb.application.glycanbuilder.GlycanCanvas;
import org.eurocarbdb.application.glycanbuilder.GlycanDocument;
import org.eurocarbdb.application.glycanbuilder.ICON_SIZE;
import org.eurocarbdb.application.glycanbuilder.Monitor;
import org.eurocarbdb.application.glycanbuilder.ThemeManager;
import org.eurocarbdb.application.glycanbuilder.converter.GlycanParserFactory;
import org.eurocarbdb.application.glycanbuilder.dataset.CoreDictionary;
import org.eurocarbdb.application.glycanbuilder.fileutil.ExtensionFileFilter;
import org.eurocarbdb.application.glycanbuilder.fileutil.FileHistory;
import org.eurocarbdb.application.glycanbuilder.logutility.LogUtils;
import org.eurocarbdb.application.glycanbuilder.renderutil.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.renderutil.SVGUtils;
import org.eurocarbdb.application.glycanbuilder.util.ActionManager;
import org.eurocarbdb.application.glycanbuilder.util.MouseUtils;

public class GlycanBuilder
extends JFrame
implements ActionListener,
BaseDocument.DocumentChangeListener,
FileHistory.Listener,
MouseListener {
    private static final long serialVersionUID = 0L;
    protected BuilderWorkspace theWorkspace;
    protected GlycanDocument theDoc;
    protected ActionManager theActionManager;
    protected JMenuBar theMenuBar;
    protected JToolBar theToolBarFile;
    protected JPanel theToolBarPanel;
    protected GlycanCanvas theCanvas;
    protected JMenu recent_files_menu;
    protected String last_exported_file = null;
    private Monitor halt_interactions = null;
    protected Set<ContextAwareContainer> contextAwareListeners;

    public GlycanBuilder() throws MalformedURLException {
        ThemeManager themeManager = new ThemeManager(null, this.getClass());
        ThemeManager.lookupNoneCached = false;
        FileUtils.themeManager = themeManager;
        try {
            themeManager.addIconPath("/icons/glycan_builder", this.getClass());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            themeManager.addIconPath("/icons/crystal_project", this.getClass());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LogUtils.setReportOwner(this);
        LogUtils.setGraphicalReport(true);
        String resource = "/config.xml";
        this.theWorkspace = new BuilderWorkspace(resource, true, new GlycanRendererAWT());
        this.theWorkspace.setAutoSave(true);
        this.theDoc = this.theWorkspace.getStructures();
        this.theActionManager = new ActionManager();
        this.halt_interactions = new Monitor(this);
        this.createActions();
        this.getContentPane().setLayout(new BorderLayout());
        this.theCanvas = new GlycanCanvas(this, this.theWorkspace, themeManager, false);
        UIManager.getDefaults().put("ToolTip.hideAccelerator", Boolean.TRUE);
        this.theToolBarPanel = new JPanel(new BorderLayout());
        this.theToolBarFile = this.createToolBarFile();
        JPanel northTbPanel = new JPanel();
        northTbPanel.setLayout(new BoxLayout(northTbPanel, 0));
        northTbPanel.add(this.theToolBarFile);
        northTbPanel.add(this.theCanvas.getToolBarDocument());
        this.theToolBarPanel.add((Component)northTbPanel, "North");
        this.theToolBarPanel.add((Component)this.theCanvas.getToolBarStructure(), "Center");
        this.theToolBarPanel.add((Component)this.theCanvas.getToolBarProperties(), "South");
        this.getContentPane().add((Component)this.theToolBarPanel, "North");
        this.theMenuBar = this.createMenuBar();
        this.setJMenuBar(this.theMenuBar);
        JScrollPane sp = new JScrollPane(this.theCanvas);
        this.theCanvas.setScrollPane(sp);
        this.getContentPane().add((Component)sp, "Center");
        this.theDoc.addDocumentChangeListener(this);
        this.theCanvas.addMouseListener(this);
        this.theWorkspace.addDocumentChangeListener(this);
        this.theWorkspace.getFileHistory().addHistoryChangedListener(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                GlycanBuilder.this.onExit();
            }
        });
        this.setIconImage(FileUtils.themeManager.getImageIcon("logo").getImage());
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
        this.onNew(this.theDoc);
        this.theWorkspace.setChanged(false);
        this.updateActions();
        NativeInterface.open();
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
    }

    public void exit(int err_level) {
        String resource = "./config.xml";
        this.theWorkspace.init();
        System.gc();
        System.runFinalization();
        System.exit(err_level);
    }

    public BuilderWorkspace getWorkspace() {
        return this.theWorkspace;
    }

    public GlycanCanvas getCanvas() {
        return this.theCanvas;
    }

    public void haltInteractions() {
        if (this.halt_interactions.isFree()) {
            Component glassPane = this.getGlassPane();
            glassPane.addMouseListener(new MouseAdapter(){});
            glassPane.setCursor(Cursor.getPredefinedCursor(3));
            glassPane.setVisible(true);
        }
        this.halt_interactions.hold();
    }

    public void restoreInteractions() {
        this.halt_interactions.release();
        if (this.halt_interactions.isFree()) {
            this.getGlassPane().setVisible(false);
        }
    }

    private void createActions() {
        this.theActionManager.add("empty", ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), "Empty", -1, "", (ActionListener)this);
        for (CoreType coreType : CoreDictionary.getCores()) {
            this.theActionManager.add("new=" + coreType.getName(), ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), coreType.getDescription(), -1, "", (ActionListener)this);
        }
        this.theActionManager.add("new", FileUtils.themeManager.getImageIcon("new"), "New", 78, "ctrl N", (ActionListener)this);
        this.theActionManager.add("open", FileUtils.themeManager.getImageIcon("open"), "Open document...", 79, "ctrl O", (ActionListener)this);
        this.theActionManager.add("openinto", FileUtils.themeManager.getImageIcon("openinto"), "Open additional document...", 73, "ctrl I", (ActionListener)this);
        this.theActionManager.add("save", FileUtils.themeManager.getImageIcon("save"), "Save", 83, "ctrl S", (ActionListener)this);
        this.theActionManager.add("saveas", FileUtils.themeManager.getImageIcon("saveas"), "Save as...", 65, "shift ctrl S", (ActionListener)this);
        this.theActionManager.add("print", FileUtils.themeManager.getImageIcon("print"), "Print...", 80, "ctrl P", (ActionListener)this);
        this.theActionManager.add("quit", FileUtils.themeManager.getImageIcon("quit"), "Quit", 81, "ctrl Q", (ActionListener)this);
        for (Map.Entry entry : GlycanDocument.getImportFormats().entrySet()) {
            this.theActionManager.add("import=" + (String)entry.getKey(), ThemeManager.getEmptyIcon(null), "Import from " + (String)entry.getValue() + "...", -1, "", (ActionListener)this);
        }
        for (Map.Entry entry : GlycanDocument.getExportFormats().entrySet()) {
            this.theActionManager.add("export=" + (String)entry.getKey(), ThemeManager.getEmptyIcon(null), "Export to " + (String)entry.getValue() + "...", -1, "", (ActionListener)this);
        }
        for (Map.Entry entry : SVGUtils.getExportFormats().entrySet()) {
            this.theActionManager.add("export=" + (String)entry.getKey(), ThemeManager.getEmptyIcon(null), "Export to " + (String)entry.getValue() + "...", -1, "", (ActionListener)this);
        }
        this.theActionManager.add("about", FileUtils.themeManager.getImageIcon("about"), "About", 66, "", (ActionListener)this);
    }

    private void updateActions() {
        this.theActionManager.get("save").setEnabled(this.theDoc.hasChanged());
    }

    private void updateRecentFileMenu() {
        this.recent_files_menu.removeAll();
        FileHistory theFileHistory = this.theWorkspace.getFileHistory();
        Iterator<String> i = theFileHistory.iterator();
        while (i.hasNext()) {
            String file_path = i.next();
            String file_type = theFileHistory.getFileType(file_path);
            JMenuItem mi = new JMenuItem(FileHistory.getAbbreviatedName(file_path));
            if (file_type.equals("Workspace")) {
                mi.setActionCommand("openall=" + file_path);
            } else if (file_type.equals("Structures")) {
                mi.setActionCommand("openstruct=" + file_path);
            }
            mi.addActionListener(this);
            mi.setToolTipText(file_path);
            this.recent_files_menu.add(mi);
        }
        if (this.recent_files_menu.getItemCount() == 0) {
            this.recent_files_menu.add(new JMenuItem("<empty>"));
        }
    }

    private JMenu createNewDocumentMenu() {
        JMenu new_menu = new JMenu("New");
        new_menu.setMnemonic(78);
        new_menu.setIcon(FileUtils.themeManager.getImageIcon("new"));
        new_menu.add(this.theActionManager.get("empty"));
        for (String superclass : CoreDictionary.getSuperclasses()) {
            JMenu class_menu = new JMenu(superclass);
            for (CoreType core_type : CoreDictionary.getCores(superclass)) {
                class_menu.add(this.theActionManager.get("new=" + core_type.getName()));
            }
            if (class_menu.getItemCount() <= 0) continue;
            new_menu.add(class_menu);
        }
        return new_menu;
    }

    private JMenu createImportSequenceMenu() {
        JMenu import_menu = new JMenu("Import from sequence formats");
        import_menu.setMnemonic(77);
        import_menu.setIcon(FileUtils.themeManager.getImageIcon("import"));
        for (Map.Entry<String, String> e : GlycanDocument.getImportFormats().entrySet()) {
            import_menu.add(this.theActionManager.get("import=" + e.getKey()));
        }
        return import_menu;
    }

    private JMenu createExportSequenceMenu() {
        JMenu export_menu = new JMenu("Export to sequence formats");
        export_menu.setMnemonic(88);
        export_menu.setIcon(FileUtils.themeManager.getImageIcon("export"));
        for (Map.Entry<String, String> e : GlycanDocument.getExportFormats().entrySet()) {
            export_menu.add(this.theActionManager.get("export=" + e.getKey()));
        }
        return export_menu;
    }

    private JMenu createExportDrawingMenu() {
        JMenu export_menu = new JMenu("Export to graphical formats");
        export_menu.setMnemonic(71);
        export_menu.setIcon(FileUtils.themeManager.getImageIcon("export"));
        for (Map.Entry<String, String> e : SVGUtils.getExportFormats().entrySet()) {
            export_menu.add(this.theActionManager.get("export=" + e.getKey()));
        }
        return export_menu;
    }

    private JMenu createFileMenu() {
        this.recent_files_menu = new JMenu("Recent files");
        this.recent_files_menu.setMnemonic(82);
        this.recent_files_menu.setIcon(ThemeManager.getEmptyIcon(null));
        this.updateRecentFileMenu();
        JMenu file_menu = new JMenu("File");
        file_menu.setMnemonic(70);
        file_menu.add(this.createNewDocumentMenu());
        file_menu.add(this.theActionManager.get("open"));
        file_menu.add(this.theActionManager.get("openinto"));
        file_menu.add(this.recent_files_menu);
        file_menu.addSeparator();
        file_menu.add(this.theActionManager.get("save"));
        file_menu.add(this.theActionManager.get("saveas"));
        file_menu.addSeparator();
        file_menu.add(this.createImportSequenceMenu());
        file_menu.add(this.createExportSequenceMenu());
        file_menu.add(this.createExportDrawingMenu());
        file_menu.addSeparator();
        file_menu.add(this.theActionManager.get("print"));
        file_menu.addSeparator();
        file_menu.add(this.theActionManager.get("quit"));
        return file_menu;
    }

    private JMenuBar createMenuBar() {
        JMenuBar menubar = new JMenuBar();
        menubar.add(this.createFileMenu());
        menubar.add(this.theCanvas.getEditMenu());
        menubar.add(this.theCanvas.getStructureMenu());
        menubar.add(this.theCanvas.getViewMenu());
        JMenu help_menu = new JMenu("Help");
        help_menu.setMnemonic(72);
        help_menu.add(this.theActionManager.get("about"));
        menubar.add(help_menu);
        menubar.add(this.theCanvas.getDebugMenu());
        return menubar;
    }

    private JPopupMenu createPopupMenu() {
        return this.theCanvas.createPopupMenu();
    }

    private JToolBar createToolBarFile() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add(this.theActionManager.get("new"));
        toolbar.add(this.theActionManager.get("open"));
        toolbar.add(this.theActionManager.get("openinto"));
        toolbar.add(this.theActionManager.get("save"));
        toolbar.add(this.theActionManager.get("saveas"));
        toolbar.addSeparator();
        toolbar.add(this.theActionManager.get("print"));
        return toolbar;
    }

    private String askName(String what) {
        return JOptionPane.showInputDialog(this, "Insert " + what + " name:", "", 3);
    }

    private void updateTitle() {
        String title = FileHistory.getAbbreviatedName(this.theDoc.getFileName()) + " - GlycanBuilder";
        if (this.theDoc.hasChanged()) {
            title = "* " + title;
        }
        this.setTitle(title);
    }

    private File getLastExportedFile() {
        if (this.last_exported_file != null && this.last_exported_file.length() > 0) {
            return new File(this.last_exported_file);
        }
        return null;
    }

    private void setLastExportedFile(String name) {
        this.last_exported_file = name;
    }

    private boolean checkDocumentChanges(BaseDocument doc) {
        if (doc.hasChanged() && !doc.isEmpty()) {
            int ret = JOptionPane.showConfirmDialog(this, "Save changes to " + doc.getName().toLowerCase() + "?", null, 1, 3);
            if (ret == 2) {
                return false;
            }
            if (ret == 0) {
                return this.onSaveAs(doc);
            }
            return ret == 1;
        }
        return true;
    }

    private boolean checkExisting(String filename) {
        if (!new File(filename).exists()) {
            JOptionPane.showMessageDialog(this, "The file selected is not existing.", "File not found", 0);
            this.theWorkspace.getFileHistory().remove(filename);
            return false;
        }
        return true;
    }

    public boolean onNew(BaseDocument doc) {
        if (doc == null) {
            return false;
        }
        if (!this.checkDocumentChanges(doc)) {
            return false;
        }
        doc.init();
        return true;
    }

    public boolean onNew(String name) {
        try {
            if (!this.checkDocumentChanges(this.theDoc)) {
                return false;
            }
            if (name != null && name.length() > 0) {
                return this.theDoc.init(CoreDictionary.getCoreType(name).getStructure());
            }
            this.theDoc.init();
            return true;
        }
        catch (Exception e) {
            LogUtils.report(e);
            return false;
        }
    }

    private boolean onOpenDocument(Collection<BaseDocument> documents, boolean merge) {
        if (documents == null || documents.size() == 0) {
            return false;
        }
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(false);
        HashMap<FileFilter, BaseDocument> all_ff = new HashMap<FileFilter, BaseDocument>();
        for (BaseDocument doc : documents) {
            FileFilter ff = doc.getAllFileFormats();
            fileChooser.addChoosableFileFilter(ff);
            all_ff.put(ff, doc);
        }
        fileChooser.setCurrentDirectory(this.theWorkspace.getFileHistory().getRecentFolder());
        if (fileChooser.showOpenDialog(this) != 0) {
            return false;
        }
        String filename = fileChooser.getSelectedFile().getAbsolutePath();
        BaseDocument document = (BaseDocument)all_ff.get(fileChooser.getFileFilter());
        return this.onOpen(filename, document, merge);
    }

    private boolean onOpen(String filename, BaseDocument doc, boolean merge) {
        if (doc == null) {
            return false;
        }
        if (filename == null) {
            if (doc.getFileFormats().size() == 0) {
                return false;
            }
            JFileChooser fileChooser = new JFileChooser();
            for (FileFilter ff : doc.getFileFormats()) {
                fileChooser.addChoosableFileFilter(ff);
            }
            fileChooser.setCurrentDirectory(this.theWorkspace.getFileHistory().getRecentFolder());
            if (fileChooser.showOpenDialog(this) != 0) {
                return false;
            }
            filename = fileChooser.getSelectedFile().getAbsolutePath();
        }
        if (!this.checkExisting(filename)) {
            return false;
        }
        if (filename.equals(doc.getFileName())) {
            if (!doc.hasChanged()) {
                return false;
            }
            int retValue = JOptionPane.showOptionDialog(this, "Reload document from the file: " + filename + "?", "Load document", 1, 3, null, null, null);
            if (retValue != 0) {
                return false;
            }
        } else if (!this.checkDocumentChanges(doc)) {
            return false;
        }
        this.haltInteractions();
        if (!doc.open(filename, merge, true)) {
            this.restoreInteractions();
            return false;
        }
        this.restoreInteractions();
        this.theWorkspace.getFileHistory().add(filename, doc.getName());
        return true;
    }

    public boolean onSave(BaseDocument doc) {
        return this.onSave(doc, true);
    }

    public boolean onSave(BaseDocument doc, boolean ask_filename) {
        if (doc == null) {
            return false;
        }
        File cur = doc.getFile();
        if (cur != null && cur.canWrite()) {
            doc.save(cur.getAbsolutePath());
            return true;
        }
        if (ask_filename) {
            return this.onSaveAs(doc);
        }
        return false;
    }

    public boolean onSaveAs(BaseDocument doc) {
        if (doc == null) {
            return false;
        }
        JFileChooser fileChooser = new JFileChooser();
        for (FileFilter ff : doc.getFileFormats()) {
            fileChooser.addChoosableFileFilter(ff);
        }
        fileChooser.setCurrentDirectory(this.theWorkspace.getFileHistory().getRecentFolder());
        if (fileChooser.showSaveDialog(this) == 0) {
            int retValue;
            File file;
            FileFilter ff;
            String filename = fileChooser.getSelectedFile().getAbsolutePath();
            ff = fileChooser.getFileFilter();
            if (ff != fileChooser.getAcceptAllFileFilter() && ff instanceof ExtensionFileFilter) {
                filename = FileUtils.enforceExtension(filename, ((ExtensionFileFilter)ff).getDefaultExtension());
            }
            if ((file = new File(filename)).exists() && (retValue = JOptionPane.showOptionDialog(this, "File exists. Overwrite file: " + filename + "?", "Salva documento", 1, 3, null, null, null)) != 0) {
                return false;
            }
            if (!doc.save(filename)) {
                return false;
            }
            this.theWorkspace.getFileHistory().add(filename, doc.getName());
            return true;
        }
        return false;
    }

    public boolean onImportFrom(String format) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(this.theWorkspace.getFileHistory().getRecentFolder());
        if (fileChooser.showOpenDialog(this) != 0) {
            return false;
        }
        String filename = fileChooser.getSelectedFile().getAbsolutePath();
        if (!this.checkExisting(filename)) {
            return false;
        }
        return this.theDoc.importFrom(filename, format);
    }

    public boolean onExportTo(String format) {
        if (this.theDoc.getStructures().size() > 1) {
            int retValue;
            if (!GlycanDocument.supportMultipleStructures(format) && (retValue = JOptionPane.showOptionDialog(this, "The selected format does not support multiple structures.\nOnly the first structure will be exported. Continue?", "Cannot export all structures", 0, 2, null, null, null)) != 0) {
                return false;
            }
        }
        JFileChooser fileChooser = new JFileChooser();
        if (GlycanParserFactory.getExportFormats().containsKey(format)) {
            fileChooser.addChoosableFileFilter(new ExtensionFileFilter("txt", "Glycan text"));
        } else {
            fileChooser.addChoosableFileFilter(new ExtensionFileFilter(format, "Graphic image"));
        }
        fileChooser.setCurrentDirectory(this.theWorkspace.getFileHistory().getRecentFolder());
        int returnVal = fileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            int retValue;
            String filename = fileChooser.getSelectedFile().getAbsolutePath();
            File file = new File(filename = FileUtils.enforceExtension(filename, format));
            if (file.exists() && (retValue = JOptionPane.showOptionDialog(this, "File exists. Overwrite file: " + filename + "?", "Salva documento", 1, 3, null, null, null)) != 0) {
                return false;
            }
            if (GlycanDocument.isSequenceFormat(format)) {
                if (this.theDoc.exportTo(filename, format)) {
                    this.setLastExportedFile(filename);
                }
                return true;
            }
            if (SVGUtils.export((GlycanRendererAWT)this.theWorkspace.getGlycanRenderer(), filename, this.theDoc.getStructures(), this.theWorkspace.getGraphicOptions().SHOW_MASSES, this.theWorkspace.getGraphicOptions().SHOW_REDEND, format)) {
                this.setLastExportedFile(filename);
                return true;
            }
        }
        return false;
    }

    public void onPrint() {
        try {
            PrinterJob pj = this.theWorkspace.getPrinterJob();
            if (pj != null) {
                pj.setPrintable(this.theCanvas);
                if (pj.printDialog()) {
                    this.theCanvas.print(pj);
                }
            }
        }
        catch (Exception e) {
            LogUtils.report(e);
        }
    }

    public void onExit() {
        if (this.checkDocumentChanges(this.theDoc)) {
            this.exit(0);
        }
    }

    public void onAbout() {
        try {
            JDialog dlg = new JDialog(this, "About GlycanBuilder2", true);
            JEditorPane html = new JEditorPane(this.getClass().getResource("/html/about_builder.html"));
            html.setEditable(false);
            html.setBorder(new EmptyBorder(0, 20, 20, 20));
            JScrollPane jscPane = new JScrollPane(html);
            dlg.add(jscPane);
            dlg.setSize(320, 350);
            dlg.setResizable(true);
            dlg.setLocationRelativeTo(this);
            dlg.setVisible(true);
        }
        catch (Exception e) {
            LogUtils.report(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (MouseUtils.isPopupTrigger(e)) {
            this.theCanvas.enforceSelection(e.getPoint());
            this.createPopupMenu().show(this.theCanvas, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (MouseUtils.isPopupTrigger(e)) {
            this.theCanvas.enforceSelection(e.getPoint());
            this.createPopupMenu().show(this.theCanvas, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void documentInit(BaseDocument.DocumentChangeEvent e) {
        if (e.getSource() == this.theWorkspace) {
            this.theDoc = this.theWorkspace.getStructures();
            this.theDoc.addDocumentChangeListener(this);
            this.theCanvas.setDocument(this.theDoc);
        }
        this.updateTitle();
        this.updateActions();
    }

    @Override
    public void documentChanged(BaseDocument.DocumentChangeEvent e) {
        this.updateTitle();
        this.updateActions();
    }

    @Override
    public void fileHistoryChanged() {
        this.updateRecentFileMenu();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = GlycanAction.getAction(e);
        String param = GlycanAction.getParam(e);
        if (action.equals("empty")) {
            this.onNew(this.theDoc);
        } else if (action.equals("new")) {
            this.onNew(param);
        } else if (action.equals("open")) {
            this.onOpenDocument(this.theWorkspace.getAllDocuments(), false);
        } else if (action.equals("openinto")) {
            this.onOpenDocument(this.theWorkspace.getAllDocuments(), true);
        } else if (action.equals("openstruct")) {
            this.onOpen(param, this.theWorkspace.getStructures(), false);
        } else if (action.equals("save")) {
            this.onSave(this.theDoc, true);
        } else if (action.equals("saveas")) {
            this.onSaveAs(this.theDoc);
        } else if (action.equals("print")) {
            this.onPrint();
        } else if (action.equals("import")) {
            this.onImportFrom(param);
        } else if (action.equals("export")) {
            this.onExportTo(param);
        } else if (action.equals("quit")) {
            this.onExit();
        } else if (action.equals("about")) {
            this.onAbout();
        }
        this.updateActions();
    }

    public static void main(String[] args) throws MalformedURLException {
        new GlycanBuilder().setVisible(true);
        NativeInterface.runEventPump();
    }
}

