/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.util.LinkedList;
import org.eurocarbdb.application.glycanbuilder.FragmentEntry;
import org.eurocarbdb.application.glycanbuilder.Glycan;

class FragmentGroup {
    private LinkedList<LinkedList<FragmentEntry>> fragments = new LinkedList();

    public LinkedList<LinkedList<FragmentEntry>> getFragmentEntries() {
        return this.fragments;
    }

    public LinkedList<FragmentEntry> getFragmentEntries(int s_ind) {
        return this.fragments.get(s_ind);
    }

    public LinkedList<Glycan> getFragments(int s_ind) {
        LinkedList<Glycan> ret = new LinkedList<Glycan>();
        for (FragmentEntry fe : this.fragments.get(s_ind)) {
            ret.add(fe.fragment);
        }
        return ret;
    }

    public boolean isEmpty() {
        for (LinkedList linkedList : this.fragments) {
            if (linkedList.size() <= 0) continue;
            return false;
        }
        return true;
    }

    public void assertSize(int s_ind) {
        while (this.fragments.size() <= s_ind) {
            this.fragments.add(new LinkedList());
        }
    }

    public void addFragment(int s_ind, FragmentEntry fe) {
        this.assertSize(s_ind);
        this.fragments.get(s_ind).add(fe);
    }

    public void removeFragments(int s_ind) {
        this.fragments.remove(s_ind);
    }

    public void removeFragment(int s_ind, FragmentEntry fe) {
        if (s_ind >= this.fragments.size()) {
            return;
        }
        LinkedList<FragmentEntry> vfe = this.fragments.get(s_ind);
        for (int i = 0; i < vfe.size(); ++i) {
            if (!vfe.get(i).equals(fe)) continue;
            vfe.remove(i);
            return;
        }
    }
}

