/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.channels.FileChannel;
import javax.swing.ImageIcon;
import org.eurocarbdb.application.glycanbuilder.ThemeManager;
import org.eurocarbdb.application.glycanbuilder.converter.GlycanParserFactory;

public class FileUtils {
    protected static ThemeManager themeManager;
    public static ThemeManager defaultThemeManager;

    public static ThemeManager getThemeManager() {
        return themeManager;
    }

    public static void setThemeManager(ThemeManager _themeManager) {
        themeManager = _themeManager;
    }

    private FileUtils() {
    }

    public static String removeEscapes(String src) {
        char[] in = src.toCharArray();
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < in.length; ++i) {
            if (in[i] == '%' && i < in.length - 2) {
                if (in[i + 1] == '%') {
                    out.append('%');
                    ++i;
                    continue;
                }
                String num = "" + in[i + 1] + in[i + 2];
                out.append((char)Integer.valueOf(num, 16).intValue());
                i += 2;
                continue;
            }
            out.append(in[i]);
        }
        return out.toString();
    }

    public static String getRootDir() {
        String s = FileUtils.class.getResource("FileUtils.class").getFile();
        s = (s = FileUtils.removeEscapes(s)).indexOf("!") == -1 ? FileUtils.class.getResource("/").getFile() : s.substring(5, s.indexOf("!"));
        return s.substring(0, s.lastIndexOf("/"));
    }

    public static Cursor createCursor(String id) {
        String path = "/cursors/" + id + ".png";
        URL imgURL = FileUtils.class.getResource(path);
        if (imgURL != null) {
            ImageIcon img = new ImageIcon(imgURL);
            return Toolkit.getDefaultToolkit().createCustomCursor(img.getImage(), new Point(0, 0), id);
        }
        return null;
    }

    public static String enforceExtension(String filename, String extension) {
        String ext = "";
        int i = filename.lastIndexOf(46);
        if (i > 0 && i < filename.length() - 1) {
            ext = filename.substring(i + 1).toLowerCase();
        }
        if (ext.equals(extension)) {
            return filename;
        }
        if (GlycanParserFactory.getExportFormats().containsKey(extension)) {
            return filename + ".txt";
        }
        return filename + "." + extension;
    }

    public static InputStream open(Class owner, String filename) throws Exception {
        URL file_url = owner.getResource(filename);
        if (file_url == null) {
            File file = new File(filename);
            if (!file.exists()) {
                throw new FileNotFoundException(filename);
            }
            return new FileInputStream(file);
        }
        return file_url.openStream();
    }

    public static InputStream open(Class owner, String filename, boolean in_jar) throws Exception {
        if (!in_jar) {
            File file = new File(filename);
            if (!file.exists()) {
                throw new FileNotFoundException(filename);
            }
            return new FileInputStream(file);
        }
        URL file_url = owner.getResource(filename);
        if (file_url == null) {
            throw new FileNotFoundException(filename);
        }
        return file_url.openStream();
    }

    public static boolean exists(String filename) {
        return new File(filename).exists();
    }

    public static String content(String filename) throws Exception {
        return FileUtils.content(new FileInputStream(filename));
    }

    public static String content(File file) throws Exception {
        return FileUtils.content(new FileInputStream(file));
    }

    public static String content(InputStream is) throws Exception {
        int ch;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder ret = new StringBuilder();
        while ((ch = br.read()) != -1) {
            ret.appendCodePoint(ch);
        }
        return ret.toString();
    }

    public static byte[] binaryContent(String filename) throws Exception {
        return FileUtils.binaryContent(new FileInputStream(filename));
    }

    public static byte[] binaryContent(File file) throws Exception {
        return FileUtils.binaryContent(new FileInputStream(file));
    }

    public static byte[] binaryContent(InputStream is) throws Exception {
        int b;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        while ((b = is.read()) != -1) {
            os.write(b);
        }
        return os.toByteArray();
    }

    public static void copy(File src, File dst) throws Exception {
        if (src == null) {
            throw new Exception("Invalid source file");
        }
        if (dst == null) {
            throw new Exception("Invalid destination file");
        }
        FileChannel inChannel = new FileInputStream(src).getChannel();
        FileChannel outChannel = new FileOutputStream(dst).getChannel();
        try {
            long size = inChannel.size();
            for (long position = 0L; position < size; position += inChannel.transferTo(position, 32000L, outChannel)) {
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    public static void copy(InputStream src, File dst) throws Exception {
        if (src == null) {
            throw new Exception("Invalid source stream");
        }
        if (dst == null) {
            throw new Exception("Invalid destination file");
        }
        BufferedInputStream bis = new BufferedInputStream(src);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(dst));
        int ch = -1;
        while ((ch = bis.read()) != -1) {
            bos.write(ch);
        }
        bos.close();
    }
}

