/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.eurocarbdb.application.glycanbuilder.FileUtils;

public class DropDownList
extends JToggleButton
implements ActionListener,
ListSelectionListener,
PopupMenuListener {
    private static final long serialVersionUID = 0L;
    private JList theList;
    private MyPopupMenu thePopup;
    private boolean is_changed;
    private boolean ignore_list_events;
    public JComponent this_object;

    public DropDownList(Object[] data) {
        super("---", FileUtils.themeManager.getImageIcon("smalldownarrow", 10));
        this.setHorizontalTextPosition(10);
        this.this_object = this;
        this.theList = new JList(this.createListModel(data));
        this.theList.setSelectionMode(2);
        this.addActionListener(this);
        this.theList.addListSelectionListener(this);
        this.updateText();
        this.is_changed = false;
        this.ignore_list_events = false;
    }

    private DefaultListModel createListModel(Object[] data) {
        DefaultListModel<Object> ret = new DefaultListModel<Object>();
        for (Object o : data) {
            ret.addElement(o);
        }
        return ret;
    }

    public void setListModel(Object[] data) {
        this.theList.setModel(this.createListModel(data));
    }

    public void setListModel(ListModel model) {
        this.theList.setModel(model);
    }

    private MyPopupMenu createPopup() {
        MyPopupMenu popup = new MyPopupMenu();
        popup.setLayout(new BorderLayout());
        popup.add(this.theList);
        popup.addPopupMenuListener(this);
        return popup;
    }

    public void clearSelection() {
        this.ignore_list_events = true;
        this.theList.clearSelection();
        this.updateText();
        this.ignore_list_events = false;
    }

    public Object[] getSelectedValues() {
        return this.theList.getSelectedValues();
    }

    public void setSelectedValues(Object[] values) {
        this.ignore_list_events = true;
        this.theList.clearSelection();
        DefaultListModel dlm = (DefaultListModel)this.theList.getModel();
        for (int i = 0; i < values.length; ++i) {
            int ind = dlm.indexOf(values[i]);
            this.theList.addSelectionInterval(ind, ind);
        }
        this.updateText();
        this.ignore_list_events = false;
    }

    public void fireActionEvent() {
        for (ActionListener al : this.getActionListeners()) {
            if (al == this) continue;
            if (this.getActionCommand() != null) {
                al.actionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
                continue;
            }
            al.actionPerformed(new ActionEvent(this, 1001, this.getText()));
        }
        this.is_changed = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isSelected()) {
            this.thePopup = this.createPopup();
            Rectangle bounds = this.getBounds(null);
            Dimension psize = this.thePopup.getPreferredSize();
            this.thePopup.show(this, 0, bounds.height);
            this.thePopup.setPopupSize(Math.max(bounds.width, psize.width), psize.height);
        } else {
            this.thePopup.makeInvisible();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!this.ignore_list_events) {
            this.is_changed = true;
            this.updateText();
        }
    }

    private void updateText() {
        StringBuilder sb = new StringBuilder();
        for (Object o : this.theList.getSelectedValues()) {
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(o.toString());
        }
        if (sb.length() > 0) {
            this.setText(sb.toString());
        } else {
            this.setText("---");
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.is_changed = false;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        if (this.is_changed) {
            this.fireActionEvent();
        }
        this.setSelected(false);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    private class MyPopupMenu
    extends JPopupMenu {
        private MyPopupMenu() {
        }

        @Override
        public void setVisible(boolean f) {
            if (f || DropDownList.this.this_object.getMousePosition(true) == null) {
                super.setVisible(f);
            }
        }

        public void makeInvisible() {
            super.setVisible(false);
        }
    }
}

