/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.LinkedList;

public class CustomFocusTraversalPolicy
extends FocusTraversalPolicy {
    private LinkedList<Component> sequence = new LinkedList();

    public void clear() {
        this.sequence.clear();
    }

    public void addComponent(Component c) {
        if (c != null) {
            this.sequence.add(c);
        }
    }

    @Override
    public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
        int ind = this.sequence.indexOf(aComponent);
        if (ind == -1) {
            return this.getFirstComponent(focusCycleRoot);
        }
        int next = ind + 1 == this.sequence.size() ? 0 : ind + 1;
        return this.sequence.get(next);
    }

    @Override
    public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
        int ind = this.sequence.indexOf(aComponent);
        if (ind == -1) {
            return this.getFirstComponent(focusCycleRoot);
        }
        int last = ind == 0 ? this.sequence.size() - 1 : ind - 1;
        return this.sequence.get(last);
    }

    @Override
    public Component getDefaultComponent(Container focusCycleRoot) {
        return this.getFirstComponent(focusCycleRoot);
    }

    @Override
    public Component getLastComponent(Container focusCycleRoot) {
        return this.sequence.getLast();
    }

    @Override
    public Component getFirstComponent(Container focusCycleRoot) {
        return this.sequence.getFirst();
    }
}

