/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.util.Collection;
import java.util.LinkedList;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.util.TextUtils;

public class CrossRingFragmentType
extends ResidueType {
    private String str_residues;
    private LinkedList<String> residues;
    private char anomeric_carbon;
    private char ring_size;
    private char fragment_type;
    private int first_pos;
    private int last_pos;

    public CrossRingFragmentType() {
        this.str_residues = "";
        this.residues = new LinkedList();
        this.anomeric_carbon = (char)63;
        this.ring_size = (char)63;
        this.fragment_type = (char)45;
        this.first_pos = 0;
        this.last_pos = 0;
    }

    public CrossRingFragmentType(String init) throws Exception {
        LinkedList<String> tokens = TextUtils.tokenize(init, "\t");
        if (tokens.size() != 12) {
            throw new Exception("Invalid string format: " + init);
        }
        this.str_residues = tokens.get(0);
        this.residues = this.parseArray(tokens.get(0));
        this.anomeric_carbon = tokens.get(1).charAt(0);
        this.ring_size = Character.toLowerCase(tokens.get(2).charAt(0));
        this.fragment_type = Character.toUpperCase(tokens.get(3).charAt(0));
        this.first_pos = Integer.parseInt(tokens.get(4));
        this.last_pos = Integer.parseInt(tokens.get(5));
        this.nmethyls = Integer.parseInt(tokens.get(6));
        this.nacetyls = Integer.parseInt(tokens.get(7));
        this.nlinkages = Integer.parseInt(tokens.get(8));
        this.linkage_pos = this.parseCharArray(tokens.get(9));
        this.charges_pos = this.parseCharArray(tokens.get(10));
        this.composition = tokens.get(11);
        this.name = "#" + Character.toLowerCase(this.fragment_type) + "cleavage_" + this.first_pos + "_" + this.last_pos;
        this.superclass = "cleavage";
        this.is_saccharide = false;
        this.is_cleavable = false;
        this.is_labile = false;
        this.bar_order = 0;
        this.drop_methylated = false;
        this.drop_acetylated = false;
        this.can_redend = this.fragment_type == 'A';
        this.can_parent = !this.can_redend;
        this.description = this.fragment_type + "_" + this.first_pos + "_" + this.last_pos + " cleavage of C" + this.anomeric_carbon + " " + this.str_residues;
        this.updateMolecule();
    }

    private LinkedList<String> parseArray(String str) throws Exception {
        if (str.equals("-") || str.equals("none") || str.equals("empty")) {
            return new LinkedList<String>();
        }
        return TextUtils.tokenize(str, ",");
    }

    public boolean matches(Residue r) {
        return this.residues.contains(r.getTypeName()) && r.getAnomericCarbon() == this.anomeric_carbon && r.getRingSize() == this.ring_size;
    }

    public boolean matches(char _fragment_type, int _first_pos, int _last_pos, Residue r) {
        return this.fragment_type == (_fragment_type = Character.toUpperCase(_fragment_type)) && this.first_pos == _first_pos && this.last_pos == _last_pos && this.matches(r);
    }

    public Collection<String> getResidues() {
        return this.residues;
    }

    public boolean isAFragmentType() {
        return this.fragment_type == 'A';
    }

    public boolean isXFragmentType() {
        return this.fragment_type == 'X';
    }

    public String getRingFragmentType() {
        return "" + this.fragment_type;
    }

    @Override
    public String getCleavageType() {
        return "^{" + this.first_pos + "," + this.last_pos + "}" + this.fragment_type;
    }

    public int getFirstPos() {
        return this.first_pos;
    }

    public int getLastPos() {
        return this.last_pos;
    }

    int getStartPos() {
        int ret = -1;
        int anom = this.anomeric_carbon - 48;
        if (this.fragment_type == 'A') {
            return this.first_pos >= anom ? this.first_pos : this.last_pos;
        }
        return this.first_pos >= anom ? this.last_pos : this.first_pos;
    }

    int getEndPos() {
        int anom = this.anomeric_carbon - 48;
        if (this.fragment_type == 'A') {
            return this.first_pos >= anom ? this.last_pos : this.first_pos;
        }
        return this.first_pos >= anom ? this.first_pos : this.last_pos;
    }
}

