/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.sax.TransformerHandler;
import org.eurocarbdb.application.glycanbuilder.logutility.LogUtils;
import org.eurocarbdb.application.glycanbuilder.util.SAXUtils;
import org.eurocarbdb.application.glycanbuilder.util.TextUtils;
import org.eurocarbdb.application.glycanbuilder.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Configuration
implements SAXUtils.SAXWriter {
    protected HashMap<String, HashMap<String, String>> properties = new HashMap();

    public boolean open(String filename) {
        try {
            if (filename == null) {
                return false;
            }
            File file = new File(filename);
            InputStream fis = !file.exists() ? this.getClass().getResourceAsStream(filename) : new FileInputStream(file);
            if (fis == null) {
                fis = new FileInputStream("src/main/resources/config.xml");
            }
            SAXUtils.read(fis, new SAXHandler(this));
            return true;
        }
        catch (Exception e) {
            LogUtils.report(e);
            return false;
        }
    }

    public boolean save(String filename) {
        try {
            if (filename == null) {
                return false;
            }
            FileOutputStream fos = new FileOutputStream(filename);
            Document document = XMLUtils.newDocument();
            document.appendChild(this.toXML(document));
            return XMLUtils.write(fos, document);
        }
        catch (Exception e) {
            LogUtils.report(e);
            return false;
        }
    }

    public void remove(String section, String argument) {
        if (this.properties.containsKey(section)) {
            this.properties.get(section).remove(argument);
        }
    }

    public void put(String section, String argument, String value) {
        if (!this.properties.containsKey(section)) {
            this.properties.put(section, new HashMap());
        }
        this.properties.get(section).put(argument, value);
    }

    public void put(String section, String argument, List<String> values, char delim) {
        this.put(section, argument, TextUtils.toString(values, delim));
    }

    public void put(String section, String argument, String[] values, char delim) {
        this.put(section, argument, TextUtils.toString(values, delim));
    }

    public void put(String section, String argument, double value) {
        this.put(section, argument, Double.toString(value));
    }

    public void put(String section, String argument, int value) {
        this.put(section, argument, Integer.toString(value));
    }

    public void put(String section, String argument, boolean value) {
        this.put(section, argument, Boolean.toString(value));
    }

    public void put(String section, String argument, Color value) {
        this.put(section, argument, value.getRGB());
    }

    public void put(String section, String argument, Object value) {
        if (value instanceof Color) {
            this.put(section, argument, ((Color)value).getRGB());
        } else {
            this.put(section, argument, value.toString());
        }
    }

    public String get(String section, String argument) {
        if (!this.properties.containsKey(section)) {
            return null;
        }
        return this.properties.get(section).get(argument);
    }

    public String[] get(String section, String argument, String[] default_value, char delim) {
        String str_value = this.get(section, argument);
        if (str_value == null) {
            return default_value;
        }
        return str_value.split("\\" + delim);
    }

    public List<String> get(String section, String argument, List<String> default_value, char delim) {
        String str_value = this.get(section, argument);
        if (str_value == null) {
            return default_value;
        }
        return new ArrayList<String>(Arrays.asList(str_value.split("\\" + delim)));
    }

    public String get(String section, String argument, String default_value) {
        String str_value = this.get(section, argument);
        if (str_value == null) {
            return default_value;
        }
        return str_value;
    }

    public double get(String section, String argument, double default_value) {
        String str_value = this.get(section, argument);
        if (str_value == null) {
            return default_value;
        }
        return Double.parseDouble(str_value);
    }

    public int get(String section, String argument, int default_value) {
        String str_value = this.get(section, argument);
        if (str_value == null) {
            return default_value;
        }
        return Integer.parseInt(str_value);
    }

    public boolean get(String section, String argument, boolean default_value) {
        String str_value = this.get(section, argument);
        if (str_value == null) {
            return default_value;
        }
        return Boolean.valueOf(str_value);
    }

    public Color get(String section, String argument, Color default_value) {
        String str_value = this.get(section, argument);
        if (str_value == null) {
            return default_value;
        }
        return new Color(Integer.parseInt(str_value));
    }

    public Object get(String section, String argument, Object default_value) {
        String str_value = this.get(section, argument);
        if (str_value == null) {
            return default_value;
        }
        if (default_value instanceof String) {
            return str_value;
        }
        if (default_value instanceof Double) {
            return Double.valueOf(str_value);
        }
        if (default_value instanceof Integer) {
            return Integer.valueOf(str_value);
        }
        if (default_value instanceof Boolean) {
            return Boolean.valueOf(str_value);
        }
        if (default_value instanceof Color) {
            return new Color(Integer.valueOf(str_value));
        }
        return null;
    }

    public void fromXML(Node c_node) {
        this.properties.clear();
        for (Node s_node : XMLUtils.findAllChildren(c_node)) {
            for (Node a_node : XMLUtils.findAllChildren(s_node)) {
                this.put(s_node.getNodeName(), a_node.getNodeName(), XMLUtils.getText(a_node));
            }
        }
    }

    public Element toXML(Document from_doc) {
        Element c_node = from_doc.createElement("Configuration");
        for (Map.Entry<String, HashMap<String, String>> s : this.properties.entrySet()) {
            Element s_node = from_doc.createElement(s.getKey());
            for (Map.Entry<String, String> a : s.getValue().entrySet()) {
                Element a_node = from_doc.createElement(a.getKey());
                XMLUtils.setText(a_node, a.getValue());
                s_node.appendChild(a_node);
            }
            c_node.appendChild(s_node);
        }
        return c_node;
    }

    @Override
    public void write(TransformerHandler th) throws SAXException {
        th.startElement("", "", "Configuration", new AttributesImpl());
        for (Map.Entry<String, HashMap<String, String>> s : this.properties.entrySet()) {
            th.startElement("", "", s.getKey(), new AttributesImpl());
            for (Map.Entry<String, String> a : s.getValue().entrySet()) {
                th.startElement("", "", a.getKey(), new AttributesImpl());
                th.characters(a.getValue().toCharArray(), 0, a.getValue().length());
                th.endElement("", "", a.getKey());
            }
            th.endElement("", "", s.getKey());
        }
        th.endElement("", "", "Configuration");
    }

    public static class SAXHandler
    extends SAXUtils.ObjectTreeHandler {
        private Configuration theDocument;

        public SAXHandler(Configuration _doc) {
            this.theDocument = _doc;
        }

        @Override
        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(SAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "Configuration";
        }

        @Override
        protected SAXUtils.ObjectTreeHandler getHandler(String namespaceURI, String localName, String qName) {
            return new SectionSAXHandler();
        }

        @Override
        protected Object finalizeContent(String namespaceURI, String localName, String qName) throws SAXException {
            this.theDocument.properties.clear();
            for (Map.Entry s : this.sub_objects.entrySet()) {
                if (((LinkedList)s.getValue()).size() > 1) {
                    throw new SAXException(this.createMessage("Duplicated section"));
                }
                this.theDocument.properties.put((String)s.getKey(), (HashMap)((LinkedList)s.getValue()).get(0));
            }
            this.object = this.theDocument;
            return this.object;
        }
    }

    public static class SectionSAXHandler
    extends SAXUtils.ObjectTreeHandler {
        @Override
        public boolean isElement(String namespaceURI, String localName, String qName) {
            return true;
        }

        @Override
        protected SAXUtils.ObjectTreeHandler getHandler(String namespaceURI, String localName, String qName) {
            return new ArgumentSAXHandler();
        }

        @Override
        protected Object finalizeContent(String namespaceURI, String localName, String qName) throws SAXException {
            HashMap<String, String> arguments = new HashMap<String, String>();
            for (Map.Entry a : this.sub_objects.entrySet()) {
                if (((LinkedList)a.getValue()).size() > 1) {
                    throw new SAXException(this.createMessage("Duplicated argument"));
                }
                arguments.put((String)a.getKey(), (String)((LinkedList)a.getValue()).get(0));
            }
            this.object = arguments;
            return this.object;
        }
    }

    public static class ArgumentSAXHandler
    extends SAXUtils.ObjectTreeHandler {
        @Override
        public boolean isElement(String namespaceURI, String localName, String qName) {
            return true;
        }

        @Override
        protected SAXUtils.ObjectTreeHandler getHandler(String namespaceURI, String localName, String qName) {
            return null;
        }

        @Override
        protected Object finalizeContent(String namespaceURI, String localName, String qName) throws SAXException {
            this.object = this.text.toString();
            return this.object;
        }
    }
}

