/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import org.eurocarbdb.application.glycanbuilder.CoreType;
import org.eurocarbdb.application.glycanbuilder.EurocarbResizableIcon;
import org.eurocarbdb.application.glycanbuilder.ICON_SIZE;
import org.eurocarbdb.application.glycanbuilder.ImageResizableIconReducedMem;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.STOCK_ICON;
import org.eurocarbdb.application.glycanbuilder.ThemeManager;
import org.eurocarbdb.application.glycanbuilder.dataset.CoreDictionary;
import org.eurocarbdb.application.glycanbuilder.dataset.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.renderutil.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.renderutil.ResidueRenderer;
import org.eurocarbdb.application.glycanbuilder.util.ActionManager;
import org.glycoinfo.application.glycanbuilder.dataset.CrossLinkedSubstituentDictionary;

public class CanvasAction {
    public void createAction(ActionManager a_oActionManager, ThemeManager a_oTheme, ICON_SIZE defaultMenuIconSize, ActionListener a_oListerner, GlycanRendererAWT a_oGlycanRenderer) {
        this.createEditAction(a_oActionManager, a_oTheme, defaultMenuIconSize, a_oListerner);
        this.createStructureAction(a_oActionManager, a_oTheme, defaultMenuIconSize, a_oListerner);
        this.createViewAction(a_oActionManager, a_oTheme, defaultMenuIconSize, a_oListerner);
        this.createOtherAction(a_oActionManager, a_oTheme, defaultMenuIconSize, a_oListerner);
        this.createMonosaccharideAction(a_oActionManager, a_oTheme, a_oListerner, a_oGlycanRenderer);
        this.createGlyTouCanAction(a_oActionManager, a_oTheme, defaultMenuIconSize, a_oListerner);
    }

    private void createEditAction(ActionManager a_oActionManager, ThemeManager a_oTheme, ICON_SIZE defaultMenuIconSize, ActionListener a_oListener) {
        a_oActionManager.add("explode", a_oTheme.getResizableIcon("explode", defaultMenuIconSize), "Explode", 69, "ctrl E", a_oListener);
        a_oActionManager.add("implode", a_oTheme.getResizableIcon("implode", defaultMenuIconSize), "Implode", 69, "ctrl shift E", a_oListener);
        a_oActionManager.add("undo", a_oTheme.getResizableIcon(STOCK_ICON.UNDO, defaultMenuIconSize), "Undo", 85, "ctrl Z", a_oListener);
        a_oActionManager.add("redo", a_oTheme.getResizableIcon(STOCK_ICON.REDO, defaultMenuIconSize), "Redo", 82, "ctrl Y", a_oListener);
        a_oActionManager.add("cut", a_oTheme.getResizableIcon(STOCK_ICON.CUT, defaultMenuIconSize), "Cut", 84, "ctrl X", a_oListener);
        a_oActionManager.add("copy", a_oTheme.getResizableIcon(STOCK_ICON.COPY, defaultMenuIconSize), "Copy", 67, "ctrl C", a_oListener);
        a_oActionManager.add("paste", a_oTheme.getResizableIcon(STOCK_ICON.PASTE, defaultMenuIconSize), "Paste", 80, "ctrl V", a_oListener);
        a_oActionManager.add("delete", a_oTheme.getResizableIcon("eraser", defaultMenuIconSize), "Delete", 76, "DELETE", a_oListener);
        a_oActionManager.add("orderstructuresasc", a_oTheme.getResizableIcon("sort_ascending", defaultMenuIconSize), "Sort structures by m/z in ascending order", 65, "", a_oListener);
        a_oActionManager.add("orderstructuresdesc", a_oTheme.getResizableIcon("sort_descending", defaultMenuIconSize), "Sort structures by m/z in descending order", 68, "", a_oListener);
        a_oActionManager.add("selectstructure", a_oTheme.getResizableIcon("selectstructure", defaultMenuIconSize), "Select current structure", 83, "ctrl W", a_oListener);
        a_oActionManager.add("selectall", a_oTheme.getResizableIcon("selectall", defaultMenuIconSize), "Select all", 65, "ctrl A", a_oListener);
        a_oActionManager.add("selectnone", a_oTheme.getResizableIcon("deselect", defaultMenuIconSize), "Select none", 78, "ESCAPE", a_oListener);
        a_oActionManager.add("gotostart", a_oTheme.getResizableIcon("go-first", defaultMenuIconSize), "Show beginning of the canvas", 66, "ctrl HOME", a_oListener);
        a_oActionManager.add("gotoend", a_oTheme.getResizableIcon("go-last", defaultMenuIconSize), "Show end of the canvas", 69, "ctrl END", a_oListener);
        a_oActionManager.add("antennaParent", a_oTheme.getResizableIcon(STOCK_ICON.FAMILY, ICON_SIZE.L2), "SelectParent", -1, "", a_oListener);
    }

    private void createStructureAction(ActionManager a_oActionManager, ThemeManager themeManager, ICON_SIZE defaultMenuIconSize, ActionListener a_oListener) {
        a_oActionManager.add("write", themeManager.getResizableIcon("write", defaultMenuIconSize), "Add structure from string", 83, "", a_oListener);
        a_oActionManager.add("addstructurestr", themeManager.getResizableIcon("import", defaultMenuIconSize), "Add structure from string", 83, "", a_oListener);
        a_oActionManager.add("getstructurestr", themeManager.getResizableIcon("export", defaultMenuIconSize), "Get string from structure", -1, "", a_oListener);
        a_oActionManager.add("addcomposition", themeManager.getResizableIcon("piechart", defaultMenuIconSize), "Add composition", 67, "", a_oListener);
        a_oActionManager.add("bracket", themeManager.getResizableIcon("bracket", defaultMenuIconSize), "Add bracket", 66, "ctrl B", a_oListener);
        a_oActionManager.add("repeat", themeManager.getResizableIcon("repeat", defaultMenuIconSize), "Add repeating unit", 85, "ctrl R", a_oListener);
        a_oActionManager.add("cyclic", themeManager.getResizableIcon("cyclic", defaultMenuIconSize), "Add cyclic symbol", 67, "ctrl C", a_oListener);
        a_oActionManager.add("properties", themeManager.getResizableIcon("properties", defaultMenuIconSize), "Residue properties", 80, "ctrl ENTER", a_oListener);
        a_oActionManager.add("moveccw", themeManager.getResizableIcon("rotateccw", defaultMenuIconSize), "Move residue counter-clockwise", 75, "ctrl shift LEFT", a_oListener);
        a_oActionManager.add("movecw", themeManager.getResizableIcon("rotatecw", defaultMenuIconSize), "Move residue clockwise", 87, "ctrl shift RIGHT", a_oListener);
        a_oActionManager.add("massoptstruct", themeManager.getResizableIcon("massoptions", defaultMenuIconSize), "Mass options of selected structures", 77, "", a_oListener);
        for (CoreType t : CoreDictionary.getCores()) {
            a_oActionManager.add("addstructure=" + t.getName(), ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), t.getDescription(), -1, "", a_oListener);
        }
    }

    private void createViewAction(ActionManager a_oActionManager, ThemeManager themeManager, ICON_SIZE defaultMenuIconSize, ActionListener a_oListener) {
        a_oActionManager.add("notation=cfg", themeManager.getResizableIcon("CFG_color", defaultMenuIconSize), "CFG notation", 67, "", a_oListener);
        a_oActionManager.add("notation=cfgbw", themeManager.getResizableIcon("CFG_greyscale", defaultMenuIconSize), "CFG black and white notation", 66, "", a_oListener);
        a_oActionManager.add("notation=cfglink", themeManager.getResizableIcon("CFG_linkage", defaultMenuIconSize), "CFG with linkage placement notation", 76, "", a_oListener);
        a_oActionManager.add("notation=uoxf", themeManager.getResizableIcon("uoxf", defaultMenuIconSize), "UOXF notation", 79, "", a_oListener);
        a_oActionManager.add("notation=uoxfcol", themeManager.getResizableIcon("uoxfcol", defaultMenuIconSize), "UOXFCOL notation", 79, "", a_oListener);
        a_oActionManager.add("notation=text", themeManager.getResizableIcon("text", defaultMenuIconSize), "Text only notation", 84, "", a_oListener);
        a_oActionManager.add("notation=snfg", themeManager.getResizableIcon("", defaultMenuIconSize), "SNFG notation", 83, "", a_oListener);
        a_oActionManager.add("display=compact", ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), "compact view", 79, "", a_oListener);
        a_oActionManager.add("display=normal", ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), "normal view", 78, "", a_oListener);
        a_oActionManager.add("display=normalinfo", ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), "normal view with linkage info", 73, "", a_oListener);
        a_oActionManager.add("display=custom", ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), "custom view with user settings", 85, "", a_oListener);
        a_oActionManager.add("scale=400", ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), "400%", -1, "", a_oListener);
        a_oActionManager.add("scale=300", ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), "300%", -1, "", a_oListener);
        a_oActionManager.add("scale=200", ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), "200%", -1, "", a_oListener);
        a_oActionManager.add("scale=150", ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), "150%", -1, "", a_oListener);
        a_oActionManager.add("scale=100", ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), "100%", -1, "", a_oListener);
        a_oActionManager.add("scale=67", ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), "67%", -1, "", a_oListener);
        a_oActionManager.add("scale=50", ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), "50%", -1, "", a_oListener);
        a_oActionManager.add("scale=33", ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), "33%", -1, "", a_oListener);
        a_oActionManager.add("scale=25", ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), "25%", -1, "", a_oListener);
        a_oActionManager.add("collapsemultipleantennae", ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), "Collapse multiple antennae", 65, "", a_oListener);
        a_oActionManager.add("showmassescanvas", ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), "Show masses in the drawing canvas", 86, "", a_oListener);
        a_oActionManager.add("showmasses", ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), "Show masses when exporting", 77, "", a_oListener);
        a_oActionManager.add("showredendcanvas", ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), "Show reducing end indicator in the drawing canvas", 82, "", a_oListener);
        a_oActionManager.add("showredend", ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), "Show reducing end indicator when exporting", 69, "", a_oListener);
        a_oActionManager.add("orientation", themeManager.getResizableIcon("rl", ICON_SIZE.L3), "Change orientation", 79, "", a_oListener);
        a_oActionManager.add("displaysettings", themeManager.getResizableIcon("display", ICON_SIZE.L4), "Change display settings", 68, "", a_oListener);
        a_oActionManager.add("savespec", themeManager.getResizableIcon("savespec", ICON_SIZE.L4), "Save spectra", 68, "", a_oListener);
    }

    private void createOtherAction(ActionManager a_oActionManager, ThemeManager themeManager, ICON_SIZE defaultMenuIconSize, ActionListener a_oListener) {
        a_oActionManager.add("about", themeManager.getResizableIcon("about", ICON_SIZE.L4), "About", 66, "", a_oListener);
        a_oActionManager.add("changeLV2", themeManager.getResizableIcon("changeLV2", ICON_SIZE.L4), "changeLV2", 67, "", a_oListener);
        a_oActionManager.add("changeLV3", themeManager.getResizableIcon("changeLV3", ICON_SIZE.L4), "changeLV3", 67, "", a_oListener);
        a_oActionManager.add("changeLV4", themeManager.getResizableIcon("changeLV4", ICON_SIZE.L4), "changeLV4", 67, "", a_oListener);
        a_oActionManager.add("showid", themeManager.getResizableIcon("showid", ICON_SIZE.L4), "Show ID", 67, "", a_oListener);
        a_oActionManager.add("showindex", themeManager.getResizableIcon("showindex", ICON_SIZE.L4), "Show Index", 67, "", a_oListener);
        a_oActionManager.add("removeanotation", themeManager.getResizableIcon("removeanotation", ICON_SIZE.L4), "Remove Anotation", 67, "", a_oListener);
    }

    private void createMonosaccharideAction(ActionManager a_oActionManager, ThemeManager a_oTheme, ActionListener a_oListerner, GlycanRendererAWT a_oGlycanRender) {
        EurocarbResizableIcon eu_icon;
        ImageResizableIconReducedMem icon;
        ICON_SIZE iconSize = ICON_SIZE.L3;
        ResidueRenderer rr = a_oGlycanRender.getResidueRenderer();
        for (ResidueType a_oRT : CrossLinkedSubstituentDictionary.getCrossLinkedSubstituents()) {
            icon = new ImageResizableIconReducedMem(rr.getImage(a_oRT, iconSize.getSize()), iconSize.getSize(), iconSize.getSize());
            eu_icon = new EurocarbResizableIcon(a_oTheme, null, icon);
            eu_icon.setResizableIcon(icon);
            a_oActionManager.add("bridge=" + a_oRT.getName(), eu_icon, a_oRT.getDescription(), -1, "", a_oListerner);
        }
        for (ResidueType t : ResidueDictionary.allResidues()) {
            icon = new ImageResizableIconReducedMem(rr.getImage(t, iconSize.getSize()), iconSize.getSize(), iconSize.getSize());
            eu_icon = new EurocarbResizableIcon(a_oTheme, null, icon);
            eu_icon.setResizableIcon(icon);
            a_oActionManager.add("change=" + t.getName(), eu_icon, t.getDescription(), -1, "", a_oListerner);
            if (t.canHaveParent()) {
                a_oActionManager.add("add=" + t.getName(), eu_icon, t.getDescription(), -1, t.getToolbarOrder() != 0 ? "ctrl " + t.getToolbarOrder() : "", a_oListerner);
                a_oActionManager.get("add=" + t.getName()).putValue("SmallIcon", new ImageIcon(rr.getImage(t, ICON_SIZE.L3.getSize())));
            }
            if (t.canHaveParent() && t.canHaveChildren()) {
                a_oActionManager.add("insert=" + t.getName(), eu_icon, t.getDescription(), -1, "", a_oListerner);
            }
            if (!t.canBeReducingEnd()) continue;
            a_oActionManager.add("changeredend=" + t.getName(), eu_icon, t.getDescription(), -1, "", a_oListerner);
        }
    }

    private void createGlyTouCanAction(ActionManager a_oActionManager, ThemeManager a_oTheme, ICON_SIZE defaultMenuIconSize, ActionListener a_oListener) {
        a_oActionManager.add("selectapidialog", a_oTheme.getResizableIcon("export", defaultMenuIconSize), "Send", 69, "", a_oListener);
        a_oActionManager.add("glycanidlist", a_oTheme.getResizableIcon("report", defaultMenuIconSize), "GlyTouCanID List", 69, "", a_oListener);
        a_oActionManager.add("edituser", a_oTheme.getResizableIcon("actions/edit_user", defaultMenuIconSize), "Change User", 69, "", a_oListener);
    }
}

