/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileFilter;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.GlycanUndoManager;
import org.eurocarbdb.application.glycanbuilder.ICON_SIZE;
import org.eurocarbdb.application.glycanbuilder.logutility.LogUtils;

public abstract class BaseDocument {
    protected GlycanUndoManager theUndoManager = null;
    protected String filename = "";
    protected boolean was_saved = false;
    protected boolean has_changed = false;
    protected Vector<DocumentChangeListener> dc_listeners = new Vector();
    HashMap<String, Component> components;

    public BaseDocument() {
        this.init();
        this.theUndoManager = new GlycanUndoManager(this);
        this.components = new HashMap();
    }

    public BaseDocument(boolean undo_redo) {
        this.init();
        this.components = new HashMap();
        if (undo_redo) {
            this.theUndoManager = new GlycanUndoManager(this);
        }
    }

    public abstract int size();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public abstract String getName();

    public ImageIcon getIcon() {
        try {
            return FileUtils.themeManager.getImageIcon("basedoc", ICON_SIZE.L2);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getFileName() {
        return this.filename;
    }

    public File getFile() {
        if (this.filename != null && this.filename.length() > 0 && this.was_saved) {
            return new File(this.filename);
        }
        return null;
    }

    public abstract Collection<FileFilter> getFileFormats();

    public abstract FileFilter getAllFileFormats();

    public boolean wasSaved() {
        return this.was_saved;
    }

    public boolean hasChanged() {
        return this.has_changed;
    }

    public GlycanUndoManager getUndoManager() {
        return this.theUndoManager;
    }

    public void resetStatus() {
        this.filename = "[untitled]";
        this.was_saved = false;
        this.has_changed = false;
    }

    public void setFilename(String filename) {
        this.filename = filename;
        this.was_saved = true;
        this.has_changed = false;
    }

    public void setChanged(boolean changed) {
        this.has_changed = changed;
    }

    public void init() {
        this.resetStatus();
        this.initData();
        this.fireDocumentInit();
    }

    public boolean init(String value) {
        try {
            this.resetStatus();
            this.initData();
            this.fromString(value);
            this.fireDocumentInit();
            return true;
        }
        catch (Exception e) {
            LogUtils.report(e);
            return false;
        }
    }

    protected boolean fill(String value) {
        return this.fill(value, false);
    }

    protected boolean fill(String value, boolean initial_state) {
        try {
            this.fromString(value);
            if (initial_state) {
                this.fireDocumentRestored();
            } else {
                this.fireDocumentChanged();
            }
            return true;
        }
        catch (Exception e) {
            LogUtils.report(e);
            return false;
        }
    }

    public void clear() {
        this.initData();
        this.fireDocumentChanged();
    }

    public abstract void initData();

    public boolean open(String filename, boolean merge, boolean warning) {
        return this.open(new File(filename), merge, warning);
    }

    public boolean open(File file, boolean merge, boolean warning) {
        try {
            FileInputStream fis = new FileInputStream(file);
            try {
                this.read(fis, merge);
            }
            catch (Exception e) {
                System.err.println("Got exception: " + e.getMessage());
                this.init();
                if (warning) {
                    throw e;
                }
                return false;
            }
            this.setFilename(file.getAbsolutePath());
            this.fireDocumentInit();
            return true;
        }
        catch (Exception e) {
            LogUtils.report(e);
            return false;
        }
    }

    protected void read(InputStream is, boolean merge) throws Exception {
        System.err.println("in read");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        this.fromString(this.consume(br), merge);
    }

    protected String consume(BufferedReader br) throws Exception {
        int ch;
        StringBuilder ret = new StringBuilder();
        while ((ch = br.read()) != -1) {
            ret.appendCodePoint(ch);
        }
        return ret.toString();
    }

    public boolean save(String filename) {
        try {
            this.setFilename(filename);
            File tmpfile = File.createTempFile("gwb", null);
            this.write(new FileOutputStream(tmpfile));
            FileUtils.copy(tmpfile, new File(filename));
            tmpfile.delete();
            this.fireDocumentInit();
            return true;
        }
        catch (Exception e) {
            LogUtils.report(e);
            return false;
        }
    }

    public void write(OutputStream os) throws Exception {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));
        String str = this.toString();
        bw.write(str, 0, str.length());
        bw.newLine();
        bw.close();
    }

    public void addDocumentChangeListener(DocumentChangeListener l) {
        if (l != null && !this.dc_listeners.contains(l)) {
            this.dc_listeners.add(l);
        }
    }

    public void removeDocumentChangeListener(DocumentChangeListener l) {
        if (l != null) {
            this.dc_listeners.remove(l);
        }
    }

    public void fireDocumentInit() {
        this.has_changed = false;
        for (DocumentChangeListener dcl : this.dc_listeners) {
            dcl.documentInit(new DocumentChangeEvent(this));
        }
    }

    public void fireDocumentInit(BaseDocument source) {
        this.has_changed = false;
        for (DocumentChangeListener dcl : this.dc_listeners) {
            dcl.documentInit(new DocumentChangeEvent(source));
        }
    }

    public void fireDocumentRestored() {
        this.has_changed = false;
        for (DocumentChangeListener dcl : this.dc_listeners) {
            dcl.documentChanged(new DocumentChangeEvent(this));
        }
    }

    public void fireDocumentChanged() {
        this.has_changed = true;
        for (DocumentChangeListener dcl : this.dc_listeners) {
            dcl.documentChanged(new DocumentChangeEvent(this));
        }
    }

    public void fireDocumentChanged(BaseDocument source) {
        this.has_changed = true;
        for (DocumentChangeListener dcl : this.dc_listeners) {
            dcl.documentChanged(new DocumentChangeEvent(source));
        }
    }

    public void fromString(String str) throws Exception {
        this.fromString(str, false);
    }

    public abstract void fromString(String var1, boolean var2) throws Exception;

    public void registerComponent(String id, Component component) {
        this.components.put(id, component);
    }

    public Component getRegisteredComponent(String id) {
        return this.components.get(id);
    }

    public static interface DocumentChangeListener {
        public void documentInit(DocumentChangeEvent var1);

        public void documentChanged(DocumentChangeEvent var1);
    }

    public static class DocumentChangeEvent
    extends EventObject {
        protected BaseDocument theDoc;

        public DocumentChangeEvent(BaseDocument _theDoc) {
            super(_theDoc);
            this.theDoc = _theDoc;
        }
    }
}

