/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.util.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.eurocarbdb.MolecularFramework.io.GlycoCT.GlycoCTLinkageComparator;
import org.eurocarbdb.MolecularFramework.sugar.Anomer;
import org.eurocarbdb.MolecularFramework.sugar.BaseType;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraph;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraphAlternative;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Linkage;
import org.eurocarbdb.MolecularFramework.sugar.LinkageType;
import org.eurocarbdb.MolecularFramework.sugar.Modification;
import org.eurocarbdb.MolecularFramework.sugar.ModificationType;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.SubstituentType;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitCyclic;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.Superclass;
import org.eurocarbdb.MolecularFramework.sugar.UnderdeterminedSubTree;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverser;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverserValdidation;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorNodeType;

public class GlycoVisitorValidation
implements GlycoVisitor {
    private ArrayList<String> m_aErrorList = new ArrayList();
    private ArrayList<String> m_aWarningList = new ArrayList();
    private GlycoGraph m_objGlycoGraph = null;
    private ArrayList<GlycoEdge> m_aEdge = new ArrayList();
    private GlycoVisitorNodeType m_visNodeType = new GlycoVisitorNodeType();

    public ArrayList<String> getErrors() {
        return this.m_aErrorList;
    }

    public ArrayList<String> getWarnings() {
        return this.m_aWarningList;
    }

    @Override
    public GlycoTraverser getTraverser(GlycoVisitor a_objVisitor) throws GlycoVisitorException {
        return new GlycoTraverserValdidation(a_objVisitor);
    }

    @Override
    public void visit(GlycoEdge a_objEdge) throws GlycoVisitorException {
        if (!this.m_aEdge.contains(a_objEdge)) {
            if (a_objEdge.getChild() == null || a_objEdge.getParent() == null) {
                this.m_aErrorList.add("Child or parent are null in Edge.");
            }
            if (!this.m_objGlycoGraph.containsNode(a_objEdge.getChild())) {
                this.m_aErrorList.add("Child node of an linkage is not part of the same sugar block.");
            }
            if (!this.m_objGlycoGraph.containsNode(a_objEdge.getParent())) {
                this.m_aErrorList.add("Parent node of an linkage is not part of the same sugar block.");
            }
            this.testLinkageArray(a_objEdge);
            GlycoNode t_objNode = a_objEdge.getChild();
            if (t_objNode.getParentEdge() != a_objEdge) {
                this.m_aErrorList.add("Child residue in edge does not have this edge as parent.");
            }
            if (!(t_objNode = a_objEdge.getParent()).getChildEdges().contains(a_objEdge)) {
                this.m_aErrorList.add("Parent residue in edge does not have this edge as child.");
            }
            this.m_aEdge.add(a_objEdge);
        }
    }

    private void testLinkageArray(GlycoEdge a_objEdge) {
        if (a_objEdge.getGlycosidicLinkages().size() == 0) {
            this.m_aErrorList.add("GlycoEdge contains no Linkages.");
        }
        for (Linkage t_objLinkage : a_objEdge.getGlycosidicLinkages()) {
            if (t_objLinkage.getChildLinkages().size() == 0) {
                this.m_aErrorList.add("No child linkage position given in GlycoEdge.");
            }
            ArrayList<Object> t_aPositions = new ArrayList();
            Integer t_iPosition2 = null;
            for (Integer t_iPosition2 : t_objLinkage.getChildLinkages()) {
                if (t_aPositions.contains(t_iPosition2)) {
                    this.m_aErrorList.add("Duplicated child linkage position in GlycoEdge.");
                }
                t_aPositions.add(t_iPosition2);
            }
            t_aPositions = t_objLinkage.getChildLinkages();
            if (t_aPositions.size() > 1 && t_aPositions.contains(-1)) {
                this.m_aErrorList.add("Unknown and defined positions in one GlycoEdge.");
            }
            if (t_objLinkage.getParentLinkages().size() == 0) {
                this.m_aErrorList.add("No parent linkage position given in GlycoEdge.");
            }
            t_aPositions = new ArrayList();
            t_iPosition2 = null;
            for (Integer t_iPosition2 : t_objLinkage.getParentLinkages()) {
                if (t_aPositions.contains(t_iPosition2)) {
                    this.m_aErrorList.add("Duplicated parent linkage position in GlycoEdge.");
                }
                t_aPositions.add(t_iPosition2);
            }
            t_aPositions = t_objLinkage.getParentLinkages();
            if (t_aPositions.size() > 1 && t_aPositions.contains(-1)) {
                this.m_aErrorList.add("Unknown and defined positions in one GlycoEdge.");
            }
            if (t_objLinkage.getChildLinkageType() == null || t_objLinkage.getParentLinkageType() == null) {
                this.m_aErrorList.add("Linkagetype is not set.");
                continue;
            }
            if (t_objLinkage.getChildLinkageType() != LinkageType.UNKNOWN && t_objLinkage.getParentLinkageType() != LinkageType.UNKNOWN) continue;
            this.m_aWarningList.add("Linkagetype UNKNOWN found in structure.");
        }
    }

    @Override
    public void visit(NonMonosaccharide a_objResidue) throws GlycoVisitorException {
        this.m_aWarningList.add("NonMonosaccharides are not allowed in unique GlycoCT.");
        GlycoEdge t_objEdge2 = a_objResidue.getParentEdge();
        if (t_objEdge2 != null) {
            for (Linkage t_objLinkage : t_objEdge2.getGlycosidicLinkages()) {
                if (t_objLinkage.getChildLinkageType() == LinkageType.NONMONOSACCHARID) continue;
                this.m_aErrorList.add("LinkageType for NonMonosaccharide must be LinkageType.NONMONOSACCHARID.");
            }
        }
        for (GlycoEdge t_objEdge2 : a_objResidue.getChildEdges()) {
            for (Linkage t_objLinkage : t_objEdge2.getGlycosidicLinkages()) {
                if (t_objLinkage.getParentLinkageType() == LinkageType.NONMONOSACCHARID) continue;
                this.m_aErrorList.add("LinkageType for NonMonosaccharide must be LinkageType.NONMONOSACCHARID.");
            }
        }
    }

    @Override
    public void visit(UnvalidatedGlycoNode a_objUnvalidated) throws GlycoVisitorException {
        this.m_aErrorList.add("UnvalidatedGlycoNode in Sugar.");
    }

    @Override
    public void visit(Substituent a_objSubstituent) throws GlycoVisitorException {
        GlycoNode t_objNode;
        GlycoEdge t_objEdge2 = a_objSubstituent.getParentEdge();
        int t_iLinkageCount = 0;
        if (t_objEdge2 != null) {
            Iterator<Linkage> t_iterLinkage = t_objEdge2.getGlycosidicLinkages().iterator();
            while (t_iterLinkage.hasNext()) {
                ++t_iLinkageCount;
                Linkage t_objLinkage = t_iterLinkage.next();
                if (!a_objSubstituent.getSubstituentType().getComplexType().booleanValue()) {
                    for (Integer element : t_objLinkage.getChildLinkages()) {
                        if (element.equals(1)) continue;
                        this.m_aErrorList.add("For this substituent " + a_objSubstituent.getSubstituentType().getName() + " linkage pos must be 1.");
                    }
                } else {
                    for (int element : t_objLinkage.getChildLinkages()) {
                        if (element >= 1 || element == -1) continue;
                        this.m_aErrorList.add("For this substituent " + a_objSubstituent.getSubstituentType().getName() + " linkage pos must be larger than 0.");
                    }
                }
                if (t_objLinkage.getChildLinkageType() == LinkageType.NONMONOSACCHARID) continue;
                this.m_aErrorList.add("LinkageType for substituent must be LinkageType.NONMONOSACCHARID.");
            }
        }
        for (GlycoEdge t_objEdge2 : a_objSubstituent.getChildEdges()) {
            Iterator<Linkage> t_iterLinkage = t_objEdge2.getGlycosidicLinkages().iterator();
            while (t_iterLinkage.hasNext()) {
                ++t_iLinkageCount;
                Linkage t_objLinkage = t_iterLinkage.next();
                if (!a_objSubstituent.getSubstituentType().getComplexType().booleanValue()) {
                    for (Integer element : t_objLinkage.getParentLinkages()) {
                        if (element.equals(1)) continue;
                        this.m_aErrorList.add("For this substituent linkage pos must be 1.");
                    }
                } else {
                    for (int element : t_objLinkage.getParentLinkages()) {
                        if (element >= 1 || element == -1) continue;
                        this.m_aErrorList.add("For this substituent " + a_objSubstituent.getSubstituentType().getName() + " linkage pos must be larger than 0.");
                    }
                }
                if (t_objLinkage.getParentLinkageType() == LinkageType.NONMONOSACCHARID) continue;
                this.m_aErrorList.add("LinkageType for substituent must be LinkageType.NONMONOSACCHARID.");
            }
        }
        if (a_objSubstituent.getSubstituentType() == null) {
            this.m_aErrorList.add("SubstituentType for substituent is null.");
        } else {
            SubstituentType t_objSubstitutent = a_objSubstituent.getSubstituentType();
            try {
                if (!this.m_objGlycoGraph.getRootNodes().contains(a_objSubstituent)) {
                    if (t_iLinkageCount < t_objSubstitutent.getMinValence()) {
                        this.m_aErrorList.add("Minimum valence constraint for substituent " + a_objSubstituent.getSubstituentType().getName() + " not fulfilled.");
                    }
                    if (t_iLinkageCount > t_objSubstitutent.getMaxValence() && t_objSubstitutent.getMaxValence() > 0) {
                        this.m_aErrorList.add("Maximum valence constraint for substituent " + a_objSubstituent.getSubstituentType().getName() + " broken.");
                    }
                }
            }
            catch (GlycoconjugateException e) {
                throw new GlycoVisitorException(e.getMessage(), e);
            }
            if (t_objSubstitutent == SubstituentType.EPOXY || t_objSubstitutent == SubstituentType.LACTONE || t_objSubstitutent == SubstituentType.ANHYDRO) {
                if (a_objSubstituent.getChildEdges().size() != 0) {
                    this.m_aErrorList.add("SubstituentType.EPOXY, SubstituentType.LACTONE, SubstituentType.ANHYDRO can not have child linkages.");
                }
                if (a_objSubstituent.getParentEdge().getGlycosidicLinkages().size() != 2) {
                    this.m_aErrorList.add("SubstituentType.EPOXY, SubstituentType.LACTONE, SubstituentType.ANHYDRO can not have more than two linkages.");
                } else {
                    ArrayList<Linkage> t_oLinkages = a_objSubstituent.getParentEdge().getGlycosidicLinkages();
                    GlycoCTLinkageComparator t_linComp = new GlycoCTLinkageComparator();
                    Collections.sort(t_oLinkages, t_linComp);
                    int t_iCount = 1;
                    for (Linkage linkage : t_oLinkages) {
                        if (t_iCount == 1) {
                            if (linkage.getParentLinkageType() != LinkageType.DEOXY) {
                                this.m_aErrorList.add("SubstituentType.EPOXY, SubstituentType.LACTONE, SubstituentType.ANHYDRO first linkage type must be DEOXY.");
                            }
                            ++t_iCount;
                            continue;
                        }
                        if (linkage.getParentLinkageType() == LinkageType.H_AT_OH) continue;
                        this.m_aErrorList.add("SubstituentType.EPOXY, SubstituentType.LACTONE, SubstituentType.ANHYDRO first linkage type must be H_AT_OH.");
                    }
                }
            }
        }
        if (a_objSubstituent.getParentEdge() != null && (t_objNode = a_objSubstituent.getParentEdge().getParent()) != null && this.m_visNodeType.isSubstituent(t_objNode)) {
            this.m_aErrorList.add("Substituent - Substituent linkages are not allowed.");
        }
    }

    @Override
    public void visit(SugarUnitCyclic a_objCyclic) throws GlycoVisitorException {
        GlycoNode t_objNode = a_objCyclic.getCyclicStart();
        if (t_objNode == null) {
            this.m_aErrorList.add("Start residue for cyclic structure is null.");
        }
        if (this.m_visNodeType.isSugarUnitCyclic(t_objNode)) {
            this.m_aErrorList.add("Start residue for cyclic structure is a SugarUnitCyclic.");
        }
        if (!this.m_objGlycoGraph.containsNode(t_objNode)) {
            this.m_aErrorList.add("Start residue is not part of the same GlycoNode as SugarUnitCyclic.");
        }
        if (a_objCyclic.getChildEdges().size() != 0) {
            this.m_aErrorList.add("SugarUnitCyclic can not have child linkages.");
        }
        if (a_objCyclic.getParentEdge() == null) {
            this.m_aErrorList.add("SugarUnitCyclic must have a parent linkage.");
        } else {
            for (Linkage t_objLinkage : a_objCyclic.getParentEdge().getGlycosidicLinkages()) {
                for (Integer t_iPos : t_objLinkage.getChildLinkages()) {
                    if (t_iPos >= 1 || t_iPos == -1) continue;
                    this.m_aErrorList.add("Linkage position smaller than 1 are not allowed.");
                }
            }
        }
    }

    @Override
    public void start(Sugar a_objSugar) throws GlycoVisitorException {
        this.clear();
        try {
            this.m_objGlycoGraph = a_objSugar;
            GlycoTraverser t_objTraverser = this.getTraverser(this);
            t_objTraverser.traverseGraph(a_objSugar);
            GlycoVisitorNodeType t_visType = new GlycoVisitorNodeType();
            for (GlycoNode t_objNode : a_objSugar.getRootNodes()) {
                if (!t_visType.isSubstituent(t_objNode)) continue;
                this.m_aErrorList.add("A substituent can not be the root node auf an sugar.");
            }
            for (UnderdeterminedSubTree t_objTree : a_objSugar.getUndeterminedSubTrees()) {
                this.m_objGlycoGraph = t_objTree;
                if (t_objTree.getRootNodes().size() != 1) {
                    this.m_aErrorList.add("UnderdeterminedSubTree has more than one root residue.");
                }
                t_objTraverser.traverseGraph(t_objTree);
                this.testUnderdeterminded(t_objTree, a_objSugar);
                if (t_objTree.getProbabilityLower() < 100.0) {
                    this.m_aErrorList.add("Sugar can not have a statistical distribution.");
                }
                if (t_objTree.getParents().size() >= 2) continue;
                this.m_aErrorList.add("Each uncertain terminal block needs at least 2 parent residues.");
            }
        }
        catch (GlycoconjugateException e) {
            throw new GlycoVisitorException(e.getMessage(), e);
        }
    }

    private void testUnderdeterminded(UnderdeterminedSubTree a_objTree, GlycoGraph a_objGraph) throws GlycoVisitorException, GlycoconjugateException {
        GlycoEdge t_objEdge;
        for (GlycoNode t_objNode : a_objTree.getParents()) {
            if (a_objGraph.containsNode(t_objNode)) continue;
            this.m_aErrorList.add("Parent node of UnderdeterminedSubTree is not part of the attached GlycoGraph.");
        }
        if (a_objTree.getProbabilityLower() > a_objTree.getProbabilityUpper()) {
            this.m_aErrorList.add("Lower border of probabilitic value for UnderdeterminedSubTree is larger than uper border.");
        }
        if (a_objTree.getProbabilityUpper() > 100.0) {
            this.m_aErrorList.add("A probabilitic value for UnderdeterminedSubTree larger than 100.0% is not possible.");
        }
        if (a_objTree.getParents().size() < 2 && a_objTree.getProbabilityLower() >= 100.0) {
            this.m_aErrorList.add("Each uncertain terminal block needs at least 2 parent residues.");
        }
        if ((t_objEdge = a_objTree.getConnection()).getChild() != null || t_objEdge.getParent() != null) {
            this.m_aErrorList.add("Parent and Child for connection into UnderdetermindedSubTree must be null.");
        }
        if (t_objEdge.getGlycosidicLinkages().size() == 0) {
            this.m_aErrorList.add("Connection into UnderdetermindedSubTree contains no Linkages.");
        }
        for (Linkage t_objLinkage : t_objEdge.getGlycosidicLinkages()) {
            if (t_objLinkage.getChildLinkages().size() == 0) {
                this.m_aErrorList.add("No child linkage position given in GlycoEdge.");
            }
            ArrayList<Object> t_aPositions = new ArrayList();
            Integer t_iPosition2 = null;
            for (Integer t_iPosition2 : t_objLinkage.getChildLinkages()) {
                if (t_aPositions.contains(t_iPosition2)) {
                    this.m_aErrorList.add("Duplicated child linkage position in GlycoEdge.");
                }
                t_aPositions.add(t_iPosition2);
            }
            t_aPositions = t_objLinkage.getChildLinkages();
            if (t_aPositions.size() > 1 && t_aPositions.contains(-1)) {
                this.m_aErrorList.add("Unknown and defined positions in one GlycoEdge.");
            }
            if (t_objLinkage.getParentLinkages().size() == 0) {
                this.m_aErrorList.add("No parent linkage position given in GlycoEdge.");
            }
            t_aPositions = new ArrayList();
            t_iPosition2 = null;
            for (Integer t_iPosition2 : t_objLinkage.getParentLinkages()) {
                if (t_aPositions.contains(t_iPosition2)) {
                    this.m_aErrorList.add("Duplicated parent linkage position in GlycoEdge.");
                }
                t_aPositions.add(t_iPosition2);
            }
            t_aPositions = t_objLinkage.getParentLinkages();
            if (t_aPositions.size() > 1 && t_aPositions.contains(-1)) {
                this.m_aErrorList.add("Unknown and defined positions in one GlycoEdge.");
            }
            LinkageType t_objLinkTypeChild = null;
            if (a_objTree.getRootNodes().size() == 1) {
                GlycoNode t_objNode = a_objTree.getRootNodes().get(0);
                if (this.m_visNodeType.isMonosaccharide(t_objNode)) {
                    if (t_objLinkage.getChildLinkageType() == LinkageType.NONMONOSACCHARID || t_objLinkage.getChildLinkageType() == LinkageType.UNVALIDATED) {
                        this.m_aErrorList.add("LinkageType for Start residue of UnderdetermindedSubTree is not allowed (for Monosaccharide).");
                    } else {
                        t_objLinkTypeChild = t_objLinkage.getChildLinkageType();
                    }
                } else if (this.m_visNodeType.isSubstituent(t_objNode)) {
                    if (t_objLinkage.getChildLinkageType() != LinkageType.NONMONOSACCHARID) {
                        this.m_aErrorList.add("LinkageType of start residue of UnderdetermindedSubTree is not allowed (for Substituent).");
                    }
                } else if (this.m_visNodeType.isNonMonosaccharide(t_objNode) && t_objLinkage.getChildLinkageType() != LinkageType.NONMONOSACCHARID) {
                    this.m_aErrorList.add("LinkageType of start residue of UnderdetermindedSubTree is not allowed (for NonMonosaccharide).");
                }
            }
            boolean t_bContainMS = false;
            boolean t_bContainSubst = false;
            boolean t_bContainNonMS = false;
            Iterator<GlycoNode> t_iterParent = a_objTree.getParents().iterator();
            while (t_iterParent.hasNext()) {
                GlycoNode t_objParent = this.getSimpleGlycoNode(t_iterParent.next(), false);
                LinkageType t_objLinkTypeParent = null;
                if (this.m_visNodeType.isMonosaccharide(t_objParent)) {
                    if (t_objLinkage.getParentLinkageType() == LinkageType.NONMONOSACCHARID || t_objLinkage.getParentLinkageType() == LinkageType.UNVALIDATED) {
                        this.m_aErrorList.add("LinkageType for parent of UnderdetermindedSubTree is not allowed (for Monosaccharide).");
                    } else {
                        t_objLinkTypeParent = t_objLinkage.getParentLinkageType();
                        if (t_objLinkTypeChild != null && t_objLinkTypeParent != LinkageType.UNKNOWN && (t_objLinkTypeChild != LinkageType.DEOXY || t_objLinkTypeParent != LinkageType.H_AT_OH)) {
                            this.m_aErrorList.add("UnderdetermindedSubTree connection is not a glycosidic linkage (for two Monosaccharides).");
                        }
                    }
                    t_bContainMS = true;
                    continue;
                }
                if (this.m_visNodeType.isNonMonosaccharide(t_objParent)) {
                    if (t_objLinkage.getParentLinkageType() != LinkageType.NONMONOSACCHARID && t_objLinkage.getParentLinkageType() != LinkageType.UNKNOWN) {
                        this.m_aErrorList.add("LinkageType of parent residue of UnderdetermindedSubTree is not allowed (for NonMonosaccharide).");
                    }
                    t_bContainNonMS = true;
                    continue;
                }
                if (!this.m_visNodeType.isSubstituent(t_objParent)) continue;
                if (t_objLinkage.getParentLinkageType() != LinkageType.NONMONOSACCHARID && t_objLinkage.getParentLinkageType() != LinkageType.UNKNOWN) {
                    this.m_aErrorList.add("LinkageType of parent residue of UnderdetermindedSubTree is not allowed (for Substituent).");
                }
                t_bContainSubst = true;
            }
            if (t_bContainMS) {
                if ((t_bContainNonMS || t_bContainSubst) && t_objLinkage.getParentLinkageType() != LinkageType.UNKNOWN) {
                    this.m_aErrorList.add("LinkageType of parent residue of UnderdetermindedSubTree must be UNKNOWN (for different types of parent residues).");
                }
            } else if (t_bContainNonMS) {
                if (t_bContainSubst && t_objLinkage.getParentLinkageType() != LinkageType.UNKNOWN) {
                    this.m_aErrorList.add("LinkageType of parent residue of UnderdetermindedSubTree must be UNKNOWN (for different types of parent residues).");
                }
            } else if (t_bContainSubst && t_objLinkage.getParentLinkageType() == LinkageType.UNKNOWN) {
                this.m_aErrorList.add("LinkageType of parent residue of UnderdetermindedSubTree can not be UNKNOWN (for same types of parent residues).");
            }
            if (t_objLinkage.getChildLinkageType() != LinkageType.UNKNOWN && t_objLinkage.getParentLinkageType() != LinkageType.UNKNOWN) continue;
            this.m_aWarningList.add("UND linkage contains linkage type UNKNOWN.");
        }
    }

    @Override
    public void visit(SugarUnitRepeat a_objRepeat) throws GlycoVisitorException {
        try {
            GlycoGraph t_objGraph = this.m_objGlycoGraph;
            this.m_objGlycoGraph = a_objRepeat;
            if (a_objRepeat.getRootNodes().size() != 1) {
                this.m_aErrorList.add("SugarUnitRepeat has more than one root residue.");
            }
            GlycoTraverser t_objTraverser = this.getTraverser(this);
            t_objTraverser.traverseGraph(a_objRepeat);
            if (a_objRepeat.getMinRepeatCount() == a_objRepeat.getMaxRepeatCount()) {
                if (a_objRepeat.getMinRepeatCount() < 7 && a_objRepeat.getMinRepeatCount() != -1) {
                    this.m_aErrorList.add("SugarUnitRepeat with repeat count less than 7 are not allowed.");
                }
            } else {
                if (a_objRepeat.getMinRepeatCount() > a_objRepeat.getMaxRepeatCount() && a_objRepeat.getMaxRepeatCount() != -1) {
                    this.m_aErrorList.add("Min repeat count of SugarUnitRepeat must be smaller than max repeat count.");
                }
                if (a_objRepeat.getMinRepeatCount() < 1 && a_objRepeat.getMinRepeatCount() != -1) {
                    this.m_aErrorList.add("Negative min repeat count of SugarUnitRepeat is not allowed.");
                }
                if (a_objRepeat.getMaxRepeatCount() < 1 && a_objRepeat.getMaxRepeatCount() != -1) {
                    this.m_aErrorList.add("Negative max repeat count of SugarUnitRepeat is not allowed.");
                }
            }
            GlycoEdge t_objInternal = a_objRepeat.getRepeatLinkage();
            this.testLinkageArray(t_objInternal);
            if (t_objInternal.getChild() == null || t_objInternal.getParent() == null) {
                this.m_aErrorList.add("Child or parent residue of internal repeat linkage is null.");
            } else {
                if (!a_objRepeat.containsNode(t_objInternal.getChild())) {
                    this.m_aErrorList.add("Child of repeat linkage is not part of the repeat unit.");
                }
                if (!a_objRepeat.getRootNodes().contains(t_objInternal.getChild())) {
                    this.m_aErrorList.add("Child of repeat linkage is not part of the root nodes of the repeat unit.");
                }
                if (!a_objRepeat.containsNode(t_objInternal.getParent())) {
                    this.m_aErrorList.add("Parent of repeat linkage is not part of the repeat unit.");
                }
                GlycoNode t_objParent = this.getSimpleGlycoNode(t_objInternal.getParent(), false);
                GlycoNode t_objChild = this.getSimpleGlycoNode(t_objInternal.getChild(), true);
                for (Linkage t_objLinkage : t_objInternal.getGlycosidicLinkages()) {
                    if (t_objParent != null) {
                        if (this.m_visNodeType.isMonosaccharide(t_objParent)) {
                            if (t_objLinkage.getParentLinkageType() == LinkageType.NONMONOSACCHARID || t_objLinkage.getParentLinkageType() == LinkageType.UNVALIDATED) {
                                this.m_aErrorList.add("Wrong linkage type in internal repeat unit (for Monosaccharide).");
                            }
                        } else if (this.m_visNodeType.isNonMonosaccharide(t_objParent)) {
                            if (t_objLinkage.getParentLinkageType() != LinkageType.NONMONOSACCHARID) {
                                this.m_aErrorList.add("Wrong linkage type in internal repeat unit (for NonMonosaccharide).");
                            }
                        } else if (this.m_visNodeType.isSubstituent(t_objParent)) {
                            if (t_objLinkage.getParentLinkageType() != LinkageType.NONMONOSACCHARID) {
                                this.m_aErrorList.add("Wrong linkage type in internal repeat unit (for Substituent).");
                            }
                        } else if (this.m_visNodeType.isSugarUnitCyclic(t_objParent)) {
                            this.m_aErrorList.add("Cyclic unit can not be the parent residue in a repeat linkage.");
                        }
                    }
                    if (t_objChild != null) {
                        if (this.m_visNodeType.isMonosaccharide(t_objChild)) {
                            if (t_objLinkage.getChildLinkageType() == LinkageType.NONMONOSACCHARID || t_objLinkage.getChildLinkageType() == LinkageType.UNVALIDATED) {
                                this.m_aErrorList.add("Wrong linkage type in internal repeat unit (for Monosaccharide).");
                            }
                        } else if (this.m_visNodeType.isNonMonosaccharide(t_objChild)) {
                            if (t_objLinkage.getChildLinkageType() != LinkageType.NONMONOSACCHARID) {
                                this.m_aErrorList.add("Wrong linkage type in internal repeat unit (for NonMonosaccharide).");
                            }
                        } else if (this.m_visNodeType.isSubstituent(t_objChild)) {
                            if (t_objLinkage.getChildLinkageType() != LinkageType.NONMONOSACCHARID) {
                                this.m_aErrorList.add("Wrong linkage type in internal repeat unit (for Substituent).");
                            }
                        } else if (this.m_visNodeType.isSugarUnitCyclic(t_objChild)) {
                            this.m_aErrorList.add("Cyclic unit can not be the parent residue in a repeat linkage.");
                        }
                    }
                    if (t_objChild != null && t_objParent != null && this.m_visNodeType.isMonosaccharide(t_objChild) && this.m_visNodeType.isMonosaccharide(t_objParent) && (t_objLinkage.getParentLinkageType() != LinkageType.H_AT_OH || t_objLinkage.getChildLinkageType() != LinkageType.DEOXY)) {
                        this.m_aErrorList.add("Repeatlinkage is not a glycosidic linkage.");
                    }
                    for (Integer t_iPos : t_objLinkage.getChildLinkages()) {
                        if (t_iPos >= 1 || t_iPos == -1) continue;
                        this.m_aErrorList.add("Linkage position smaller than 1 are not allowed.");
                    }
                    for (Integer t_iPos : t_objLinkage.getParentLinkages()) {
                        if (t_iPos >= 1 || t_iPos == -1) continue;
                        this.m_aErrorList.add("Linkage position smaller than 1 are not allowed.");
                    }
                }
                GlycoEdge t_objEdge2 = a_objRepeat.getParentEdge();
                if (t_objEdge2 != null) {
                    for (Linkage t_objLinkage : t_objEdge2.getGlycosidicLinkages()) {
                        if (t_objLinkage.getChildLinkageType() != LinkageType.NONMONOSACCHARID) {
                            this.m_aErrorList.add("Wrong linkage type in linkage to repeat unit.");
                        }
                        for (Integer t_iPos : t_objLinkage.getChildLinkages()) {
                            if (t_iPos >= 1 || t_iPos == -1) continue;
                            this.m_aErrorList.add("Linkage position smaller than 1 are not allowed.");
                        }
                    }
                    if (t_objEdge2.getGlycosidicLinkages().size() != a_objRepeat.getRepeatLinkage().getGlycosidicLinkages().size()) {
                        this.m_aErrorList.add("Number of linkages into repeat and internal repeat linkages does not match.");
                    }
                }
                for (GlycoEdge t_objEdge2 : a_objRepeat.getChildEdges()) {
                    for (Linkage t_objLinkage : t_objEdge2.getGlycosidicLinkages()) {
                        if (t_objLinkage.getParentLinkageType() != LinkageType.NONMONOSACCHARID) {
                            this.m_aErrorList.add("Wrong linkage type in linkage from repeat unit.");
                        }
                        for (Integer t_iPos : t_objLinkage.getParentLinkages()) {
                            if (t_iPos >= 1 || t_iPos == -1) continue;
                            this.m_aErrorList.add("Linkage position smaller than 1 are not allowed.");
                        }
                    }
                    if (t_objEdge2.getGlycosidicLinkages().size() == a_objRepeat.getRepeatLinkage().getGlycosidicLinkages().size()) continue;
                    this.m_aErrorList.add("Number of linkages out of repeat and internal repeat linkages does not match.");
                }
            }
            for (UnderdeterminedSubTree t_objTree : a_objRepeat.getUndeterminedSubTrees()) {
                this.m_objGlycoGraph = t_objTree;
                if (t_objTree.getRootNodes().size() != 1) {
                    this.m_aErrorList.add("UnderdeterminedSubTree has more than one root residue.");
                }
                t_objTraverser.traverseGraph(t_objTree);
                this.testUnderdeterminded(t_objTree, a_objRepeat);
            }
            this.m_objGlycoGraph = t_objGraph;
        }
        catch (GlycoconjugateException e) {
            throw new GlycoVisitorException(e.getMessage(), e);
        }
    }

    private GlycoNode getSimpleGlycoNode(GlycoNode a_objResidue, boolean a_bRepeatIn) throws GlycoVisitorException {
        int t_iNodeType = this.m_visNodeType.getNodeType(a_objResidue);
        if (t_iNodeType == 2) {
            return a_objResidue;
        }
        if (t_iNodeType == 5) {
            return null;
        }
        if (t_iNodeType == 3) {
            return this.getSimpleGlycoNode(this.m_visNodeType.getSugarUnitCyclic(a_objResidue).getCyclicStart(), a_bRepeatIn);
        }
        return a_objResidue;
    }

    @Override
    public void visit(SugarUnitAlternative a_objAlternative) throws GlycoVisitorException {
        GlycoTraverser t_objTraverser = this.getTraverser(this);
        if (a_objAlternative.getAlternatives().size() < 2) {
            this.m_aErrorList.add("SugarUnitAlternative must have at least two alternative units.");
        }
        for (GlycoGraphAlternative t_objAltGraph : a_objAlternative.getAlternatives()) {
            t_objTraverser.traverseGraph(t_objAltGraph);
            if (a_objAlternative.getParentEdge() == null) {
                if (t_objAltGraph.getLeadInNode() != null) {
                    this.m_aErrorList.add("SugarUnitAlternative without parent edge can not have lead in nodes.");
                }
            } else if (t_objAltGraph.getLeadInNode() == null) {
                this.m_aErrorList.add("SugarUnitAlternative with parent edge has to have lead in nodes.");
            }
            Iterator<GlycoEdge> t_iterChilds = a_objAlternative.getChildEdges().iterator();
            while (t_iterChilds.hasNext()) {
                GlycoNode t_objChild = t_iterChilds.next().getChild();
                if (t_objAltGraph.getLeadOutNodeToNode().containsKey(t_objChild)) continue;
                this.m_aErrorList.add("Child node is missing in lead out node definition.");
            }
            if (t_objAltGraph.getLeadOutNodeToNode().size() == a_objAlternative.getChildEdges().size()) continue;
            this.m_aErrorList.add("Number of lead out nodes for a alternative tree and number of child residues for a Alternative unit must be identical.");
        }
        GlycoNode t_objLead = null;
        boolean t_bAllSame = true;
        if (a_objAlternative.getParentEdge() != null) {
            for (GlycoGraphAlternative t_objAltGraph : a_objAlternative.getAlternatives()) {
                if (t_objLead == null) {
                    t_objLead = t_objAltGraph.getLeadInNode();
                    continue;
                }
                if (this.m_visNodeType.getNodeType(t_objLead) == this.m_visNodeType.getNodeType(t_objAltGraph.getLeadInNode())) continue;
                t_bAllSame = false;
            }
            if (t_bAllSame) {
                if (this.testLinkageType(a_objAlternative.getParentEdge().getParent(), a_objAlternative.getParentEdge(), t_objLead)) {
                    this.m_aErrorList.add("Lead in linkage of alternative trees have the false linkage type.");
                }
            } else {
                for (Linkage t_objLinkage : a_objAlternative.getParentEdge().getGlycosidicLinkages()) {
                    if (t_objLinkage.getChildLinkageType() == LinkageType.UNKNOWN) continue;
                    this.m_aErrorList.add("For alternative trees with diferent types of lead in node the linkage type of the parent linkage has to be UNKNOWN.");
                }
            }
        }
        for (GlycoEdge t_objEdge : a_objAlternative.getChildEdges()) {
            t_bAllSame = true;
            t_objLead = null;
            for (GlycoGraphAlternative t_objAltGraph : a_objAlternative.getAlternatives()) {
                if (t_objLead == null) {
                    t_objLead = t_objAltGraph.getLeadOutNodeToNode().get(t_objEdge.getChild());
                    continue;
                }
                if (this.m_visNodeType.getNodeType(t_objLead) == this.m_visNodeType.getNodeType(t_objAltGraph.getLeadOutNodeToNode().get(t_objEdge.getChild()))) continue;
                t_bAllSame = false;
            }
            if (t_bAllSame) {
                if (!this.testLinkageType(t_objLead, t_objEdge, t_objEdge.getChild())) continue;
                this.m_aErrorList.add("Lead out linkage of alternative trees have the false linkage type.");
                continue;
            }
            for (Linkage t_objLinkage : t_objEdge.getGlycosidicLinkages()) {
                if (t_objLinkage.getParentLinkageType() == LinkageType.UNKNOWN) continue;
                this.m_aErrorList.add("For alternative trees with different types of lead out node, the linkage type of the corresponding child linkage has to be UNKNOWN.");
            }
        }
    }

    private boolean testLinkageType(GlycoNode a_objParent, GlycoEdge a_objEdge, GlycoNode a_objChild) throws GlycoVisitorException {
        GlycoNode t_objParent = this.getSimpleGlycoNode(a_objParent, false);
        GlycoNode t_objChild = this.getSimpleGlycoNode(a_objChild, true);
        boolean t_bResult = true;
        for (Linkage t_objLinkage : a_objEdge.getGlycosidicLinkages()) {
            if (t_objParent != null) {
                if (this.m_visNodeType.isMonosaccharide(t_objParent)) {
                    if (t_objLinkage.getParentLinkageType() == LinkageType.NONMONOSACCHARID || t_objLinkage.getParentLinkageType() == LinkageType.UNVALIDATED) {
                        this.m_aErrorList.add("Wrong linkage type in linkage (for Monosaccharide).");
                    }
                } else if (this.m_visNodeType.isNonMonosaccharide(t_objParent)) {
                    if (t_objLinkage.getParentLinkageType() != LinkageType.NONMONOSACCHARID) {
                        this.m_aErrorList.add("Wrong linkage type in linkage (for NonMonosaccharide).");
                    }
                } else if (this.m_visNodeType.isSubstituent(t_objParent)) {
                    if (t_objLinkage.getParentLinkageType() != LinkageType.NONMONOSACCHARID) {
                        this.m_aErrorList.add("Wrong linkage type in linkage (for Substituent).");
                    }
                } else if (this.m_visNodeType.isSugarUnitRepeat(t_objParent)) {
                    if (t_objLinkage.getParentLinkageType() != LinkageType.NONMONOSACCHARID) {
                        this.m_aErrorList.add("Wrong linkage type in linkage (for Repeat).");
                    }
                    t_objParent = null;
                }
            }
            if (t_objChild != null) {
                if (this.m_visNodeType.isMonosaccharide(t_objChild)) {
                    if (t_objLinkage.getChildLinkageType() == LinkageType.NONMONOSACCHARID || t_objLinkage.getChildLinkageType() == LinkageType.UNVALIDATED) {
                        this.m_aErrorList.add("Wrong linkage type in linkage (for Monosaccharide).");
                    }
                } else if (this.m_visNodeType.isNonMonosaccharide(t_objChild)) {
                    if (t_objLinkage.getChildLinkageType() != LinkageType.NONMONOSACCHARID) {
                        this.m_aErrorList.add("Wrong linkage type in linkage (for NonMonosaccharide).");
                    }
                } else if (this.m_visNodeType.isSubstituent(t_objChild)) {
                    if (t_objLinkage.getChildLinkageType() != LinkageType.NONMONOSACCHARID) {
                        this.m_aErrorList.add("Wrong linkage type in linkage (for Substituent).");
                    }
                } else if (this.m_visNodeType.isSugarUnitRepeat(t_objChild)) {
                    if (t_objLinkage.getChildLinkageType() != LinkageType.NONMONOSACCHARID) {
                        this.m_aErrorList.add("Wrong linkage type in linkage (for Repeat).");
                    }
                    t_objChild = null;
                }
            }
            if (t_objChild == null || t_objParent == null || !this.m_visNodeType.isMonosaccharide(t_objChild) || !this.m_visNodeType.isMonosaccharide(t_objParent) || t_objLinkage.getParentLinkageType() == LinkageType.H_AT_OH && t_objLinkage.getChildLinkageType() == LinkageType.DEOXY) continue;
            this.m_aErrorList.add("Linkage is not a glycosidic linkage.");
        }
        return t_bResult;
    }

    @Override
    public void visit(Monosaccharide a_objMonosaccharid) throws GlycoVisitorException {
        if (a_objMonosaccharid.getAnomer() == null) {
            this.m_aErrorList.add("Anomer null not valid.");
        }
        if (a_objMonosaccharid.getSuperclass() == null) {
            this.m_aErrorList.add("Superclass null not valid.");
        }
        if (a_objMonosaccharid.getBaseType() == null) {
            this.m_aErrorList.add("Basetype List null not valid.");
        }
        Integer t_iChainLength = a_objMonosaccharid.getSuperclass().getCAtomCount();
        if (a_objMonosaccharid.getSuperclass() == Superclass.SUG) {
            t_iChainLength = 100;
        }
        for (Modification t_objModi : a_objMonosaccharid.getModification()) {
            if (t_iChainLength < t_objModi.getPositionOne()) {
                this.m_aErrorList.add("Modification is out of C-bounds");
            }
            if (t_objModi.hasPositionTwo() && t_iChainLength < t_objModi.getPositionTwo()) {
                this.m_aErrorList.add("Modification is out of C-bounds");
            }
            if (t_objModi.getModificationType() == ModificationType.ALDI && t_objModi.getPositionOne() != 1) {
                this.m_aErrorList.add("Alditol is only allowed for C1");
                if (a_objMonosaccharid.getRingStart() == 1) {
                    this.m_aErrorList.add("C1 cannot be ringstart in alditols");
                }
            }
            if (t_objModi.getModificationType() == ModificationType.DEOXY && t_objModi.getPositionOne() == 1) {
                this.m_aErrorList.add("Deoxy on C1 impossible");
            }
            if (t_objModi.getModificationType() == ModificationType.ACID && t_objModi.getPositionOne() != 1 && t_objModi.getPositionOne() != t_iChainLength.intValue()) {
                this.m_aErrorList.add("Acidic functions only at terminal C");
            }
            if (t_objModi.getModificationType() != ModificationType.UNKNOWN_DOUBLEBOND && t_objModi.getModificationType() != ModificationType.DOUBLEBOND) continue;
            for (Modification m : a_objMonosaccharid.getModification()) {
                if (m.getPositionOne() != t_objModi.getPositionOne() || m == t_objModi || m.getModificationType() == ModificationType.DEOXY || m.getModificationType() == ModificationType.ALDI) continue;
                this.m_aErrorList.add("Double bonds cannot have other modifications than Deoxy or aldi");
            }
            for (Modification m : a_objMonosaccharid.getModification()) {
                if (m.getPositionOne() != t_objModi.getPositionOne() + 1 || m == t_objModi || m.getModificationType() == ModificationType.DEOXY) continue;
                this.m_aErrorList.add("Double bonds cannot have other modifications than Deoxy at n+1");
            }
        }
        if (a_objMonosaccharid.getBaseType().size() > 1) {
            for (int i = 0; i < a_objMonosaccharid.getBaseType().size(); ++i) {
                BaseType t_basetype = a_objMonosaccharid.getBaseType().get(i);
                if (i == 0 || t_basetype.getStereoCode().length() == 4) continue;
                this.m_aErrorList.add("Basetype order is not according to IUPAC");
            }
        }
        if (a_objMonosaccharid.getBaseType().size() != 0) {
            Integer t_IntSuperclass = a_objMonosaccharid.getSuperclass().getCAtomCount();
            HashMap<Integer, String> modihash = new HashMap<Integer, String>();
            Integer t_IntTheoreticalNumber = 0;
            for (BaseType baseType : a_objMonosaccharid.getBaseType()) {
                t_IntTheoreticalNumber = t_IntTheoreticalNumber + baseType.getStereoCode().length();
            }
            t_IntTheoreticalNumber = t_IntTheoreticalNumber + 2;
            for (Modification modification : a_objMonosaccharid.getModification()) {
                if (!(modification.getName() != "d" && modification.getName() != "keto" || modification.getPositionOne() == 1 || modification.getPositionOne() == a_objMonosaccharid.getSuperclass().getCAtomCount() || modihash.containsKey(modification.getPositionOne()))) {
                    modihash.put(modification.getPositionOne(), modification.getName());
                    Integer n = t_IntTheoreticalNumber;
                    t_IntTheoreticalNumber = t_IntTheoreticalNumber + 1;
                }
                Integer d_count = 0;
                if (modification.getName() != "enx" && modification.getName() != "en") continue;
                for (Modification element2 : a_objMonosaccharid.getModification()) {
                    Integer n;
                    if (element2.getPositionOne() == modification.getPositionOne() && element2.getName() == "d") {
                        n = d_count;
                        d_count = d_count + 1;
                    }
                    if (element2.getPositionOne() != modification.getPositionTwo().intValue() || element2.getName() != "d") continue;
                    n = d_count;
                    d_count = d_count + 1;
                }
                t_IntTheoreticalNumber = t_IntTheoreticalNumber + 2 - d_count;
            }
            if (t_IntTheoreticalNumber != t_IntSuperclass) {
                this.m_aErrorList.add("Error on superclass definition" + t_IntTheoreticalNumber + "====" + t_IntSuperclass);
            }
        }
        if (a_objMonosaccharid.getRingEnd() > t_iChainLength || a_objMonosaccharid.getRingStart() > t_iChainLength) {
            this.m_aErrorList.add("Ring end out of C-backbone");
        }
        if (a_objMonosaccharid.getRingEnd() > 0 && a_objMonosaccharid.getRingStart() > 0) {
            Integer t_IntRingSize = 0;
            ArrayList<Integer> t_IntKeto = new ArrayList<Integer>();
            for (Modification element3 : a_objMonosaccharid.getModification()) {
                if (element3.getModificationType() != ModificationType.KETO) continue;
                t_IntKeto.add(element3.getPositionOne());
            }
            if (!t_IntKeto.contains(a_objMonosaccharid.getRingStart()) && a_objMonosaccharid.getRingStart() != 1) {
                this.m_aErrorList.add("Ring has to start at a carbonyl function");
            }
            t_IntRingSize = a_objMonosaccharid.getRingEnd() - a_objMonosaccharid.getRingStart();
            if (a_objMonosaccharid.getRingStart() + t_IntRingSize > a_objMonosaccharid.getSuperclass().getCAtomCount()) {
                this.m_aErrorList.add("Ring size exceeds backbone");
            }
        }
        if (a_objMonosaccharid.getAnomer() == Anomer.OpenChain && (a_objMonosaccharid.getRingStart() != 0 || a_objMonosaccharid.getRingEnd() != 0)) {
            this.m_aErrorList.add("Open chain has no ring closure");
        }
        if (a_objMonosaccharid.getRingStart() != 0 && a_objMonosaccharid.getRingEnd() != 0 && a_objMonosaccharid.getAnomer() == Anomer.OpenChain) {
            this.m_aErrorList.add("Open chain has no ring closure");
        }
        ArrayList<Boolean> t_aOH = new ArrayList<Boolean>();
        ArrayList<Boolean> t_aH = new ArrayList<Boolean>();
        for (int t_iCounter = 0; t_iCounter <= t_iChainLength; ++t_iCounter) {
            t_aH.add(true);
            t_aOH.add(true);
        }
        for (Modification t_objModi : a_objMonosaccharid.getModification()) {
            if (t_objModi.getPositionOne() <= 0) continue;
            int n = 0;
            if (t_objModi.getPositionTwo() != null && t_objModi.getPositionTwo() > 0) {
                n = 0;
            }
            if (n > t_iChainLength || t_objModi.getPositionOne() > t_iChainLength) {
                this.m_aErrorList.add("Modification postition out of chain length.");
                continue;
            }
            if (t_objModi.getModificationType() == ModificationType.ACID) {
                t_aH.set(t_objModi.getPositionOne(), false);
                continue;
            }
            if (t_objModi.getModificationType() == ModificationType.DEOXY) {
                t_aOH.set(t_objModi.getPositionOne(), false);
                continue;
            }
            if (t_objModi.getModificationType() == ModificationType.KETO) {
                t_aH.set(t_objModi.getPositionOne(), false);
                if (t_objModi.getPositionOne() == a_objMonosaccharid.getRingStart() || a_objMonosaccharid.getRingStart() == -1) continue;
                t_aOH.set(t_objModi.getPositionOne(), false);
                continue;
            }
            if (t_objModi.getModificationType() != ModificationType.TRIPLEBOND) continue;
            t_aH.set(t_objModi.getPositionOne(), false);
            t_aOH.set(t_objModi.getPositionOne(), false);
        }
        if (a_objMonosaccharid.getParentEdge() != null) {
            for (Linkage t_objLinkage : a_objMonosaccharid.getParentEdge().getGlycosidicLinkages()) {
                if (t_objLinkage.getChildLinkages().size() != 1) continue;
                for (int t_iPos : t_objLinkage.getChildLinkages()) {
                    if (t_iPos > 0) {
                        if (t_iPos > t_iChainLength) {
                            this.m_aErrorList.add("Attache position of monosaccharide parent edge is out of chain length.");
                            continue;
                        }
                        if (t_objLinkage.getChildLinkageType() == LinkageType.DEOXY) {
                            if (((Boolean)t_aOH.get(t_iPos)).booleanValue()) {
                                t_aOH.set(t_iPos, false);
                                continue;
                            }
                            this.m_aErrorList.add("Attache position of monosaccharide parent edge is not possible (DEOXY).");
                            continue;
                        }
                        if (t_objLinkage.getChildLinkageType() == LinkageType.H_AT_OH) {
                            if (((Boolean)t_aOH.get(t_iPos)).booleanValue()) {
                                t_aOH.set(t_iPos, false);
                                continue;
                            }
                            this.m_aErrorList.add("Attache position of monosaccharide parent edge is not possible (H_AT_OH).");
                            continue;
                        }
                        if (t_objLinkage.getChildLinkageType() == LinkageType.H_LOSE) {
                            if (((Boolean)t_aH.get(t_iPos)).booleanValue()) {
                                t_aH.set(t_iPos, false);
                                continue;
                            }
                            this.m_aErrorList.add("Attache position of monosaccharide parent edge is not possible (H_LOSE).");
                            continue;
                        }
                        if (t_objLinkage.getChildLinkageType() == LinkageType.NONMONOSACCHARID) {
                            this.m_aErrorList.add("Nonmonosaccharide linkage tpyes are not allowed in monosaccharide parent edge.");
                            continue;
                        }
                        if (t_objLinkage.getChildLinkageType() != LinkageType.UNVALIDATED) continue;
                        this.m_aErrorList.add("Unvalidated linkage tpyes are not allowed in monosaccharide parent edge.");
                        continue;
                    }
                    if (t_iPos >= 1 || t_iPos == -1) continue;
                    this.m_aErrorList.add("Linkage positions smaller than 1 are not allowed.");
                }
            }
        }
        for (GlycoEdge t_edge : a_objMonosaccharid.getChildEdges()) {
            for (Linkage t_objLinkage : t_edge.getGlycosidicLinkages()) {
                if (t_objLinkage.getParentLinkages().size() != 1) continue;
                for (int t_iPos : t_objLinkage.getParentLinkages()) {
                    if (t_iPos > 0) {
                        if (t_iPos > t_iChainLength) {
                            this.m_aErrorList.add("Attache position of monosaccharide parent edge is out of chain length.");
                            continue;
                        }
                        if (t_objLinkage.getParentLinkageType() == LinkageType.DEOXY) {
                            if (((Boolean)t_aOH.get(t_iPos)).booleanValue()) {
                                t_aOH.set(t_iPos, false);
                                continue;
                            }
                            this.m_aErrorList.add("Attache position of monosaccharide child edge is not possible (DEOXY).");
                            continue;
                        }
                        if (t_objLinkage.getParentLinkageType() == LinkageType.H_AT_OH) {
                            if (((Boolean)t_aOH.get(t_iPos)).booleanValue()) {
                                t_aOH.set(t_iPos, false);
                                continue;
                            }
                            this.m_aErrorList.add("Attache position of monosaccharide child edge is not possible (H_AT_OH).");
                            continue;
                        }
                        if (t_objLinkage.getParentLinkageType() == LinkageType.H_LOSE) {
                            if (((Boolean)t_aH.get(t_iPos)).booleanValue()) {
                                t_aH.set(t_iPos, false);
                                continue;
                            }
                            this.m_aErrorList.add("Attache position of monosaccharide child edge is not possible (H_LOSE).");
                            continue;
                        }
                        if (t_objLinkage.getParentLinkageType() == LinkageType.NONMONOSACCHARID) {
                            this.m_aErrorList.add("Nonmonosaccharide linkage tpyes are not allowed in monosaccharide parent edge.");
                            continue;
                        }
                        if (t_objLinkage.getChildLinkageType() != LinkageType.UNVALIDATED) continue;
                        this.m_aErrorList.add("Unvalidated linkage tpyes are not allowed in monosaccharide parent edge.");
                        continue;
                    }
                    if (t_iPos >= 1 || t_iPos == -1) continue;
                    this.m_aErrorList.add("Linkage positions smaller than 1 are not allowed.");
                }
            }
        }
        if (a_objMonosaccharid.getParentEdge() != null) {
            for (Linkage t_objLinkage : a_objMonosaccharid.getParentEdge().getGlycosidicLinkages()) {
                if (t_objLinkage.getChildLinkages().size() <= 1) continue;
                for (int t_iPos : t_objLinkage.getChildLinkages()) {
                    if (t_iPos > 0) {
                        if (t_iPos > t_iChainLength) {
                            this.m_aErrorList.add("Alternative attache position of monosaccharide parent edge is out of chain length.");
                            continue;
                        }
                        if (t_objLinkage.getChildLinkageType() == LinkageType.DEOXY) {
                            if (((Boolean)t_aOH.get(t_iPos)).booleanValue()) continue;
                            this.m_aErrorList.add("Alternative attache position of monosaccharide parent edge is not possible (DEOXY).");
                            continue;
                        }
                        if (t_objLinkage.getChildLinkageType() == LinkageType.H_AT_OH) {
                            if (((Boolean)t_aOH.get(t_iPos)).booleanValue()) continue;
                            this.m_aErrorList.add("Alternative attache position of monosaccharide parent edge is not possible (H_AT_OH).");
                            continue;
                        }
                        if (t_objLinkage.getChildLinkageType() == LinkageType.H_LOSE) {
                            if (((Boolean)t_aH.get(t_iPos)).booleanValue()) continue;
                            this.m_aErrorList.add("Alternative attache position of monosaccharide parent edge is not possible (H_LOSE).");
                            continue;
                        }
                        if (t_objLinkage.getChildLinkageType() == LinkageType.NONMONOSACCHARID) {
                            this.m_aErrorList.add("Nonmonosaccharide linkage tpyes are not allowed in monosaccharide parent edge.");
                            continue;
                        }
                        if (t_objLinkage.getChildLinkageType() != LinkageType.UNVALIDATED) continue;
                        this.m_aErrorList.add("Unvalidated linkage tpyes are not allowed in monosaccharide parent edge.");
                        continue;
                    }
                    if (t_iPos >= 1 || t_iPos == -1) continue;
                    this.m_aErrorList.add("Linkage positions smaller than 1 are not allowed.");
                }
            }
        }
        for (GlycoEdge t_edge : a_objMonosaccharid.getChildEdges()) {
            for (Linkage t_objLinkage : t_edge.getGlycosidicLinkages()) {
                if (t_objLinkage.getParentLinkages().size() <= 1) continue;
                for (int t_iPos : t_objLinkage.getParentLinkages()) {
                    if (t_iPos > 0) {
                        if (t_iPos > t_iChainLength) {
                            this.m_aErrorList.add("Alternative attache position of monosaccharide parent edge is out of chain length.");
                            continue;
                        }
                        if (t_objLinkage.getParentLinkageType() == LinkageType.DEOXY) {
                            if (((Boolean)t_aOH.get(t_iPos)).booleanValue()) continue;
                            this.m_aErrorList.add("Alternative attache position of monosaccharide child edge is not possible (DEOXY).");
                            continue;
                        }
                        if (t_objLinkage.getParentLinkageType() == LinkageType.H_AT_OH) {
                            if (((Boolean)t_aOH.get(t_iPos)).booleanValue()) continue;
                            this.m_aErrorList.add("Alternative attache position of monosaccharide child edge is not possible (H_AT_OH).");
                            continue;
                        }
                        if (t_objLinkage.getParentLinkageType() == LinkageType.H_LOSE) {
                            if (((Boolean)t_aH.get(t_iPos)).booleanValue()) continue;
                            this.m_aErrorList.add("Alternative attache position of monosaccharide child edge is not possible (H_LOSE).");
                            continue;
                        }
                        if (t_objLinkage.getParentLinkageType() == LinkageType.NONMONOSACCHARID) {
                            this.m_aErrorList.add("Nonmonosaccharide linkage tpyes are not allowed in monosaccharide parent edge.");
                            continue;
                        }
                        if (t_objLinkage.getChildLinkageType() != LinkageType.UNVALIDATED) continue;
                        this.m_aErrorList.add("Unvalidated linkage tpyes are not allowed in monosaccharide parent edge.");
                        continue;
                    }
                    if (t_iPos >= 1 || t_iPos == -1) continue;
                    this.m_aErrorList.add("Linkage positions smaller than 1 are not allowed.");
                }
            }
        }
        for (GlycoEdge t_edge : a_objMonosaccharid.getChildEdges()) {
            this.validateDirection(t_edge);
        }
        if (a_objMonosaccharid.getParentEdge() != null) {
            this.testLinkageType(a_objMonosaccharid.getParentNode(), a_objMonosaccharid.getParentEdge(), a_objMonosaccharid);
        }
    }

    private boolean validateDirection(GlycoEdge t_edge) throws GlycoVisitorException {
        GlycoVisitorNodeType t_gvis = new GlycoVisitorNodeType();
        if (t_gvis.isMonosaccharide(t_edge.getChild())) {
            Monosaccharide t_mono = t_gvis.getMonosaccharide(t_edge.getChild());
            ArrayList<Integer> t_aIntKeto = new ArrayList<Integer>();
            for (Modification element3 : t_mono.getModification()) {
                if (element3.getModificationType() != ModificationType.KETO) continue;
                t_aIntKeto.add(element3.getPositionOne());
            }
            if (t_aIntKeto.size() == 0) {
                t_aIntKeto.add(1);
                t_aIntKeto.add(-1);
            }
            for (Linkage t_lin : t_edge.getGlycosidicLinkages()) {
                for (Integer i : t_lin.getChildLinkages()) {
                    if (!t_aIntKeto.contains(i)) continue;
                    return true;
                }
            }
            this.m_aErrorList.add("Child parent relationship (direction of linkages) broken");
            return false;
        }
        if (t_gvis.isMonosaccharide(t_edge.getParent())) {
            Monosaccharide t_mono = t_gvis.getMonosaccharide(t_edge.getParent());
            ArrayList<Integer> t_aIntKeto = new ArrayList<Integer>();
            for (Modification element3 : t_mono.getModification()) {
                if (element3.getModificationType() != ModificationType.KETO) continue;
                t_aIntKeto.add(element3.getPositionOne());
            }
            if (t_aIntKeto.size() == 0) {
                t_aIntKeto.add(1);
            }
            for (Linkage t_lin : t_edge.getGlycosidicLinkages()) {
                for (Integer i : t_lin.getParentLinkages()) {
                    if (!t_aIntKeto.contains(i)) continue;
                    this.m_aErrorList.add("Parent child relationship (direction of linkages) broken.");
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    @Override
    public void clear() {
        this.m_aErrorList.clear();
        this.m_aWarningList.clear();
        this.m_aEdge.clear();
    }
}

