/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.util.analytical.misc;

import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.ModificationType;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitCyclic;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverser;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverserTree;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;

public class GlycoVisitorChargeCalculator
implements GlycoVisitor {
    Integer m_icharge = 0;
    private GlycoTraverser m_objTraverser;

    @Override
    public void visit(Monosaccharide a_objMonosaccharid) throws GlycoVisitorException {
        Integer n;
        if (a_objMonosaccharid.hasModification(ModificationType.ACID, 1)) {
            n = this.m_icharge;
            this.m_icharge = this.m_icharge - 1;
        }
        if (a_objMonosaccharid.hasModification(ModificationType.ACID, a_objMonosaccharid.getSuperclass().getCAtomCount())) {
            n = this.m_icharge;
            this.m_icharge = this.m_icharge - 1;
        }
    }

    @Override
    public void visit(NonMonosaccharide a_objResidue) throws GlycoVisitorException {
    }

    @Override
    public void visit(SugarUnitRepeat a_objRepeat) throws GlycoVisitorException {
        GlycoTraverser t_objTraverser = this.getTraverser(this);
        t_objTraverser.traverseGraph(a_objRepeat);
    }

    @Override
    public void visit(Substituent a_objSubstituent) throws GlycoVisitorException {
        Integer n;
        if (a_objSubstituent.getSubstituentType().getName().equals("sulfate")) {
            n = this.m_icharge;
            this.m_icharge = this.m_icharge - 1;
        }
        if (a_objSubstituent.getSubstituentType().getName().equals("phosphate")) {
            n = this.m_icharge;
            this.m_icharge = this.m_icharge - 1;
            n = this.m_icharge;
            this.m_icharge = this.m_icharge - 1;
        }
        if (a_objSubstituent.getSubstituentType().getName().equals("pyrophosphate")) {
            n = this.m_icharge;
            this.m_icharge = this.m_icharge - 1;
            n = this.m_icharge;
            this.m_icharge = this.m_icharge - 1;
            n = this.m_icharge;
            this.m_icharge = this.m_icharge - 1;
        }
        if (a_objSubstituent.getSubstituentType().getName().equals("triphosphate")) {
            n = this.m_icharge;
            this.m_icharge = this.m_icharge - 1;
            n = this.m_icharge;
            this.m_icharge = this.m_icharge - 1;
            n = this.m_icharge;
            this.m_icharge = this.m_icharge - 1;
            n = this.m_icharge;
            this.m_icharge = this.m_icharge - 1;
        }
        if (a_objSubstituent.getSubstituentType().getName().equals("amino")) {
            n = this.m_icharge;
            this.m_icharge = this.m_icharge + 1;
        }
        if (a_objSubstituent.getSubstituentType().getName().equals("amidino")) {
            n = this.m_icharge;
            this.m_icharge = this.m_icharge + 1;
        }
        if (a_objSubstituent.getSubstituentType().getName().equals("ethanolamine")) {
            n = this.m_icharge;
            this.m_icharge = this.m_icharge + 1;
        }
        if (a_objSubstituent.getSubstituentType().getName().equals("imino")) {
            n = this.m_icharge;
            this.m_icharge = this.m_icharge + 1;
        }
        if (a_objSubstituent.getSubstituentType().getName().equals("n-alanine")) {
            n = this.m_icharge;
            this.m_icharge = this.m_icharge + 1;
        }
        if (a_objSubstituent.getSubstituentType().getName().equals("n-dimethyl")) {
            n = this.m_icharge;
            this.m_icharge = this.m_icharge + 1;
        }
        if (a_objSubstituent.getSubstituentType().getName().equals("n-methyl")) {
            n = this.m_icharge;
            this.m_icharge = this.m_icharge + 1;
        }
        if (a_objSubstituent.getSubstituentType().getName().equals("n-succinate")) {
            n = this.m_icharge;
            this.m_icharge = this.m_icharge - 1;
        }
        if (a_objSubstituent.getSubstituentType().getName().equals("n-sulfate")) {
            n = this.m_icharge;
            this.m_icharge = this.m_icharge - 1;
        }
        if (a_objSubstituent.getSubstituentType().getName().equals("phosphate")) {
            n = this.m_icharge;
            this.m_icharge = this.m_icharge - 1;
        }
        if (a_objSubstituent.getSubstituentType().getName().equals("(r)-carboxymethyl")) {
            n = this.m_icharge;
            this.m_icharge = this.m_icharge - 1;
        }
        if (a_objSubstituent.getSubstituentType().getName().equals("(s)-carboxymethyl")) {
            n = this.m_icharge;
            this.m_icharge = this.m_icharge - 1;
        }
        if (a_objSubstituent.getSubstituentType().getName().equals("(r)-carboxyethyl")) {
            n = this.m_icharge;
            this.m_icharge = this.m_icharge - 1;
        }
        if (a_objSubstituent.getSubstituentType().getName().equals("(r)-carboxyethyl")) {
            n = this.m_icharge;
            this.m_icharge = this.m_icharge - 1;
        }
        if (a_objSubstituent.getSubstituentType().getName().equals("(r)-pyruvate") || a_objSubstituent.getSubstituentType().getName().equals("(s)-pyruvate") || a_objSubstituent.getSubstituentType().getName().equals("(x)-pyruvate")) {
            n = this.m_icharge;
            this.m_icharge = this.m_icharge - 1;
        }
    }

    @Override
    public void visit(SugarUnitCyclic a_objCyclic) throws GlycoVisitorException {
    }

    @Override
    public void visit(SugarUnitAlternative a_objAlternative) throws GlycoVisitorException {
    }

    @Override
    public void visit(UnvalidatedGlycoNode a_objUnvalidated) throws GlycoVisitorException {
    }

    @Override
    public void visit(GlycoEdge a_objLinkage) throws GlycoVisitorException {
    }

    @Override
    public void start(Sugar a_objSugar) throws GlycoVisitorException {
        this.clear();
        this.m_objTraverser = this.getTraverser(this);
        this.m_objTraverser.traverseGraph(a_objSugar);
    }

    @Override
    public GlycoTraverser getTraverser(GlycoVisitor a_objVisitor) throws GlycoVisitorException {
        return new GlycoTraverserTree(a_objVisitor);
    }

    @Override
    public void clear() {
        this.m_icharge = 0;
    }

    public Integer getCharge() {
        return this.m_icharge;
    }
}

