/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.util.analytical.mass;

import org.eurocarbdb.MolecularFramework.sugar.LinkageType;
import org.eurocarbdb.MolecularFramework.sugar.ModificationType;
import org.eurocarbdb.MolecularFramework.sugar.SubstituentType;
import org.eurocarbdb.MolecularFramework.sugar.Superclass;
import org.eurocarbdb.MolecularFramework.util.analytical.mass.GlycoMassException;

public class MassComponents {
    public double getSuperclassMass(Superclass a_objSuper, boolean a_bMonoisotopic) throws GlycoMassException {
        if (a_objSuper == Superclass.SUG) {
            throw new GlycoMassException("Mass calculation for superclass SUG not possible.");
        }
        double t_dResult = 0.0;
        t_dResult = a_bMonoisotopic ? 30.0105646861 : 30.0260223327743;
        return t_dResult * (double)a_objSuper.getCAtomCount();
    }

    public double getModificationMass(ModificationType a_objModi, boolean a_bMonoisotopic, int t_iPositionOne) throws GlycoMassException {
        double t_dResult = 0.0;
        if (a_objModi == ModificationType.ACID) {
            t_dResult = a_bMonoisotopic ? 13.9792645581 : 13.9835234207067;
        } else if (a_objModi == ModificationType.ALDI) {
            t_dResult = a_bMonoisotopic ? 2.015650064 : 2.01588150765158;
        } else if (a_objModi == ModificationType.DEOXY) {
            t_dResult = a_bMonoisotopic ? -15.9949146221 : -15.9994049283583;
        } else if (a_objModi == ModificationType.DOUBLEBOND) {
            t_dResult = a_bMonoisotopic ? -2.015650064 : -2.01588150765158;
        } else if (a_objModi == ModificationType.KETO) {
            t_dResult = a_bMonoisotopic ? -2.015650064 : -2.01588150765158;
        } else {
            throw new GlycoMassException("Mass calculation for modification " + a_objModi.getName() + " is not supported.");
        }
        return t_dResult;
    }

    public double getSubstitutionsMass(SubstituentType a_objSubst, boolean a_bMonoisotopic) throws GlycoMassException {
        double t_dResult = 0.0;
        if (a_objSubst == SubstituentType.ACETYL) {
            t_dResult = a_bMonoisotopic ? 43.0183897181 : 43.0446989833646;
        } else if (a_objSubst == SubstituentType.AMIDINO) {
            t_dResult = a_bMonoisotopic ? 43.029623106 : 43.0480443450573;
        } else if (a_objSubst == SubstituentType.AMINO) {
            t_dResult = a_bMonoisotopic ? 16.018724069 : 16.0226246010593;
        } else if (a_objSubst == SubstituentType.ANHYDRO) {
            t_dResult = a_bMonoisotopic ? 0.0 : 0.0;
        } else if (a_objSubst == SubstituentType.CHLORO) {
            t_dResult = a_bMonoisotopic ? 34.96885271 : 35.452538193358;
        } else if (a_objSubst == SubstituentType.ETHANOLAMINE) {
            t_dResult = a_bMonoisotopic ? 44.050024197 : 44.0758594098914;
        } else if (a_objSubst == SubstituentType.ETHYL) {
            t_dResult = a_bMonoisotopic ? 29.03912516 : 29.0611755626579;
        } else if (a_objSubst == SubstituentType.FLOURO) {
            t_dResult = a_bMonoisotopic ? 18.9984032 : 18.9984032;
        } else if (a_objSubst == SubstituentType.FORMYL) {
            t_dResult = a_bMonoisotopic ? 29.0027396541 : 29.0180815789485;
        } else if (a_objSubst == SubstituentType.GLYCOLYL) {
            t_dResult = a_bMonoisotopic ? 59.0133043402 : 59.0441039117229;
        } else if (a_objSubst == SubstituentType.HYDROXYMETHYL) {
            t_dResult = a_bMonoisotopic ? 31.0183897181 : 31.0339630866001;
        } else if (a_objSubst == SubstituentType.IMINO) {
            t_dResult = a_bMonoisotopic ? 15.010899037 : 15.0146838472335;
        } else if (a_objSubst == SubstituentType.LACTONE) {
            t_dResult = a_bMonoisotopic ? 0.0 : 0.0;
        } else if (a_objSubst == SubstituentType.METHYL) {
            t_dResult = a_bMonoisotopic ? 15.023475096 : 15.0345581582418;
        } else if (a_objSubst == SubstituentType.N_ACETYL) {
            t_dResult = a_bMonoisotopic ? 58.0292887551 : 58.0593828305981;
        } else if (a_objSubst == SubstituentType.N_ALANINE) {
            t_dResult = a_bMonoisotopic ? 73.0401877921 : 73.0740666778316;
        } else if (a_objSubst == SubstituentType.N_AMIDINO) {
            t_dResult = a_bMonoisotopic ? 58.040522143 : 58.0627281922908;
        } else if (a_objSubst == SubstituentType.N_DIMETHYL) {
            t_dResult = a_bMonoisotopic ? 44.050024197 : 44.0758594098914;
        } else if (a_objSubst == SubstituentType.N_FORMYL) {
            t_dResult = a_bMonoisotopic ? 44.0136386911 : 44.0327654261821;
        } else if (a_objSubst == SubstituentType.N_GLYCOLYL) {
            t_dResult = a_bMonoisotopic ? 74.0242033772 : 74.0587877589564;
        } else if (a_objSubst == SubstituentType.N_METHYL) {
            t_dResult = a_bMonoisotopic ? 47.005061638 : 47.0162604220676;
        } else if (a_objSubst == SubstituentType.N_METHYLCARBAMOYL) {
            t_dResult = a_bMonoisotopic ? 58.0292887551 : 58.0593828305981;
        } else if (a_objSubst == SubstituentType.N_SUCCINATE) {
            t_dResult = a_bMonoisotopic ? 116.0347680633 : 116.095545988495;
        } else if (a_objSubst == SubstituentType.N_SULFATE) {
            t_dResult = a_bMonoisotopic ? 95.9755386253 : 96.0869240799342;
        } else if (a_objSubst == SubstituentType.N_TRIFLOUROACETYL) {
            t_dResult = a_bMonoisotopic ? 110.9931982271 : 111.022829415295;
        } else if (a_objSubst == SubstituentType.NITRATE) {
            t_dResult = a_bMonoisotopic ? 45.9929032492 : 46.0055529501243;
        } else if (a_objSubst == SubstituentType.PHOSPHATE) {
            t_dResult = a_bMonoisotopic ? 80.9741554403 : 80.9878578027265;
        } else if (a_objSubst == SubstituentType.PHOSPHO_CHOLINE) {
            t_dResult = a_bMonoisotopic ? 166.0633047973 : 166.13562867204;
        } else if (a_objSubst == SubstituentType.PHOSPHO_ETHANOLAMINE) {
            t_dResult = a_bMonoisotopic ? 123.0085295733 : 123.047835704966;
        } else if (a_objSubst == SubstituentType.PYROPHOSPHATE) {
            t_dResult = a_bMonoisotopic ? 160.9404858486 : 160.967774851627;
        } else if (a_objSubst == SubstituentType.PYRUVATE) {
            t_dResult = a_bMonoisotopic ? 71.0133043402 : 71.0548398084873;
        } else if (a_objSubst == SubstituentType.R_CARBOXYETHYL) {
            t_dResult = a_bMonoisotopic ? 73.0289544042 : 73.0707213161389;
        } else if (a_objSubst == SubstituentType.R_CARBOXYMETHYL) {
            t_dResult = a_bMonoisotopic ? 59.0133043402 : 59.0441039117229;
        } else if (a_objSubst == SubstituentType.R_PYRUVATE) {
            t_dResult = a_bMonoisotopic ? 72.0211293722 : 72.0627805623131;
        } else if (a_objSubst == SubstituentType.S_CARBOXYETHYL) {
            t_dResult = a_bMonoisotopic ? 73.0289544042 : 73.0707213161389;
        } else if (a_objSubst == SubstituentType.S_CARBOXYMETHYL) {
            t_dResult = a_bMonoisotopic ? 59.0133043402 : 59.0441039117229;
        } else if (a_objSubst == SubstituentType.S_PYRUVATE) {
            t_dResult = a_bMonoisotopic ? 72.0211293722 : 72.0627805623131;
        } else if (a_objSubst == SubstituentType.SULFATE) {
            t_dResult = a_bMonoisotopic ? 80.9646395883 : 81.0722402327007;
        } else if (a_objSubst == SubstituentType.THIO) {
            t_dResult = a_bMonoisotopic ? 32.979895722 : 33.0740254476258;
        } else if (a_objSubst == SubstituentType.TRIPHOSPHATE) {
            t_dResult = a_bMonoisotopic ? 240.9068162569 : 240.947691900528;
        } else {
            throw new GlycoMassException("Mass calculation for substituent " + a_objSubst.getName() + " is not supported.");
        }
        return t_dResult;
    }

    public double getLinkageTypeMass(LinkageType a_objLinkageType, boolean a_bMonoisotopic) throws GlycoMassException {
        double t_dResult = 0.0;
        if (a_objLinkageType == LinkageType.DEOXY) {
            t_dResult = a_bMonoisotopic ? -17.0027396541 : -17.0073456821841;
        } else if (a_objLinkageType == LinkageType.H_AT_OH || a_objLinkageType == LinkageType.H_LOSE) {
            t_dResult = a_bMonoisotopic ? -1.007825032 : -1.00794075382579;
        } else {
            throw new GlycoMassException("Mass calculation for Linkagetype " + (Object)((Object)a_objLinkageType) + " is not supported.");
        }
        return t_dResult;
    }
}

