/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.io.ncfg;

import java.util.ArrayList;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.io.SugarImporterText;
import org.eurocarbdb.MolecularFramework.io.iupac.IupacSubTree;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Linkage;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;

public class SugarImporterNCFG
extends SugarImporterText {
    @Override
    protected void start() throws SugarImporterException {
        try {
            this.clear();
            UnvalidatedGlycoNode t_objResiduumChild = new UnvalidatedGlycoNode();
            UnvalidatedGlycoNode t_objResiduumParent = new UnvalidatedGlycoNode();
            GlycoEdge t_objEdge = new GlycoEdge();
            Linkage t_objLinkage = new Linkage();
            int t_iStartPosition = this.m_iPosition;
            this.residue();
            String t_strResidueName = this.m_strText.substring(t_iStartPosition, this.m_iPosition);
            t_objResiduumChild.setName(t_strResidueName);
            this.m_objSugar.addNode(t_objResiduumChild);
            while (this.m_cToken != '$') {
                if (this.m_cToken != '-') {
                    t_objLinkage.addChildLinkage(this.linkageposition());
                } else {
                    t_objLinkage.addChildLinkage(-1);
                }
                if (this.m_cToken != '-') {
                    throw new SugarImporterException("IUPAC005", this.m_iPosition);
                }
                this.nextToken();
                if (this.isNumber()) {
                    t_objLinkage.addParentLinkage(this.linkageposition());
                } else {
                    t_objLinkage.addParentLinkage(-1);
                }
                t_objEdge.addGlycosidicLinkage(t_objLinkage);
                ArrayList<IupacSubTree> t_aIupacSubtree = new ArrayList<IupacSubTree>();
                while (this.m_cToken == '(') {
                    t_aIupacSubtree.add(this.subbranch());
                }
                t_iStartPosition = this.m_iPosition;
                this.residue();
                t_strResidueName = this.m_strText.substring(t_iStartPosition, this.m_iPosition);
                t_objResiduumParent.setName(t_strResidueName);
                this.m_objSugar.addNode(t_objResiduumParent);
                this.m_objSugar.addEdge(t_objResiduumParent, t_objResiduumChild, t_objEdge);
                for (IupacSubTree t_objTree : t_aIupacSubtree) {
                    this.m_objSugar.addEdge(t_objResiduumParent, t_objTree.getGlycoNode(), t_objTree.getGlycoEdge());
                }
                t_objResiduumChild = t_objResiduumParent;
                t_objResiduumParent = new UnvalidatedGlycoNode();
                t_objEdge = new GlycoEdge();
                t_objLinkage = new Linkage();
            }
            if (!this.finished()) {
                throw new SugarImporterException("IUPAC002", this.m_iPosition);
            }
        }
        catch (GlycoconjugateException e) {
            throw new SugarImporterException("COMMON013", this.m_iPosition);
        }
    }

    private IupacSubTree subbranch() throws SugarImporterException, GlycoconjugateException {
        if (this.m_cToken != '(') {
            throw new SugarImporterException("IUPAC000", this.m_iPosition);
        }
        this.nextToken();
        IupacSubTree t_objTreeChild = this.fullresidue();
        this.m_objSugar.addNode(t_objTreeChild.getGlycoNode());
        while (this.m_cToken != ')') {
            ArrayList<IupacSubTree> t_aIupacSubtree = new ArrayList<IupacSubTree>();
            while (this.m_cToken == '(') {
                t_aIupacSubtree.add(this.subbranch());
            }
            IupacSubTree t_objTreeParent = this.fullresidue();
            this.m_objSugar.addNode(t_objTreeChild.getGlycoNode());
            this.m_objSugar.addEdge(t_objTreeParent.getGlycoNode(), t_objTreeChild.getGlycoNode(), t_objTreeChild.getGlycoEdge());
            for (IupacSubTree t_objTree : t_aIupacSubtree) {
                this.m_objSugar.addEdge(t_objTreeParent.getGlycoNode(), t_objTree.getGlycoNode(), t_objTree.getGlycoEdge());
            }
            t_objTreeChild = t_objTreeParent;
        }
        this.nextToken();
        return t_objTreeChild;
    }

    private IupacSubTree fullresidue() throws SugarImporterException, GlycoconjugateException {
        IupacSubTree t_objTree = new IupacSubTree();
        UnvalidatedGlycoNode t_objNode = new UnvalidatedGlycoNode();
        GlycoEdge t_objEdge = new GlycoEdge();
        Linkage t_objLinkage = new Linkage();
        int t_iStartPosition = this.m_iPosition;
        this.residue();
        String t_strResidueName = this.m_strText.substring(t_iStartPosition, this.m_iPosition);
        t_objNode.setName(t_strResidueName);
        this.m_objSugar.addNode(t_objNode);
        if (this.m_cToken != '-') {
            t_objLinkage.addChildLinkage(this.linkageposition());
        } else {
            t_objLinkage.addChildLinkage(-1);
        }
        if (this.m_cToken != '-') {
            throw new SugarImporterException("IUPAC005", this.m_iPosition);
        }
        this.nextToken();
        t_objLinkage.addParentLinkage(this.linkageposition());
        t_objEdge.addGlycosidicLinkage(t_objLinkage);
        t_objTree.setGlycoEdge(t_objEdge);
        t_objTree.setGlycoNode(t_objNode);
        return t_objTree;
    }

    private int linkageposition() throws SugarImporterException {
        return this.number();
    }

    private void residue() throws SugarImporterException {
        boolean t_bLoop = true;
        do {
            this.symbol();
            if (this.m_cToken == '-') {
                t_bLoop = false;
                continue;
            }
            if (this.m_cToken == '$') {
                t_bLoop = false;
                continue;
            }
            boolean t_bNumber = true;
            int t_iCounter = 0;
            do {
                if (this.m_iLength > this.m_iPosition + t_iCounter) {
                    char t_iDigit = this.m_strText.charAt(this.m_iPosition + t_iCounter);
                    if (t_iDigit > '/' && t_iDigit < ':') {
                        t_bNumber = true;
                    } else if (this.m_strText.charAt(this.m_iPosition + t_iCounter) == '-') {
                        t_bNumber = false;
                        t_bLoop = false;
                    } else {
                        t_bNumber = false;
                    }
                } else {
                    t_bNumber = false;
                }
                ++t_iCounter;
            } while (t_bNumber);
        } while (t_bLoop);
    }

    private boolean isNumber() {
        char t_iDigit = this.m_strText.charAt(this.m_iPosition);
        return t_iDigit > '/' && t_iDigit < ':';
    }

    private void symbol() throws SugarImporterException {
        if (this.m_cToken == '[') {
            this.nextToken();
        } else if (this.m_cToken == ']') {
            this.nextToken();
        } else if (this.m_cToken == ',') {
            this.nextToken();
        } else {
            char t_iDigit = this.m_cToken;
            if (t_iDigit > '/' && t_iDigit < ':') {
                this.number();
            } else {
                this.character();
            }
        }
    }

    private void clear() {
    }
}

